<?php

/**
 * PowerBB Engine - The Engine Helps You To Create Bulletin Board System.
 */

/**
 * Private message system
 *
 * @package		: 	PowerBBPM
 * @author		: 	Mohammed Q. Hussain <MaaSTaaR@gmail.com>
 * @start 		: 	24/2/2006 8:31 AM
 * @end   		: 	24/2/2006 9:05 AM
 * @updated 	: 	16/07/2008 11:52:42 PM
*/

/**
 * @package PowerBBPM
 */

class PowerBBPM
{
	var $id;
	var $Engine;

	function PowerBBPM($Engine)
	{
		$this->Engine = $Engine;
	}

	/**
	 * Send private massege for member
	 *
	 * @param :
	 *			from	->	the username of the sender
	 *			to		->	the username of the resiver
	 *			title	->	the title of private massege
	 *			text	->	the text of private massege
	 *			date	->	the date of private massege
	 *			icon	->	the icon of private massege
	 *			folder	->	the folder of private massege
	 */
	function InsertMassege($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$query = $this->Engine->records->Insert($this->Engine->table['pm'],$param['field']);

		if ($param['get_id'])
		{
			$this->id = $this->Engine->DB->sql_insert_id();
		}

		return ($query) ? true : false;
	}

	/**
	 * Get the number of private massege
	 *
	 * @param :
	 *			way ->
	 *					new 	- to get the number of new pm
	 *					all 	- to get the total of pm
	 *					query 	- our own SQL query
	 *
	 *			username -> the username
	 *			query	 -> if the way is query , this variable should value the query
	 */
	function GetPrivateMassegeNumber($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
		$param['from']		=	$this->Engine->table['pm'];

		$num = $this->Engine->records->GetNumber($param);

		return $num;
	}

	/**
	 * Get the list of private massege
	 *
	 * @param :
	 *			username ->	the owner of pm
	 *			folder	 -> the pm from which folder ?
	 */
	function GetPrivateMassegeList($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

 		$param['select'] 	= 	'*';
 		$param['from'] 		= 	$this->Engine->table['pm'];

 	 	$rows = $this->Engine->records->GetList($param);

		return $rows;
	}

	/**
	 * Read pm by id
	 *
	 * @param :
	 *				id 			-> the id of pm
	 *				username 	-> who request the msg to read ?
	 */
	function GetPrivateMassegeInfo($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 			= 	'*';
		$param['from']				=	$this->Engine->table['pm'];
		$param['where']				=	array();

		if (!empty($param['id'])
			and !empty($param['username']))
		{
			$param['where'][0]			=	array();
			$param['where'][0]['name']	=	'id';
			$param['where'][0]['oper']	=	'=';
			$param['where'][0]['value']	=	$param['id'];

		}

		$rows = $this->Engine->records->GetInfo($param);

		return $rows;
	}


	function MakeMassegeRead($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$field 				= 	array();
		$field['user_read'] = 	'1';

		$update = $this->Engine->records->Update($this->Engine->table['pm'],$field,$param['where']);

		return ($update) ? true : false;
	}

   function MakeMassegeUnRead($param)
    {
        if (!isset($param)
           or !is_array($param))
        {
           $param = array();
        }

       $field              =    array();
       $field['user_read'] =    '0';

       $update = $this->Engine->records->Update($this->Engine->table['pm'],$field,$param['where']);

       return ($update) ? true : false;
    }

	function NewMessageNumber($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$arr 							= 	array();
		$arr['where'] 					= 	array();

		$arr['where'][0] 				= 	array();
		$arr['where'][0]['name'] 		= 	'user_to';
		$arr['where'][0]['oper'] 		= 	'=';
		$arr['where'][0]['value'] 		= 	$param['username'];

		$arr['where'][1] 				= 	array();
		$arr['where'][1]['con'] 		= 	'AND';
		$arr['where'][1]['name'] 		= 	'folder';
		$arr['where'][1]['oper'] 		= 	'=';
		$arr['where'][1]['value'] 		= 	'inbox';

		$arr['where'][2] 				= 	array();
		$arr['where'][2]['con'] 		= 	'AND';
		$arr['where'][2]['name'] 		= 	'user_read';
		$arr['where'][2]['oper'] 		= 	'<>';
		$arr['where'][2]['value'] 		= 	'1';

		return $this->GetPrivateMassegeNumber($arr);
	}

	function GetPmList($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
 		$param['from'] 		= 	$this->Engine->table['pm'];

		$rows = $this->Engine->records->GetList($param);

		return $rows;
     }
       function GetAllPmNum($param)
    {
        if (!isset($param)
           or !is_array($param))
        {
           $param = array();
        }

       $param['select']    =    '*';
        $param['from']        =    $this->Engine->table['pm'];

       $param['where']    =  array();

       $param['where'][0] = array();
       $param['where'][0]['name'] =   '(user_to';
       $param['where'][0]['oper']    =    '=';
       $param['where'][0]['value']    =    $param['username'];

       $param['where'][1]              =    array();
       $param['where'][1]['con']        =    'AND';
       $param['where'][1]['name']        =    'folder';
       $param['where'][1]['oper']        =    '=';
       $param['where'][1]['value']    =    'inbox';

       $param['where'][2]              =    array();
       $param['where'][2]['con']        =    ') OR';
       $param['where'][2]['name']        =    'user_from';
       $param['where'][2]['oper']        =    '=';
       $param['where'][2]['value']    =    $param['username'];

       $param['where'][3]              =    array();
       $param['where'][3]['con']        =    'AND';
       $param['where'][3]['name']        =    'folder';
       $param['where'][3]['oper']        =    '=';
       $param['where'][3]['value']    =    'sent';


       $rows = $this->GetPrivateMassegeNumber($param);

       return $rows;
    }

	/** High-Level functions **/
	function GetInboxList($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['where'] 				= 	array();

		$param['where'][0] 				= 	array();
		$param['where'][0]['name'] 		= 	'user_to';
		$param['where'][0]['oper'] 		= 	'=';
		$param['where'][0]['value'] 	= 	$param['username'];

		$param['where'][1] 				= 	array();
		$param['where'][1]['con'] 		= 	'AND';
		$param['where'][1]['name'] 		= 	'folder';
		$param['where'][1]['oper'] 		= 	'=';
		$param['where'][1]['value'] 	= 	'inbox';

		$rows = $this->GetPrivateMassegeList($param);

		return $rows;
	}

	function GetSentList($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['where'] 				= 	array();

		$param['where'][0] 				= 	array();
		$param['where'][0]['name'] 		= 	'user_from';
		$param['where'][0]['oper'] 		= 	'=';
		$param['where'][0]['value'] 	= 	$param['username'];

		$param['where'][1] 				= 	array();
		$param['where'][1]['con'] 		= 	'AND';
		$param['where'][1]['name'] 		= 	'folder';
		$param['where'][1]['oper'] 		= 	'=';
		$param['where'][1]['value'] 	= 	'sent';

		$rows = $this->GetPrivateMassegeList($param);

		return $rows;
	}

	function UpdatePrivateMessage($param)
 	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$query = $this->Engine->records->Update($this->Engine->table['pm'],$param['field'],$param['where']);

		return ($query) ? true : false;
 	}

 	function DeletePrivateMessage($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['table'] = $this->Engine->table['pm'];

		$del = $this->Engine->records->Delete($param);

		return ($del) ? true : false;
	}

	function GetMessageInfo($param)
	{
 		if (!isset($param)
 			or !is_array($param))
 		{
 			$param = array();
 		}

		$param['select'] 	= 	'*';
		$param['from'] 		= 	$this->Engine->table['pm'];

		$rows = $this->Engine->records->GetInfo($param);

		return $rows;
	}
}

?>
