<?php
(!defined('IN_PowerBB')) ? die() : '';
include('common.php');
define('CLASS_NAME','PowerBBActiveMOD');
class PowerBBActiveMOD
{
	function run()
	{
		global $PowerBB;
		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['Activation_members']);
		// The index page for active
		if ($PowerBB->_GET['index'])
		{
			$this->_Index();
		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$PowerBB->functions->GetFooter();
	}

	function _Index()
	{
		global $PowerBB;

		$PowerBB->functions->AddressBar($PowerBB->_CONF['template']['lang']['Activation_members']);

		// No code !
		if (empty($PowerBB->_GET['code']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['url_not_true']);
		}
		// This isn't member
        if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['url_not_true']);
		}

		$MemberReqArr 			= 	array();
		$MemberReqArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$ReqMemberInfo = $PowerBB->member->GetMemberInfo($MemberReqArr);

		$ReqArr = array();

		$ReqArr['code'] 	= 	$PowerBB->_GET['code'];
		$ReqArr['type'] 	= 	3;
		$ReqArr['username'] = 	$ReqMemberInfo['username'];

		// Get request information
		$RequestInfo = $PowerBB->request->GetRequestInfo($ReqArr);

		// No request , so stop the page
		if (!$RequestInfo)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Sorry_demand_does_not_exist']);
		}

      	//////////

      	// Get the information of default group to set username style cache

		$GrpArr 			= 	array();
		$GrpArr['where'] 	= 	array('id',$PowerBB->_CONF['info_row']['adef_group']);

		$GroupInfo = $PowerBB->group->GetGroupInfo($GrpArr);

		$style = $GroupInfo['username_style'];
		$username_style_cache = str_replace('[username]',$ReqMemberInfo['username'],$style);

      	//////////

		$GroupArr 				= 	array();
		$GroupArr['field'] 		= 	array();

		$GroupArr['field']['usergroup'] 			= 	$PowerBB->_CONF['info_row']['adef_group'];
		$GroupArr['field']['username_style_cache']	=	$username_style_cache;
		$GroupArr['where'] 							= 	array('id',$PowerBB->_GET['id']);

		// We found the request , so active the member
		$UpdateGroup = $PowerBB->member->UpdateMember($GroupArr);

		// Update username_style to Members Group username_style in Online Today
		$UpdateTodayArr 			= 	array();
		$UpdateTodayArr['field']	=	array();

		$UpdateTodayArr['field']['username_style'] 	= 	$username_style_cache;
       	$UpdateTodayArr['where']						=	array('user_id',$PowerBB->_GET['id']);

		$UpdateToday = $PowerBB->online->UpdateToday($UpdateTodayArr);

		// The active is success
		if ($UpdateGroup)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['activated_successfully']);
			$PowerBB->functions->redirect('index.php');
		}
	}
}

?>
