<?php

(!defined('IN_PowerBB')) ? die() : '';

define('IN_ADMIN',true);

$CALL_SYSTEM = array();
$CALL_SYSTEM['SECTION'] = true;
$CALL_SYSTEM['SUBJECT'] = true;
$CALL_SYSTEM['REPLY'] = true;

include('common.php');

define('CLASS_NAME','PowerBBMainMOD');

class PowerBBMainMOD
{
	function run()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['member_permission'])
		{
			if (empty($PowerBB->_GET['top'])
				and empty($PowerBB->_GET['right'])
				and empty($PowerBB->_GET['left']))
			{
				$PowerBB->template->display('main');
			}

			elseif ($PowerBB->_GET['top'])
			{
				$this->_DisplayTopPage();
			}

			elseif ($PowerBB->_GET['right'])
			{
				$this->_DisplayMenuPage();
			}

			elseif ($PowerBB->_GET['left'])
			{
				$this->_DisplayBodyPage();
			}
		}
	}

	function _DisplayTopPage()
	{
		global $PowerBB;

		$PowerBB->template->display('header');
		$PowerBB->template->display('top');
		$PowerBB->template->display('footer');
	}

	function _DisplayMenuPage()
	{
		global $PowerBB;

		$PowerBB->template->display('header');
		$PowerBB->template->display('menu');
		$PowerBB->template->display('footer');
	}

	//This function checks if this system's version is up to date =)
	function _VersionCheck()
	{
		global $PowerBB;

		$LatestVersionUrl = ('http://www.pbboard.com/pbboardlatestversion.txt');


		$JS_Notification = 1;
		$CurrentVersion = $PowerBB->_CONF['info_row']['MySBB_version'];

		//Connect to the official website of pbboard
		$LatestVersionTxt = @file_get_contents($LatestVersionUrl);

			if (!$LatestVersionTxt)
			{
			$ch         = curl_init();

			curl_setopt($ch, CURLOPT_URL, $LatestVersionUrl);
			curl_setopt($ch, CURLOPT_HEADER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

			$content    = curl_exec($ch);
			$error      = curl_error($ch);
			}

			if (empty($content)
				and empty($LatestVersionTxt))
			{
            $Result = $PowerBB->_CONF['template']['lang']['failed_connect'];
			 }
			else
			{
				if($LatestVersionTxt)
				{
					$arr = explode('-',$LatestVersionTxt);
				 }
				else
				{
					$arr = explode('-',$content);
				}
				$LatestVersion     = trim($arr[0]);
				$LatestVersionLink = trim($arr[1]);
				$Compare = version_compare($CurrentVersion,$LatestVersion);
				if ( $LatestVersion == $CurrentVersion )
				{
				$JS_Notification = 0;
				$Result = $PowerBB->_CONF['template']['lang']['version_identical'];
				}
				else
				{
				$Result = $PowerBB->_CONF['template']['lang']['there_is_newer_version1'].$LatestVersion.$PowerBB->_CONF['template']['lang']['there_is_newer_version2'].$LatestVersion.$PowerBB->_CONF['template']['lang']['there_is_newer_version3'];

				}
			}
		if ( $JS_Notification )
		{
			$Notification = '<script type="text/javascript">
							function VNTimer()
							{
								var BackgroundColor = document.getElementById("Notifyboxr1").bgColor.toLowerCase();
								if(BackgroundColor == \'#f5f8f7\' )
								{
									document.getElementById("Notifyboxr1").bgColor=\'#E0E0E0\';
									document.getElementById("Notifyboxr2").bgColor=\'#E0E0E0\';
							    }
								else
								{
									document.getElementById("Notifyboxr1").bgColor=\'#F5F8F7\';
									document.getElementById("Notifyboxr2").bgColor=\'#F5F8F7\';
								}
							}
							setInterval("VNTimer()",500);
							</script>';
			$PowerBB->template->assign('versionnotification',$Notification);
		}

		// close cURL resource, and free up system resources
		if (!$LatestVersionTxt)
		{
		curl_close($ch);
		}
		return $Result;

	}
	//------------------------------------------------------------


	function _DisplayBodyPage()
	{
		global $PowerBB;

		$PowerBB->_CONF['template']['MemberNumber'] = $PowerBB->member->GetMemberNumber(array('get_from'	=>	'db'));

		$PowerBB->_CONF['template']['ActiveMember'] = $PowerBB->member->GetActiveMemberNumber();

		$SecArr 						= 	array();
		$SecArr['where'] 				= 	array();
		$SecArr['where'][0] 			= 	array();
		$SecArr['where'][0]['name'] 	= 	'parent';
		$SecArr['where'][0]['oper'] 	= 	'<>';
		$SecArr['where'][0]['value'] 	= 	'0';

		$PowerBB->_CONF['template']['ForumsNumber'] = $PowerBB->section->GetSectionNumber($SecArr);

		$PowerBB->_CONF['template']['SubjectNumber'] = $PowerBB->subject->GetSubjectNumber(array('get_from'	=>	'db'));

		$PowerBB->_CONF['template']['ReplyNumber'] = $PowerBB->reply->GetReplyNumber(array('get_from'	=>	'db'));

		$day 	= 	date('j');
		$month 	= 	date('n');
		$year 	= 	date('Y');

		$from 	= 	mktime(0,0,0,$month,$day,$year);
		$to 	= 	mktime(23,59,59,$month,$day,$year);

		$TodayMemberArr 				= 	array();
		$TodayMemberArr['get_from'] 	= 	'db';
		$TodayMemberArr['where'] 		= 	array();

		$TodayMemberArr['where'][0] 			= 	array();
		$TodayMemberArr['where'][0]['name'] 	= 	'register_date';
		$TodayMemberArr['where'][0]['oper'] 	= 	'BETWEEN';
		$TodayMemberArr['where'][0]['value'] 	= 	$from . ' AND ' . $to;

		$PowerBB->_CONF['template']['TodayMemberNumber'] = $PowerBB->member->GetMemberNumber($TodayMemberArr);

		$TodaySubjectArr 				= 	array();
		$TodaySubjectArr['get_from'] 	= 	'db';
		$TodaySubjectArr['where'] 		= 	array();

		$TodaySubjectArr['where'][0] 			= 	array();
		$TodaySubjectArr['where'][0]['name'] 	= 	'native_write_time';
		$TodaySubjectArr['where'][0]['oper'] 	= 	'BETWEEN';
		$TodaySubjectArr['where'][0]['value'] 	= 	$from . ' AND ' . $to;

		$PowerBB->_CONF['template']['TodaySubjectNumber'] = $PowerBB->subject->GetSubjectNumber($TodaySubjectArr);

		$TodayReplyArr 				= 	array();
		$TodayReplyArr['get_from'] 	= 	'db';
		$TodayReplyArr['where'] 	= 	array();

		$TodayReplyArr['where'][0] 				= 	array();
		$TodayReplyArr['where'][0]['name'] 		= 	'write_time';
		$TodayReplyArr['where'][0]['oper'] 		= 	'BETWEEN';
		$TodayReplyArr['where'][0]['value'] 	= 	$from . ' AND ' . $to;

		$PowerBB->_CONF['template']['TodayReplyNumber'] = $PowerBB->reply->GetReplyNumber($TodayReplyArr);

     //  Waiting Members Number

		$WaitingMemberArr 				= 	array();
		$WaitingMemberArr['get_from'] 	= 	'db';
		$WaitingMemberArr['where'] 		= 	array();

		$WaitingMemberArr['where'][0] 			= 	array();
		$WaitingMemberArr['where'][0]['name'] 	= 	'usergroup';
		$WaitingMemberArr['where'][0]['oper'] 	= 	'=';
		$WaitingMemberArr['where'][0]['value'] 	= 	'5';

		$PowerBB->_CONF['template']['MembersActiveList'] = $PowerBB->member->GetMemberNumber($WaitingMemberArr);

		// Check if this version is up to date
		$LatestVersionUrl = ('http://www.pbboard.com/pbboardlatestversion.txt');
		$handle = @fopen( $LatestVersionUrl, "r" );
        if ($handle)
		{
		$VersionCheck = $this->_VersionCheck();
		$PowerBB->template->assign('versioncheck',$VersionCheck);
		}
		else
		{
           $Result = $PowerBB->_CONF['template']['lang']['failed_connect_web'];
		   $PowerBB->template->assign('versioncheck',$Result);
		 }

		//------------------------------------
		$PowerBB->template->display('header');
		$PowerBB->template->display('main_body');
		$PowerBB->template->display('footer');
	}
}

?>
