<?php

(!defined('IN_PowerBB')) ? die() : '';

define('IN_ADMIN',true);

//Edited------------------------------------
$CALL_SYSTEM                         =  array();
$CALL_SYSTEM['ADDONS']              =   true;
$CALL_SYSTEM['HOOKS']               =   true;
$CALL_SYSTEM['STYLE']               =  true;
$CALL_SYSTEM['TEMPLATE']            =  true;
$CALL_SYSTEM['TEMPLATESEDITS']      =  true;
$CALL_SYSTEM['GROUP']               = 	true;
$CALL_SYSTEM['MEMBER']              = 	true;


define('CLASS_NAME','PowerBBStyleMOD');
//We are going to use the addons module which previously includes common.php.
include('addons.module.php');
//include('common.php');
//-------------------------------------------



class PowerBBStyleMOD extends _functions
{
	function run()
	{
		global $PowerBB;

		$PowerBB->template->display('header');
			if ($PowerBB->_CONF['rows']['group_info']['admincp_style'] == '0')
			{
			  $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}

		if ($PowerBB->_CONF['member_permission'])
		{
			if ($PowerBB->_GET['add'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_AddMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_AddStart();
				}
			}
			elseif ($PowerBB->_GET['control'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_ControlMain();
				}
			}
			elseif ($PowerBB->_GET['edit'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_EditMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_EditStart();
				}
			}
			elseif ($PowerBB->_GET['del'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_DelMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_DelStart();
				}
			}
			elseif ($PowerBB->_GET['export'])
			{
				if ($PowerBB->_GET['start'])
				{
					$this->_ExportStart();
				}
			}
			elseif ($PowerBB->_GET['edit_css'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_CssMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_CssStart();
				}
			}
			elseif ($PowerBB->_GET['colouredit'])
			{
				if ($PowerBB->_GET['main'])
				{
					$this->_ColourEditMain();
				}
				elseif ($PowerBB->_GET['start'])
				{
					$this->_ColourEditStart();
				}
			}

			if ($PowerBB->_GET['default'])
			{
				$this->_DefaultMain();
			}

			$PowerBB->template->display('footer');
		}
	}

	function _AddMain()
	{
		global $PowerBB;

		$StyleDir = ('look/styles/forum/');

		if (is_dir($StyleDir))
		{
			$dir = opendir($StyleDir);

			if ($dir)
			{
				while (($file = readdir($dir)) !== false)
				{
					if ($file == '.'
						or $file == '..')
					{
						continue;
					}

					$StylesList[]['filename'] = $file;
				}

				closedir($dir);
			}
		}

		$PowerBB->_CONF['template']['foreach']['StyleList'] = $StylesList;

		 $TotalStylesNm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['style'] . " WHERE id"));
		 $PowerBB->template->assign('order',$TotalStylesNm+1);

		$PowerBB->template->display('style_add');
	}
	function _AddStart()
	{
		global $PowerBB;

		$this->_ExportStart();
	}

	function _ControlMain()
	{
		global $PowerBB;

		$StlArr 					= 	array();
		$StlArr['proc'] 			= 	array();
		$StlArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$StlArr['order']			=	array();
		$StlArr['order']['field']	=	'id';
		$StlArr['order']['type']	=	'DESC';

		$PowerBB->_CONF['template']['while']['StlList'] = $PowerBB->style->GetStyleList($StlArr);

		$StlDefArr 					= 	array();
		$StlDefArr['proc'] 			= 	array();
		$StlDefArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		$StlDefArr['order']			=	array();
		$StlDefArr['order']['field']	=	'id';
		$StlDefArr['order']['type']	=	'DESC';

		$PowerBB->_CONF['template']['while']['StlDef'] = $PowerBB->style->GetStyleList($StlDefArr);

		$PowerBB->template->display('styles_main');
	}

	function _EditMain()
	{
		global $PowerBB;

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		$PowerBB->template->display('style_edit');
	}

	function _EditStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);

		if (empty($PowerBB->_POST['name'])
			or empty($PowerBB->_POST['style_path'])
			or empty($PowerBB->_POST['image_path'])
			or empty($PowerBB->_POST['template_path']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
		}

		if ($PowerBB->_POST['order'] == '')
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
         }

		//////////

		$StlArr 			= 	array();
		$StlArr['field']	=	array();

		$StlArr['field']['style_title'] 	= 	$PowerBB->_POST['name'];
		$StlArr['field']['style_path'] 		= 	$PowerBB->_POST['style_path'];
		$StlArr['field']['style_order'] 	= 	$PowerBB->_POST['order'];
		$StlArr['field']['style_on'] 		= 	$PowerBB->_POST['style_on'];
		$StlArr['field']['image_path'] 		= 	$PowerBB->_POST['image_path'];
		$StlArr['field']['template_path'] 	= 	$PowerBB->_POST['template_path'];
		$StlArr['field']['cache_path'] 		= 	$PowerBB->_POST['cache_path'];
		$StlArr['where']					= 	array('id',$Inf['id']);

		$update = $PowerBB->style->UpdateStyle($StlArr);

		//////////

		if ($update)
		{
			//////////

			$UpdateArr 				= 	array();
			$UpdateArr['field']		=	array();

			$UpdateArr['field']['should_update_style_cache'] 	= 	1;
			$UpdateArr['where'] 								= 	array('style',$Inf['id']);

			$cache_update = $PowerBB->member->UpdateMember($UpdateArr);

			if ($PowerBB->_POST['style_on'] == '0')
			{
			$UpdateMemArr 				= 	array();
			$UpdateMemArr['field']		=	array();

			$UpdateMemArr['field']['style'] 	= 	$PowerBB->_CONF['info_row']['def_style'];
			$UpdateMemArr['where'] 				= 	array('style',$Inf['id']);

			$update = $PowerBB->member->UpdateMember($UpdateMemArr);
			}

			//////////

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Style_has_been_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;control=1&amp;main=1');

			//////////
		}

		//////////
	}

	function _DelMain()
	{
		global $PowerBB;

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		$PowerBB->template->display('style_del');
	}
	//Edited---------------
	function _DelStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);

		if ($PowerBB->_CONF['info_row']['def_style'] == $Inf['id'])
	     {
             $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_can_not_delete_the_default_Style']);
         }

        //
		if ($PowerBB->member->IsMember(array('where' => array('style',$Inf['id']))))
		{
		 $UpdateArr 				                = 	array();
		 $UpdateArr['field'] 	                    = 	array();
		 $UpdateArr['field']['style'] 			    = 	'1';
		 $UpdateArr['where']						=	array('style',$Inf['id']);

		 $update = $PowerBB->member->UpdateMember($UpdateArr);
		}

		$DelArr 			= 	array();
		$DelArr['where'] 	= 	array('id',$Inf['id']);
		//Undo template edits
		$AddonsMod = new PowerBBAddonsMOD();
		$Addons = $PowerBB->addons->GetAddonsList(array('where' => array('active',1)));
		if ( !empty($Addons) )
		{
			$AddonsMod = new PowerBBAddonsMOD();
			$applied   = 0;
			foreach ($Addons as $key => $addonrow )
			{
				$applied = 1;
				$AddonsMod->back_templates($addonrow,$Inf['id']);
			}
			if ( $applied ) $PowerBB->functions->msg("تم إعادة القوالب إلى اصلها مرة اخرى");
		}
		//--------------------

		$del = $PowerBB->style->DeleteStyle($DelArr);

		if ($del)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Style_has_been_deleted_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;control=1&amp;main=1');
		}
	}

   function _ExportStart()
   {
     global $PowerBB;

		//
		$path_foldr   = "look/styles/forum/".$PowerBB->_POST['foldr']."/templates";
		if ($PowerBB->style->IsStyle(array('where' => array('template_path',$path_foldr))))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['This_Style']. ' ' . $PowerBB->_POST['foldr'] . ' ' .$PowerBB->_CONF['template']['lang']['Already_added']);
		}
		else
	    {

			$name = $PowerBB->_POST['foldr'];
	        $path_t   = "look/styles/forum/".$name;
	        $path_s   = $path_t."/css/style.css";
	        $path_img = $path_t."/images";
	        $path_tpl = $path_t."/templates";
	        $path_ch  = $path_t."/compiler";


	         if ($PowerBB->_POST['anyversion'] == '0')
	         {

        	$xml_code = @file_get_contents($path_t.'/pbboard-style.xml');
		    $plugin = $PowerBB->addons->xml_to_array($xml_code);
            $version 			= $plugin['plugin']['version']['value'];

			 if (!$xml_code)
			  {
		      $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['file_pbboard_style_not_available_in_folder_style'].' '.$name .'<br /><br />'.$path_t.'/pbboard-style.xml');
			  }

			 if ($version != $PowerBB->_CONF['info_row']['MySBB_version'])
			  {
		      $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['version_style_Different']);
	          }
	 	  	}

	       	$StlArr 					= 	array();
			$StlArr['field']			=	array();

			$StlArr['field']['style_title'] 	= 	$PowerBB->_POST['name'];
			$StlArr['field']['style_path'] 		= 	$path_s;
			$StlArr['field']['style_order'] 	= 	$PowerBB->_POST['order'];
			$StlArr['field']['style_on'] 		= 	$PowerBB->_POST['style_on'];
			$StlArr['field']['image_path'] 		= 	$path_img;
			$StlArr['field']['template_path'] 	= 	$path_tpl;
			$StlArr['field']['cache_path'] 		= 	$path_ch;

			//Edited----------------------------------------
			$insert = $PowerBB->style->InsertStyle($StlArr);
			if ($insert)
			{
				$styleid = $PowerBB->DB->sql_insert_id();
				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Style_has_been_added_successfully']);
				//Apply template edits of our addons
				$Addons = $PowerBB->addons->GetAddonsList(array('where' => array('active',1)));
				if ( !empty($Addons) )
				{
					//lets start using the addons module abit
					$AddonsMod = new PowerBBAddonsMOD();
					foreach ($Addons as $key => $addonrow )
					{
						$xml_code = @file_get_contents('addons/'.$addonrow['name']);
						$plugin = $PowerBB->addons->xml_to_array($xml_code);
						if(is_array($plugin['plugin']['templates']))
						{
							$applied = 1;
							$AddonsMod->edit_templates($plugin,$addonrow,$styleid);
						}
					}
					$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['edit_templates_style_addons']);
				}
				$PowerBB->functions->redirect2('admin.php?page=style&amp;control=1&amp;main=1',3);
				if ( $applied == 1 ) $this->_ClearCache($styleid);
			}
			//---------------------------------------------------
	        else
	        {
	        	$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Style_is_not_added']);
	        }

        }
    }

	//Edited---------------------------------
	//This function deletes the new style's cache in case the style was used before
	function _ClearCache($styleid)
	{
		global $PowerBB;
		$style_query = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['style'] . " WHERE id='".intval($styleid)."'");
		while ($getstyle_row = $PowerBB->DB->sql_fetch_array($style_query))
		{
			if (is_dir($getstyle_row['cache_path']))
			{
				$dir = opendir($getstyle_row['cache_path']);
				if ($dir)
				{
					while (($file = readdir($dir)) !== false)
					{
						if ($file == '.' or $file == '..')
						{
							continue;
						}
						$del = unlink('./' . $getstyle_row['cache_path'] . '/' . $file);
					}
					closedir($dir);
				}
			}
		}
	}
	//----------------------------------------
    function _CssMain()
	{
		global $PowerBB;

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		if (empty($PowerBB->_GET['id']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}

		$CssArr 			= 	array();
		$CssArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

        $Css = $PowerBB->style->GetStyleInfo($CssArr);

        $path = $Css['style_path'];

        if (!file_exists($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}
    	$lines = file($path);
    	$context = '';

    	foreach ($lines as $line)
    	{
    		$context .= $line;
    	}

    	$context = $PowerBB->functions->CleanVariable($context,'unhtml');
        $PowerBB->template->assign('style_path',$Css['style_path']);
    	$PowerBB->template->assign('css_context',$context);

		$PowerBB->template->display('css_edit');
	}

	function _CssStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);

    	$StyleInfo = false;

    	$this->check_by_id($StyleInfo);

    	if (empty($PowerBB->_GET['style_path']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
    	}
    	if (empty($PowerBB->_GET['id']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}

    	$PowerBB->_GET['style_path'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['style_path'],'html');

    	$path = $PowerBB->_GET['style_path'];

    	if (!file_exists($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}

    	// To be more advanced :D
    	if (!is_writable($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['is_not_writable']);
    	}

    	$PowerBB->_POST['css_context'] = stripslashes($PowerBB->_POST['css_context']);

    	$fp = fopen($path,'w+');
    	$fw = fwrite($fp,$PowerBB->_POST['css_context']);

    	if ($fw)
    	{

            $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['CSS_has_been_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;edit_css=1&amp;main=1&amp;id=' . $PowerBB->_GET['id']);
    	}

		//////////
	}

	function _ColourEditMain()
	{
		global $PowerBB;

		//-----------------------------------------

		$this->check_by_id($PowerBB->_CONF['template']['Inf']);

		if (empty($PowerBB->_GET['id']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}


		$PowerBB->_GET['id'] = intval($PowerBB->_GET['id']);
   				$PowerBB->template->display('css_main_colour');

		//-----------------------------------------
		// check tree...
		//-----------------------------------------

		$found_id      = "";
		$found_content = "";
		$this_set      = "";

		if ( $PowerBB->_GET['p'] > 0 )
		{
			$in = ','.intval($PowerBB->_GET['p']);
		}

		//-----------------------------------------
		// Query
		//-----------------------------------------

		 $_query= $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['style'] . " WHERE id");

		//-----------------------------------------
		// check tree...
		//-----------------------------------------
		while( $row = $PowerBB->DB->sql_fetch_array($_query) )
		{

		        $path = $row['style_path'];

		        if (!file_exists($path))
		    	{
		    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		    	}
		    	$lines = file($path);
		    	$context = '';

		    	foreach ($lines as $line)
		    	{
		    		$context .= $line;
		    	}

		    	$context = $PowerBB->functions->CleanVariable($context,'unhtml');
				$found_id      = $row['id'];
				$found_content = $context;

			if ( $PowerBB->_GET['id'] == $row['id'] )
			{
				$this_set = $row;
			}
		}

		//-----------------------------------------


		$css = $found_content;
		$css = preg_replace( "#/\*.+?\*/#s", "", $css );
		//print "<pre>"; print $css; exit();
		//-----------------------------------------
		// Start the CSS matcher thingy
		//-----------------------------------------

		//.class { definitions }
		//#id { definitions }

		$colours = array();

		//-----------------------------------------
		// Make http:// safe..
		//-----------------------------------------

		$css = str_replace( 'http://', 'http|//', $css );

		preg_match_all( "/([\:\.\#\w\s,\-]+)\{(.+?)\}/s", $css, $match );

		for ($i=0; $i < count($match[0]); $i++)
		{
			$name    = trim($match[1][$i]);
			$content = trim($match[2][$i]);

			$defs    = explode( ';', $content );

			if ( count( $defs ) > 0 )
			{
				foreach( $defs as $a )
				{
					$a = trim($a);

					if ( $a != "" )
					{
						list( $property, $value ) = explode( ":", $a, 2 );

						$property = trim($property);
						$value    = trim( str_replace( 'http|//', 'http://', $value) );

						if ( $property )
						{
							if ( $property == 'color' or $property == 'background-color' )
							{
								$colours[ $name ][$property] = $value;
							}
							else
							{
								$colours[ $name ]['_extra'] .= $property.':'.$value.';'."\n";
							}
						}
					}
				}
			}
		}

		//print "<pre>"; print_r( $colours ); exit();



		if ( count($colours) < 1 )
		{
			$PowerBB->functions->error("CSS all gone wonky! No colours to edit");
		}


		foreach ( $colours as $prop => $val )
		{
			$tbl_colour = "";
			$tbl_bg     = "";
			$tbl_html   = "";

			$desc = $css_names[ $prop ];

			if ( $desc == "" )
			{
				$desc = 'None available';
			}

			$name = $prop;

			$md5 = md5($name);

			if ( strlen($name) > 80 )
			{
				$name = substr( $name, 0, 80 ) .'...';
			}

			$font_box  = $PowerBB->functions->form_simple_input('f'.$md5.'color'           , $val['color'], "14", "colors");
			$bgcol_box = $PowerBB->functions->form_simple_input('f'.$md5.'backgroundcolor' , $val['background-color'], "14", "colors");

			echo "<div class='tablerow1'>
								 <fieldset>
								  <legend><strong style='font-size:14px'>{$name}</strong></legend>
								  <table width='100%' border='0' cellpadding='4' cellspacing='0'>
								  <tr>
								   <td width='40%' valign='top'>
								    <fieldset>
								     <legend><strong>".$PowerBB->_CONF['template']['lang']['font_color']."</strong></legend>
										{$font_box}&nbsp;&nbsp;
										<input type='text' id='{$md5}color' size='6' style='border:1px solid black;background-color:{$val['color']}' readonly='readonly'>
									</fieldset>
									<br />
									<fieldset>
									 <legend><strong>".$PowerBB->_CONF['template']['lang']['background_color']."</strong></legend>
			 						    {$bgcol_box}&nbsp;&nbsp;
			 						    <input type='text' id='{$md5}backgroundcolor' size='6' style='border:1px solid black;background-color:{$val['background-color']}' readonly='readonly'>
			 						</fieldset>
			 					   </td>
			 					   <td width='60%' valign='top'>
			 					   <fieldset>
                                       <legend><strong>".$PowerBB->_CONF['template']['lang']['additional_css_properties']."</strong></legend>
			 						    <textarea class='textinput' dir='ltr' cols='40' rows='5' style='width:100%' name='f{$md5}extra' >
			 						    {$val['_extra']}
			 						    </textarea>
			 						</fieldset>
			 					   </td>
			 					  </tr>
			 					  </table>
			 					 </fieldset>
			 					 </div>";
		}

         				$PowerBB->template->display('css_main_colour_dn');

	}

	function _ColourEditStart()
	{
		global $PowerBB;

		$this->check_by_id($Inf);

    	$StyleInfo = false;

    	$this->check_by_id($StyleInfo);

    	if (empty($PowerBB->_GET['id']))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}

		$PowerBB->_GET['id'] = intval($PowerBB->_GET['id']);

		//-----------------------------------------
		// check tree...
		//-----------------------------------------

		$found_id      = "";
		$found_content = "";
		$this_set      = "";

		//-----------------------------------------
		// Query
		//-----------------------------------------

		 $_query= $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['style'] . " WHERE id");

		//-----------------------------------------
		// check tree...
		//-----------------------------------------

		while( $row = $PowerBB->DB->sql_fetch_array($_query) )
		{

		        $path = $row['style_path'];

		        if (!file_exists($path))
		    	{
		    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		    	}
		    	$lines = file($path);
		    	$context = '';

		    	foreach ($lines as $line)
		    	{
		    		$context .= $line;
		    	}

		    	$context = $PowerBB->functions->CleanVariable($context,'unhtml');
				$found_id      = $row['id'];
				$found_content = $context;

			if ( $PowerBB->_GET['id'] == $row['id'] )
			{
				$this_set = $row;
			}
		}

		//-----------------------------------------

		$css = $found_content;
		$css = preg_replace( "#/\*.+?\*/#s", "", $css );

		//-----------------------------------------
		// Start the CSS matcher thingy
		//-----------------------------------------

		$css     = str_replace( 'http://', 'http|//', $css );

		$colours = array();

		preg_match_all( "/([\:\.\#\w\s,\-]+)\{(.+?)\}/s", $css, $match );

		for ($i=0; $i < count($match[0]); $i++)
		{
			$name    = trim($match[1][$i]);
			$content = trim($match[2][$i]);

			$md5     = md5($name);

			$defs    = explode( ';', $content );

			if ( count( $defs ) > 0 )
			{
				foreach( $defs as $a )
				{
					$a = trim($a);

					if ( $a != "" )
					{
						list( $property, $value ) = explode( ":", $a, 2 );

						$property = trim($property);
						$value    = trim( str_replace( 'http|//', 'http://', $value) );

						if ( $property )
						{
							$colours[ $name ][$property] = $value;
						}
					}
				}
			}

			foreach( array( 'color', 'backgroundcolor' ) as $prop )
			{
				if ( strlen($PowerBB->_POST['f'.$md5.$prop]) >= 1 )
				{
					$field = $prop == 'backgroundcolor' ? 'background-color' : $prop;

					$colours[ $name ][$field] = stripslashes($PowerBB->_POST['f'.$md5.$prop]);
				}
			}

			if ( isset( $PowerBB->_POST['f'.$md5.'extra'] ) )
			{
				$tmp = str_replace( "\n", "", $PowerBB->_POST['f'.$md5.'extra'] );
				$tmp = str_replace( "\r", "", $tmp );

				$extra_attr = explode( ";", $tmp );

				if ( is_array( $extra_attr ) and count( $extra_attr ) )
				{
					foreach( $extra_attr as $l )
					{
						$l = str_replace( 'http://', 'http|//', $l );

						list( $p, $v ) = explode( ":", $l );

						$colours[ $name ][ trim($p) ] = trim( str_replace( 'http|//', 'http://', $v) );
					}
				}
			}
		}

		if ( count($colours) < 1 )
		{
			$PowerBB->functions->error("CSS all gone wonky! No colours to edit");
		}

		//-----------------------------------------

		unset($name);
		unset($property);

		$final = "";

		foreach( $colours as $name => $property )
		{
			$final .= $name."\n{\n";

			if ( is_array($property) and count($property) > 0 )
			{
				foreach( $property as $key => $value )
				{
					if ( $key AND isset($value) )
					{
						$final .= "\t".$key.": ".$value.";\n";
					}
				}
			}

			$final .= "}\n\n";

		}

		$PowerBB->_GET['txtcss']     = $final;
		$PowerBB->_POST['txtcss']                     = $final;
		$PowerBB->_GET['savereload'] = 0;

    	$PowerBB->_GET['style_path'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['style_path'],'html');

    	$path = $PowerBB->_GET['style_path'];

    	if (!file_exists($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
    	}

    	// To be more advanced :D
    	if (!is_writable($path))
    	{
    		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['is_not_writable']);
    	}

    	$PowerBB->_POST['txtcss'] = stripslashes($PowerBB->_POST['txtcss']);

    	$fp = fopen($path,'w+');
    	$fw = fwrite($fp,$PowerBB->_POST['txtcss']);

    	if ($fw)
    	{

            $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['CSS_has_been_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;colouredit=1&amp;main=1&amp;id=' . $PowerBB->_GET['id']);
    	}

		//////////
	}

	function _DefaultMain()
	{
		global $PowerBB;

        $update = array();
        $update = $PowerBB->info->UpdateInfo(array('value'=>$PowerBB->_POST['default'],'var_name'=>'def_style'));


		//////////

		if ($update)
		{
			//////////

           $getmember_query = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['member'] . " ORDER BY id DESC");

             while ($getmember_row = $PowerBB->DB->sql_fetch_array($getmember_query))
             {

				$UpdateArr 				                = 	array();
				$UpdateArr['field'] 	                    = 	array();
				$UpdateArr['field']['style'] 			    = 	$PowerBB->_POST['default'];
				$UpdateArr['where']						=	array('id',$getmember_row['id']);

				$update = $PowerBB->member->UpdateMember($UpdateArr);

             }

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Last_updated_successfully']);
			$PowerBB->functions->redirect('admin.php?page=style&amp;control=1&amp;main=1');

			//////////
		}

    }
}
class _functions
{
	function check_by_id(&$Inf)
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_request_is_not_valid']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$StyleArr 			= 	array();
		$StyleArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$Inf = $PowerBB->style->GetStyleInfo($StyleArr);

		if ($Inf == false)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Style_requested_does_not_exist']);
		}

		$PowerBB->functions->CleanVariable($Inf,'html');
	}
}

?>
