<?php
(!defined('IN_PowerBB')) ? die() : '';
class PowerBBCommon
{
	var $CheckMember;
    var $Main = array();
	var $Sub = array();
	var $Url;
	Var $Type;

	/**
	 * The main function
	 */
	function run()
	{

		$this->_GeneralProc();

		$this->_CheckMember();

		$this->_SetInformation();

		$this->_GetStylePath();

		$this->_TemplateAssign();

		$this->_GetForumAdress();

		$this->_ProtectionFunctions();

		$this->_CheckClose();


		//////////
	}



	/**
	 * Clean not important information
	 */
	function _GeneralProc()
	{
		global $PowerBB;

        // Get time zone
        $PowerBB->functions->GetTimezoneSet($PowerBB->_CONF['info_row']['timeoffset']);

        $LangInfoArr 				= 	array();
		$LangInfoArr['where']		=	array('id',$PowerBB->_CONF['info_row']['def_lang']);

		$DefLang = $PowerBB->lang->GetLangInfo($LangInfoArr);

		if ($PowerBB->_CONF['info_row']['mor_seconds_online'] == '300')
		{
 		// Delete not important rows in online table
 		$CleanOnline = $PowerBB->_CONF['timeout'];
        $CleanDelOnline = $PowerBB->DB->sql_query("DELETE FROM " . $PowerBB->table['online'] . " WHERE logged <= $CleanOnline ");

 		}
		else
		{
		// Delete not important rows in online table
        $time_check_online=$PowerBB->_CONF['now']-$PowerBB->_CONF['info_row']['mor_seconds_online'];
        $DelOnline = $PowerBB->DB->sql_query("DELETE FROM " . $PowerBB->table['online'] . " WHERE logged <= $time_check_online ");
		}

 		////////////
       // Delete not important rows in today table
        if ($PowerBB->_CONF['info_row']['show_online_list_today'] == 1)
       {
			if ($PowerBB->_CONF['info_row']['mor_hours_online_today'] == '0')
			{
	 		$CleanArr 			= 	array();
	 		$CleanArr['date'] 	= 	$PowerBB->_CONF['date'];

	 	 	$CleanToday = $PowerBB->online->CleanTodayTable($CleanArr);
	 	 	}
			else
			{
	 		 $mor_online_today = ($PowerBB->_CONF['now'] - ($PowerBB->_CONF['info_row']['mor_hours_online_today'] * 86400));
	         $CleanToday = $PowerBB->DB->sql_query("DELETE FROM " . $PowerBB->table['today'] . " WHERE logged <= $mor_online_today");
	 	    }
	 	 	////////////
			if ($PowerBB->_CONF['info_row']['today_date_cache'] != $PowerBB->_CONF['date'])
			{
				$PowerBB->info->UpdateInfo(array('value'=>'1','var_name'=>'today_number_cache'));
				$PowerBB->info->UpdateInfo(array('value'=>$PowerBB->_CONF['date'],'var_name'=>'today_date_cache'));
			}
      }
		////////////
	}


	function _GetForumAdress()
	{
		global $PowerBB;

		$url = $PowerBB->functions->GetForumAdress();

		$PowerBB->template->assign('url',$url);
	}


	function _CheckMember()
	{
		global $PowerBB;

		////////////

		if ($PowerBB->functions->IsCookie($PowerBB->_CONF['username_cookie'])
			and $PowerBB->functions->IsCookie($PowerBB->_CONF['password_cookie']))
		{
			////////////

			$username = $PowerBB->_COOKIE[$PowerBB->_CONF['username_cookie']];
			$password = $PowerBB->_COOKIE[$PowerBB->_CONF['password_cookie']];

			////////////

			// Check if the visitor is member or not ?
 			$MemberArr 			= 	array();
			$MemberArr['get']	= 	'*';

			$MemberArr['where']	=	array();

			$MemberArr['where'][0]				=	array();
			$MemberArr['where'][0]['name']		=	'username';
			$MemberArr['where'][0]['oper']		=	'=';
			$MemberArr['where'][0]['value']		=	$username;

			$MemberArr['where'][1]				=	array();
			$MemberArr['where'][1]['con']		=	'AND';
			$MemberArr['where'][1]['name']		=	'password';
			$MemberArr['where'][1]['oper']		=	'=';
			$MemberArr['where'][1]['value']		=	$password;

			// If the information isn't valid CheckMember's value will be false
			// otherwise the value will be an array
			$this->CheckMember = $PowerBB->member->GetMemberInfo($MemberArr);

			////////////

			// This is a member :)
			if ($this->CheckMember != false)
			{
				$this->__MemberProcesses();
			}
			// This is visitor
			else
			{
				$this->__VisitorProcesses();
			}
		}
		else
		{
			$this->__VisitorProcesses();
		}

		////////////
	}

	/**
	 * If the Guest is member , call this function
	 */
	function __MemberProcesses()
	{
		global $PowerBB;

		$PowerBB->_CONF['rows']['member_row'] 	= 	$this->CheckMember;
		$PowerBB->_CONF['member_permission']	 	= 	true;

		////////////

		// I hate SQL injections
		//$PowerBB->functions->CleanVariable($PowerBB->_CONF['rows']['member_row'],'sql');

		// I hate XSS
		$PowerBB->functions->CleanVariable($PowerBB->_CONF['rows']['member_row'],'html');

		////////////

		// alias name
		// TODO : Delete this line, it's get size from memory!
		$PowerBB->_CONF['member_row'] = $PowerBB->_CONF['rows']['member_row'];

		////////////

		// Get the member's group info and store it in _CONF['group_info']
		$GroupInfo 				= 	array();
		$GroupInfo['where'] 	= 	array('id',$PowerBB->_CONF['member_row']['usergroup']);

		$PowerBB->_CONF['rows']['group_info'] = $PowerBB->group->GetGroupInfo($GroupInfo);

		// alias name
		// TODO : Delete this line, it's get size from memory!
		$PowerBB->_CONF['group_info'] = $PowerBB->_CONF['rows']['group_info'];

		////////////

		// Check if the member is already online
		$IsOnline = $PowerBB->online->IsOnline(array('where' => array('user_id',$PowerBB->_CONF['member_row']['id'])));
		////////////

		// Where is the member now ?
		$MemberLocation = $PowerBB->_CONF['template']['lang']['home_Page'];

		$page = empty($PowerBB->_GET['page']) ? 'index' : $PowerBB->_GET['page'];
		$locations 					= 	array();
		$locations['index'] 		= 	$PowerBB->_CONF['template']['lang']['home_Page'];
		$locations['forum'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_forum'];
		$locations['profile'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_member'];
		$locations['static'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_Statistics'];
		$locations['member_list'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_members_list'];
		$locations['search'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_search_page'];
		$locations['announcement'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_announcemen'];
		$locations['team'] 			= 	$PowerBB->_CONF['template']['lang']['Seen_the_teams'];
		$locations['login'] 		= 	$PowerBB->_CONF['template']['lang']['He_Login'];
		$locations['logout'] 		= 	$PowerBB->_CONF['template']['lang']['He_logout'];
		$locations['usercp'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_usercp'];
		$locations['pm'] 			= 	$PowerBB->_CONF['template']['lang']['Seen_the_pm'];
		$locations['topic'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_topic'];
		$locations['new_topic'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_new_topic'];
		$locations['new_reply'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_new_reply'];
		$locations['vote'] 			= 	$PowerBB->_CONF['template']['lang']['Seen_the_vote'];
		$locations['tags'] 			= 	$PowerBB->_CONF['template']['lang']['Seen_the_tags'];
		$locations['online'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_online'];
		if (array_key_exists($page,$locations))
		{
			$MemberLocation = $locations[$page];

		}

         $PowerBB->template->assign('Location',$MemberLocation);

		// Get username with group style
		$username_style = $PowerBB->_CONF['member_row']['username_style_cache'];


		////////////
		// Member don't exists in online table , so we insert member info
		if (!$IsOnline)
		{
			$InsertOnline 			= 	array();
			$InsertOnline['field'] 	= 	array();

			$InsertOnline['field']['username'] 			= 	$PowerBB->_CONF['member_row']['username'];
			$InsertOnline['field']['username_style'] 	= 	$username_style;
			$InsertOnline['field']['logged'] 			= 	$PowerBB->_CONF['now'];
			$InsertOnline['field']['path'] 				= 	addslashes($PowerBB->_SERVER['QUERY_STRING']);
			$InsertOnline['field']['user_ip'] 			= 	$PowerBB->_CONF['ip'];
			$InsertOnline['field']['hide_browse'] 		= 	$PowerBB->_CONF['member_row']['hide_online'];
			$InsertOnline['field']['user_location'] 	= 	$MemberLocation;
			$InsertOnline['field']['subject_show'] 		= 	$subject_show;
			$InsertOnline['field']['subject_id'] 		= 	$subject_id;
			$InsertOnline['field']['user_id'] 			= 	$PowerBB->_CONF['member_row']['id'];

			$insert = $PowerBB->online->InsertOnline($InsertOnline);
		}
		// Member is already online , just update information
		else
		{

			if ($IsOnline['logged'] < $PowerBB->_CONF['timeout']
				or $IsOnline['path'] != $PowerBB->_SERVER['QUERY_STRING']
				or $IsOnline['username_style'] != $username_style
				or $IsOnline['hide_browse'] != $PowerBB->_CONF['rows']['member_row']['hide_online'])
			{
				$UpdateOnline 					= 	array();
				$UpdateOnline['field']			=	array();

				$UpdateOnline['field']['username'] 			= 	$PowerBB->_CONF['member_row']['username'];
				$UpdateOnline['field']['username_style'] 	= 	$username_style;
				$UpdateOnline['field']['logged']			=	$PowerBB->_CONF['now'];
				$UpdateOnline['field']['path']				=	addslashes($PowerBB->_SERVER['QUERY_STRING']);
				$UpdateOnline['field']['user_ip']			=	$PowerBB->_CONF['ip'];
				$UpdateOnline['field']['hide_browse']		=	$PowerBB->_CONF['member_row']['hide_online'];
				$UpdateOnline['field']['user_location']		=	$MemberLocation;
				$UpdateOnline['field']['subject_show']		=	$subject_show;
				$UpdateOnline['field']['subject_id']		=	$subject_id;
				$UpdateOnline['field']['user_id']			=	$PowerBB->_CONF['member_row']['id'];
				$UpdateOnline['where']						=	array('username',$PowerBB->_CONF['member_row']['username']);

				$update = $PowerBB->online->UpdateOnline($UpdateOnline);
			}
		}

		////////////
     if ($PowerBB->_CONF['info_row']['show_online_list_today'] == 1)
     {
		// Ok , now we check if this member is exists in today list
       if (!$PowerBB->online->IsToday(array('where' => array('user_id',$PowerBB->_CONF['member_row']['id']))))
       {
       // Member isn't exists in today table , so insert the member
			////////////
			$InsertTodayArr 			= 	array();
			$InsertTodayArr['field']	=	array();

			$InsertTodayArr['field']['username'] 		= 	$PowerBB->_CONF['member_row']['username'];
			$InsertTodayArr['field']['user_id'] 		= 	$PowerBB->_CONF['member_row']['id'];
			$InsertTodayArr['field']['user_date'] 		= 	$PowerBB->_CONF['date'];
			$InsertTodayArr['field']['logged'] 		    = 	$PowerBB->_CONF['now'];
			$InsertTodayArr['field']['hide_browse'] 	= 	$PowerBB->_CONF['member_row']['hide_online'];
			$InsertTodayArr['field']['username_style'] 	= 	$username_style;

			$InsertToday = $PowerBB->online->InsertToday($InsertTodayArr);

			////////////

			if ($InsertToday)
			{
				////////////

				$UpdateArr 				= 	array();
				$UpdateArr['field']		=	array();

				$UpdateArr['field']['visitor'] 	= 	$PowerBB->_CONF['member_row']['visitor'] + 1;
				$UpdateArr['where'] 			= 	array('id',$PowerBB->_CONF['member_row']['id']);

				$PowerBB->member->UpdateMember($UpdateArr);

				////////////

				if ($PowerBB->_CONF['info_row']['today_date_cache'] == $PowerBB->_CONF['date'])
				{
					$number = $PowerBB->_CONF['info_row']['today_number_cache'] + 1;

					$PowerBB->info->UpdateInfo(array('value'=>$number,'var_name'=>'today_number_cache'));
				}

				////////////
			}

			////////////
		}

	 }	////////////


		// Can't find last visit cookie , so register it
		if (!$PowerBB->functions->IsCookie('PowerBB_lastvisit'))
		{
			$CookieArr 					= 	array();
			$CookieArr['last_visit'] 	= 	(empty($PowerBB->_CONF['member_row']['lastvisit'])) ? $PowerBB->_CONF['now'] or  $PowerBB->_CONF['date']: $PowerBB->_CONF['member_row']['lastvisit'];
			$CookieArr['date'] 			= 	$PowerBB->_CONF['now'];
			$CookieArr['id'] 			= 	$PowerBB->_CONF['member_row']['id'];

			$PowerBB->member->LastVisitCookie($CookieArr);

		}

		if ($PowerBB->_CONF['member_row']['lastvisit'] =='')
		{
			$CookieArr 					= 	array();
			$CookieArr['last_visit'] 	= 	(empty($PowerBB->_CONF['member_row']['lastvisit'])) ? $PowerBB->_CONF['now'] or  $PowerBB->_CONF['date']: $PowerBB->_CONF['member_row']['lastvisit'];
			$CookieArr['date'] 			= 	$PowerBB->_CONF['now'];
			$CookieArr['id'] 			= 	$PowerBB->_CONF['member_row']['id'];

			$PowerBB->member->LastVisitCookie($CookieArr);

		}



		////////////

		// Get member style
		if ($PowerBB->_CONF['member_row']['style_id_cache'] == $PowerBB->_CONF['member_row']['style'])
		{
			$cache = unserialize(base64_decode($PowerBB->_CONF['member_row']['style_cache']));

			$PowerBB->_CONF['rows']['style']['style_path'] 		= 	$cache['style_path'];
			$PowerBB->_CONF['rows']['style']['image_path'] 		= 	$cache['image_path'];
			$PowerBB->_CONF['rows']['style']['template_path'] 	= 	$cache['template_path'];
			$PowerBB->_CONF['rows']['style']['cache_path'] 		= 	$cache['cache_path'];
			$PowerBB->_CONF['rows']['style']['id'] 				= 	$PowerBB->_CONF['member_row']['style'];
		}
		else if ($PowerBB->_CONF['member_row']['style_id_cache'] != $PowerBB->_CONF['member_row']['style']
				or ($PowerBB->_CONF['member_row']['should_update_style_cache']))
		{
			////////////

			$GetStyleArr 			= 	array();
			$GetStyleArr['where']	=	array('id',$PowerBB->_CONF['member_row']['style']);

			$PowerBB->_CONF['rows']['style'] = $PowerBB->style->GetStyleInfo($GetStyleArr);

			////////////

			$style_cache = $PowerBB->style->CreateStyleCache(array('where'=>array('id',$PowerBB->_CONF['member_row']['style'])));

			////////////

			$UpdateArr						=	array();
			$UpdateArr['field']				=	array();

			$UpdateArr['field']['style_cache'] 		= 	$style_cache;
			$UpdateArr['field']['style_id_cache']	=	$PowerBB->_CONF['member_row']['style'];
			$UpdateArr['where']						=	array('id',$PowerBB->_CONF['member_row']['id']);

			if ($PowerBB->_CONF['member_row']['should_update_style_cache'])
			{
				$UpdateArr['field']['should_update_style_cache'] = 0;
			}

			$update_cache = $PowerBB->member->UpdateMember($UpdateArr);

			////////////
		}

		////////////

		if ($PowerBB->_CONF['member_row']['logged'] < $PowerBB->_CONF['timeout'])
		{
			$LoggedArr 				= 	array();
			$LoggedArr['field'] 	= 	array();

			$LoggedArr['field']['logged'] 		= 	$PowerBB->_CONF['now'];
			$LoggedArr['field']['member_ip'] 	= 	$PowerBB->_CONF['ip'];
			$LoggedArr['where']					=	array('id',$PowerBB->_CONF['member_row']['id']);

			$PowerBB->member->UpdateMember($LoggedArr);

			$UpdateOnline 					= 	array();
			$UpdateOnline['field']			=	array();
			$UpdateOnline['field']['last_move'] = $PowerBB->_CONF['now'];
			$UpdateOnline['where']                    =    array('username',$PowerBB->_CONF['member_row']['username']);
	        $update = $PowerBB->online->UpdateOnline($UpdateOnline);
		}

	}

	/**
	 * If the visitor isn't member, call this function
	 */
	function __VisitorProcesses()
	{
		global $PowerBB;

 		/////////////////////////////////////////////////
        // Get Language visitor
        $LangInfoArr 				= 	array();
		$LangInfoArr['where']		=	array('id',$PowerBB->_CONF['info_row']['def_lang']);

		$DefLang = $PowerBB->lang->GetLangInfo($LangInfoArr);

		$VisitorLangArr 						= 	array();
        $VisitorLangArr['where'] 		    	= 	array('ip',$PowerBB->_CONF['ip']);

		$InfoVisitor = $PowerBB->visitor->GetVisitorInfo($VisitorLangArr);

		$VisitorLangInfoArr 				= 	array();
		$VisitorLangInfoArr['where']		=	array('id',$InfoVisitor['lang_id']);

		$VisitorLang = $PowerBB->lang->GetLangInfo($VisitorLangInfoArr);

        if (!$VisitorLang['id'])
        {
       	  include("lang/".$DefLang['lang_path']."/language.php");
	      $PowerBB->template->assign('lang',$lang);
        }
       	else
		{
	       include("lang/".$VisitorLang['lang_path']."/language.php");
	       $PowerBB->template->assign('lang',$lang);
		   $PowerBB->template->assign('VisitorLang',$InfoVisitor['lang_id']);
		 }



		$PowerBB->_CONF['member_permission'] = false;

		// Get the visitor's group info and store it in _CONF['group_info']
		$GroupInfo 				= 	array();
		$GroupInfo['where'] 	= 	array('id','7');

		$PowerBB->_CONF['group_info'] = $PowerBB->group->GetGroupInfo($GroupInfo);

		// Get username with group style
		$username_style = $PowerBB->_CONF['member_row']['username_style_cache'];



		// Where is the member now ?
		$GuestLocation = $PowerBB->_CONF['template']['lang']['home_Page'];

		$page = empty($PowerBB->_GET['page']) ? 'index' : $PowerBB->_GET['page'];
		$locations 					= 	array();
		$locations['index'] 		= 	$PowerBB->_CONF['template']['lang']['home_Page'];
		$locations['forum'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_forum'];
		$locations['profile'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_member'];
		$locations['static'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_Statistics'];
		$locations['member_list'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_members_list'];
		$locations['search'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_search_page'];
		$locations['announcement'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_announcemen'];
		$locations['team'] 			= 	$PowerBB->_CONF['template']['lang']['Seen_the_teams'];
		$locations['login'] 		= 	$PowerBB->_CONF['template']['lang']['He_Login'];
		$locations['logout'] 		= 	$PowerBB->_CONF['template']['lang']['He_logout'];
		$locations['usercp'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_usercp'];
		$locations['pm'] 			= 	$PowerBB->_CONF['template']['lang']['Seen_the_pm'];
		$locations['topic'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_topic'];
		$locations['new_topic'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_new_topic'];
		$locations['new_reply'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_new_reply'];
		$locations['vote'] 			= 	$PowerBB->_CONF['template']['lang']['Seen_the_vote'];
		$locations['tags'] 			= 	$PowerBB->_CONF['template']['lang']['Seen_the_tags'];
		$locations['online'] 		= 	$PowerBB->_CONF['template']['lang']['Seen_the_online'];

		if (array_key_exists($page,$locations))
		{
			$GuestLocation = $locations[$page];
		}

		// Check if the visitor is already online
       	$IsGuestOnline = $PowerBB->online->IsOnline(array('where' => array('user_ip',$PowerBB->_CONF['ip'])));
       	$isBot = $PowerBB->functions->is_bot();
        $BotName = $PowerBB->functions->bot_name();

		$OnlineArr = array();
		$OnlineArr['where'] = array('user_ip',$PowerBB->_CONF['ip']);

		$OnlineInfo = $PowerBB->online->GetOnlineInfo($OnlineArr);

		if (!$IsGuestOnline)
		{
			$InsertOnlineArr 			= 	array();
			$InsertOnlineArr['field'] 	= 	array();

			$InsertOnlineArr['field']['username'] 			= 	'Guest';
			$InsertOnlineArr['field']['username_style'] 	= 	'Guest';
			$InsertOnlineArr['field']['logged'] 			= 	$PowerBB->_CONF['now'];
			$InsertOnlineArr['field']['path'] 				= 	addslashes($PowerBB->_SERVER['QUERY_STRING']);
			$InsertOnlineArr['field']['user_ip'] 			= 	$PowerBB->_CONF['ip'];
			$InsertOnlineArr['field']['user_location'] 	    = 	$GuestLocation;
			$InsertOnlineArr['field']['user_id']			=	-1;
			$InsertOnlineArr['field']['subject_show']		=	$subject_show;
			$InsertOnlineArr['field']['subject_id']		    =	$subject_id;
            $InsertOnlineArr['field']['last_move']          = $PowerBB->_CONF['now'];
            $InsertOnlineArr['field']['is_bot']             = $isBot;
            $InsertOnlineArr['field']['bot_name']           = $BotName;

			$insert = $PowerBB->online->InsertOnline($InsertOnlineArr);

		}
		else
		{

		   // visitor already online , just update information


			if ($OnlineInfo)
			{

				$UpdateOnlineArr 					= 	array();
				$UpdateOnlineArr['field']			=	array();

				$UpdateOnlineArr['field']['path']				=	addslashes($PowerBB->_SERVER['QUERY_STRING']);
				$UpdateOnlineArr['field']['username'] 	= 	'Guest';
				$UpdateOnlineArr['field']['username_style'] 	= 	'Guest';
				$UpdateOnlineArr['field']['user_location']		=	$GuestLocation;
				$UpdateOnlineArr['field']['subject_show']		=	$subject_show;
				$UpdateOnlineArr['field']['subject_id']		    =	$subject_id;
				$UpdateOnlineArr['field']['last_move']          =   $PowerBB->_CONF['now'];
				$UpdateOnlineArr['where']						=	array('id',$OnlineInfo['id']);

			   $update = $PowerBB->online->UpdateOnline($UpdateOnlineArr);

			}

		}
		// Get visitor's style
		$style_id = (!empty($PowerBB->_COOKIE[$PowerBB->_CONF['style_cookie']])) ? $PowerBB->_COOKIE[$PowerBB->_CONF['style_cookie']] : $PowerBB->_CONF['info_row']['def_style'];

		$style_id = $PowerBB->functions->CleanVariable($style_id,'intval');

		$StyleArr 			= 	array();
		$StyleArr['where'] 	= 	array('id',$style_id);

		$PowerBB->_CONF['rows']['style'] = $PowerBB->style->GetStyleInfo($StyleArr);


	}

	function _SetInformation()
	{
		global $PowerBB;

		if (!isset($PowerBB->_CONF['rows']['style'])
			or !is_array($PowerBB->_CONF['rows']['style'])
			or empty($PowerBB->_CONF['rows']['style']['template_path'])
			or empty($PowerBB->_CONF['rows']['style']['cache_path']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Not_Was_style_Information']);
		}

		$PowerBB->template->SetInformation(	$PowerBB->_CONF['rows']['style']['template_path'] . '/',
												$PowerBB->_CONF['rows']['style']['cache_path'] . '/',
												'.tpl',
												'file');

  		$pager_html 	= 	array();
  		$pager_html[0] 	= 	$PowerBB->template->content('pager_style_part1');
  		$pager_html[1] 	= 	$PowerBB->template->content('pager_style_part2');
  		$pager_html[2] 	= 	$PowerBB->template->content('pager_style_part3');
  		$pager_html[3] 	= 	$PowerBB->template->content('pager_style_part4');
		$PowerBB->pager->SetInformation($pager_html);
	}



	/**
	 * Get the style path
	 */
	function _GetStylePath()
	{
		global $PowerBB;
		global $_VARS;

		if (!strstr($PowerBB->_CONF['rows']['style']['style_path'],'http://www.'))
		{
			$filename = explode('/',$PowerBB->_CONF['rows']['style']['style_path']);

			$PowerBB->template->assign('style_path',$_VARS['path'] . $PowerBB->_CONF['rows']['style']['style_path']);
		}
		else
		{
			$PowerBB->functions->error('Path error / Plot style file missing : ' . $PowerBB->_CONF['rows']['style']['style_path']);
		}

	}

	/**
	 * Close the forums
	 */
	function _CheckClose()
	{
		global $PowerBB;

		// This member is banned :/
		if (!$PowerBB->_GET['page'] == 'logout')
		{
			if ($PowerBB->_CONF['group_info']['banned'] == 1)
			{
				// Stop the page with small massege
				$PowerBB->template->assign('_CONF',$PowerBB->_CONF);
	        	$PowerBB->template->assign('image_path',$_VARS['path'] . $PowerBB->_CONF['rows']['style']['image_path']);
				$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['Can_you_enter_the_Forum']);
	            $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['suspended_member']);
	        }
        }
        //  Stop ipaddress banned
		if ($PowerBB->banned->IsBanned(array('where' => array('ip',$PowerBB->_CONF['ip']))))
		{
			$BanInfoArr 							= 	array();
	        $BanInfoArr['where'] 		    	= 	array('ip',$PowerBB->_CONF['ip']);

			$InfoBan = $PowerBB->banned->GetBannedInfo($BanInfoArr);

			$stop = ($PowerBB->_CONF['ip'] and !$PowerBB->_CONF['ip']) ? false : true;
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['ban_IP'].'<br />'.$PowerBB->_CONF['template']['lang']['reason_ban'].' '.$InfoBan['reason'],$stop,$stop);
		}

		// if the forum close by admin , stop the page
		if ($PowerBB->_CONF['info_row']['board_close'])
    	{
  			if ($PowerBB->_CONF['group_info']['admincp_allow'] != 1
  				and !defined('LOGIN'))
        	{

        		// If the PowerCode is allow , use it

				$PowerBB->_CONF['info_row']['board_msg'] = $PowerBB->Powerparse->replace($PowerBB->_CONF['info_row']['board_msg']);

				// Convert the smiles to image

        		$PowerBB->template->assign('_CONF',$PowerBB->_CONF);
        		$PowerBB->template->assign('image_path',$_VARS['path'] . $PowerBB->_CONF['rows']['style']['image_path']);
        		$PowerBB->functions->ShowHeader();
    			$PowerBB->functions->error($PowerBB->_CONF['info_row']['board_msg']);
  			}

 		}




	}

// Protect the forums from script kiddie and crackers
	function _ProtectionFunctions()
	{
		global $PowerBB;
		//////////
		// Check if $_GET don't value any HTML or Javascript codes
    	foreach ($PowerBB->_GET as $xss_get)
    	{
   			if ((@strstr($xss_get, "<[^>]*script*\"?[^>]*>")) or
       			(@strstr($xss_get,"<[^>]*object*\"?[^>]*>")) or
       			(@strstr($xss_get, "<[^>]*iframe*\"?[^>]*>")) or
       			(@strstr($xss_get, "<[^>]*applet*\"?[^>]*>")) or
       			(@strstr($xss_get, "<[^>]*meta*\"?[^>]*>")) 	or
       			(@strstr($xss_get, "<[^>]*style*\"?[^>]*>")) 	or
       			(@strstr($xss_get, "<[^>]*form*\"?[^>]*>")) 	or
       			(@strstr($xss_get, "<[^>]*img*\"?[^>]*>")))
            {
            	$PowerBB->functions->ShowHeader();
    			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_the_process_of_illegal']);
   			}
  		}

  		//////////

		// Check if $_GET don't value any SQL Injection
  		foreach ($PowerBB->_GET as $sql_get)
    	{

			$kv = array();
			foreach ($PowerBB->_GET as $var_name => $value) {
			$kv[] = "$var_name=$value";
			if ($value !='')
			{
			 $PowerBB->_GET[$var_name] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_GET[$var_name],'sql');
			}
			}

   			if ((@strstr($sql_get, "select")) or
       			(@strstr($sql_get, "create")) or
       			(@strstr($sql_get, "alert")) or
       			(@strstr($sql_get, "like")) or
       			(@strstr($sql_get, "union")) or
       			(@strstr($sql_get, "onload")) or
       			(@strstr($sql_get, "%")))
       		{
       		    $PowerBB->functions->ShowHeader();
       			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_the_process_of_illegal']);
   			}
  		}

  		//////////

  		// Stop any unknown forms
 		if ($PowerBB->_SERVER['REQUEST_METHOD'] == 'POST')
    	{
    		//////////
  			$Y = explode('/',$GLOBALS['HTTP_REFERER']);
  			$X = explode('/',$GLOBALS['HTTP_HOST']);

  			//////////

  			if ($Y[2] != $X[0])
        	{
        		$PowerBB->functions->ShowHeader();
   				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_the_process_of_illegal']);
  			}

  			//////////
 		}

 		//////////
	}

	/**
	 * Assign the important variables for template
	 */
	function _TemplateAssign()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['group_info']['admincp_allow']
		or $PowerBB->_CONF['group_info']['vice'])
		{
			$PowerBB->template->assign('admin_mod_toolbar',0);
		}
		else
		{
			$PowerBB->template->assign('admin_mod_toolbar',1);
		}

		$PowerBB->template->assign('image_path',$_VARS['path'] . $PowerBB->_CONF['rows']['style']['image_path']);



		$PowerBB->template->assign('_CONF',$PowerBB->_CONF);
		$PowerBB->template->assign('_COOKIE',$PowerBB->_COOKIE);


		/** For debug only **/
		$PowerBB->template->assign('_SERVER',$PowerBB->_SERVER);


 		if ($PowerBB->_CONF['info_row']['active_subject_today'])
		{
		      /**
		   * Ok , are you ready to get subject today nm ? :)
		   */
			$day 	= 	date('j');
			$month 	= 	date('n');
			$year 	= 	date('Y');

			$from 	= 	mktime(0,0,0,$month,$day,$year);
			$to 	= 	mktime(23,59,59,$month,$day,$year);

		     $forum_not = $PowerBB->_CONF['info_row']['last_subject_writer_not_in'];
		     $subject_today_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['subject'] . " WHERE native_write_time BETWEEN " . $from . " AND " . $to . " AND section not in (" .$forum_not. ") AND review_subject<>1 AND delete_topic<>1 "));
			 $PowerBB->template->assign('subject_today_nm',$subject_today_nm);

		}
			/**
		 * Get subject special nm
		 */
         $subject_special_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['subject'] . " WHERE special='1'"));
		 $PowerBB->template->assign('subject_special_nm',$subject_special_nm);
			/**
		 * Get last posts bar
		 */
       if ($PowerBB->_CONF['info_row']['activate_lasts_posts_bar'] == 1)
	 {

		$LastPostsArr 							= 	array();

		// Order data
		$LastPostsArr['order'] 				= 	array();
		$LastPostsArr['order']['field'] 	= 	'write_time';
		$LastPostsArr['order']['type'] 		= 	'DESC';

		// Ten rows only
		$LastPostsArr['limit']				=	$PowerBB->_CONF['info_row']['lasts_posts_bar_num'];

        $LastPostsArr['where'][1] 			= 	array();
		$LastPostsArr['where'][1]['con']		=	'AND';
		$LastPostsArr['where'][1]['name'] 	= 	'review_subject<>1 AND sec_subject<>1 AND delete_topic';
		$LastPostsArr['where'][1]['oper'] 	= 	'<>';
		$LastPostsArr['where'][1]['value'] 	= 	'1';


		// Clean data
		$LastPostsArr['proc'] 				= 	array();
		$LastPostsArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');
        $LastPostsArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$LastPostsArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

        $PowerBB->_CONF['template']['while']['LastsPosts'] = $PowerBB->subject->GetSubjectList($LastPostsArr);

        	if ($PowerBB->_CONF['template']['while']['LastsPosts'] != false)
			{
				$PowerBB->template->assign('LastsPosts_Show',true);

			}
			else
			{
				$PowerBB->template->assign('LastsPosts_Show',false);
			}
        }

		// time
        $timestamp= time($PowerBB->_CONF['info_row']['timesystem']);
        $timest = $PowerBB->functions->time($timestamp);
		$PowerBB->template->assign('timer',$timest);

		// Get style list
		$StyleListArr 							= 	array();

		// Clean data
		$StyleListArr['proc']					=	array();
		$StyleListArr['proc']['*']				=	array('method'=>'clean','param'=>'html');

		// Where setup
		$StyleListArr['where'][0]				=	array();
		$StyleListArr['where'][0]['con']		=	'AND';
		$StyleListArr['where'][0]['name']		=	'style_on';
		$StyleListArr['where'][0]['oper']		=	'=';
		$StyleListArr['where'][0]['value']		=	'1';

		// Order setup
		$StyleListArr['order'] 					= 	array();
		$StyleListArr['order']['field'] 		= 	'style_order';
		$StyleListArr['order']['type'] 			= 	'ASC';

		$PowerBB->_CONF['template']['while']['StyleList'] = $PowerBB->style->GetStyleList($StyleListArr);

     if ($PowerBB->_CONF['info_row']['show_ads'] == 1)
		{
		// show ads
		$AdsArr 					= 	array();
		$AdsArr['order']			=	array();
		$AdsArr['order']['field']	=	'id';
		$AdsArr['order']['type']	=	'ASC';
		$AdsArr['proc'] 			= 	array();
		$AdsArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['AdsList'] = $PowerBB->ads->GetAdsList($AdsArr);

		 $adsnum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['ads'] . " WHERE id"));

		 $PowerBB->template->assign('adsnum',$adsnum);
		if ($PowerBB->_CONF['template']['while']['AdsList'] == false)
		{
			$PowerBB->template->assign('No_Ads',true);
		}
		else
		{
			$PowerBB->template->assign('No_Ads',false);
		}

      }
        //////

		if ($PowerBB->_CONF['info_row']['activate_chat_bar'] == 1)
		{
        // GET Caht Messages
		$CahtArr 					= 	array();
		$CahtArr['order']			=	array();
		$CahtArr['order']['field']	=	'id';
		$CahtArr['order']['type']	=	'DESC';
		$CahtArr['limit']           = $PowerBB->_CONF['info_row']['chat_message_num'];
		$CahtArr['proc'] 			= 	array();
		$CahtArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

       $PowerBB->_CONF['template']['while']['Messages'] = $PowerBB->chat->GetChatList($CahtArr);
       }


       	 /////////////////////////////////////////////////
        // Get Language members
        if ($PowerBB->_CONF['member_permission'])
		{
			/** Get member Language **/

	        if ($PowerBB->_CONF['member_row']['lang'] == '0')
			 {
				/** Get member lang **/
				$negLangArr 				= 	array();
				$negLangArr['where']		=	array('id',$PowerBB->_CONF['member_row']['lang']+1);

				$neg_lang = $PowerBB->lang->GetLangInfo($negLangArr);

				 include("lang/".$neg_lang['lang_path']."/language.php");
				 $PowerBB->template->assign('lang',$lang);
	         }
	         elseif ($PowerBB->_CONF['member_row']['lang'] > '0')
			 {
				/** Get member lang **/
				$plsLangArr 				= 	array();
				$plsLangArr['where']		=	array('id',$PowerBB->_CONF['member_row']['lang']);

				$pls_lang = $PowerBB->lang->GetLangInfo($plsLangArr);

				 @include("lang/".$pls_lang['lang_path']."/language.php");
				 $PowerBB->template->assign('lang',$lang);
	         }
	        // If the language was deleted and spoke the language of the user to the default language
			elseif ($PowerBB->member->IsMember(array('where' => array('lang',$PowerBB->_CONF['member_row']['lang']))))
			{
				$UpdateArr 					= 	array();
				$UpdateArr['field']			=	array();

				$UpdateArr['field']['lang'] 	= 	$PowerBB->_CONF['info_row']['def_lang'];
				$UpdateArr['where'] 					= 	array('username',$PowerBB->_CONF['member_row']['username']);

				$Updatedefaultlanguage = $PowerBB->member->UpdateMember($UpdateArr);

			}
	       	 else
			 {
             	  include("lang/".$DefLang['lang_path']."/language.php");
			      $PowerBB->template->assign('lang',$lang);
			  }

         }


	    ////////////
	    // Get lang list
		$LangListArr 							= 	array();

		// Clean data
		$LangListArr['proc']					=	array();
		$LangListArr['proc']['*']				=	array('method'=>'clean','param'=>'html');

		// Where setup
		$LangListArr['where'][0]				=	array();
		$LangListArr['where'][0]['con']		=	'AND';
		$LangListArr['where'][0]['name']		=	'lang_on';
		$LangListArr['where'][0]['oper']		=	'=';
		$LangListArr['where'][0]['value']		=	'1';

		// Order setup
		$LangListArr['order'] 					= 	array();
		$LangListArr['order']['field'] 		= 	'Lang_order';
		$LangListArr['order']['type'] 			= 	'ASC';

		$PowerBB->_CONF['template']['while']['LangList'] = $PowerBB->lang->GetLangList($LangListArr);


		/** Visitor can't use the private massege system **/
		if ($PowerBB->_CONF['member_permission'])
		{
			if ($PowerBB->_CONF['info_row']['pm_feature'])
			{
	        	/** Can't use the private massege system **/
				if ($PowerBB->_CONF['rows']['group_info']['use_pm'])
				{
				      if ($PowerBB->_CONF['member_row']['unread_pm'] > 0)
				      {
	                     //Get the New masseges In pm popup
				        $user_to = $PowerBB->_CONF['member_row']['username'];

				        $GetMassegeinfo = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['pm'] . " WHERE user_to = '$user_to' and user_read = '' and folder = 'inbox'");
				        $GetMassege = $PowerBB->DB->sql_fetch_array($GetMassegeinfo);
				        $num ='100';
				        $GetMassege['text'] = str_replace('[quote]','',$GetMassege['text']);
				        $GetMassege['text'] = str_replace('[/quote]','',$GetMassege['text']);
		                $GetMassege['text'] = $PowerBB->functions->words_count_replace_strip_tags_html2bb($GetMassege['text'],$num);
						$PowerBB->template->assign('Massege_date',$GetMassege['date']);
				        $PowerBB->template->assign('Massege_text',$GetMassege['text']);
				        $Massege_id = $GetMassege['id'];
				        $PowerBB->template->assign('Massege_id',$Massege_id);
				        $PowerBB->template->assign('Massege',$GetMassege);
				      }
				}

			}

		}
		/** **/
      $page = empty($PowerBB->_GET['page']) ? 'index' : $PowerBB->_GET['page'];
      $PowerBB->template->assign('page',$page);


        // show Adsense List
		$AdsenseArr 					= 	array();
		$AdsenseArr['order']			=	array();
		$AdsenseArr['order']['field']	=	'id';
		$AdsenseArr['order']['type']	=	'DESC';
		$AdsenseArr['proc'] 			= 	array();
		$AdsenseArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['AdsensesList'] = $PowerBB->adsense->GetAdsenseList($AdsenseArr);
		if (is_array($PowerBB->_CONF['template']['while']['AdsensesList'])
			and sizeof($PowerBB->_CONF['template']['while']['AdsensesList']) > 0)
		{
			$PowerBB->template->assign('STOP_ADSENSES_TEMPLATE',false);
		}
		else
		{
			$PowerBB->template->assign('STOP_ADSENSES_TEMPLATE',true);
		}


		// Sorry visitor you can't visit this forum today :(
		if (!$PowerBB->_CONF['member_permission'])
		{
			if (!$PowerBB->_CONF['info_row'][$PowerBB->_CONF['day']])
	   		{
				$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['sorry_visitor_you_cant_visit_this_forum_today']);
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['sorry_visitor_you_cant_visit_this_forum_today']);
	   		}
   		}
   		////////////////////////////

   		// Get username style
       $PowerBB->template->assign('username_style_cache ',$PowerBB->_CONF['member_row']['username_style_cache']);
       // Get username
       $PowerBB->template->assign('username_style',$PowerBB->_CONF['member_row']['username']);
      ////////

    // Get member alerts
     $user_name = $PowerBB->_CONF['member_row']['username'];
     $user_id = $PowerBB->_CONF['member_row']['id'];
		if ($PowerBB->_CONF['member_permission'])
		{
			 if ($PowerBB->_CONF['info_row']['pm_feature'])
			 {
			   $GetPmNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['pm'] . " WHERE user_to = '$user_name' and user_read = '' and folder = 'inbox'"));
		       $GetTotalPmNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['pm'] . " WHERE user_to = '$user_name' and folder = 'inbox'"));
			 }
			 if ($PowerBB->_CONF['info_row']['active_visitor_message'])
			 {
		       $GetVisitorMessageNumrs = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['visitormessage'] . " WHERE userid = '$user_id' and messageread = '1'"));
			 }
			 if ($PowerBB->_CONF['info_row']['active_friend'])
			 {
		       $GetFriendsNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['friends'] . " WHERE username_friend = '$user_name' and approval = '0'"));
			 }
			 if ($PowerBB->_CONF['info_row']['reputationallw'])
			 {
		      $GetReputationNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['reputation'] . " WHERE username = '$user_name' and reputationread = '1'"));
			 }
        }
     $PowerBB->template->assign('alerts_num',$GetFriendsNum+$GetVisitorMessageNumrs+$GetReputationNum);
     $PowerBB->template->assign('all_alerts_num',$GetFriendsNum+$GetVisitorMessageNumrs+$GetPmNum+$GetReputationNum);
     $PowerBB->template->assign('pm_num',$GetPmNum);
     $PowerBB->template->assign('TotalPmNum',$GetTotalPmNum);
     $PowerBB->template->assign('visitor_message_Numrs',$GetVisitorMessageNumrs);
     $PowerBB->template->assign('friends_num',$GetFriendsNum);
     $PowerBB->template->assign('ReputationNum',$GetReputationNum);
     ////////
       // Get All Smile - SmlList
	   $PowerBB->_CONF['template']['while']['SmlList'] = $PowerBB->icon->GetSmileList($SmlArr);

       // Get Pages
		$PageArr 					= 	array();
		$PageArr['order']			=	array();
		$PageArr['order']['field']	=	'id';
		$PageArr['order']['type']	=	'DESC';
		$PageArr['proc'] 			= 	array();
		$PageArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['PagesList'] = $PowerBB->pages->GetPagesList($PageArr);
		if ($PowerBB->_CONF['template']['while']['PagesList'] == false)
		{
			$PowerBB->template->assign('No_PagesList',true);
		}
		//
        // Get Numbr Styles And Lang
		 $StylesNm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['style'] . " WHERE id"));
		 $PowerBB->template->assign('StylesNo',$StylesNm);
         $LangNm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT ID FROM " . $PowerBB->table['lang'] . " WHERE id"));
         $PowerBB->template->assign('LangsNo',$LangNm);
      // Get register date
   		$register_date = $PowerBB->functions->date($PowerBB->_CONF['member_row']['register_date']);
         $PowerBB->template->assign('register_date',$register_date);
         // Get Last visit
   		$last_visit = $PowerBB->functions->date($PowerBB->_CONF['member_row']['lastvisit']);
         $PowerBB->template->assign('lastvisit',$last_visit);


	 }

}

?>
