<?php

$CALL_SYSTEM 			= 	array();
$CALL_SYSTEM['SUBJECT'] = 	true;
$CALL_SYSTEM['SECTION'] = 	true;
$CALL_SYSTEM['ATTACH'] 	= 	true;
$CALL_SYSTEM['PM'] 		= 	true;
$CALL_SYSTEM['REPLY'] 	= 	true;

(!defined('IN_PowerBB')) ? die() : '';

include('common.php');

define('CLASS_NAME','PowerBBDownloadMOD');

class PowerBBDownloadMOD
{
	function run()
	{
		global $PowerBB;

		if ($PowerBB->_GET['subject'])
		{
			$this->_DownloadSubject();
		}
		elseif ($PowerBB->_GET['attach'])
		{
			$this->_DownloadAttach();
		}
		elseif ($PowerBB->_GET['pm'])
		{
			$this->_DownloadPM();
		}
	}

	function _DownloadSubject()
	{
		global $PowerBB;

		//////////

		// Clean id from any string, that will protect us
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		// If the id is empty, so stop the page
		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->ShowHeader();
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		//////////

		$SubjectArr = array();

		$SubjectArr['where'] 				= 	array();

		$SubjectArr['where'][0] 			= 	array();
		$SubjectArr['where'][0]['name'] 	= 	'id';
		$SubjectArr['where'][0]['oper'] 	= 	'=';
		$SubjectArr['where'][0]['value'] 	= 	$PowerBB->_GET['id'];

		$SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$PowerBB->functions->CleanVariable($SubjectInfo,'html');

		if ($SubjectInfo['delete_topic']
			and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Subject_Was_Trasht']);
		}

		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$SubjectInfo['section']);

		$SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

		$SecGroupArr 						= 	array();
		$SecGroupArr['where'] 				= 	array();
		$SecGroupArr['where'][0]			=	array();
		$SecGroupArr['where'][0]['name'] 	= 	'section_id';
		$SecGroupArr['where'][0]['value'] 	= 	$SectionInfo['id'];
		$SecGroupArr['where'][1]			=	array();
		$SecGroupArr['where'][1]['con']		=	'AND';
		$SecGroupArr['where'][1]['name']	=	'group_id';
		$SecGroupArr['where'][1]['value']	=	$PowerBB->_CONF['group_info']['id'];

		// Finally get the permissions of group
		$SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);

		if (!$SectionGroup['view_section'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['can_not_view_this_subject']);
		}

		$filename = str_replace(' ','_',$SubjectInfo['title']);
		$filename .= '.html';

		header('Content-Disposition: attachment;filename=' . $filename);
		header('Content-type: text/html');
       $charset1                =   $PowerBB->_CONF['info_row']['content_dir'];
       $title                =   $SubjectInfo['title'];
       $forum_title = $PowerBB->_CONF['info_row']['title'];
        echo "<html dir='$charset1'> <head> <meta http-equiv='Content-Type' content='text/html; charset=utf-8'><title>". $forum_title ." : ".$title."</title></head><body>";
        echo '<a target="_blank" href="'.$PowerBB->functions->GetForumAdress().'">'.$PowerBB->_CONF['info_row']['title'].'</a>';
        echo '<br />  '.$crlf . $crlf . $crlf;
		echo $PowerBB->_CONF['template']['lang']['Topic_entitled'] . $SubjectInfo['title'];
		echo '<br />  '.$crlf . $crlf . $crlf;
		echo $PowerBB->_CONF['template']['lang']['LastsPostsWriter'] . $SubjectInfo['writer'];
		echo ' <br /> '.$crlf . $crlf . $crlf;
		$SubjectInfo['text'] = $PowerBB->Powerparse->replace($SubjectInfo['text']);
		$SubjectInfo['text'] = str_ireplace('&quot;','"',$SubjectInfo['text']);
		$SubjectInfo['text'] = str_ireplace('&amp;','&',$SubjectInfo['text']);
		$PowerBB->Powerparse->replace_smiles_print($SubjectInfo['text']);
		echo '<br /><hr>' . $SubjectInfo['text'];
        echo "</body></html>";

	}

	function _DownloadAttach()
	{
		global $PowerBB;

		//////////

		// Clean id from any string, that will protect us
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');



		// If the id is empty, so stop the page
		if (empty($PowerBB->_GET['id']))
		{
		       $PowerBB->functions->ShowHeader();
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		if (!$PowerBB->attach->IsAttach(array('where' => array('id',$PowerBB->_GET['id']))))
		{
		       $PowerBB->functions->ShowHeader();
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Attach_you_want_does_not_exist']);
		}

		//////////

		// Get attachment information
		$AttachArr = array();

		$AttachArr['where'] 				= 	array();

		$AttachArr['where'][0] 				= 	array();
		$AttachArr['where'][0]['name'] 		= 	'id';
		$AttachArr['where'][0]['oper'] 		= 	'=';
		$AttachArr['where'][0]['value'] 	= 	$PowerBB->_GET['id'];

		$AttachInfo = $PowerBB->attach->GetAttachInfo($AttachArr);

		// Clean the information from XSS
		$PowerBB->functions->CleanVariable($AttachInfo,'html');

		//////////

		// Get subject information
		$SubjectArr = array();

		$SubjectArr['where'] 				= 	array();

		$SubjectArr['where'][0] 			= 	array();
		$SubjectArr['where'][0]['name'] 	= 	'id';
		$SubjectArr['where'][0]['oper'] 	= 	'=';
		$SubjectArr['where'][0]['value'] 	= 	$AttachInfo['subject_id'];

		$SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		// Clean the information from XSS
		$PowerBB->functions->CleanVariable($SubjectInfo,'html');

		//////////

		// The subject isn't available
		if ($SubjectInfo['delete_topic']
			and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Subject_Was_Trasht']);
		}

		//////////

		// We can't stop the admin :)
		if (!$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$SecGroupArr 						= 	array();
			$SecGroupArr['where'] 				= 	array();
			$SecGroupArr['where'][0]			=	array();
			$SecGroupArr['where'][0]['name'] 	= 	'section_id';
			$SecGroupArr['where'][0]['value'] 	= 	$SubjectInfo['id'];
			$SecGroupArr['where'][1]			=	array();
			$SecGroupArr['where'][1]['con']		=	'AND';
			$SecGroupArr['where'][1]['name']	=	'group_id';
			$SecGroupArr['where'][1]['value']	=	$PowerBB->_CONF['group_info']['id'];

			// Finally get the permissions of group
			$SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);

			//////////


			// The user can't download this attachment
			if (!$PowerBB->_CONF['group_info']['download_attach'])
			{
					$PowerBB->functions->ShowHeader();

          if (!$PowerBB->_CONF['member_permission'])
              {
              $PowerBB->template->display('login');
              $PowerBB->functions->error_stop();
			}
	        else
	        {
	        $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Sorry_you_can_not_download_this_Attachment']);
	        }
	     }

			// These checks are special for members
			if ($PowerBB->_CONF['member_permission'])
			{
				// No enough posts
				if ($PowerBB->_CONF['group_info']['download_attach_number'] > $PowerBB->_CONF['member_row']['posts'])
				{
					$PowerBB->functions->ShowHeader();
					$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Member_can_not_download_the_Attachment_posts_less']);
				}
			}
		}

		//////////

     if ($PowerBB->_CONF['group_info']['download_attach'])
	  {
		// Count a new download
		$UpdateArr 						= 	array();
		$UpdateArr['field'] 			= 	array();
		$UpdateArr['field']['visitor'] 	= 	$AttachInfo['visitor'] + 1;
		$UpdateArr['where'] 			= 	array('id',$AttachInfo['id']);

		$update = $PowerBB->attach->UpdateAttach($UpdateArr);
      }
		//////////



		//////////

          if ($AttachInfo['filename'] != '.jpg' and $AttachInfo['filename'] != '.gif')
         {
          if (file_exists('./' . $AttachInfo['filepath']))
          {
         	$file_mime = $AttachInfo['extension'];
            header("Content-type: $file_mime");
		    header("Content-Disposition: attachment;filename=" . rawurlencode($AttachInfo['filename']) . "");
		    header('Content-type: application/download');
			header("Content-Transfer-Encoding: binary");
		    $read = @readfile('./' . $AttachInfo['filepath']);
		  }
		  elseif (!file_exists('./' . $AttachInfo['filepath']))
		  {
            extract($AttachInfo);
         	$file_contents = $AttachInfo['contents'];
         	$file_mime = $AttachInfo['extension'];
			$file_name = rawurlencode($AttachInfo['filename']);
			$filesize = $AttachInfo['filesize'];

            header("Content-type: $file_mime");
            header("Content-disposition: filename=$file_name");
			header("Content-Transfer-Encoding: binary");
			print( $file_contents);
			exit;
		  }
		  else
		  {
           $PowerBB->functions->ShowHeader();
	       $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Attach_you_want_does_not_exist']);
		  }

         }
         else
         {
             echo '<img src="' . $AttachInfo['filepath'] . '" border="0">';
         }



		//////////

	}

	function _DownloadPM()
	{
		global $PowerBB;

		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$MsgArr 			= 	array();
		$MsgArr['id'] 		= 	$PowerBB->_GET['id'];
		$MsgArr['username'] = 	$PowerBB->_CONF['member_row']['username'];

		$MsgInfo = $PowerBB->pm->GetPrivateMassegeInfo($MsgArr);

		if (!$MsgInfo)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Massege_requested_does_not_exist']);
		}

		$MsgInfo['title'] = $PowerBB->functions->CleanVariable($MsgInfo['title'],'html');

		$filename = str_replace(' ','_',$MsgInfo['title']);
		$filename .= '.html';

		header('Content-Disposition: attachment;filename=' . $filename);
		header('Content-type: text/html');
       $charset1                =   $PowerBB->_CONF['info_row']['content_dir'];
       $title                =   $MsgInfo['title'];
       $forum_title = $PowerBB->_CONF['info_row']['title'];
        echo "<html dir='$charset1'> <head> <meta http-equiv='Content-Type' content='text/html; charset=utf-8'><title>". $forum_title ." : ".$title."</title></head><body>";
        echo '<a target="_blank" href="'.$PowerBB->functions->GetForumAdress().'">'.$PowerBB->_CONF['info_row']['title'].'</a>';
        echo '<br />  '.$crlf . $crlf . $crlf;
		echo $PowerBB->_CONF['template']['lang']['Pm_entitled'] . ' ' . $MsgInfo['title'];
		echo '<br />  '.$crlf . $crlf . $crlf;
		echo $PowerBB->_CONF['template']['lang']['Sender'] . ' : ' . $MsgInfo['user_from'];
		echo ' <br /> '.$crlf . $crlf . $crlf;
		$MsgInfo['text'] = $PowerBB->Powerparse->replace($MsgInfo['text']);
		$MsgInfo['text'] = str_ireplace('&quot;','"',$MsgInfo['text']);
		$MsgInfo['text'] = str_ireplace('&amp;','&',$MsgInfo['text']);
		$PowerBB->Powerparse->replace_smiles_print($MsgInfo['text']);
		echo '<br /><hr>' . $MsgInfo['text'];
        echo "</body></html>";
	}
}

?>
