<?php

(!defined('IN_PowerBB')) ? die() : '';

$CALL_SYSTEM				=	array();
$CALL_SYSTEM['REQUEST'] 	= 	true;
$CALL_SYSTEM['MESSAGE'] 	= 	true;

include('common.php');

define('CLASS_NAME','PowerBBForgetMOD');

class PowerBBForgetMOD
{
	function run()
	{
		global $PowerBB;

		if ($PowerBB->_GET['index'])
		{
			$this->_Index();
		}
		elseif ($PowerBB->_GET['start'])
		{
			$this->_Start();
		}
		if ($PowerBB->_GET['active_member'])
		{
			$this->_IndexActiveMember();
		}
		elseif ($PowerBB->_GET['send_active_code'])
		{
			$this->_SendActiveCode();
		}


		$PowerBB->functions->GetFooter();
	}

	function _Index()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['Lost_password']);

		$PowerBB->template->display('forget_password_form');
	}

	function _Start()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['execution_Lost_password']);

		$PowerBB->functions->AddressBar($PowerBB->_CONF['template']['lang']['execution_Lost_password']);

		if (empty($PowerBB->_POST['email']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
		}

		if (!$PowerBB->functions->CheckEmail($PowerBB->_POST['email']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_enter_your_correct_email']);
		}

		$CheckArr 			= 	array();
		$CheckArr['where']	=	array('email',$PowerBB->_POST['email']);

		$CheckEmail = $PowerBB->member->IsMember($CheckArr);

		if (!$CheckEmail)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['E-mail_does_not_exist_in_our_databases']);
		}

		$MemberArr 			= 	array();
		$MemberArr['where'] 	= 	array('email',$PowerBB->_POST['email']);

		$ForgetMemberInfo = $PowerBB->member->GetMemberInfo($MemberArr);

		$Adress = 	$PowerBB->functions->GetForumAdress();
		$Code	=	$PowerBB->functions->RandomCode();

		$ChangeAdress = $Adress . 'index.php?page=new_password&index=1&code=' . $Code;
		$CancelAdress = $Adress . 'index.php?page=cancel_requests&index=1&type=1&code=' . $Code;

		$ReqArr 				= 	array();
		$ReqArr['field']		=	array();

		$ReqArr['field']['random_url'] 		= 	$Code;
		$ReqArr['field']['username'] 		= 	$ForgetMemberInfo['username'];
		$ReqArr['field']['request_type'] 	= 	1;

		$InsertReq = $PowerBB->request->InsertRequest($ReqArr);

		if ($InsertReq)
		{
			$UpdateArr 					= 	array();
			$UpdateArr['field']			=	array();

			$UpdateArr['field']['new_password'] 	= 	$PowerBB->functions->RandomCode();
			$UpdateArr['where'] 					= 	array('id',$ForgetMemberInfo['id']);

			$UpdateNewPassword = $PowerBB->member->UpdateMember($UpdateArr);

			if ($UpdateNewPassword)
			{
				$MsgArr 			= 	array();
				$MsgArr['where'] 	= 	array('id','1');

				$MassegeInfo = $PowerBB->message->GetMessageInfo($MsgArr);

				$MsgArr 				= 	array();
				$MsgArr['text'] 		= 	$MassegeInfo['text'];
				$MsgArr['change_url'] 	= 	$ChangeAdress;
				$MsgArr['cancel_url'] 	= 	$CancelAdress;
				$MsgArr['username']		=	$PowerBB->_CONF['member_row']['username'];
				$MsgArr['title']		=	$PowerBB->_CONF['info_row']['title'];

				$MassegeInfo['text'] = $PowerBB->message->MessageProccess($MsgArr);


				if ($PowerBB->_CONF['info_row']['mailer']=='phpmail')
						{
				         $Send = $PowerBB->functions->mail($ForgetMemberInfo['email'],$MassegeInfo['title'],$MassegeInfo['text'],$PowerBB->_CONF['info_row']['send_email']);
			            }
						elseif ($PowerBB->_CONF['info_row']['mailer']=='smtp')
						{
						$to = $ForgetMemberInfo['email'];
						$fromname = $PowerBB->_CONF['info_row']['title'];
						$message = $MassegeInfo['text'];
						$subject = $MassegeInfo['title'];
						$from = $PowerBB->_CONF['info_row']['send_email'];
                        $Send = $PowerBB->functions->send_this_smtp($to,$fromname,$message,$subject,$from);
						}

				if ($Send)
				{
					$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Password_has_been_sent_to_E-mail']);
					$PowerBB->functions->redirect('index.php',2);
				}
				else
				{
					$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['is_not_sent']);
				}
			}
		}
	}

	function _IndexActiveMember()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$MemberArr 			= 	array();
		$MemberArr['where'] 	= 	array('username',$PowerBB->_CONF['rows']['member_row']['username']);

		$GettMemberEmail = $PowerBB->member->GetMemberInfo($MemberArr);
		$PowerBB->template->assign('MemberEmail',$GettMemberEmail['email']);

		$PowerBB->template->display('send_active_code');
	}

	function _SendActiveCode()
	{
		global $PowerBB;

		if (!$PowerBB->member->IsMember(array('where' => array('email',$PowerBB->_POST['email']))))
		{
            $PowerBB->functions->ShowHeader();
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['E-mail_does_not_exist_in_our_databases']);
		}

		$MemberArr 			= 	array();
		$MemberArr['where'] 	= 	array('email',$PowerBB->_POST['email']);

		$ActiveMemberInfo = $PowerBB->member->GetMemberInfo($MemberArr);


    	$Adress	= 	$PowerBB->functions->GetForumAdress();
		$Code	=	$PowerBB->functions->RandomCode();

		$ActiveAdress = $Adress . 'index.php?page=active_member&index=1&id=' . $ActiveMemberInfo['id'] . '&code=' . $Code;

		$ReqArr 			= 	array();
		$ReqArr['field'] 	= 	array();

		$ReqArr['field']['random_url'] 		= 	$Code;
		$ReqArr['field']['username'] 		= 	$ActiveMemberInfo['username'];
		$ReqArr['field']['request_type'] 	= 	3;

		$InsertReq = $PowerBB->request->InsertRequest($ReqArr);

		if ($InsertReq)
		{
			$MsgArr 			= 	array();
			$MsgArr['where'] 	= 	array('id','4');

			$MassegeInfo = $PowerBB->message->GetMessageInfo($MsgArr);

			$MsgArr = array();

			$MsgArr['text'] 		= 	$MassegeInfo['text'];
			$MsgArr['active_url'] 	= 	$ActiveAdress;
			$MsgArr['username']		=	$ActiveMemberInfo['username'];
			$MsgArr['title']		=	$PowerBB->_CONF['info_row']['title'];

			$MassegeInfo['text'] = $PowerBB->message->MessageProccess($MsgArr);

				if ($PowerBB->_CONF['info_row']['mailer']=='phpmail')
						{
			             $Send = $PowerBB->functions->mail($PowerBB->_POST['email'],$MassegeInfo['title'],$MassegeInfo['text'],$PowerBB->_CONF['info_row']['send_email']);
			            }
						elseif ($PowerBB->_CONF['info_row']['mailer']=='smtp')
						{
						$to = $PowerBB->_POST['email'];
						$fromname = $PowerBB->_CONF['info_row']['title'];
						$message = $MassegeInfo['text'];
						$subject = $MassegeInfo['title'];
						$from = $PowerBB->_CONF['info_row']['send_email'];

                         $Send = $PowerBB->functions->send_this_smtp($to,$fromname,$message,$subject,$from);
						}

            $PowerBB->functions->ShowHeader();
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['has_been_sent_to_your_e-mail_activation']);

		    $PowerBB->functions->redirect('index.php');

		}

	}

}

?>
