<?php
(!defined('IN_PowerBB')) ? die() : '';
include('common.php');
define('CLASS_NAME','PowerBBManagementMOD');
class PowerBBManagementMOD
{
	function run()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader();

		$PowerBB->_GET['section'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['section'],'intval');
		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');


			if ($PowerBB->_GET['subject'])
			{
				$this->_Subject();
			}
			elseif ($PowerBB->_GET['move'])
			{
				$this->_MoveStart();
			}
			elseif ($PowerBB->_GET['subject_edit'])
			{
				$this->_SubjectEditStart();
			}
			elseif ($PowerBB->_GET['repeat'])
			{
				$this->_SubjectRepeatStart();
			}
			elseif ($PowerBB->_GET['close'])
			{
				$this->_CloseStart();
			}
			elseif ($PowerBB->_GET['delete'])
			{
				$this->_DeleteStart();
			}
			elseif ($PowerBB->_GET['reply'])
			{
				$this->_Reply();
			}
			elseif ($PowerBB->_GET['reply_edit'])
			{
				$this->_ReplyEditStart();
			}
			elseif ($PowerBB->_GET['multimod'])
			{
				$this->_TopicModStart();
			}
			elseif ($PowerBB->_GET['startmerge'])
			{
				$this->_MergeStart();
			}


		$PowerBB->functions->GetFooter();
	}

	function _Subject()
	{
		global $PowerBB;

  	    $SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$MemberArr 				= 	array();
		$MemberArr['where']		=	array('username',$SubjectInfo['writer']);

		$WriterInfo = $PowerBB->member->GetMemberInfo($MemberArr);


	    if ($PowerBB->functions->ModeratorCheck($PowerBB->_GET['section'])
	    or $PowerBB->_CONF['member_row']['username'] == $WriterInfo['username'])
		{

		if ($PowerBB->_GET['operator'] == 'stick')
		{
			$this->__Stick();
		}
		elseif ($PowerBB->_GET['operator'] == 'unstick')
		{
			$this->__UnStick();
		}
		elseif ($PowerBB->_GET['operator'] == 'close')
		{
			$this->__Close();
		}
		elseif ($PowerBB->_GET['operator'] == 'open')
		{
			$this->__Open();
		}
		elseif ($PowerBB->_GET['operator'] == 'delete')
		{
			$this->_DeleteIndex();
		}
		elseif ($PowerBB->_GET['operator'] == 'delete_start')
		{
			$this->_DeleteStart();
		}
		elseif ($PowerBB->_GET['operator'] == 'move')
		{
			$this->__MoveIndex();
		}
		elseif ($PowerBB->_GET['operator'] == 'edit')
		{
			$this->__SubjectEdit();
		}
		elseif ($PowerBB->_GET['operator'] == 'repeated')
		{
			$this->__SubjectRepeat();
		}
		elseif ($PowerBB->_GET['operator'] == 'up')
		{
			$this->__UpStart();
		}
		elseif ($PowerBB->_GET['operator'] == 'down')
		{
			$this->__DownStart();
		}
		elseif ($PowerBB->_GET['operator'] == 'unreview_subject')
		{
			$this->__UnReviewSubject();
		}
		elseif ($PowerBB->_GET['operator'] == 'review_subject')
		{
			$this->__ReviewSubject();
		}
		elseif ($PowerBB->_GET['operator'] == 'special')
		{
			$this->_SpecialStart();
		}
		elseif ($PowerBB->_GET['operator'] == 'nospecial')
		{
			$this->_NospecialStart();
		}
		elseif ($PowerBB->_GET['operator'] == 'merge')
		{
			$this->_MergeIndex();
		}
		elseif ($PowerBB->_GET['operator'] == 'tools_thread')
		{
			$this->_ToolsThread();
		}


		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['not_allowed_access']);
		}

	}

	function __Stick()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['stick_subject'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$UpdateArr 			= array();
		$UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$update = $PowerBB->subject->StickSubject($UpdateArr);

		if ($update)
		{
          	// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Sticky_Topic'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_stick_subject']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}

	function __UnStick()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['unstick_subject'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$UpdateArr 			= array();
		$UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$update = $PowerBB->subject->UnstickSubject($UpdateArr);

		if ($update)
		{
			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['unstick_Subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_Cancel_stick_subject']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}

	function __Close()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['close_subject'] == '0')
			{
			 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}
			$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

			if (empty($PowerBB->_GET['subject_id']))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
			}

			$SubjectInfoArr				=	array();
		    $SubjectInfoArr['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectInfoArr);
			$PowerBB->template->assign('SubjectInfo',$SubjectInfo);

			$PowerBB->template->assign('subject',$PowerBB->_GET['subject_id']);

			$PowerBB->template->display('subject_close_index');


	}

	function __Open()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$UpdateArr 			= array();
		$UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$update = $PowerBB->subject->OpenSubject($UpdateArr);

		if ($update)
		{
		          	// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['open_Subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_Opin_subject']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}

	function __SubjectDelete()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}
		$UpdateArr 			= array();
		$UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$update = $PowerBB->subject->MoveSubjectToTrash($UpdateArr);

		if ($update)
		{

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_Trasht']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);
		}
	}

	function __MoveIndex()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['move_subject'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');
		$PowerBB->_GET['section'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['section'],'intval');

		if (empty($PowerBB->_GET['subject_id'])
			or empty($PowerBB->_GET['section']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SecArr 						= 	array();
		$SecArr['get_from']				=	'db';

		$SecArr['proc'] 				= 	array();
		$SecArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$SecArr['order']				=	array();
		$SecArr['order']['field']		=	'sort';
		$SecArr['order']['type']		=	'ASC';

		$SecArr['where']				=	array();
		$SecArr['where'][0]['name']		= 	'parent';
		$SecArr['where'][0]['oper']		= 	'=';
		$SecArr['where'][0]['value']	= 	'0';

		// Get main sections
		$cats = $PowerBB->section->GetSectionsList($SecArr);

		// We will use forums_list to store list of forums which will view in main page
		$PowerBB->_CONF['template']['foreach']['forums_list'] = array();

		// Loop to read the information of main sections
		foreach ($cats as $cat)
		{
			// Get the groups information to know view this section or not
			$groups = unserialize(base64_decode($cat['sectiongroup_cache']));

			if (is_array($groups[$PowerBB->_CONF['group_info']['id']]))
			{
				if ($groups[$PowerBB->_CONF['group_info']['id']]['view_section'])
				{
					$PowerBB->_CONF['template']['foreach']['forums_list'][$cat['id'] . '_m'] = $cat;
				}
			}

			unset($groups);

			if (!empty($cat['forums_cache']))
			{
				$forums = unserialize(base64_decode($cat['forums_cache']));

				foreach ($forums as $forum)
				{
					if (is_array($forum['groups'][$PowerBB->_CONF['group_info']['id']]))
					{
						if ($forum['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
						{
							//////////

							// Get the first-level sub forums as a _link_ and store it in $forum['sub']

							$forum['is_sub'] 	= 	0;
							$forum['sub']		=	'';

							if (!empty($forum['forums_cache']))
							{
								$subs = unserialize(base64_decode($forum['forums_cache']));

								if (is_array($subs))
								{
									foreach ($subs as $sub)
									{
										if (is_array($sub['groups'][$PowerBB->_CONF['group_info']['id']]))
										{
											if ($sub['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
											{
												if (!$forum['is_sub'])
												{
													$forum['is_sub'] = 1;
												}

												$forum['sub'] .= ('<option value="' .$sub['id'] . '" selected="selected">--- '  . $sub['title'] . '</option>');

											}
										}

										          if (!empty($sub['forums_cache']))
												  {
													$forum['is_sub_sub'] 	= 	0;
													$forum['sub_sub']		=	'';
													$subs_sub = unserialize(base64_decode($sub['forums_cache']));

													if (is_array($subs_sub))
													{
														foreach ($subs_sub as $sub_sub)
														{
															if (is_array($sub_sub['groups'][$PowerBB->_CONF['group_info']['id']]))
															{
																if ($sub_sub['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
																{
																	if (!$forum['is_sub_sub'])
																	{
																		$forum['is_sub_sub'] = 1;
																	}

																	$forum['sub_sub'] .= ('<option value="' .$sub_sub['id'] . '" selected="selected">---- '  . $sub_sub['title'] . '</option>');
																}
															}
														}
													}
												  }

									}


								 }
							}


							$PowerBB->_CONF['template']['foreach']['forums_list'][$forum['id'] . '_f'] = $forum;
						}
					} // end if is_array
				} // end foreach ($forums)
			} // end !empty($forums_cache)
		} // end foreach ($cats)

		//////////
    	$SubjectArr 			= 	array();
		$SubjectArr['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

		$this->SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$PowerBB->template->assign('section',$PowerBB->_GET['section']);
		$PowerBB->template->assign('subject',$PowerBB->_GET['subject_id']);
		$PowerBB->template->assign('subject_title',$this->SubjectInfo['title']);
        $PowerBB->template->assign('section_id',$this->SubjectInfo['section']);
		$PowerBB->template->display('subject_move_index');
	}

	function _MoveStart()
	{
		global $PowerBB;

		// Check the powers group mod  of transfer of the subject
		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['move_subject'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}
         // intval to subject_id
		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');
        ////
		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		     // subject_id
		     $subject_id = $PowerBB->_GET['subject_id'];
            // Get id Both Move from section AND Move to section
			$Move_from_section = $PowerBB->_GET['section'];
			$Move_to_section = $PowerBB->_POST['section'];
            ////


        // Get Subject Info
  	    $SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);

     	// Get Section Form Info
     	$SecFormArr 			= 	array();
		$SecFormArr['where'] 	= 	array('id',$Move_from_section);

		$SectionFormInfo = $PowerBB->section->GetSectionInfo($SecFormArr);

     	// Get Section To Info
     	$SecToArr 			= 	array();
		$SecToArr['where'] 	= 	array('id',$Move_to_section );

		$SectionToInfo = $PowerBB->section->GetSectionInfo($SecToArr);


        $Move_replys = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['reply'] . " WHERE subject_id = '$subject_id' ");
         while ($Moved = $PowerBB->DB->sql_fetch_array($Move_replys))
	         {
				$UpdateArr 				= 	array();
				$UpdateArr['field']		= 	array();

				$UpdateArr['field']['section'] 		= 	$Move_to_section;
				$UpdateArr['where'] 				= 	array('id',$Moved['id']);

				$update = $PowerBB->reply->UpdateReply($UpdateArr);
	         }

		// Change the Section number to Section transferee
		    $UpdateArr 					= 	array();
		    $UpdateArr['field'] 				= 	array();
		    $UpdateArr['field']['section'] 		= 	$Move_to_section;
			$UpdateArr['where'] 				= 	array('id',$PowerBB->_GET['subject_id']);

			$update = $PowerBB->subject->UpdateSubject($UpdateArr);


		    // INSERT moderators Action

		    $subject_title = $SubjectInfo['title'];
		    $SectionInf = ('<a target="_blank" href="index.php?page=forum&show=1&id=' . $SectionToInfo['id'] . '">' .$SectionToInfo['title'] .'</a>');
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	=  	$PowerBB->_CONF['template']['lang']['mov_Subject_to'] . $SectionInf;
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

       			$UpdateSectionCache1 =	$PowerBB->functions->UpdateSectionCache($Move_from_section);
                $UpdateSectionCache2 = $PowerBB->functions->UpdateSectionCache($Move_to_section);

     		$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_mov_subject']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
   }

	function _CloseStart()
	{
		global $PowerBB;


		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['close_subject'] == '0')
			{
			 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

      $PowerBB->_POST['reason']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason'],'sql');

		$UpdateArr 				= 	array();
		$UpdateArr['reason']	=	$PowerBB->_POST['reason'];
		$UpdateArr['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

		$update = $PowerBB->subject->CloseSubject($UpdateArr);

		if ($update)
		{
			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		if ($action['poll_subject'] == '1')
		{
		 if ($PowerBB->_POST['close_poll'] == '1')
		 {
		    $UpdateArr 					= 	array();
		    $UpdateArr['field'] 				= 	array();
		    $UpdateArr['field']['close_poll_subject'] 		= 	'1';
			$UpdateArr['where'] 				= 	array('id',$PowerBB->_GET['subject_id']);

			$update = $PowerBB->subject->UpdateSubject($UpdateArr);
		 }

		}

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['locked_Topic'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_Close_subject']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}

	function _DeleteIndex()
	{
		global $PowerBB;

			$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

			if (empty($PowerBB->_GET['subject_id']))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
			}
			    $SubjectArr = array();
			    $SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);
			    $SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['del_subject'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}
        else
		{
			if ($PowerBB->_CONF['group_info']['id'] != '1'
			   AND  $PowerBB->_CONF['group_info']['id'] != '2')
			{

				if ($SubjectInfo['close'] == '1')
				{
				 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['This_topic_is_locked']);
				}


		       $SecGroupArr                    =    array();
		       $SecGroupArr['where']              =    array();

		       $SecGroupArr['where'][0]          =    array();
		       $SecGroupArr['where'][0]['name']    =    'section_id';
		       $SecGroupArr['where'][0]['oper']    =    '=';
		       $SecGroupArr['where'][0]['value']    =    $PowerBB->_GET['section'];

		       $SecGroupArr['where'][1]          =    array();
		       $SecGroupArr['where'][1]['con']       =    'AND';
		       $SecGroupArr['where'][1]['name']    =    'group_id';
		       $SecGroupArr['where'][1]['oper']    =    '=';
		       $SecGroupArr['where'][1]['value']    =    $PowerBB->_CONF['group_info']['id'];

		       // Finally get the permissions of group
		       $this->SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);

		          if ($SubjectInfo['writer'] == $PowerBB->_CONF['member_row']['username'])
		        {
			       if (!$this->SectionGroup['del_own_subject'])
			       {
					 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			       }
		         }

          }
      }
	     $PowerBB->template->assign('SubjectDelInfo',$SubjectInfo);
	     $PowerBB->template->assign('subject',$PowerBB->_GET['subject_id']);

	     $PowerBB->template->display('subject_delete_index');
	}

	function _DeleteStart()
	{
		global $PowerBB;


		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

	if ($PowerBB->_POST['deletetype'] == 1)
	 {

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}
		$UpdateArr 			= array();
		$UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$update = $PowerBB->subject->MoveSubjectToTrash($UpdateArr);


		    // INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Was_Trasht1'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

          $UpdateSectionCache1 = $PowerBB->functions->UpdateSectionCache($PowerBB->_GET['section']);


			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_Trasht']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);

		 }
	  else
	  {



		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['del_subject'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}
		    // INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Was_rely_delet_subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

   	     $DelAttachArr				=	array();
	         $DelAttachArr['where'] 	= 	array('subject_id',$PowerBB->_GET['subject_id']);

			  $DeleteAttach = $PowerBB->attach->DeleteAttach($DelAttachArr);

            //  Delete Tags
             $subjectInfoid =  $PowerBB->_GET['subject_id'];
             $getTags_query = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['tag_subject'] . " WHERE subject_id = '$subjectInfoid'");
               while ($getTags_row = $PowerBB->DB->sql_fetch_array($getTags_query))
                 {
					  $DeleteTagArr				=	array();
			          $DeleteTagArr['where'] 	= 	array('id',$getTags_row['tag_id']);
					  $delTags = $PowerBB->tag->DeleteTag($DeleteTagArr);
                 }

			  $DeleteSubjectArr				=	array();
	          $DeleteSubjectArr['where'] 	= 	array('subject_id',$PowerBB->_GET['subject_id']);
			  $delSubject = $PowerBB->tag_subject->DeleteSubject($DeleteSubjectArr);

			     $DelReplyArr				=	array();
		         $DelReplyArr['where'] 	= 	array('subject_id',$PowerBB->_GET['subject_id']);

				  $delReply = $PowerBB->reply->DeleteReply($DelReplyArr);

			     $DelArr				=	array();
		         $DelArr['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

				  $del = $PowerBB->subject->DeleteSubject($DelArr);

           $UpdateSectionCache2 = $PowerBB->functions->UpdateSectionCache($PowerBB->_GET['section']);


		 }

	        $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_delet_subject']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);

	}

	function _empty_bac()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

        // Moderator And admin Editing Subject any time limit

	     if (!$PowerBB->functions->ModeratorCheck($PowerBB->_GET['section']))
	     {

             // time_out For Editing Subject

				$SubjectArr = array();
				$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

				$PowerBB->_CONF['template']['SubjectInfoTime'] = $PowerBB->subject->GetSubjectInfo($SubjectArr);

               $time_out = $PowerBB->_CONF['info_row']['time_out']*60;
              if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['SubjectInfoTime']['write_time']+$time_out)
               {
               $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Editing_time_out']);
               }
	     }

		$PowerBB->template->assign('edit_page','index.php?page=management&amp;subject_edit=1&amp;subject_id=' . $PowerBB->_GET['subject_id'] . '&amp;section=' . $PowerBB->_GET['section']);

		$PowerBB->functions->GetEditorTools();

		$PowerBB->template->assign('reply_id',$PowerBB->_GET['reply_id']);
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['subject_id']);

		$SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$this->Subject = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$PowerBB->template->assign('SubjectpreviewInfo',$this->Subject);

		// Get section information and set it in $this->Section
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

		$this->Section = $PowerBB->section->GetSectionInfo($SecArr);
		$PowerBB->template->assign('section_info',$this->Section);

         $previewtext = $PowerBB->_POST['text'];
         $previewtext = $PowerBB->Powerparse->replace($previewtext);
         $previewtext = $PowerBB->Powerparse->censor_words($previewtext);
         $PowerBB->Powerparse->replace_smiles($previewtext);
         $PowerBB->template->assign('preview',$previewtext);
         $PowerBB->_POST['text'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['text']);
         $PowerBB->template->assign('prev',$PowerBB->_POST['text']);
         $PowerBB->template->assign('title_prev',$PowerBB->_POST['title']);
         $PowerBB->template->assign('describe_prev',$PowerBB->_POST['describe']);
         $PowerBB->template->assign('prefix_subject_prev',$PowerBB->_POST['prefix_subject']);
         $PowerBB->template->assign('SRInfo',$this->Subject);

		$PowerBB->template->display('subject_edit');
	}

	function _SubjectEditpreview()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

        // Moderator And admin Editing Subject any time limit

	     if (!$PowerBB->functions->ModeratorCheck($PowerBB->_GET['section']))
	     {


             // time_out For Editing Subject

				$SubjectArr = array();
				$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

				$PowerBB->_CONF['template']['SubjectInfoTime'] = $PowerBB->subject->GetSubjectInfo($SubjectArr);

               $time_out = $PowerBB->_CONF['info_row']['time_out']*60;
              if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['SubjectInfoTime']['write_time']+$time_out)
               {
               $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Editing_time_out']);
               }
	     }

		$PowerBB->template->assign('edit_page','index.php?page=management&amp;subject_edit=1&amp;subject_id=' . $PowerBB->_GET['subject_id'] . '&amp;section=' . $PowerBB->_GET['section']);

		$PowerBB->functions->GetEditorTools();

		$PowerBB->template->assign('reply_id',$PowerBB->_GET['reply_id']);
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['subject_id']);

		$SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$this->Subject = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$PowerBB->template->assign('SubjectpreviewInfo',$this->Subject);

		// Get section information and set it in $this->Section
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

		$this->Section = $PowerBB->section->GetSectionInfo($SecArr);
		$PowerBB->template->assign('section_info',$this->Section);
        $PowerBB->template->assign('SRInfo',$this->Subject);

		$PowerBB->template->display('subject_edit');
	}

	function __SubjectEdit()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['edit_subject'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}
        else
		{
			if ($PowerBB->_CONF['group_info']['id'] != '1'
			   AND  $PowerBB->_CONF['group_info']['id'] != '2')
			{
			    $SubjectArr = array();
			    $SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);
			    $SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);
				if ($SubjectInfo['close'] == '1')
				{
				 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['This_topic_is_locked']);
				}
			}
		}
       $getmember_subscribtion = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['emailed'] . " WHERE `user_id`='" . $PowerBB->_CONF['member_row']['id'] . "' AND subject_id = '" .$PowerBB->_GET['subject_id'] . "'");
       $getmember_count = $PowerBB->DB->sql_num_rows($getmember_subscribtion);
       $PowerBB->template->assign('IsSubscribed',$getmember_count);

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

       $SecGroupArr                    =    array();
       $SecGroupArr['where']              =    array();

       $SecGroupArr['where'][0]          =    array();
       $SecGroupArr['where'][0]['name']    =    'section_id';
       $SecGroupArr['where'][0]['oper']    =    '=';
       $SecGroupArr['where'][0]['value']    =    $PowerBB->_GET['section'];

       $SecGroupArr['where'][1]          =    array();
       $SecGroupArr['where'][1]['con']       =    'AND';
       $SecGroupArr['where'][1]['name']    =    'group_id';
       $SecGroupArr['where'][1]['oper']    =    '=';
       $SecGroupArr['where'][1]['value']    =    $PowerBB->_CONF['group_info']['id'];

       // Finally get the permissions of group
       $this->SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);
       if (!$this->SectionGroup['edit_own_subject'])
       {
		 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
       }

       if ($this->SectionGroup['write_poll']
       and $PowerBB->_CONF['group_info']['write_poll'])
       {
       $PowerBB->template->assign('write_poll',true);
       }

	    $GetSubjectArr = array();
		$GetSubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$GetSubjectInfo = $PowerBB->subject->GetSubjectInfo($GetSubjectArr);
        $GetSubjectInfo['text'] = $PowerBB->Powerparse->censor_words($GetSubjectInfo['text']);
        $PowerBB->template->assign('GetSubjectInfo',$GetSubjectInfo['text']);

		$MemberArr 				= 	array();
		$MemberArr['where']		=	array('username',$SubjectInfo['writer']);

		$WriterInfo = $PowerBB->member->GetMemberInfo($MemberArr);

		$MemberReplyArr 				= 	array();
		$MemberReplyArr['where']		=	array('username',$ReplyInfo['writer']);

		$ReplyWriterInfo = $PowerBB->member->GetMemberInfo($MemberReplyArr);
        $Admin = $PowerBB->functions->ModeratorCheck($PowerBB->_GET['subject_id']);
        $PowerBB->template->assign('Admin',$Admin);

        // show Custom_bbcode List
		$Custom_bbcodeArr 					= 	array();
		$Custom_bbcodeArr['order']			=	array();
		$Custom_bbcodeArr['order']['field']	=	'id';
		$Custom_bbcodeArr['order']['type']	=	'DESC';
		$Custom_bbcodeArr['proc'] 			= 	array();
		$Custom_bbcodeArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['Custom_bbcodesList'] = $PowerBB->custom_bbcode->GetCustom_bbcodeList($Custom_bbcodeArr);


	  if ($PowerBB->functions->ModeratorCheck($PowerBB->_GET['section'])
	  or $PowerBB->_CONF['member_row']['username'] == $GetSubjectInfo['writer'])
		{

        // Moderator And admin Editing Subject any time limit

	     if (!$PowerBB->functions->ModeratorCheck($PowerBB->_GET['section']))
	     {

             // time_out For Editing Subject

				$SubjectArr = array();
				$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

				$PowerBB->_CONF['template']['SubjectInfo'] = $PowerBB->subject->GetSubjectInfo($SubjectArr);

               $time_out = $PowerBB->_CONF['info_row']['time_out']*60;
              if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['SubjectInfo']['write_time']+$time_out)
               {
               $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Editing_time_out']);
               }
	     }

		$PowerBB->template->assign('edit_page','index.php?page=management&amp;subject_edit=1&amp;subject_id=' . $PowerBB->_GET['subject_id'] . '&amp;section=' . $PowerBB->_GET['section']);

		$PowerBB->functions->GetEditorTools();

		$SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$PowerBB->_CONF['template']['SubjectInfo'] = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$PowerBB->template->assign('subject_id',$PowerBB->_GET['subject_id']);

		// Get section information and set it in $this->Section
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

		$this->Section = $PowerBB->section->GetSectionInfo($SecArr);
		$PowerBB->template->assign('section_info',$this->Section);
        $PowerBB->_CONF['template']['SubjectInfo']['reason_edit'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo']['reason_edit'],'html');
        $PowerBB->_CONF['template']['SubjectInfo']['reason_edit'] = $PowerBB->Powerparse->censor_words($PowerBB->_CONF['template']['SubjectInfo']['reason_edit']);
        $PowerBB->template->assign('reason_edit',$PowerBB->_CONF['template']['SubjectInfo']['reason_edit']);
        $PowerBB->template->assign('SRInfo',$PowerBB->_CONF['template']['SubjectInfo']);

		$PowerBB->template->display('subject_edit');

		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['not_allowed_access']);
		}
	}

	function _SubjectEditStart()
	{
		global $PowerBB;
		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['edit_subject'] == '0')
			{
			 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');
		$PowerBB->_POST['title'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['title'],'html');
        $PowerBB->_POST['describe']	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['describe'],'html');
		$PowerBB->_POST['text'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'html');
		$PowerBB->_POST['title'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['title'],'sql');
        $censorwords = preg_split('#[ \r\n\t]+#', $PowerBB->_CONF['info_row']['censorwords'], -1, PREG_SPLIT_NO_EMPTY);
       $PowerBB->_POST['reason_edit'] = str_ireplace($censorwords,'**', $PowerBB->_POST['reason_edit']);
       $PowerBB->_POST['reason_edit'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason_edit'],'html');
       $PowerBB->_POST['reason_edit'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['reason_edit'],'sql');
       $PowerBB->_POST['text'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'sql');
        $PowerBB->_POST['describe']	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['describe'],'sql');
				if ($PowerBB->_POST['stick'])
				{
					$UpdateArr = array();
					$UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

					$update = $PowerBB->subject->StickSubject($UpdateArr);
				}

				if ($PowerBB->_POST['close'])
				{
		$PowerBB->_POST['reason']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason'],'sql');

					$UpdateArr = array();
					$UpdateArr['reason'] = $PowerBB->_POST['reason'];
					$UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

					$update = $PowerBB->subject->CloseSubject($UpdateArr);
				}
                if ($PowerBB->_POST['unstick'])
                {
                   $UpdateArr = array();
                   $UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);
                   $update = $PowerBB->subject->UnstickSubject($UpdateArr);
                }

                if ($PowerBB->_POST['unclose'])
                {
		           $PowerBB->_POST['reason']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason'],'sql');

                    $UpdateArr = array();
                    $UpdateArr['reason'] = $PowerBB->_POST['reason'];
                    $UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);
                    $update = $PowerBB->subject->OpenSubject($UpdateArr);
                }

                  $PowerBB->_POST['reason_edit'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['reason_edit']);

		if ($PowerBB->_POST['preview'])
       {
            $previewtext = $PowerBB->_POST['text'];
            $previewtext = $PowerBB->Powerparse->replace($previewtext);
            $previewtext = $PowerBB->Powerparse->censor_words($previewtext);
            $PowerBB->Powerparse->replace_smiles($previewtext);
            $PowerBB->_POST['text'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['text']);
           $PowerBB->_POST['text'] = str_replace('target="_blank" ','',$PowerBB->_POST['text']);

           $PowerBB->_POST['text']	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'sql');
           $previewtext	= 	$PowerBB->functions->CleanVariable($previewtext,'sql');

            $PowerBB->template->assign('prev',$PowerBB->_POST['text']);
            $PowerBB->template->assign('title_prev',$PowerBB->_POST['title']);
            $PowerBB->template->assign('describe_prev',$PowerBB->_POST['describe']);
            $PowerBB->template->assign('preview',$previewtext);
       	    $PowerBB->template->assign('view_preview',$previewtext);
            $PowerBB->template->assign('reason_edit',$PowerBB->_POST['reason_edit']);
            $PowerBB->template->assign('prefix_subject_prev',$PowerBB->_POST['prefix_subject']);

			$this->_SubjectEditpreview();


        }
      else
       {

			if (empty($PowerBB->_GET['subject_id']))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
			}

				if (empty($PowerBB->_POST['title']))
				{
                    $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['no_title']);
                    $this->_empty_bac();
					$PowerBB->functions->error_stop();

				}

				if (empty($PowerBB->_POST['text']))
				{
					$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['no_text']);
				}

                    $TitlePost = utf8_decode($PowerBB->_POST['title']);
		     		if (isset($TitlePost{$PowerBB->_CONF['info_row']['post_title_max']}))
		     		{
                        $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['post_text_max_subjects']);
                         $this->_empty_bac();
		       			$PowerBB->functions->error_stop();
		    		}

		        	if  (!isset($TitlePost{$PowerBB->_CONF['info_row']['post_title_min']}))
		     		{
                        $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['post_text_min_subjects']);
                         $this->_empty_bac();
		      			$PowerBB->functions->error_stop();
		     		}

                    $TextPost = utf8_decode($PowerBB->_POST['text']);
                    $TextPost = preg_replace('#\[IMG\](.*)\[/IMG\]#siUe', '', $TextPost);
		       	 	if (isset($TextPost{$PowerBB->_CONF['info_row']['post_text_max']}))
		     		{
                        $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['post_text_max']);
                         $this->_empty_bac();
		      			$PowerBB->functions->error_stop();
		     		}

		     		if (!isset($TextPost{$PowerBB->_CONF['info_row']['post_text_min']}))
		     		{
		     			 $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['post_text_min']);
                         $this->_empty_bac();
		      			$PowerBB->functions->error_stop();
		     		}

	        // Moderator And admin Editing Subject any time limit

		     if (!$PowerBB->functions->ModeratorCheck($PowerBB->_GET['section']))
		     {

	             // time_out For Editing Subject

					$SubjectArr = array();
					$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

					$PowerBB->_CONF['template']['SubjectInfo'] = $PowerBB->subject->GetSubjectInfo($SubjectArr);

	               $time_out = $PowerBB->_CONF['info_row']['time_out']*60;
	              if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['SubjectInfo']['write_time']+$time_out)
	               {
	               $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Editing_time_out']);
	               }
		     }

         $SubjectInfoArr 			= 	array();
		 $SubjectInfoArr['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

		$SubjectUpdate = $PowerBB->subject->GetSubjectInfo($SubjectInfoArr);

       $PowerBB->_POST['reason_edit'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason_edit'],'html');
       $PowerBB->_POST['reason_edit'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['reason_edit']);

            $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

			// ADD poll
         if ($PowerBB->_POST['poll'])
         {
                // Filter Words
                  $PowerBB->_POST['question'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['question'],'html');
                  $PowerBB->_POST['question'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['question']);
                  $PowerBB->_POST['question'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['question'],'sql');

              if (empty($PowerBB->_POST['question']))
             {
                $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['fill_in_question']);
                 $PowerBB->template->assign('question',$PowerBB->_POST['question']);
                    $this->_empty_bac();
                    $PowerBB->functions->error_stop();
              }

                 $Answer = $PowerBB->_POST['answer'];
               foreach ($Answer as $Answer_x)
               {
                // Filter Answer Words
                $Answer_x = $PowerBB->functions->CleanVariable($Answer_x,'html');
                 $Answer_x = $PowerBB->functions->CleanVariable($Answer_x,'sql');
                $Answer_x = $PowerBB->Powerparse->censor_words($Answer_x);
                $Answer_x = str_replace('<','',$Answer_x);
                  if (empty($Answer_x))
                {
                    $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['fill_in_answer']);
                    $PowerBB->template->assign('question',$PowerBB->_POST['question']);
                    $this->_empty_bac();
                    $PowerBB->functions->error_stop();
                }

               }
           }
			//

			$UpdateArr 				= 	array();
			$UpdateArr['field']		=	array();

			$UpdateArr['field']['title'] 				= 	$PowerBB->_POST['title'];
			$UpdateArr['field']['text'] 				= 	$PowerBB->_POST['text'];
			$UpdateArr['field']['icon'] 				= 	$PowerBB->_POST['icon'];
			$UpdateArr['field']['actiondate'] 	        = 	$PowerBB->_CONF['now'];
			$UpdateArr['field']['reason_edit'] 	        = 	$PowerBB->_POST['reason_edit'];
             if ($PowerBB->_POST['poll'])
             {
             $UpdateArr['field']['poll_subject']        =    1;
             }
     		$UpdateArr['field']['action_by'] 	        = 	$PowerBB->_CONF['member_row']['username'];
			$UpdateArr['field']['subject_describe'] 	= 	$PowerBB->_POST['describe'];
            $UpdateArr['field']['stick']                =    $stick;
            $UpdateArr['field']['close']                =    $close;
		    $UpdateArr['field']['prefix_subject'] 		= 	$PowerBB->_POST['prefix_subject'];
			$UpdateArr['where'] 						= 	array('id',$PowerBB->_GET['subject_id']);

			$update = $PowerBB->subject->UpdateSubject($UpdateArr);

			if ($update)
			{

              if ($PowerBB->_CONF['info_row']['allowed_emailed'] == '1')
                 {

                 if ($PowerBB->_POST['emailed'])
                 {
                 $EmailedArr                           =    array();
                 $EmailedArr['get_id']                    =    true;
                 $EmailedArr['field']                    =    array();
                 $EmailedArr['field']['user_id']           =    $PowerBB->_CONF['member_row']['id'];
                 $EmailedArr['field']['subject_id']           =    $PowerBB->_GET['subject_id'];
                 $EmailedArr['field']['subject_title']        =    $UpdateArr['field']['title'];
                $Insert = $PowerBB->emailed->InsertEmailed($EmailedArr);

                }else{

                $Del = $PowerBB->emailed->UnScubscribe($PowerBB->_GET['subject_id']);
                }
                }

               if ($PowerBB->_POST['poll'])
                 {

                    if (isset($PowerBB->_POST['question'])
                        and isset($PowerBB->_POST['answer'][0])
                        and isset($PowerBB->_POST['answer'][1]))
                    {
                        $answers_number = 2;

                        if ($PowerBB->_POST['poll_answers_count'] > 0)
                        {
                           $answers_number = $PowerBB->_POST['poll_answers_count'];
                        }

                        $answers = array();

                        $x = 0;

                        while ($x < $answers_number)
                        {
                           // The text of the answer
                           $answers[$x][0] = $PowerBB->_POST['answer'][$x];
                        $PowerBB->functions->CleanVariable($PowerBB->_POST['answer'][$x],'html');
                        $PowerBB->functions->CleanVariable($PowerBB->_POST['answer'][$x],'sql');
						$PowerBB->_POST['answer'][$x] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['answer'][$x]);
						$PowerBB->_POST['answer'][$x] = str_replace('SCRIPT','',$PowerBB->_POST['answer'][$x]);
						$PowerBB->_POST['answer'][$x] = $PowerBB->functions->CleanVariable($PowerBB->_POST['answer'][$x],'sql');

                           // The result
                           $answers[$x][1] = 0;

                           $x += 1;
                        }

                        $PollArr              =    array();
                        $PollArr['field']    =    array();
                        $PollArr['field']['qus']        =    $PowerBB->functions->CleanVariable($PowerBB->_POST['question'],'html');
                        $PollArr['field']['answers']    =    $PowerBB->_POST['answer'];
                        $PollArr['field']['subject_id']    =    $PowerBB->_GET['subject_id'];

                        $InsertPoll = $PowerBB->poll->InsertPoll($PollArr);
                    }
                 }

     		// The number of section's subjects number
     		$UpdateArr 					= 	array();
     		$UpdateArr['field']			=	array();

     		$UpdateArr['field']['icon'] 	= 	$PowerBB->_POST['icon'];
     		$UpdateArr['field']['last_subject'] 	= 	$PowerBB->_POST['title'];
     		$UpdateArr['where']					= 	array('last_subjectid',$PowerBB->_GET['subject_id']);

     		$UpdateSubject = $PowerBB->section->UpdateSection($UpdateArr);
     		$PowerBB->cache->UpdateSubjectNumber(array('icon'	=>	$PowerBB->_POST['icon']));
     		$PowerBB->cache->UpdateSubjectNumber(array('last_subject'	=>	$PowerBB->_POST['title']));

     				$SecArr 			= 	array();
					$SecArr['where'] 	= 	array('id',$SubjectUpdate['section']);

					$SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

     		// Update section's cache
     		$UpdateArr 				= 	array();
     		$UpdateArr['parent'] 	= 	$SectionInfo['parent'];

     		$update_cache = $PowerBB->section->UpdateSectionsCache($UpdateArr);

     		unset($UpdateArr);


			$cache = $PowerBB->section->UpdateSectionsCache(array('parent'=>$SubjectUpdate['section']));
			$cache = $PowerBB->section->UpdateSectionsCache(array('parent'=>$PowerBB->_GET['section']));


				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_successfully']);
				 $PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
			}

		}
	}

	function _Reply()
	{
		global $PowerBB;

		if (!isset($PowerBB->_GET['operator'])
			or !isset($PowerBB->_GET['section'])
			or !isset($PowerBB->_GET['reply']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}
		elseif ($PowerBB->_GET['operator'] == 'edit')
		{
			$this->__ReplyEdit();
		}
		elseif ($PowerBB->_GET['operator'] == 'unreview_reply')
		{
			$this->_UnReviewReply();
		}


	}



	function _empty_bac_ReplyEdit()
	{
		global $PowerBB;

		$PowerBB->_GET['reply_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['reply_id'],'intval');

		if (empty($PowerBB->_GET['reply_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		 // Moderator And admin Editing Reply any time limit

	     if (!$PowerBB->functions->ModeratorCheck($PowerBB->_GET['section']))
	     {

             // time out For Editing Reply

			$ReplyArr = array();
			$ReplyArr['where'] = array('id',$PowerBB->_GET['reply_id']);

			$PowerBB->_CONF['template']['ReplyInfoTime'] = $PowerBB->reply->GetReplyInfo($ReplyArr);

	               $time_out = $PowerBB->_CONF['info_row']['time_out']*60;
	             if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['ReplyInfoTime']['write_time']+$time_out)
	             {
	               $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Reply_Editing_time_out']);
	            }
	     }


		$PowerBB->template->assign('edit_page','index.php?page=management&amp;reply_edit=1&amp;reply_id=' . $PowerBB->_GET['reply_id'] . '&amp;section=' . $PowerBB->_GET['section'] . '&amp;subject_id=' . $PowerBB->_GET['subject_id']);

		$PowerBB->functions->GetEditorTools();

		$PowerBB->template->assign('reply_id',$PowerBB->_GET['reply_id']);
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['subject_id']);


		// Get Reply preview information and set it in $this->Reply
			$ReplyArr = array();
			$ReplyArr['where'] = array('id',$PowerBB->_GET['reply_id']);

			$this->Reply = $PowerBB->reply->GetReplyInfo($ReplyArr);

		$PowerBB->template->assign('ReplyInfoTime',$this->Reply);

				// Get section information and set it in $this->Section
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

		$this->Section = $PowerBB->section->GetSectionInfo($SecArr);
		$PowerBB->template->assign('section_info',$this->Section);
        $previewtext = $PowerBB->_POST['text'];
        $previewtext = $PowerBB->Powerparse->replace($previewtext);
        $previewtext = $PowerBB->Powerparse->censor_words($previewtext);
        $PowerBB->Powerparse->replace_smiles($previewtext);
        $PowerBB->_POST['text'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['text']);
        $PowerBB->_POST['text'] = str_replace('target="_blank" ','',$PowerBB->_POST['text']);
        $PowerBB->template->assign('preview',$previewtext);
        $PowerBB->template->assign('prev',$PowerBB->_POST['text']);
       	$PowerBB->template->assign('reply_id',$PowerBB->_GET['reply_id']);
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['subject_id']);
		$PowerBB->template->assign('SRInfo',$this->Reply);

		$PowerBB->template->display('reply_edit');
	}

	function _ReplyEditpreview()
	{
		global $PowerBB;

		$PowerBB->_GET['reply_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['reply_id'],'intval');

		if (empty($PowerBB->_GET['reply_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		 // Moderator And admin Editing Reply any time limit

	     if (!$PowerBB->functions->ModeratorCheck($PowerBB->_GET['section']))
	     {


             // time out For Editing Reply

			$ReplyArr = array();
			$ReplyArr['where'] = array('id',$PowerBB->_GET['reply_id']);

			$PowerBB->_CONF['template']['ReplyInfoTime'] = $PowerBB->reply->GetReplyInfo($ReplyArr);

	               $time_out = $PowerBB->_CONF['info_row']['time_out']*60;
	             if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['ReplyInfoTime']['write_time']+$time_out)
	             {
	               $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Reply_Editing_time_out']);
	            }
	     }


		$PowerBB->template->assign('edit_page','index.php?page=management&amp;reply_edit=1&amp;reply_id=' . $PowerBB->_GET['reply_id'] . '&amp;section=' . $PowerBB->_GET['section'] . '&amp;subject_id=' . $PowerBB->_GET['subject_id']);

		$PowerBB->functions->GetEditorTools();

		$PowerBB->template->assign('reply_id',$PowerBB->_GET['reply_id']);
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['subject_id']);


		// Get Reply preview information and set it in $this->Reply
			$ReplyArr = array();
			$ReplyArr['where'] = array('id',$PowerBB->_GET['reply_id']);

			$this->Reply = $PowerBB->reply->GetReplyInfo($ReplyArr);

		$PowerBB->template->assign('ReplyInfoTime',$this->Reply);

				// Get section information and set it in $this->Section
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

		$this->Section = $PowerBB->section->GetSectionInfo($SecArr);
		$PowerBB->template->assign('section_info',$this->Section);
       		$PowerBB->template->assign('SRInfo',$this->Reply);

		$PowerBB->template->display('reply_edit');
	}



	function __ReplyEdit()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['edit_reply'] == '0')
			{
			 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}
		else
		{
			if ($PowerBB->_CONF['group_info']['id'] != '1'
			   AND  $PowerBB->_CONF['group_info']['id'] != '2')
			{
			    $SubjectArr = array();
			    $SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);
			    $SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);
				if ($SubjectInfo['close'] == '1')
				{
				 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['This_topic_is_locked']);
				}
			}
		}

       $SecGroupArr                    =    array();
       $SecGroupArr['where']              =    array();

       $SecGroupArr['where'][0]          =    array();
       $SecGroupArr['where'][0]['name']    =    'section_id';
       $SecGroupArr['where'][0]['oper']    =    '=';
       $SecGroupArr['where'][0]['value']    =    $PowerBB->_GET['section'];

       $SecGroupArr['where'][1]          =    array();
       $SecGroupArr['where'][1]['con']       =    'AND';
       $SecGroupArr['where'][1]['name']    =    'group_id';
       $SecGroupArr['where'][1]['oper']    =    '=';
       $SecGroupArr['where'][1]['value']    =    $PowerBB->_CONF['group_info']['id'];

       // Finally get the permissions of group
       $this->SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);
       if (!$this->SectionGroup['edit_own_reply'])
       {
		 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
       }

       $getmember_subscribtion = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['emailed'] . " WHERE `user_id`='" . $PowerBB->_CONF['member_row']['id'] . "' AND subject_id = '" .$PowerBB->_GET['subject_id'] . "'");
       $getmember_count = $PowerBB->DB->sql_num_rows($getmember_subscribtion);
       $PowerBB->template->assign('IsSubscribed',$getmember_count);

		$PowerBB->_GET['reply_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['reply_id'],'intval');

		if (empty($PowerBB->_GET['reply_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$ReplyArr = array();
		$ReplyArr['where'] = array('id',$PowerBB->_GET['reply_id']);

       $ReplyInfo = $PowerBB->reply->GetReplyInfo($ReplyArr);


		$MemberReplyArr 				= 	array();
		$MemberReplyArr['where']		=	array('username',$ReplyInfo['writer']);

		$ReplyWriterInfo = $PowerBB->member->GetMemberInfo($MemberReplyArr);

        // show Custom_bbcode List
		$Custom_bbcodeArr 					= 	array();
		$Custom_bbcodeArr['order']			=	array();
		$Custom_bbcodeArr['order']['field']	=	'id';
		$Custom_bbcodeArr['order']['type']	=	'DESC';
		$Custom_bbcodeArr['proc'] 			= 	array();
		$Custom_bbcodeArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['Custom_bbcodesList'] = $PowerBB->custom_bbcode->GetCustom_bbcodeList($Custom_bbcodeArr);


	  if ($PowerBB->functions->ModeratorCheck($PowerBB->_GET['section'])
	  or $PowerBB->_CONF['member_row']['username'] == $ReplyWriterInfo['username'])
		{

		 // Moderator And admin Editing Reply any time limit

	     if (!$PowerBB->functions->ModeratorCheck($PowerBB->_GET['section']))
	     {


             // time out For Editing Reply

			$ReplyArr = array();
			$ReplyArr['where'] = array('id',$PowerBB->_GET['reply_id']);

			$PowerBB->_CONF['template']['ReplyInfo'] = $PowerBB->reply->GetReplyInfo($ReplyArr);

	               $time_out = $PowerBB->_CONF['info_row']['time_out']*60;
	             if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['ReplyInfo']['write_time']+$time_out)
	             {
	               $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Reply_Editing_time_out']);
	            }
	     }


		$PowerBB->template->assign('edit_page','index.php?page=management&amp;reply_edit=1&amp;reply_id=' . $PowerBB->_GET['reply_id'] . '&amp;section=' . $PowerBB->_GET['section'] . '&amp;subject_id=' . $PowerBB->_GET['subject_id']);

		$PowerBB->functions->GetEditorTools();

		$ReplyArr = array();
		$ReplyArr['where'] = array('id',$PowerBB->_GET['reply_id']);

		$PowerBB->_CONF['template']['ReplyInfo'] = $PowerBB->reply->GetReplyInfo($ReplyArr);

		$SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$PowerBB->_CONF['template']['SubjectInfo'] = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		$PowerBB->template->assign('reply_id',$PowerBB->_GET['reply_id']);
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['subject_id']);

		// Get section information and set it in $this->Section
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

		$this->Section = $PowerBB->section->GetSectionInfo($SecArr);

        $PowerBB->_CONF['template']['ReplyInfo']['reason_edit'] = $PowerBB->Powerparse->censor_words($PowerBB->_CONF['template']['ReplyInfo']['reason_edit']);
        $PowerBB->_CONF['template']['ReplyInfo']['reason_edit'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['ReplyInfo']['reason_edit'],'html');

		$PowerBB->template->assign('reason_edit',$PowerBB->_CONF['template']['ReplyInfo']['reason_edit']);
		$PowerBB->template->assign('section_info',$this->Section);
		$PowerBB->template->assign('reply_number',$PowerBB->_GET['reply_number']);

          $PowerBB->template->assign('count_peg',$PowerBB->_GET['count']);
       $Admin = $PowerBB->functions->ModeratorCheck($PowerBB->_GET['subject_id']);
       $PowerBB->template->assign('Admin',$Admin);
          $PowerBB->template->assign('SRInfo',$PowerBB->_CONF['template']['ReplyInfo']);
         $PowerBB->_CONF['template']['ReplyInfo']['text'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['ReplyInfo']['text'],'sql');
         $PowerBB->template->assign('GetReplyInfo',$PowerBB->_CONF['template']['ReplyInfo']['text']);
		$PowerBB->template->display('reply_edit');

		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['not_allowed_access']);
		}
	}

	function _ReplyEditStart()
	{
		global $PowerBB;

		$PowerBB->_GET['reply_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['reply_id'],'intval');

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['edit_reply'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}
        else
		{
			if ($PowerBB->_CONF['group_info']['id'] != '1'
			   AND  $PowerBB->_CONF['group_info']['id'] != '2')
			{
			    $SubjectArr = array();
			    $SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);
			    $SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);
				if ($SubjectInfo['close'] == '1')
				{
				 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['This_topic_is_locked']);
				}
			}
		}


       $SecGroupArr                    =    array();
       $SecGroupArr['where']              =    array();

       $SecGroupArr['where'][0]          =    array();
       $SecGroupArr['where'][0]['name']    =    'section_id';
       $SecGroupArr['where'][0]['oper']    =    '=';
       $SecGroupArr['where'][0]['value']    =    $PowerBB->_GET['section'];

       $SecGroupArr['where'][1]          =    array();
       $SecGroupArr['where'][1]['con']       =    'AND';
       $SecGroupArr['where'][1]['name']    =    'group_id';
       $SecGroupArr['where'][1]['oper']    =    '=';
       $SecGroupArr['where'][1]['value']    =    $PowerBB->_CONF['group_info']['id'];

       // Finally get the permissions of group
       $this->SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);
       if (!$this->SectionGroup['edit_own_reply'])
       {
		 $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
       }


		 if ($PowerBB->_POST['preview'])
       {
           $previewtext = $PowerBB->_POST['text'];
           $previewtext = $PowerBB->Powerparse->replace($previewtext);
           $previewtext = $PowerBB->Powerparse->censor_words($previewtext);
           $PowerBB->Powerparse->replace_smiles($previewtext);
           $PowerBB->_POST['text'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['text']);
         $PowerBB->_POST['text'] = str_replace('target="_blank" ','',$PowerBB->_POST['text']);
          $PowerBB->template->assign('prev',$PowerBB->_POST['text']);
       	  $PowerBB->template->assign('reply_id',$PowerBB->_GET['reply_id']);
		 $PowerBB->template->assign('subject_id',$PowerBB->_GET['subject_id']);
		  $PowerBB->template->assign('preview',$previewtext);
          $PowerBB->template->assign('view_preview',$PowerBB->_POST['text']);

       $PowerBB->_POST['reason_edit'] = $PowerBB->Powerparse->censor_words($PowerBB->_POST['reason_edit']);
       $PowerBB->_POST['reason_edit'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason_edit'],'html');
       $PowerBB->_POST['reason_edit'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason_edit'],'sql');

          $PowerBB->template->assign('reason_edit',$PowerBB->_POST['reason_edit']);
			$this->_ReplyEditpreview();


        }
      else
       {
          $PowerBB->_GET['reply_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['reply_id'],'intval');

			if (empty($PowerBB->_GET['reply_id']))
			{
				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
			}

            if (empty($PowerBB->_POST['text']))
			{
             $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['post_text_min']);
			}
            $TextPost = utf8_decode($PowerBB->_POST['text']);
             $TextPost = preg_replace('#\[IMG\](.*)\[/IMG\]#siUe', '', $TextPost);

     		if (isset($TextPost{$PowerBB->_CONF['info_row']['post_text_max']}))
     		{
     			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['post_text_max']);
                $this->_empty_bac_ReplyEdit();
                $PowerBB->functions->error_stop();
	     	 }

     		 if (!isset($TextPost{$PowerBB->_CONF['info_row']['post_text_min']}))
     		{
             $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['post_text_min']);
     		}

			 // Moderator And admin Editing Reply any time limit

		     if (!$PowerBB->functions->ModeratorCheck($PowerBB->_GET['section']))
		     {


	             // time_out For Editing Subject

				$ReplyArr = array();
				$ReplyArr['where'] = array('id',$PowerBB->_GET['reply_id']);

				$PowerBB->_CONF['template']['ReplyInfo'] = $PowerBB->reply->GetReplyInfo($ReplyArr);

		               $time_out = $PowerBB->_CONF['info_row']['time_out']*60;
		             if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['ReplyInfo']['write_time']+$time_out)
		             {
		               $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Reply_Editing_time_out']);
		            }
		     }

            $time=time()+$PowerBB->_CONF['info_row']['timestamp'];
        $PowerBB->_POST['text'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'sql');
		$PowerBB->_POST['title'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['title'],'sql');
       $PowerBB->_POST['reason_edit']  = $PowerBB->Powerparse->censor_words($PowerBB->_POST['reason_edit']);
       $PowerBB->_POST['reason_edit'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason_edit'],'html');
       $PowerBB->_POST['reason_edit'] 	= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason_edit'],'sql');

			$UpdateArr 				= 	array();
			$UpdateArr['field']		= 	array();

			$UpdateArr['field']['title'] 		= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['title'],'html');
			$UpdateArr['field']['text'] 		= 	$PowerBB->functions->CleanVariable($PowerBB->_POST['text'],'html');
			$UpdateArr['field']['actiondate'] 	= 	$PowerBB->_CONF['now'];
			$UpdateArr['field']['reason_edit']  = 	$PowerBB->_POST['reason_edit'];
     		$UpdateArr['field']['action_by'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$UpdateArr['field']['icon'] 		= 	$PowerBB->_POST['icon'];
			$UpdateArr['where'] 				= 	array('id',$PowerBB->_GET['reply_id']);

			$update = $PowerBB->reply->UpdateReply($UpdateArr);

        if ($PowerBB->_POST['stick'])
                {
                $UpdateArr = array();
                $UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

                $update = $PowerBB->subject->StickSubject($UpdateArr);
                }

                if ($PowerBB->_POST['unstick'])
                {
                $UpdateArr = array();
                $UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

                $update = $PowerBB->subject->UnstickSubject($UpdateArr);
                }

                if ($PowerBB->_POST['close'])
                    {
		              $PowerBB->_POST['reason']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason'],'sql');

                    $UpdateArr = array();
                    $UpdateArr['reason'] = $PowerBB->_POST['reason'];
                    $UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

                    $update = $PowerBB->subject->CloseSubject($UpdateArr);
                       }
                    if ($PowerBB->_POST['unclose'])
                    {
                    $PowerBB->_POST['reason']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason'],'sql');
                    $UpdateArr = array();
                    $UpdateArr['reason'] = $PowerBB->_POST['reason'];
                    $UpdateArr['where'] = array('id',$PowerBB->_GET['subject_id']);

                    $update = $PowerBB->subject->OpenSubject($UpdateArr);
                       }

			if ($update)
			{

                   if ($PowerBB->_CONF['info_row']['allowed_emailed'] == '1')
                       {

                          if ($PowerBB->_POST['emailed'])
                          {
                          $EmailedArr                           =    array();
                          $EmailedArr['get_id']                    =    true;
                          $EmailedArr['field']                    =    array();
                          $EmailedArr['field']['user_id']           =    $PowerBB->_CONF['member_row']['id'];
                          $EmailedArr['field']['subject_id']           =    $PowerBB->_GET['subject_id'];
                          $EmailedArr['field']['subject_title']        =    $UpdateArr['field']['title'];
                          $Insert = $PowerBB->emailed->InsertEmailed($EmailedArr);

                          }else{

                          $Del = $PowerBB->emailed->UnScubscribe($PowerBB->_GET['subject_id']);
                       }
                    }

			$SubjectArr_1 			= 	array();
			$SubjectArr_1['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$this->SubjectInfo_1 = $PowerBB->subject->GetSubjectInfo($SubjectArr_1);

				$ReplyArr_1 = array();
				$ReplyArr_1['where'] = array('id',$PowerBB->_GET['reply_id']);

				$ReplyInfo_1 = $PowerBB->reply->GetReplyInfo($ReplyArr_1);

				$subject_id_1 = $PowerBB->_GET['subject_id'];
		        $reply__nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['reply'] . " WHERE subject_id='$subject_id_1' and delete_topic <>1 "));

				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_successfully']);

	   		  if ($reply__nm < $PowerBB->_CONF['info_row']['perpage'])
			   {
               $PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $this->SubjectInfo_1['id'] . '#' . $PowerBB->_GET['reply_id']);

			   }
	          else
	          {
	              $ss_r = $PowerBB->_CONF['info_row']['perpage']/2;
	              $roun_ss_r = round($ss_r, 0);
		          $reply_number_r = $reply__nm- $roun_ss_r;
		          $pagenum_r = $reply_number_r/$PowerBB->_CONF['info_row']['perpage'];
		          $round0_r = round($pagenum_r, 0);
		          $perpage_r = $round0_r*$PowerBB->_CONF['info_row']['perpage'];
		          $perpage_r = str_replace('-','',$perpage_r);
				  $PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $this->SubjectInfo_1['id'] . '&amp;count=' . $PowerBB->_POST['count']  . '#' . $PowerBB->_GET['reply_id']);
	          }
		   }



	   }

  }
  	function _TopicModStart()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

  	    $SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		// Check the powers group mod  of transfer of the subject
		 if (!$PowerBB->functions->ModeratorCheck($SubjectInfo['section']))
		{

			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);

		}


		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

			$TopicModArr				=	array();
		    $TopicModArr['where'] 	= 	array('id',$PowerBB->_POST['mod_id']);

			$TopicMod = $PowerBB->topicmod->GetTopicModInfo($TopicModArr);


     	// Get Section Form Info
     	$SecFormArr 			= 	array();
		$SecFormArr['where'] 	= 	array('id',$SubjectInfo['section']);

		$SectionFormInfo = $PowerBB->section->GetSectionInfo($SecFormArr);

		if ($TopicMod['state'] == 'leave')
		{
		 $state = '0';
		}
		elseif ($TopicMod['state'] == 'close')
		{
         $state = '1';
		}
		else
		{
        $state = '0';
		}

		if ($TopicMod['pin'] == 'leave')
		{
		 $pin = '0';
		}
		elseif ($TopicMod['pin'] == 'pin')
		{
         $pin = '1';
		}
		else
		{
        $pin = '0';
		}

		if ($TopicMod['approve'] == '0')
		{
		 $approve = '0';
		}
		elseif ($TopicMod['approve'] == '1')
		{
         $approve = '0';
		}
		else
		{
        $approve = '1';
		}

		if ($TopicMod['move'] == '-1')
		{
         $move = $SubjectInfo['section'];
		}
		else
		{
        $move = $TopicMod['move'];
		}


     	// Get Section move Form Info
     	$SecmoveFormArr 			= 	array();
		$SecmoveFormArr['where'] 	= 	array('id',$move);

		$SectionmoveFormInfo = $PowerBB->section->GetSectionInfo($SecmoveFormArr);

			$UpdateArr 				= 	array();
			$UpdateArr['field']		=	array();

			$UpdateArr['field']['title'] 				= 	$TopicMod['title_st'].$SubjectInfo['title'].$TopicMod['title_end'];
			$UpdateArr['field']['close'] 				= 	$state;
			$UpdateArr['field']['stick'] 				= 	$pin;
			$UpdateArr['field']['review_subject'] 	     = 	$approve;
			$UpdateArr['field']['section'] 	     = 	$move;
			$UpdateArr['where'] 						= 	array('id',$PowerBB->_GET['subject_id']);

			$update = $PowerBB->subject->UpdateSubject($UpdateArr);
		     if ($TopicMod['move'] > '1')
		       {
				$subject_id = $PowerBB->_GET['subject_id'];
				$Move_from_section = $SubjectInfo['section'];
					if ($SectionFormInfo['last_subjectid'] == $PowerBB->_GET['subject_id'])
					{

						$GetLastSubject = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['subject'] . " WHERE section = '$Move_from_section' ORDER by write_time DESC");
						$LastSubjectInfo = $PowerBB->DB->sql_fetch_array($GetLastSubject);

						$GetLastReply = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['reply'] . " WHERE section = '$Move_from_section' ORDER by write_time DESC");
						$LastReplyInfo = $PowerBB->DB->sql_fetch_array($GetLastReply);

						if ($LastSubjectInfo['write_time']< $LastReplyInfo['write_time'])
						{
			             $LastInfo = $PowerBB->DB->sql_fetch_array($GetLastReply);
			             $last_subjectid = $LastInfo['subject_id'];
			             $last_berpage_nm = $LastInfo['id'];
						}
						else
						{
			              $LastInfo = $PowerBB->DB->sql_fetch_array($GetLastSubject);
			              $last_subjectid = $LastInfo['id'];
			              $last_berpage_nm = $LastInfo['reply_number'];
						}
						// Update Last subject's information in Section Form
			     		$UpdateLastFormSecArr = array();
			     		$UpdateLastFormSecArr['field']			=	array();

						$UpdateLastFormSecArr['field']['last_writer'] 		= 	$LastInfo['writer'];
			     		$UpdateLastFormSecArr['field']['last_subject'] 		= 	$LastInfo['title'];
			     		$UpdateLastFormSecArr['field']['last_subjectid'] 	= 	$last_subjectid;
			     		$UpdateLastFormSecArr['field']['last_date'] 	= 	$LastInfo['write_time'];
			     		$UpdateLastFormSecArr['field']['last_time'] 	= 	$LastInfo['write_time'];
			     		$UpdateLastFormSecArr['field']['icon'] 		    = 	$LastInfo['icon'];
					    $UpdateLastFormSecArr['field']['last_reply'] 	= 	0;
					    $UpdateLastFormSecArr['field']['last_berpage_nm']  = 	0;

			     		$UpdateLastFormSecArr['where'] 		        = 	array('id',$Move_from_section);

			     		// Update Last To Sec subject's information
			     		$UpdateLastFormSec = $PowerBB->section->UpdateSection($UpdateLastFormSecArr);

					 }

						// Update Last subject's information in Section To
			     		$UpdateLastToSecArr = array();
			     		$UpdateLastToSecArr['field']			=	array();

						$UpdateLastToSecArr['field']['last_writer'] 		= 	$SubjectInfo['writer'];
			     		$UpdateLastToSecArr['field']['last_subject'] 		= 	$SubjectInfo['title'];
			     		$UpdateLastToSecArr['field']['last_subjectid'] 	= 	$PowerBB->_GET['subject_id'];
			     		$UpdateLastToSecArr['field']['last_date'] 	= 	$PowerBB->_CONF['now'];
			     		$UpdateLastToSecArr['field']['last_time'] 	= 	$PowerBB->_CONF['now'];
			     		$UpdateLastToSecArr['field']['icon'] 		= 	$SubjectInfo['icon'];
					    $UpdateLastToSecArr['field']['last_reply'] 	= 	0;
					    $UpdateLastToSecArr['field']['last_berpage_nm']  = 	0;

			     		$UpdateLastToSecArr['where'] 		        = 	array('id',$TopicMod['move']);

			     		// Update Last To Sec subject's information
			     		$UpdateLastToSec = $PowerBB->section->UpdateSection($UpdateLastToSecArr);

				$Move_replys = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['reply'] . " WHERE subject_id = '$subject_id' ");
				while ($Moved = $PowerBB->DB->sql_fetch_array($Move_replys))
				{
				$UpdateArr 				= 	array();
				$UpdateArr['field']		= 	array();

				$UpdateArr['field']['section'] 		= 	$TopicMod['move'];
				$UpdateArr['where'] 				= 	array('id',$Moved['id']);

				$update = $PowerBB->reply->UpdateReply($UpdateArr);
				}
             }

		    if ($TopicMod['reply'] == '1')
		    {

		     	$ReplyArr 			                = 	array();
		     	$ReplyArr['get_id']					=	true;
		     	$ReplyArr['field']               	= 	array();
		     	$ReplyArr['field']['title'] 		= 	$TopicMod['title_st'].$SubjectInfo['title'].$TopicMod['title_end'];
		     	$ReplyArr['field']['text'] 			= 	$TopicMod['reply_content'];
				$ReplyArr['field']['writer']		= 	$PowerBB->_CONF['member_row']['username'];
		     	$ReplyArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
		     	$ReplyArr['field']['write_time'] 	= 	$PowerBB->_CONF['now'];
		     	$ReplyArr['field']['section'] 		= 	$TopicMod['move'];
		     	$ReplyArr['field']['icon'] 			= 	'look/images/icons/i1.gif';

		     	$Insert = $PowerBB->reply->InsertReply($ReplyArr);

		     		//////////

		     		$TimeArr = array();

		     		$TimeArr['write_time'] 	= 	$PowerBB->_CONF['now'];
		     		$TimeArr['where']		=	array('id',$PowerBB->_GET['subject_id']);

		     		$UpdateWriteTime = $PowerBB->subject->UpdateWriteTime($TimeArr);

		     		$RepArr 					= 	array();
		     		$RepArr['reply_number']		=	$SubjectInfo['reply_number'];
		     		$RepArr['where'] 			= 	array('id',$PowerBB->_GET['subject_id']);

		     		$UpdateReplyNumber = $PowerBB->subject->UpdateReplyNumber($RepArr);

					$SecArr 			= 	array();
					$SecArr['where'] 	= 	array('id',$SubjectInfo['section']);

					$this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

		     	     if ($PowerBB->_CONF['member_permission'])
				    {
		     		$LastArr = array();
		     		$LastArr['replier'] 	= 	$PowerBB->_CONF['member_row']['username'];
		     		$LastArr['where']		=	array('id',$PowerBB->_GET['subject_id']);

		     		$UpdateLastReplier = $PowerBB->subject->UpdateLastReplier($LastArr);
		     		}
					$SecLastArr 			= 	array();
					$SecLastArr['where'] 	= 	array('id',$Subjectinfo['section']);

					$this->SectionLastInfo = $PowerBB->section->GetSectionInfo($SecLastArr);

		   			//////////

		     		$UpdateSubjectNumber = $PowerBB->cache->UpdateReplyNumber(array('reply_num'	=>	$PowerBB->_CONF['info_row']['reply_number']));

		     		// Free Lasts in subject
					$UpdateSubjectArr 						= 	array();
					$UpdateSubjectArr['field'] 				= 	array();

					$UpdateSubjectArr['field']['last_replier'] 	= 	$PowerBB->_CONF['member_row']['username'];
					$UpdateSubjectArr['field']['last_time'] 	= 	$PowerBB->_CONF['now'];
					$UpdateSubjectArr['field']['write_date'] 	= 	$PowerBB->_CONF['now'];
					$UpdateSubjectArr['field']['review_reply'] 	= 	$PowerBB->_CONF['member_row']['review_reply'];
					$UpdateSubjectArr['where'] 				= 	array('id',$Subjectinfo['section']);

					$UpdateLastReplier = $PowerBB->subject->UpdateSubject($UpdateSubjectArr);

					// The number of section's reply number
              		$sectionid = $SectionFormInfo['id'];
                    $ReplyNumArr = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['reply'] . " WHERE section='$sectionid' and delete_topic <>1 and review_reply <>1"));

					// The number of section's subjects number
		     		$UpdateArr 					= 	array();
		     		$UpdateArr['field']			=	array();

		     		$UpdateArr['field']['reply_num'] 	= 	$ReplyNumArr;
					$UpdateArr['field']['last_writer'] 		= 	$PowerBB->_CONF['member_row']['username'];
		     		$UpdateArr['field']['last_subject'] 		= 	$SubjectInfo['title'];
		     		$UpdateArr['field']['last_subjectid'] 	= 	$SubjectInfo['id'];
		     		$UpdateArr['field']['last_date'] 	= 	$PowerBB->_CONF['now'];
		     		$UpdateArr['field']['last_time'] 	= 	$PowerBB->_CONF['now'];
		     		$UpdateArr['field']['last_reply'] 	= 	$PowerBB->reply->id;
		     		$UpdateArr['field']['icon'] 	    = 	'look/images/icons/i1.gif';
		     		$UpdateArr['field']['last_berpage_nm']  = 	'0';

		     		$UpdateArr['where']					= 	array('id',$SectionFormInfo['id']);

		     		$UpdateSubjectNumber = $PowerBB->section->UpdateSection($UpdateArr);

		     		// Free memory
		     		unset($UpdateArr);

		     		//////////

		     		// Update section's cache
		     		$UpdateArr 				= 	array();
		     		$UpdateArr['parent'] 	= 	$SectionFormInfo['parent'];

		     		$update_cache = $PowerBB->section->UpdateSectionsCache($UpdateArr);

		     		unset($UpdateArr);
		     		//////////

		     }
            // INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $TopicMod['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	 $PowerBB->_CONF['template']['lang']['Agreed_reply_ID'] . $PowerBB->_GET['reply_id'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

				$PowerBB->functions->msg('تم تنفيذ الخاصية الإشرافية '.$subject_title.' بنجاح');
				$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);

	}

  	function _UnReviewReply()
	{
		global $PowerBB;

		$PowerBB->_GET['reply_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['reply_id'],'intval');
		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['reply_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}



			$SubjectArr = array();
			$SubjectArr['where'] 				= 	array();
			$SubjectArr['where'] 			= 	array('id',$PowerBB->_GET['subject_id']);
			$SubjectInfo = $PowerBB->subject->GetSubjectInfo($SubjectArr);

            $ReviewReply 					= 	array();
     		$ReviewReply['review_reply']	=	 $SubjectInfo['review_reply'] -1;
     		$ReviewReply['where'] 			= 	array('id',$PowerBB->_GET['subject_id']);

     		$UpdateReviewReply = $PowerBB->subject->UpdateReviewReply($ReviewReply);
     		if ($UpdateReviewReply)
			{

			$UpdateArr 				= 	array();
			$UpdateArr['field']		= 	array();

			$UpdateArr['field']['review_reply'] = '0';
			$UpdateArr['where'] 				= 	array('id',$PowerBB->_GET['reply_id']);

			$update = $PowerBB->reply->UpdateReply($UpdateArr);
        if ($PowerBB->_POST['stick'])
                {
                $UpdateArr = array();
                $UpdateArr['where'] = array('id',$this->SubjectInfo['id']);

                $update = $PowerBB->subject->StickSubject($UpdateArr);
                }

                if ($PowerBB->_POST['unstick'])
                {
                $UpdateArr = array();
                $UpdateArr['where'] = array('id',$this->SubjectInfo['id']);

                $update = $PowerBB->subject->UnstickSubject($UpdateArr);
                }

                if ($PowerBB->_POST['close'])
                    {
                    $PowerBB->_POST['reason']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason'],'sql');

                    $UpdateArr = array();
                    $UpdateArr['reason'] = $PowerBB->_POST['reason'];
                    $UpdateArr['where'] = array('id',$this->SubjectInfo['id']);

                    $update = $PowerBB->subject->CloseSubject($UpdateArr);
                       }
                    if ($PowerBB->_POST['unclose'])
                    {

                    $PowerBB->_POST['reason']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['reason'],'sql');

                    $UpdateArr = array();
                    $UpdateArr['reason'] = $PowerBB->_POST['reason'];
                    $UpdateArr['where'] = array('id',$this->SubjectInfo['id']);

                    $update = $PowerBB->subject->OpenSubject($UpdateArr);
                       }

                			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	 $PowerBB->_CONF['template']['lang']['Agreed_reply_ID'] . $PowerBB->_GET['reply_id'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Agreed_reply_successfully']);
				$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
			}

	}

	function __SubjectRepeat()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$PowerBB->template->assign('subject',$PowerBB->_GET['subject_id']);

		$PowerBB->template->display('subject_repeat_index');
	}

	function _SubjectRepeatStart()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');
    		$PowerBB->_POST['url']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['url'],'sql');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SubjectArr 			= 	array();
		$SubjectArr['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

		$Subject = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		if (!$Subject)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Requested_topic_does_not_exist']);
		}

		$SectionArr 			= 	array();
		$SectionArr['where'] 	= 	array('id',$Subject['section']);

		$Section = $PowerBB->section->GetSectionInfo($SectionArr);

		if (!isset($PowerBB->_POST['url']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
		}

		$UpdateArr 				= 	array();
		$UpdateArr['reason']	=	$PowerBB->_CONF['template']['lang']['repeated_Subject'];
		$UpdateArr['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

		$update = $PowerBB->subject->CloseSubject($UpdateArr);

		if ($update)
		{
     		$ReplyArr 			= 	array();
     		$ReplyArr['field'] 	= 	array();

     		$ReplyArr['field']['text'] 			= 	  $PowerBB->_CONF['template']['lang']['Duplicate_this_topic_see_the_original'] .'[url=' . $PowerBB->_POST['url'] . '] ' . $PowerBB->_CONF['template']['lang']['Here'] .' [/url]';
     		$ReplyArr['field']['writer'] 		= 	$PowerBB->_CONF['member_row']['username'];
     		$ReplyArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
     		$ReplyArr['field']['write_time'] 	= 	$PowerBB->_CONF['now'];
     		$ReplyArr['field']['section'] 		= 	$Subject['section'];
		    $ReplyArr['field']['icon'] 			= 	'look/images/icons/i1.gif';
     		$ReplyArr['get_id']					=	true;

     		$insert = $PowerBB->reply->InsertReply($ReplyArr);

     		if ($insert)
     		{
	   			$MemberArr 				= 	array();
	   			$MemberArr['field'] 	= 	array();

     			$MemberArr['field']['lastpost_time'] 	=	$PowerBB->_CONF['now'];
     			$MemberArr['where']						=	array('id',$PowerBB->_CONF['member_row']['id']);

   				$UpdateMember = $PowerBB->member->UpdateMember($MemberArr);

     			$TimeArr = array();

     			$TimeArr['write_time'] 	= 	$PowerBB->_CONF['now'];
     			$TimeArr['where']		=	array('id',$PowerBB->_GET['subject_id']);

     			$UpdateWriteTime = $PowerBB->subject->UpdateWriteTime($TimeArr);

     			$RepArr 					= 	array();
     			$RepArr['reply_number']		=	$Subject['reply_number'];
     			$RepArr['where'] 			= 	array('id',$PowerBB->_GET['subject_id']);

     			$UpdateReplyNumber = $PowerBB->subject->UpdateReplyNumber($RepArr);

              $Subject['title']   = 	$PowerBB->functions->CleanVariable($Subject['title'],'sql');
		     		if (!$PowerBB->_CONF['member_permission'])
					{
	                $writer = 	$PowerBB->_CONF['template']['lang']['Guestp'];
					}
			     	else
			     	{
		            $writer = 	$PowerBB->_CONF['member_row']['username'];
					}
		     		$UpdateLastArr = array();
		     		$UpdateLastArr['field']			=	array();

					$UpdateLastArr['field']['last_writer'] 		= 	$writer;
		     		$UpdateLastArr['field']['last_subject'] 	= 	$PowerBB->functions->CleanVariable($Subject['title'],'html');
		     		$UpdateLastArr['field']['last_subjectid'] 	= 	$Subject['id'];
		     		$UpdateLastArr['field']['last_date'] 	    = 	$PowerBB->_CONF['now'];
		     		$UpdateLastArr['field']['last_time'] 	    = 	$PowerBB->_CONF['now'];

		     		$UpdateLastArr['where'] 		            = 	array('id',$Section['id']);

		     		// Update Last subject's information
		     		$UpdateLast = $PowerBB->section->UpdateSection($UpdateLastArr);

		     		// Free memory
		     		unset($UpdateLastArr);

     			$UpdateSubjectNumber = $PowerBB->cache->UpdateReplyNumber(array('reply_num'	=>	$PowerBB->_CONF['info_row']['reply_number']));

     			$LastArr = array();

     			$LastArr['replier'] 	= 	$PowerBB->_CONF['member_row']['username'];
     			$LastArr['where']		=	array('id',$PowerBB->_GET['subject_id']);

     			$UpdateLastReplier = $PowerBB->subject->UpdateLastReplier($LastArr);

     			// Free memory
     			unset($LastArr);

     			$UpdateArr 					= 	array();
     			$UpdateArr['field']			=	array();

     			$UpdateArr['field']	['reply_num'] 	= 	$Section['reply_num'] + 1;
     			$UpdateArr['where']					= 	array('id',$Section['id']);

     			$UpdateSubjectNumber = $PowerBB->section->UpdateSection($UpdateArr);

     			// Free memory
     			unset($UpdateArr);

     						// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['repeated_Subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

				$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Updated_successfully']);
				$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
     		}
		}
	}

	function __UpStart()
	{
		global $PowerBB;

	  	$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SubjectArr = array();
		$SubjectArr['field'] = array();
		$SubjectArr['field']['write_time'] = time() - ( intval('-42') );

		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$Update = $PowerBB->subject->UpdateSubject($SubjectArr);

		if ($Update)
		{
						// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['topic_Up'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

            // Update Section Cache
			if ($action['reply_number'] == '0')
			{

				$writer = $action['writer'];
			}
			else
			{
			  $writer = $action['last_replier'];
			}

			// Update Last subject's information in Section Form
     		$UpdateLastFormSecArr = array();
     		$UpdateLastFormSecArr['field']			=	array();

			$UpdateLastFormSecArr['field']['last_writer'] 		= 	$writer;
     		$UpdateLastFormSecArr['field']['last_subject'] 		= 	$action['title'];
     		$UpdateLastFormSecArr['field']['last_subjectid'] 	= 	$PowerBB->_GET['subject_id'];
     		$UpdateLastFormSecArr['field']['last_date'] 	= 	$action['write_time'];
     		$UpdateLastFormSecArr['field']['last_time'] 	= 	$action['write_time'];
     		$UpdateLastFormSecArr['field']['icon'] 		    = 	$action['icon'];
		    $UpdateLastFormSecArr['field']['last_reply'] 	= 	0;
		    $UpdateLastFormSecArr['field']['last_berpage_nm']  = 	0;

     		$UpdateLastFormSecArr['where'] 		        = 	array('id',$action['section']);

     		// Update Last Form Sec subject's information
     		$UpdateLastFormSec = $PowerBB->section->UpdateSection($UpdateLastFormSecArr);

                // Get Section Info
				$SecArr 			= 	array();
				$SecArr['where'] 	= 	array('id',$action['section']);

				$this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

     		// Update section's cache
     		$UpdateArr 				= 	array();
     		$UpdateArr['parent'] 	= 	$this->SectionInfo['parent'];

     		$update_cache = $PowerBB->section->UpdateSectionsCache($UpdateArr);

     		unset($UpdateArr);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_Up_subject']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}

	function __DownStart()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SubjectArr = array();
		$SubjectArr['field'] = array();
		$SubjectArr['field']['write_time'] = time() - ( intval('420000000000000000000') );

		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$Update = $PowerBB->subject->UpdateSubject($SubjectArr);

		if ($Update)
		{
						// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['down_Subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

	    	$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_Down_subject']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}

	function __ReviewSubject()
	{
		global $PowerBB;

	  	$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SubjectArr = array();
		$SubjectArr['field'] = array();
		$SubjectArr['field']['review_subject'] = 1;

		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$Update = $PowerBB->subject->UpdateSubject($SubjectArr);

		if ($Update)
		{
			 // INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Subject_hide'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);
			  //
				$SecArr 			= 	array();
		        $SecArr['where'] 	= 	array('id',$action['section']);

		        $this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

    		// Update Section Cache

	           $UpdateSectionCache = $PowerBB->functions->UpdateSectionCache($this->SectionInfo['id']);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Subject_hide_successfully']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}
		function __UnReviewSubject()
	{
		global $PowerBB;

	  	$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SubjectArr = array();
		$SubjectArr['field'] = array();
		$SubjectArr['field']['review_subject'] = 0;

		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$Update = $PowerBB->subject->UpdateSubject($SubjectArr);

		if ($Update)
		{

					// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['approved_subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

			  //
	           $UpdateSectionCache6 = $PowerBB->functions->UpdateSectionCache($action['section']);


			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_approved_on_the_subject_successfully']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}



	function _SpecialStart()
	{
		global $PowerBB;

	  	$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SubjectArr = array();
		$SubjectArr['field'] = array();
		$SubjectArr['field']['special'] = 1;

		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$Update = $PowerBB->subject->UpdateSubject($SubjectArr);

		if ($Update)
		{

					// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['s_special'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

	    	$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['special_subject_successfully']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}

	function _NospecialStart()
	{
		global $PowerBB;

	  	$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SubjectArr = array();
		$SubjectArr['field'] = array();
		$SubjectArr['field']['special'] = 0;

		$SubjectArr['where'] = array('id',$PowerBB->_GET['subject_id']);

		$Update = $PowerBB->subject->UpdateSubject($SubjectArr);


		if ($Update)
		{
					// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['nospecial_subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_GET['subject_id'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

	    	$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['nospecial_subject_successfully']);
			$PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['subject_id']);
		}
	}

	function _MergeIndex()
	{
		global $PowerBB;

	  	$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');

	   if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}
      		$PowerBB->template->assign('subject',$PowerBB->_GET['subject_id']);

	     $PowerBB->template->display('subject_merge_index');

    }


	function _MergeStart()
	{
		global $PowerBB;

		$PowerBB->_GET['subject_id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['subject_id'],'intval');
    		$PowerBB->_POST['url']   = 	$PowerBB->functions->CleanVariable($PowerBB->_POST['url'],'sql');

		if (empty($PowerBB->_GET['subject_id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$SubjectArr 			= 	array();
		$SubjectArr['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

		$Subject = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		if (!$Subject)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Requested_topic_does_not_exist']);
		}

		if (!isset($PowerBB->_POST['url']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Please_fill_in_all_the_information']);
		}


        $PowerBB->_POST['url'] = str_replace($PowerBB->functions->GetForumAdress()."index.php?page=topic&show=1&id=","", $PowerBB->_POST['url'] );
        $PowerBB->_POST['url'] = str_replace($PowerBB->functions->GetForumAdress()."t","", $PowerBB->_POST['url'] );
        $urlhtml = ".html";
        $PowerBB->_POST['url'] = str_replace($urlhtml,'', $PowerBB->_POST['url'] );
		$PowerBB->_POST['url'] = $PowerBB->functions->CleanVariable($PowerBB->_POST['url'],'intval');

		$SubjecturlArr 			= 	array();
		$SubjecturlArr['where'] 	= 	array('id',$PowerBB->_POST['url']);

		$Subjecturl = $PowerBB->subject->GetSubjectInfo($SubjecturlArr);
       		$Subjecturl['text'] 	= 	$PowerBB->functions->CleanVariable($Subjecturl['text'],'sql');
      		$Subject['text'] 	= 	$PowerBB->functions->CleanVariable($Subject['text'],'sql');
      		$Subjecturl['text'] = str_replace("('",'("', $Subjecturl['text']);
      		$Subjecturl['text'] = str_replace("')",'")',$Subjecturl['text']);

      		$Subject['text'] = str_replace("('",'("', $Subject['text']);
      		$Subject['text'] = str_replace("')",'")', $Subject['text']);

		    $UpdateArr 					= 	array();
		    $UpdateArr['field'] 				= 	array();
		    $UpdateArr['field']['text'] 		= 	$Subjecturl['text']."\n".$Subject['text'];
			$UpdateArr['where'] 				= 	array('id',$PowerBB->_POST['url']);

			$update = $PowerBB->subject->UpdateSubject($UpdateArr);

		if ($update)
		{

     		// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',$PowerBB->_GET['subject_id']);

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Merge_topics'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_POST['url'];
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

	           $UpdateSectionCache6 = $PowerBB->functions->UpdateSectionCache($action['section']);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Has_been_Merge_topic_successfully']);
	        $PowerBB->functions->redirect('index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_POST['url']);
	}
 }
    //  Start forum tools menu

	function _ToolsThread()
	{
		global $PowerBB;

			if ($PowerBB->_POST['deletethread'])
			{
				$this->_deletethread();
			}
			elseif ($PowerBB->_POST['deletetype'] == 1)
			{
				$this->_Trashthreadstart();
			}
			elseif ($PowerBB->_POST['deletetype'] == 2)
			{
				$this->_deletethreadstart();
			}
			elseif ($PowerBB->_POST['undeletethread'])
			{
				$this->_undeletethread();
			}
			elseif ($PowerBB->_POST['openthread'])
			{
				$this->_openthread();
			}
			elseif ($PowerBB->_POST['closethread'])
			{
				$this->_closethread();
			}
			elseif ($PowerBB->_POST['approvethread'])
			{
				$this->_approvethread();
			}
			elseif ($PowerBB->_POST['unapprovethread'])
			{
				$this->_unapprovethread();
			}
			elseif ($PowerBB->_POST['stickthread'])
			{
				$this->_stickthread();
			}
			elseif ($PowerBB->_POST['unstickthread'])
			{
				$this->_unstickthread();
			}
			elseif ($PowerBB->_POST['movethread'])
			{
				$this->_movethread();
			}
			elseif ($PowerBB->_POST['movethreadstart'])
			{
				$this->_movethreadstart();
			}
		   elseif ($PowerBB->_POST['deletereplies'])
		   {
		    $this->_DeleteReplies();
		   }

	}


	function _deletethread()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}


	$PowerBB->template->assign('section',$PowerBB->_GET['section']);
	$PowerBB->template->display('subjects_delete_index');

	 $Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {
		$subjects =intval($GetThread);
		$PowerBB->template->assign('subjects',$subjects);
       $PowerBB->template->display('subjects_delete_index2');

		}

	}

	function _Trashthreadstart()
	{
		global $PowerBB;


		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		       $Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

       		      // start Update LastSubjec in Section

			        $GetSecArr 			= 	array();
					$GetSecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

					$this->GetSectionInfo = $PowerBB->section->GetSectionInfo($GetSecArr);
			      $subjects =intval($GetThread);

		     		//////////

	          	// INSERT moderators Action
				$EditAction				=	array();
			    $EditAction['where'] 	= 	array('id',$subjects);

				$action = $PowerBB->subject->GetSubjectInfo($EditAction);

			    $subject_title = $action['title'];
			    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

		        $SmLogsArr 			= 	array();
				$SmLogsArr['field']	=	array();

				$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
				$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Was_Trasht1'];
				$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
				$SmLogsArr['field']['subject_id'] 	= 	$PowerBB->_POST['subject'];
				$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

				$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);



    		// The number of section's subjects number
        $section = $PowerBB->_GET['section'];

            	// Get Section Form Info
     	$SecFormArr 			= 	array();
		$SecFormArr['where'] 	= 	array('id',$section);

		$SectionFormInfo = $PowerBB->section->GetSectionInfo($SecFormArr);
         $from_section = $PowerBB->_GET['section'];

		if ($SectionFormInfo['last_subjectid'] == $action['id'])
		{
			$GetLastSubject = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['subject'] . " WHERE section = '$from_section' ORDER by write_time DESC");
			$LastSubjectInfo = $PowerBB->DB->sql_fetch_array($GetLastSubject);

			$GetLastReply = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['reply'] . " WHERE section = '$from_section' ORDER by write_time DESC");
			$LastReplyInfo = $PowerBB->DB->sql_fetch_array($GetLastReply);

			if ($LastSubjectInfo['write_time']< $LastReplyInfo['write_time'])
			{
             $LastInfo = $PowerBB->DB->sql_fetch_array($GetLastReply);
             $last_subjectid = $LastInfo['subject_id'];
             $last_berpage_nm = $LastInfo['id'];
			}
			else
			{
              $LastInfo = $PowerBB->DB->sql_fetch_array($GetLastSubject);
              $last_subjectid = $LastInfo['id'];
              $last_berpage_nm = $LastInfo['reply_number'];
			}
			// Update Last subject's information in Section Form
     		$UpdateLastFormSecArr = array();
     		$UpdateLastFormSecArr['field']			=	array();

			$UpdateLastFormSecArr['field']['last_writer'] 		= 	$LastInfo['writer'];
     		$UpdateLastFormSecArr['field']['last_subject'] 		= 	$PowerBB->functions->CleanVariable($LastInfo['title'],'html');
     		$UpdateLastFormSecArr['field']['last_subjectid'] 	= 	$last_subjectid;
     		$UpdateLastFormSecArr['field']['last_date'] 	= 	$LastInfo['write_time'];
     		$UpdateLastFormSecArr['field']['last_time'] 	= 	$LastInfo['write_time'];
     		$UpdateLastFormSecArr['field']['icon'] 		    = 	$LastInfo['icon'];
		    $UpdateLastFormSecArr['field']['last_reply'] 	= 	0;
		    $UpdateLastFormSecArr['field']['last_berpage_nm']  = 	0;

     		$UpdateLastFormSecArr['where'] 		        = 	array('id',$from_section);

     		// Update Last To Sec subject's information
     		$UpdateLastFormSec = $PowerBB->section->UpdateSection($UpdateLastFormSecArr);

			if (!$last_subjectid)
			{
			// Update Last subject's information in Section Form
     		$UpdateLastFormSecArr = array();
     		$UpdateLastFormSecArr['field']			=	array();

     		$UpdateLastFormSecArr['field']['last_subject'] 		= 	'';

     		$UpdateLastFormSecArr['where'] 		        = 	array('id',$from_section);
			}

		 }


		$UpdateArr 			= array();
		$UpdateArr['where'] = array('id',$subjects);

		$update = $PowerBB->subject->MoveSubjectToTrash($UpdateArr);


                // Get Section Info
				$SecArr 			= 	array();
				$SecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

				$this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

                $update_cache = $PowerBB->section->UpdateSectionsCache($UpdateArr);

                $cache = $PowerBB->section->UpdateSectionsCache(array('parent'=>$this->SectionInfo['parent']));



				$cache = $PowerBB->section->UpdateSectionsCache(array('parent'=>$SectionInfo['parent']));
				$Update = $PowerBB->section->UpdateAllSectionsCache();
	           $UpdateSectionCache6 = $PowerBB->functions->UpdateSectionCache($SectionInfo['id']);


       }



            $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Was_Trasht']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);

	}

	function _deletethreadstart()
	{
		global $PowerBB;

		if ($PowerBB->_CONF['group_info']['group_mod'] == '1')
		{
			if ($PowerBB->_CONF['group_info']['del_subject'] == '0')
			{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['error_permission']);
			}
		}

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		       $Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

       		      // start Update LastSubjec in Section

			        $GetSecArr 			= 	array();
					$GetSecArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

					$this->GetSectionInfo = $PowerBB->section->GetSectionInfo($GetSecArr);
			      $subjects =intval($GetThread);

		     		//////////

		         // INSERT moderators Action
				$EditAction				=	array();
			    $EditAction['where'] 	= 	array('id',intval($GetThread));

				$action = $PowerBB->subject->GetSubjectInfo($EditAction);

			    $subject_title = intval($action['title']);
			    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

		        $SmLogsArr 			= 	array();
				$SmLogsArr['field']	=	array();

				$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
				$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Was_rely_delet_subject'];
				$SmLogsArr['field']['subject_title']= 	$PowerBB->_CONF['template']['lang']['Numo_Subject'] .intval($GetThread);
				$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
				$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

				$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);





    		// The number of section's subjects number
        $section = $PowerBB->_GET['section'];

            	// Get Section Form Info
     	$SecFormArr 			= 	array();
		$SecFormArr['where'] 	= 	array('id',$section);

		$SectionFormInfo = $PowerBB->section->GetSectionInfo($SecFormArr);
         $from_section = $PowerBB->_GET['section'];

		     $DelAttachArr				=	array();
	         $DelAttachArr['where'] 	= 	array('subject_id',intval($GetThread));

			  $DeleteAttach = $PowerBB->attach->DeleteAttach($DelAttachArr);

             $subjectInfoid =  intval($GetThread);
             $getTags_query = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['tag_subject'] . " WHERE subject_id = '$subjectInfoid'");
               while ($getTags_row = $PowerBB->DB->sql_fetch_array($getTags_query))
                 {
					  $DeleteTagArr				=	array();
			          $DeleteTagArr['where'] 	= 	array('id',$getTags_row['tag_id']);
					  $delTags = $PowerBB->tag->DeleteTag($DeleteTagArr);
                 }


			  $DeleteSubjectArr				=	array();
	          $DeleteSubjectArr['where'] 	= 	array('subject_id',intval($GetThread));
			  $delSubject = $PowerBB->tag_subject->DeleteSubject($DeleteSubjectArr);

			     $DelAttachArr				=	array();
		         $DelAttachArr['where'] 	= 	array('subject_id',intval($GetThread));

				  $DeleteAttach = $PowerBB->attach->DeleteAttach($DelAttachArr);

				  $DeleteSubjectArr				=	array();
		          $DeleteSubjectArr['where'] 	= 	array('subject_id',intval($GetThread));
				  $delSubject = $PowerBB->tag_subject->DeleteSubject($DeleteSubjectArr);

		     $DelReplyArr				=	array();
	         $DelReplyArr['where'] 	= 	array('subject_id',intval($GetThread));

			  $delReply = $PowerBB->reply->DeleteReply($DelReplyArr);


				$DelArr				=	array();
				$DelArr['where'] 	= 	array('id',intval($GetThread));

                 $del = $PowerBB->subject->DeleteSubject($DelArr);

        $UpdateSectionCache1 = $PowerBB->functions->UpdateSectionCache($PowerBB->_GET['section']);

       }



            $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['deleted_topics_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);

	}


	function _undeletethread()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		$Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

		$Trash['where']				=	array('id',intval($GetThread));

		$UnTrash = $PowerBB->subject->UnTrashSubject($Trash);

       $UpdateSectionCache2 = $PowerBB->functions->UpdateSectionCache($action['section']);


		    // INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',intval($GetThread));

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['restore_Deleted_Subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->_CONF['template']['lang']['Numo_Subject'] .intval($GetThread);
			$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);
        	$UpdateSectionCache6 = $PowerBB->functions->UpdateSectionCache($action['section']);


		}

		if ($insert)
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['restore_topics_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);
		}

	}

	function _openthread()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		$Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

        $UpdateArr 			= array();
		$UpdateArr['where'] = array('id',intval($GetThread));

		$update = $PowerBB->subject->OpenSubject($UpdateArr);

       	// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',intval($GetThread));

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Subject_open'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);
         }
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['open_topics_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);


	}

	function _closethread()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		$Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

		$UpdateArr 				= 	array();
		$UpdateArr['where'] 	= 	array('id',intval($GetThread));

		$update = $PowerBB->subject->CloseSubject($UpdateArr);



			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',intval($GetThread));

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Closing_Subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);
          }

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Closing_topics_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);


	}

	function _approvethread()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		$Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

		$SubjectArr = array();
		$SubjectArr['field'] = array();
		$SubjectArr['field']['review_subject'] = 0;

		$SubjectArr['where'] = array('id',intval($GetThread));

		$Update = $PowerBB->subject->UpdateSubject($SubjectArr);



			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',intval($GetThread));

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['approved_subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);
          }

        	$UpdateSectionCache6 = $PowerBB->functions->UpdateSectionCache($action['section']);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['approved_subjects_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);


	}

	function _unapprovethread()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		$Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

		$SubjectArr = array();
		$SubjectArr['field'] = array();
		$SubjectArr['field']['review_subject'] = 1;

		$SubjectArr['where'] = array('id',intval($GetThread));

		$Update = $PowerBB->subject->UpdateSubject($SubjectArr);



			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',intval($GetThread));

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Subject_hide'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);
          }
          $UpdateSectionCache6 = $PowerBB->functions->UpdateSectionCache($action['section']);

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['hide_subjects_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);


	}

	function _stickthread()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		$Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

		$UpdateArr 			= array();
		$UpdateArr['where'] = array('id',intval($GetThread));

		$update = $PowerBB->subject->StickSubject($UpdateArr);



			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',intval($GetThread));

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['Sticky_Topic'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);
          }

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Stick_subjects_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);


	}

	function _unstickthread()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {

		$UpdateArr 			= array();
		$UpdateArr['where'] = array('id',intval($GetThread));

		$update = $PowerBB->subject->UnstickSubject($UpdateArr);



			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',intval($GetThread));

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['unstick_Subject'];
			$SmLogsArr['field']['subject_title']= 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);
          }

			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['unstick_subjects_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_GET['section']);


	}

	function _movethread()
	{
		global $PowerBB;


		if (empty($PowerBB->_POST['check'])
			or empty($PowerBB->_GET['section']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}


		$SecArr 						= 	array();
		$SecArr['get_from']				=	'db';

		$SecArr['proc'] 				= 	array();
		$SecArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$SecArr['order']				=	array();
		$SecArr['order']['field']		=	'sort';
		$SecArr['order']['type']		=	'ASC';

		$SecArr['where']				=	array();
		$SecArr['where'][0]['name']		= 	'parent';
		$SecArr['where'][0]['oper']		= 	'=';
		$SecArr['where'][0]['value']	= 	'0';

		// Get main sections
		$cats = $PowerBB->section->GetSectionsList($SecArr);

		// We will use forums_list to store list of forums which will view in main page
		$PowerBB->_CONF['template']['foreach']['forums_list'] = array();

		// Loop to read the information of main sections
		foreach ($cats as $cat)
		{
			// Get the groups information to know view this section or not
			$groups = unserialize(base64_decode($cat['sectiongroup_cache']));

			if (is_array($groups[$PowerBB->_CONF['group_info']['id']]))
			{
				if ($groups[$PowerBB->_CONF['group_info']['id']]['view_section'])
				{
					$PowerBB->_CONF['template']['foreach']['forums_list'][$cat['id'] . '_m'] = $cat;
				}
			}

			unset($groups);

			if (!empty($cat['forums_cache']))
			{
				$forums = unserialize(base64_decode($cat['forums_cache']));

				foreach ($forums as $forum)
				{
					if (is_array($forum['groups'][$PowerBB->_CONF['group_info']['id']]))
					{
						if ($forum['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
						{
							//////////

							// Get the first-level sub forums as a _link_ and store it in $forum['sub']

							$forum['is_sub'] 	= 	0;
							$forum['sub']		=	'';

							if (!empty($forum['forums_cache']))
							{
								$subs = unserialize(base64_decode($forum['forums_cache']));

								if (is_array($subs))
								{
									foreach ($subs as $sub)
									{
										if (is_array($sub['groups'][$PowerBB->_CONF['group_info']['id']]))
										{
											if ($sub['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
											{
												if (!$forum['is_sub'])
												{
													$forum['is_sub'] = 1;
												}

												$forum['sub'] .= ('<option value="' .$sub['id'] . '" selected="selected">--- '  . $sub['title'] . '</option>');
											}
										}

						                       if (!empty($sub['forums_cache']))
												  {
													$forum['is_sub_sub'] 	= 	0;
													$forum['sub_sub']		=	'';
													$subs_sub = unserialize(base64_decode($sub['forums_cache']));

													if (is_array($subs_sub))
													{
														foreach ($subs_sub as $sub_sub)
														{
															if (is_array($sub_sub['groups'][$PowerBB->_CONF['group_info']['id']]))
															{
																if ($sub_sub['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
																{
																	if (!$forum['is_sub_sub'])
																	{
																		$forum['is_sub_sub'] = 1;
																	}

																	$forum['sub_sub'] .= ('<option value="' .$sub_sub['id'] . '" selected="selected">---- '  . $sub_sub['title'] . '</option>');
																}
															}
														}
													}
												  }
									}
								}
							}


							$PowerBB->_CONF['template']['foreach']['forums_list'][$forum['id'] . '_f'] = $forum;
						}
					} // end if is_array
				} // end foreach ($forums)
			} // end !empty($forums_cache)
		} // end foreach ($cats)

		//////////

		$PowerBB->template->assign('section',$PowerBB->_GET['section']);
		$PowerBB->template->display('subjects_move_index');

	 $Thread_D = $PowerBB->_POST['check'];

       foreach ($Thread_D as $GetThread)
       {
		$subjects =intval($GetThread);
		$PowerBB->template->assign('subjects',$subjects);
       $PowerBB->template->display('subjects_move_index2');
		}

	}

	function _movethreadstart()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['check']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['You_do_not_select_any_subject']);
		}

		$Thread_D = $PowerBB->_POST['check'];
       foreach ($Thread_D as $GetThread)
       {

      	$subject_id = intval($GetThread);

		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_POST['section']);

		$this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);


			// INSERT moderators Action
			$EditAction				=	array();
		    $EditAction['where'] 	= 	array('id',intval($GetThread));

			$action = $PowerBB->subject->GetSubjectInfo($EditAction);

            $SectionInf = ('<a target="_blank" href="index.php?page=forum&show=1&id=' . $this->SectionInfo['id'] . '">' .$this->SectionInfo['title'] .'</a>');
		    $subject_title = $action['title'];
		    $time=time()+$PowerBB->_CONF['info_row']['timestamp'];

	        $SmLogsArr 			= 	array();
			$SmLogsArr['field']	=	array();

			$SmLogsArr['field']['username'] 	= 	$PowerBB->_CONF['member_row']['username'];
			$SmLogsArr['field']['edit_action'] 	= 	$PowerBB->_CONF['template']['lang']['mov_Subject_to'] . $SectionInf;
			$SmLogsArr['field']['subject_title'] = 	$PowerBB->functions->CleanVariable($subject_title,'sql');
			$SmLogsArr['field']['subject_id'] 	= 	intval($GetThread);
			$SmLogsArr['field']['edit_date'] 	= 	date("d/m/Y", $time);

			$insert = $PowerBB->supermemberlogs->InsertSupermemberlogs($SmLogsArr);

			      // start Update LastSubjec in Section
			      $subjects =intval($GetThread);
			// End Update Last Subjec in Section from
		$SecidArr 			= 	array();
		$SecidArr['where'] 	= 	array('id',$PowerBB->_GET['section']);

		$this->id_section = $PowerBB->section->GetSectionInfo($SecidArr);

        $id_section = $PowerBB->_GET['section'];


			$UpdateArr 					= 	array();
			$UpdateArr['section_id']	=	$PowerBB->_POST['section'];
			$UpdateArr['where'] 		= 	array('id',intval($GetThread));

			$update = $PowerBB->subject->MoveSubject($UpdateArr);

	        $Move_replys = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['reply'] . " WHERE subject_id = '$subject_id' ");
	         while ($Moved = $PowerBB->DB->sql_fetch_array($Move_replys))
		         {
						$UpdateArr 				= 	array();
						$UpdateArr['field']		= 	array();

						$UpdateArr['field']['section'] 		= 	$PowerBB->_POST['section'];
						$UpdateArr['where'] 				= 	array('id',$Moved['id']);

						$update = $PowerBB->reply->UpdateReply($UpdateArr);

		         }
       }

          $UpdateSectionCache1 = $PowerBB->functions->UpdateSectionCache($PowerBB->_GET['section']);
          $UpdateSectionCache2 = $PowerBB->functions->UpdateSectionCache($PowerBB->_POST['section']);

            $PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['mov_subjects_successfully']);
			$PowerBB->functions->redirect('index.php?page=forum&show=1&id=' . $PowerBB->_POST['section']);


	}


}
?>
