<?php

(!defined('IN_PowerBB')) ? die() : '';

$CALL_SYSTEM				=	array();
$CALL_SYSTEM['MISC'] 		= 	true;
$CALL_SYSTEM['SUBJECT'] 	= 	true;
$CALL_SYSTEM['REPLY'] 		= 	true;
$CALL_SYSTEM['SECTION'] 	= 	true;

include('common.php');

define('CLASS_NAME','PowerBBStaticMOD');

class PowerBBStaticMOD
{
	function run()
	{
		global $PowerBB;

 		if (!$PowerBB->_CONF['info_row']['active_static'])
		{
		exit;
        }

		$this->_GetJumpSectionsList();

		if ($PowerBB->_GET['index'])
		{
			$this->_ShowStatic();
		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$PowerBB->functions->GetFooter();
	}

	function _ShowStatic()
	{
		global $PowerBB;

		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['statics']);

		$StaticInfo = array();

		/**
		 * Get the age of forums and install date
		 */
		$StaticInfo['Age'] 			= 	$PowerBB->misc->GetForumAge(array('date'=>$PowerBB->_CONF['info_row']['create_date']));
		$StaticInfo['InstallDate']	=	$PowerBB->functions->date($PowerBB->_CONF['info_row']['create_date']);

		/**
		 * Get the number of members , subjects , replies , active members and sections
		 */
		$SecArr 						= 	array();
		$SecArr['where'] 				= 	array();
		$SecArr['where'][0] 			= 	array();
		$SecArr['where'][0]['name'] 	= 	'parent';
		$SecArr['where'][0]['oper'] 	= 	'<>';
		$SecArr['where'][0]['value'] 	= 	'0';

		$SubjectNumber              = array();
		$SubjectNumber['get_from']  = 'db';
		$SubjectNumber['where']     = array('delete_topic',0);

		$StaticInfo['GetSubjectNumber'] = $PowerBB->subject->GetSubjectNumber($SubjectNumber);

		$ReplyNumber              = array();
		$ReplyNumber['get_from']  = 'db';
		$ReplyNumber['where']     = array('delete_topic',0);

		$StaticInfo['GetReplyNumber'] = $PowerBB->reply->GetReplyNumber($ReplyNumber);

		// Get Member Number
        $arr                   = array();
		$arr['get_from']       = 'db';

		$mn = $PowerBB->member->GetMemberNumber($arr);

		$StaticInfo['GetMemberNumber']	= $mn;
		$StaticInfo['GetActiveMember']	= $PowerBB->member->GetActiveMemberNumber();
		$StaticInfo['GetSectionNumber']	= $PowerBB->section->GetSectionNumber($SecArr);

		/**
		 * Get the writer of oldest subject , the most subject of riplies and the newer subject
		 * should be in cache
		 */
		$OldestArr 						= 	array();
		$OldestArr['order'] 			= 	array();
		$OldestArr['order']['field'] 	= 	'id';
		$OldestArr['order']['type'] 	= 	'ASC';
		$OldestArr['limit'] 			= 	'1';

		$GetOldest = $PowerBB->subject->GetSubjectInfo($OldestArr);
		$StaticInfo['OldestSubjectWriter'] = $GetOldest['writer'];

		$NewerArr 						= 	array();
		$NewerArr['order'] 				= 	array();
		$NewerArr['order']['field'] 	= 	'id';
		$NewerArr['order']['type'] 		= 	'DESC';
		$NewerArr['limit'] 				= 	'1';

		$GetNewer = $PowerBB->subject->GetSubjectInfo($NewerArr);
		$StaticInfo['NewerSubjectWriter'] = $GetNewer['writer'];

		$MostVisitArr 						= 	array();
		$MostVisitArr['order'] 			= 	array();
		$MostVisitArr['order']['field'] 	= 	'visitor';
		$MostVisitArr['order']['type'] 	= 	'DESC';
		$MostVisitArr['limit'] 			= 	'1';

		$GetMostVisit = $PowerBB->subject->GetSubjectInfo($MostVisitArr);
		$StaticInfo['MostSubjectWriter'] = $GetMostVisit['writer'];

		$PowerBB->functions->CleanVariable($StaticInfo,'html');

		$PowerBB->template->assign('StaticInfo',$StaticInfo);

		/**
		 * Get top ten list of member who have big posts
		 */
		$TopTenArr 						= 	array();

		// Order data
		$TopTenArr['order'] 			= 	array();
		$TopTenArr['order']['field'] 	= 	'posts';
		$TopTenArr['order']['type'] 	= 	'DESC';

		// Ten rows only
		$TopTenArr['limit']				=	'10';

		// Clean data
		$TopTenArr['proc'] 				= 	array();
		$TopTenArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['TopTenList'] = $PowerBB->member->GetMemberList($TopTenArr);

		/**
		 * Get top ten list of subjects which have big replies
		 */
		$TopSubjectArr 						= 	array();

		// Order data
		$TopSubjectArr['order'] 			= 	array();
		$TopSubjectArr['order']['field'] 	= 	'reply_number';
		$TopSubjectArr['order']['type'] 	= 	'DESC';

		// Ten rows only
		$TopSubjectArr['limit']					=	'10';

		// Clean data
		$TopSubjectArr['proc'] 				= 	array();
		$TopSubjectArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['TopSubject'] = $PowerBB->subject->GetSubjectList($TopSubjectArr);

		/**
		 * Get top ten list of subjects which have big visitors
		 */
		$TopSubjectVisitorArr 							= 	array();

		// Order data
		$TopSubjectVisitorArr['order'] 				= 	array();
		$TopSubjectVisitorArr['order']['field'] 	= 	'visitor';
		$TopSubjectVisitorArr['order']['type'] 		= 	'DESC';

		// Ten rows only
		$TopSubjectVisitorArr['limit']				=	'10';

		// Clean data
		$TopSubjectVisitorArr['proc'] 				= 	array();
		$TopSubjectVisitorArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['TopSubjectVisitor'] = $PowerBB->subject->GetSubjectList($TopSubjectVisitorArr);

		$PowerBB->template->display('static');


	}

	    /**
	 * Get the Jump Sections List
	 */
	function _GetJumpSectionsList()
    {
		global $PowerBB;

		//////////

		$SecArr 						= 	array();
		$SecArr['get_from']				=	'db';

		$SecArr['proc'] 				= 	array();
		$SecArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$SecArr['order']				=	array();
		$SecArr['order']['field']		=	'sort';
		$SecArr['order']['type']		=	'ASC';

		$SecArr['where']				=	array();
		$SecArr['where'][0]['name']		= 	'parent';
		$SecArr['where'][0]['oper']		= 	'=';
		$SecArr['where'][0]['value']	= 	'0';

		// Get main sections
		$catsy = $PowerBB->section->GetSectionsList($SecArr);

		// We will use forumsy_list to store list of forums which will view in main page
		$PowerBB->_CONF['template']['foreach']['forumsy_list'] = array();

		// Loop to read the information of main sections
		foreach ($catsy as $caty)
		{
			// Get the groups information to know view this section or not
			$groups = unserialize(base64_decode($caty['sectiongroup_cache']));

			if (is_array($groups[$PowerBB->_CONF['group_info']['id']]))
			{
				if ($groups[$PowerBB->_CONF['group_info']['id']]['view_section'])
				{
					$PowerBB->_CONF['template']['foreach']['forumsy_list'][$caty['id'] . '_m'] = $caty;
			if (!empty($caty['forums_cache']))
					{
						$forumsy = unserialize(base64_decode($caty['forums_cache']));

						foreach ($forumsy as $forumy)
						{
							if (is_array($forumy['groups'][$PowerBB->_CONF['group_info']['id']]))
							{
								if ($forumy['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
								{
									//////////

									// Get the first-level sub forums as a _link_ and store it in $forumy['sub']

									$forumy['is_sub'] 	= 	0;
									$forumy['sub']		=	'';

									if (!empty($forumy['forums_cache']))
									{
										$subsy = unserialize(base64_decode($forumy['forums_cache']));

										if (is_array($subsy))
										{
											foreach ($subsy as $suby)
											{
												if (is_array($suby['groups'][$PowerBB->_CONF['group_info']['id']]))
												{
													if ($suby['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
													{
														if (!$forumy['is_sub'])
														{
															$forumy['is_sub'] = 1;
														}

														$forumy['sub'] .= ('<option value="index.php?page=forum&amp;show=1&amp;id=' . $suby['id'] . '">---'  . $suby['title'] . '</option>');
													}
												}
											}
										}
									}


									$PowerBB->_CONF['template']['foreach']['forumsy_list'][$forumy['id'] . '_f'] = $forumy;
								}
							} // end if is_array
						} // end foreach ($forumsy)
					} // end !empty($forums_cache)
				}
			}

			unset($groups);


		} // end foreach ($catsy)

		//////////
   }
}

?>
