<?php
session_start();
(!defined('IN_PowerBB')) ? die() : '';
include('common.php');
define('CLASS_NAME','PowerBBTopicMOD');
class PowerBBTopicMOD
{
	var $Info;
	var $SectionInfo;
	var $SectionGroup;
	var $RInfo;
	var $x = 0;
	var $foreach_array;

	/**
	 * The main function , will require from kernel file "index.php"
	 */
	function run()
	{
		global $PowerBB;
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		$this->_GetJumpSectionsList();

		$PowerBB->functions->ShowHeader();
		// Show the topic
		if ($PowerBB->_GET['show'])
		{
			$this->_ShowTopic();
		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		// Can live without footer :) ?
		$PowerBB->functions->GetFooter();
	}



	function _ShowTopic()
	{
		global $PowerBB;

				// Check about everything
				$this->__CheckSystem();

				// Get subject information
				$this->__GetSubject();

				// Get subject's writer information
				$this->__GetWriterInfo();

				// Make subject text as a nice text
				$this->__SubjectTextFormat();

				// Show subject
				$this->__SubjectEnd();

				// Get the replies
				$this->__GetReply();

				// The Next subject And previous

				if ($PowerBB->_CONF['info_row']['samesubject_show'])
				{
					$this->__SameTopics();
				}


				// The End of page
				$this->__PageEnd();


	}

	function __CheckSystem()
	{
		global $PowerBB;
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		 // If time out For Editing Disable View Icon Edite
		$SubjectArr = array();
		$SubjectArr['where'] = array('id',$PowerBB->_GET['id']);

		$PowerBB->_CONF['template']['SubjectInfo'] = $PowerBB->subject->GetSubjectInfo($SubjectArr);

		// There is no subject, so show error message
		if (!$PowerBB->subject->GetSubjectInfo($SubjectArr))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Sorry_requested_topic_does_not_exist']);
		}

    	//$PowerBB->_CONF['template']['SubjectInfo']['title'] 				= 	$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo']['title'],'html');
    	//$PowerBB->_CONF['template']['SubjectInfo']['title'] 				= 	$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo']['title'],'sql');

		/** Get the section information **/
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_CONF['template']['SubjectInfo']['section']);

		$this->SectionInfo = $PowerBB->section->GetSectionInfo($SecArr);

		// Kill XSS
		$PowerBB->functions->CleanVariable($this->SectionInfo,'html');
		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo'],'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo'],'sql');
		$PowerBB->functions->CleanVariable($this->SectionInfo,'sql');
		/** **/
		/** Get section's group information and make some checks **/
		$SecGroupArr 						= 	array();
		$SecGroupArr['where'] 				= 	array();
		$SecGroupArr['where'][0]			=	array();
		$SecGroupArr['where'][0]['name'] 	= 	'section_id';
		$SecGroupArr['where'][0]['value'] 	= 	$this->SectionInfo['id'];
		$SecGroupArr['where'][1]			=	array();
		$SecGroupArr['where'][1]['con']		=	'AND';
		$SecGroupArr['where'][1]['name']	=	'group_id';
		$SecGroupArr['where'][1]['value']	=	$PowerBB->_CONF['group_info']['id'];

		// get the permissions of group
		$this->SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);

		// Get the subject and the subject's writer information
		$this->Info = $PowerBB->subject->GetSubjectWriterInfo(array('id'	=>	$PowerBB->_GET['id']));
       	if (!$this->Info)
		{
           if ($this->SectionGroup['write_subject'])
           {
		    $this->Info = $PowerBB->subject->GetSubjectGuestInfo(array('id'	=>	$PowerBB->_GET['id']));
		   }
		}

		// Kill XSS
		$PowerBB->functions->CleanVariable($this->Info,'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->Info,'sql');

		//////////




		// Moderator Check
		$Mod = $PowerBB->functions->ModeratorCheck($PowerBB->_GET['id']);


		// The visitor can't show this section , so stop the page
		if ($this->SectionGroup['view_section'] == '0')
		{
          if (!$PowerBB->_CONF['member_permission'])
              {
              $PowerBB->template->display('login');
              $PowerBB->functions->error_stop();
			}
	        else
	        {
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Sorry_you_can_not_see_on_this_topic']);
	        }

		}
		if ($this->SectionGroup['view_subject'] == '0')
		{
          if (!$PowerBB->_CONF['member_permission'])
              {
              $PowerBB->template->display('login');
              $PowerBB->functions->error_stop();
			}
	        else
	        {
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['can_not_view_this_subject']);
	        }
		}
		/** **/

      /*
		// We have password in the subject's section , so check the password
		if (!empty($this->SectionInfo['section_password'])
			and !$PowerBB->_CONF['rows']['group_info']['admincp_allow'])
		{
			// The visitor don't give me password , so require it
     		if (empty($PowerBB->_GET['password']))
        	{
      			$PowerBB->template->display('forum_password');
      			$PowerBB->functions->stop();
     		}
     		// The visitor give me password , so check
     		elseif (!empty($PowerBB->_GET['password']))
     		{
     			$PassArr = array();

     			// Section id
     			$PassArr['id'] 		= $this->SectionInfo['id'];

     			// The password to check
     			$PassArr['password'] 	= base64_decode($PowerBB->_GET['password']);

     			$IsTruePassword = $PowerBB->section->CheckPassword($PassArr);

     			// Stop ! it's don't true password
     			if (!$IsTruePassword)
     			{
     				$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['PasswordIsnotTrue']);
     			}

     			$PowerBB->_CONF['template']['password'] = '&amp;password=' . $PowerBB->_GET['password'];
     		}
     	}
       */

     	$PowerBB->_CONF['template']['password'] = '&amp;password=' . base64_encode($this->SectionInfo['section_password']);

		$TagArr 			= 	array();
		$TagArr['where'] 	= 	array('subject_id',$PowerBB->_GET['id']);

		$PowerBB->_CONF['template']['while']['tags'] = $PowerBB->tag->GetSubjectList($TagArr);
		if (is_array($PowerBB->_CONF['template']['while']['tags'])
			and sizeof($PowerBB->_CONF['template']['while']['tags']) > 0)
		{
			$PowerBB->template->assign('STOP_TAGS_TEMPLATE',false);
		}
		else
		{
			$PowerBB->template->assign('STOP_TAGS_TEMPLATE',true);
		}

		// Clean id from any string, that will protect us
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		// If the id is empty, so stop the page
		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		if ($PowerBB->_CONF['group_info']['view_subject'] == 0)
		{
          if (!$PowerBB->_CONF['member_permission'])
              {
              $PowerBB->template->display('login');
              $PowerBB->functions->error_stop();
			}
	        else
	        {
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['can_not_view_this_subject']);
	        }
		}


       		// if section Allw hide subject can't show this subject  , so stop the page
   		if ($this->SectionInfo['hide_subject']
   		and !$PowerBB->_CONF['group_info']['admincp_allow'])
   		{

	   		if ($PowerBB->_CONF['member_row']['username'] != $PowerBB->_CONF['template']['SubjectInfo']['writer'])
	   		{
	        $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Sorry_you_can_not_see_on_this_topic']);
	        }
        }

        if ($PowerBB->_CONF['template']['SubjectInfo']['review_subject']
   		and !$PowerBB->functions->ModeratorCheck($PowerBB->_CONF['template']['SubjectInfo']['section']))
   		{

	   		if ($PowerBB->_CONF['member_row']['username'] != $PowerBB->_CONF['template']['SubjectInfo']['writer'])
	   		{
	        $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Sorry_you_can_not_see_on_this_topic']);
	        }
        }

		//////////

		// hmmmmmmm , this subject deleted , so the members and visitor can't show it
		if ($PowerBB->_CONF['template']['SubjectInfo']['delete_topic']
			and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Subject_Was_Trasht']);
		}

		//////////
		// Where is the member now?
		if ($PowerBB->_CONF['member_permission'])
     	{
     		$UpdateOnline 			= 	array();
			$UpdateOnline['field']	=	array();

			$UpdateOnline['field']['user_location'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_topic'].' <a href="index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['id'] . '">' . $PowerBB->_CONF['template']['SubjectInfo']['title'] . '</a>';
			$UpdateOnline['field']['section_id'] 	    =  $PowerBB->_CONF['template']['SubjectInfo']['section'];
			$UpdateOnline['field']['subject_id'] 	    =  $PowerBB->_GET['id'];
			$UpdateOnline['where']						=	array('username',$PowerBB->_CONF['member_row']['username']);

			$update = $PowerBB->online->UpdateOnline($UpdateOnline);
     	}

     	// Where is the Visitor now?
		if (!$PowerBB->_CONF['member_permission'])
     	{
     		$UpdateOnline 			= 	array();
			$UpdateOnline['field']	=	array();

			$UpdateOnline['field']['user_location'] 	= 	$PowerBB->_CONF['template']['lang']['Seen_the_topic'].' <a href="index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['id'] . '">' . $PowerBB->_CONF['template']['SubjectInfo']['title'] . '</a>';
			$UpdateOnline['field']['section_id'] 	    =  $PowerBB->_CONF['template']['SubjectInfo']['section'];
			$UpdateOnline['field']['subject_id'] 	    =  $PowerBB->_GET['id'];
			$UpdateOnline['where']						=	array('user_ip',$PowerBB->_CONF['ip']);

			$update = $PowerBB->online->UpdateOnline($UpdateOnline);
     	}



        $time_out = $PowerBB->_CONF['info_row']['time_out']*60;

        if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['SubjectInfo']['write_time']+$time_out != false)
        {
              $PowerBB->template->assign('timeout',false);
		}
		else
		{
			$PowerBB->template->assign('timeout',true);
		}

		 // Moderator And admin Check for View the Icons Editing and Deletion
		$ModArr 			= 	array();
		$ModArr['where'] 	= 	array('section_id',$this->SectionInfo['id']);

		$ModeratorInfo = $PowerBB->moderator->GetModeratorInfo($ModArr);

        // show Adsense List
		$AdsenseArr 					= 	array();
		$AdsenseArr['order']			=	array();
		$AdsenseArr['order']['field']	=	'id';
		$AdsenseArr['order']['type']	=	'DESC';
		$AdsenseArr['proc'] 			= 	array();
		$AdsenseArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');
		// Where setup
		$AdsenseArr['where'][0]				=	array();
		$AdsenseArr['where'][0]['con']		=	'AND';
		$AdsenseArr['where'][0]['name']		=	'topic';
		$AdsenseArr['where'][0]['oper']		=	'=';
		$AdsenseArr['where'][0]['value']		=	'1';

		$PowerBB->_CONF['template']['while']['AdsensesList'] = $PowerBB->adsense->GetAdsenseList($AdsenseArr);
		if (is_array($PowerBB->_CONF['template']['while']['AdsensesList'])
			and sizeof($PowerBB->_CONF['template']['while']['AdsensesList']) > 0)
		{
			$PowerBB->template->assign('STOP_ADSENSES_TEMPLATE',false);
		}
		else
		{
			$PowerBB->template->assign('STOP_ADSENSES_TEMPLATE',true);
		}


		// assigns
		$PowerBB->template->assign('section_info',$this->SectionInfo);
		$PowerBB->template->assign('section_group',$this->SectionGroup);
		$PowerBB->template->assign('Mod',$Mod);
		$PowerBB->template->assign('subject_id',$PowerBB->_GET['id']);
		$PowerBB->template->assign('section_id',$PowerBB->_CONF['template']['SubjectInfo']['section']);
		$PowerBB->template->assign('SectionGroup',$this->SectionGroup);
       	$PowerBB->template->assign('show_sig',$this->SectionInfo['show_sig']);
        $PowerBB->template->assign('count_peg',$PowerBB->_GET['count']);
		// Aha, there are tags in this subject
		if ($PowerBB->_CONF['template']['while']['tags'] != false)
		{
			$PowerBB->template->assign('SHOW_TAGS',true);
		}
		else
		{
			$PowerBB->template->assign('SHOW_TAGS',false);
		}

		if (!$PowerBB->_GET['count'])
		{
			$PowerBB->template->assign('count_peg','0');
		}
		else
		{
			$PowerBB->template->assign('count_peg',$PowerBB->_GET['count']);
		}

		if ($PowerBB->functions->ModeratorCheck($this->SectionInfo['id']))
		{
			$PowerBB->template->assign('mod_toolbar',0);
		}
		else
		{
			$PowerBB->template->assign('mod_toolbar',1);
		}

       if ($PowerBB->_CONF['group_info']['admincp_allow']
       && $PowerBB->_CONF['group_info']['admincp_member'])
       {
          $PowerBB->template->assign('mod_edit_member',1);
       }
       else
       {
          $PowerBB->template->assign('mod_edit_member',0);
       }

		//////////
	}

	function __GetSubject()
	{
		global $PowerBB;


		//show list last 5 posts member
		if ($PowerBB->_CONF['info_row']['show_list_last_5_posts_member'] == 1)
		{
		$getid = $PowerBB->_GET['id'];

		 $writer =$PowerBB->_CONF['template']['SubjectInfo']['writer'];
         $LastSubjectWriter_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT id FROM " . $PowerBB->table['subject'] . " WHERE writer='$writer'"));
         $PowerBB->template->assign('LastSubjectWriter_nm',$LastSubjectWriter_nm);

		$LastSubjectWriterArr 							= 	array();
		$LastSubjectWriterArr['proc'] 					= 	array();
		$LastSubjectWriterArr['proc']['*'] 				= 	array('method'=>'clean','param'=>'html');

		$LastSubjectWriterArr['where']					=	array();
		$LastSubjectWriterArr['where'][0]				=	array();
		$LastSubjectWriterArr['where'][0]['name'] 	    = 	'review_subject<>1 AND sec_subject<>1 AND delete_topic<>1 and writer';
		$LastSubjectWriterArr['where'][0]['oper']		=	'=';
		$LastSubjectWriterArr['where'][0]['value']		=	$PowerBB->_CONF['template']['SubjectInfo']['writer'];

		$LastSubjectWriterArr['order']					=	array();
		$LastSubjectWriterArr['order']['field']			=	'id';
		$LastSubjectWriterArr['order']['type']			=	'DESC';
		$LastSubjectWriterArr['limit']			        =	$PowerBB->_CONF['info_row']['last_subject_writer_nm'];


       $PowerBB->_CONF['template']['while']['Writer_subjectList'] = $PowerBB->subject->GetSubjectList($LastSubjectWriterArr);
      }


		//////////
		//show Award member
       $ALL_Awards_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT id FROM " . $PowerBB->table['award'] . " "));
       if ($ALL_Awards_nm > 0)
		{

		 $username = $PowerBB->_CONF['template']['SubjectInfo']['writer'];
         $Award_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT id FROM " . $PowerBB->table['award'] . " WHERE username='$username'"));
         $PowerBB->template->assign('Awards_nm',$Award_nm);

		$AwardArr 							= 	array();
		$AwardArr['proc'] 					= 	array();
		$AwardArr['proc']['*'] 				= 	array('method'=>'clean','param'=>'html');

		$AwardArr['where']					=	array();
		$AwardArr['where'][0]				=	array();
		$AwardArr['where'][0]['name']		=	'username';
		$AwardArr['where'][0]['oper']		=	'=';
		$AwardArr['where'][0]['value']		=	$PowerBB->_CONF['template']['SubjectInfo']['writer'];

		$AwardArr['order']					=	array();
		$AwardArr['order']['field']			=	'id';
		$AwardArr['order']['type']			=	'DESC';


       $PowerBB->_CONF['template']['while']['AwardsList'] = $PowerBB->award->GetAwardList($AwardArr);
       }

        //////////
 		  $PowerBB->_CONF['template']['SubjectInfo']['title'] 				= 	$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo']['title'],'html');
          $PowerBB->_CONF['template']['SubjectInfo']['title'] = str_ireplace("'",'"', $PowerBB->_CONF['template']['SubjectInfo']['title']);
		 $PowerBB->_CONF['template']['SubjectInfo']['section'] = $PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo']['section'],'intval');
		 $PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');


     	//////////
	}



	function __GetWriterInfo()
	{
		global $PowerBB;

		////////
	    // Extra Field info
	    $extraEmptyFields=$PowerBB->extrafield->getEmptyLoginFields(true);
	    $fieldsRow='';
	    foreach($extraEmptyFields AS $field)
           $extraEmptyFields = $PowerBB->Powerparse->censor_words($extraEmptyFields);
         // Kill XSS
		$PowerBB->functions->CleanVariable($extraEmptyFields,'html');
		$PowerBB->functions->CleanVariable($extraEmptyFields,'sql');
	    $fieldsRow.=$field['name_tag'].',';
	    $PowerBB->_CONF['template']['while']['extrafield']=&$extraEmptyFields;

		// Make register date in nice format to show it
		if (is_numeric($this->Info['register_date']))
		{
			$this->Info['register_date'] = $PowerBB->functions->date($this->Info['register_date']);
		}
       $cache = unserialize(base64_decode($PowerBB->_CONF['member_row']['style_cache']));
       $image_path = $PowerBB->_CONF['rows']['style']['image_path'];


		// Is writer online ?
		$CheckOnline = ($this->Info['logged'] < $PowerBB->_CONF['timeout']) ? false : true;

		// If the member is online , so store that in status variable
		($CheckOnline) ? $PowerBB->template->assign('status',"<img title='Online' src='$image_path/icon_user_online.gif'>") : $PowerBB->template->assign('status',"<img title='offline' src='$image_path/icon_user_offline.gif'>");

		// Get username style
		if (empty($this->Info['username_style_cache']))
		{
			$this->Info['display_username'] = $this->Info['username'];
		}
		else
		{
			$this->Info['display_username'] = $this->Info['username_style_cache'];

			$this->Info['display_username'] = $PowerBB->functions->CleanVariable($this->Info['display_username'],'unhtml');
		}
	}


	function __SubjectTextFormat()
	{
		global $PowerBB;


		// $this->Info['text'] = wordwrap($this->Info['text'], $PowerBB->_CONF['info_row']['wordwrap'], "<br />", true);

		// The visitor come from search engine , I don't mean Google :/ I mean the local search engine
		// so highlight the key word
		if (!empty($PowerBB->_GET['highlight']))
		{
			$PowerBB->_CONF['template']['SubjectInfo']['text'] = $PowerBB->Powerparse->content_search_highlight( $PowerBB->_CONF['template']['SubjectInfo']['text'], $PowerBB->_GET['highlight'] );
		}

		// If the PowerCode is allow , so use it :)
		if ($this->SectionInfo['use_power_code_allow'])
		{
	     $PowerBB->_CONF['template']['SubjectInfo']['text'] = $PowerBB->Powerparse->replace($PowerBB->_CONF['template']['SubjectInfo']['text']);
		}
		// The PowerCode isn't allow , don't use it :(
		else
		{
			$PowerBB->_CONF['template']['SubjectInfo']['text'] = nl2br($PowerBB->_CONF['template']['SubjectInfo']['text']);
		}

		// Convert smiles in subject to nice images :)

		$PowerBB->Powerparse->replace_smiles($PowerBB->_CONF['template']['SubjectInfo']['text']);
        $PowerBB->Powerparse->replace_wordwrap($PowerBB->_CONF['template']['SubjectInfo']['text']);

		// feltr Subject Text
         $this->Info['text'] = $PowerBB->Powerparse->censor_words($PowerBB->_CONF['template']['SubjectInfo']['text']);
        // Kill XSS
        $PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo']['text'],'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['SubjectInfo']['text'],'sql');

		//get user rating
		$RatingArr 							= 	array();
		$RatingArr['proc'] 					= 	array();
		$RatingArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$RatingArr['where']					=	array();
		$RatingArr['where'][0]				=	array();
		$RatingArr['where'][0]['name']		=	'posts';
		$RatingArr['where'][0]['oper']		=	'>';
		$RatingArr['where'][0]['value']		=	$this->Info['posts'];

		$RatingInfo = $PowerBB->userrating->GetUserRatingInfo($RatingArr);
		$PowerBB->template->assign('RatingInfo',$RatingInfo);

		//get user title
		$UsertitleArr 							= 	array();
		$UsertitleArr['proc'] 					= 	array();
		$UsertitleArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$UsertitleArr['where']					=	array();
		$UsertitleArr['where'][0]				=	array();
		$UsertitleArr['where'][0]['name']		=	'posts';
		$UsertitleArr['where'][0]['oper']		=	'>';
		$UsertitleArr['where'][0]['value']		=	$this->Info['posts'];

		$UsertitleInfo = $PowerBB->usertitle->GetUsertitleInfo($UsertitleArr);
		$PowerBB->template->assign('Usertitle',$UsertitleInfo['usertitle']);
		$GrpArr 			= 	array();
		$GrpArr['where'] 	= 	array('id',$this->Info['usergroup']);

		$GroupInfo = $PowerBB->group->GetGroupInfo($GrpArr);
        $PowerBB->template->assign('GroupInfo',$GroupInfo);

	}

	function __SubjectEnd()
	{
		global $PowerBB;


		// We have attachment in this subject
		if ($PowerBB->_CONF['template']['SubjectInfo']['attach_subject'])
		{
			$AttachArr 							= 	array();
			$AttachArr['where']					= 	array();
			$AttachArr['where'][0] 				=	array();
			$AttachArr['where'][0]['name'] 		=	'subject_id';
			$AttachArr['where'][0]['oper'] 		=	'=';
			$AttachArr['where'][0]['value'] 	=	$PowerBB->_GET['id'];
			$AttachArr['where'][1] 				=	array();
			$AttachArr['where'][1]['con']		=	'AND';
			$AttachArr['where'][1]['name'] 		=	'reply';
			$AttachArr['where'][1]['oper'] 		=	'=';
			$AttachArr['where'][1]['value'] 	=	'0';

			// Get the attachment information
			$PowerBB->_CONF['template']['while']['AttachList'] = $PowerBB->attach->GetAttachList($AttachArr);

			if ($PowerBB->_CONF['template']['while']['AttachList'] != false)
			{
				$PowerBB->template->assign('ATTACH_SHOW',true);

			}
		}

		// The writer signture isn't empty
		if (!empty($this->Info['user_sig']))
		{
			// So , use the PowerCode in it
			$this->Info['user_sig'] = $PowerBB->Powerparse->replace($this->Info['user_sig']);
			$PowerBB->Powerparse->replace_smiles($this->Info['user_sig']);

		// feltr sig Text
        $this->Info['user_sig'] = $PowerBB->Powerparse->censor_words($this->Info['user_sig']);
		}

       if (!empty($this->Info['away_msg']))
		{
		   $this->Info['away_msg'] = $PowerBB->Powerparse->replace($this->Info['away_msg']);
           $PowerBB->Powerparse->replace_smiles($this->Info['away_msg']);

		// feltr sig Text
        $this->Info['away_msg'] = $PowerBB->Powerparse->censor_words($this->Info['away_msg']);
         // Kill XSS
        $this->Info['away_msg'] = $PowerBB->functions->CleanVariable($this->Info['away_msg'],'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->Info['away_msg'],'sql');
        }

     $this->Info['user_website'] = $PowerBB->functions->CleanVariable($this->Info['user_website'],'html');
     $this->Info['user_info'] = $PowerBB->functions->CleanVariable($this->Info['user_info'],'html');


		$topic_date = $PowerBB->functions->date($this->Info['native_write_time']);
		//$topic_time = $PowerBB->functions->time($this->Info['native_write_time']);

		$this->Info['native_write_time'] = $topic_date;


        $Aht=$PowerBB->_CONF['template']['lang']['THours'];
		$action_date = $PowerBB->functions->date($this->Info['actiondate']);
        //$action_time = $PowerBB->functions->time($this->Info['actiondate']);

		$this->Info['actiondate'] = $action_date;


		// Finally $this->Info to templates
		$PowerBB->template->assign('Info',$this->Info);


        ///////////////////////////////////////////////
        // pager Up Subject
		$SubjectInfid = $PowerBB->_GET['id'];
        $SubjectInfReplyNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT id FROM " . $PowerBB->table['reply'] . " WHERE subject_id='$SubjectInfid' and delete_topic <>1"));

           //  Update Reply Number
        	if ($SubjectInfReplyNum != $PowerBB->_CONF['template']['SubjectInfo']['reply_number'])
		   {

	     		$RepArr 					= 	array();
	     		$RepArr['reply_number']		=	$SubjectInfReplyNum;
	     		$RepArr['where'] 			= 	array('id',$SubjectInfid);

	     		$UpdateReplyNumber = $PowerBB->subject->UpdateReplyNumber($RepArr);
		   }


		   // Update subject review number
		    $SubjectInfReviewNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT id FROM " . $PowerBB->table['reply'] . " WHERE subject_id='$SubjectInfid' and review_reply='1'"));
		    if ($SubjectInfReviewNum != $PowerBB->_CONF['template']['SubjectInfo']['review_reply'])
		     {
		      $PowerBB->DB->sql_query("UPDATE " . $PowerBB->table['subject'] . " SET review_reply='$SubjectInfReviewNum' WHERE id='$SubjectInfid'");
		     }

        	if ($SubjectInfReplyNum > $PowerBB->_CONF['info_row']['perpage'])
		   {

              $PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
              $PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

            // Pager setup
			$ReplypagerArr = array();
			$ReplypagerArr['pager'] 				= 	array();
			$ReplypagerArr['pager']['total']		= 	$SubjectInfReplyNum;
			$ReplypagerArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['perpage'];
			$ReplypagerArr['pager']['count'] 	= 	$PowerBB->_GET['count'];
			 if ($PowerBB->_CONF['info_row']['rewriterule'] == '1')
			{
			 $ReplypagerArr['pager']['location'] 	=   't' . $PowerBB->_GET['id'];
			}
			else
			{
			$ReplypagerArr['pager']['location'] 	= 	'index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['id'] . '&amp;password=' . $PowerBB->_GET['password'];
		    }
			$ReplypagerArr['pager']['var'] 		= 	'count';
			$ReplypagerArr['subject_id'] 		= 	$PowerBB->_GET['id'];

			$this->RInfo = $PowerBB->reply->GetReplyInfo($ReplypagerArr);


		    $PowerBB->template->assign('pager_reply',$PowerBB->pager->show());

		   }

         //// get count perpage
			if ($SubjectInfReplyNum < $PowerBB->_CONF['info_row']['perpage'])
		   {

		   $PowerBB->template->assign('count',0);

		   }
          else
          {
          $ss_r = $PowerBB->_CONF['info_row']['perpage']/2;
		  $roun_ss_r = round($ss_r, 0);
          $reply_number = $SubjectInfReplyNum-$roun_ss_r;
          $pagenum = $reply_number/$PowerBB->_CONF['info_row']['perpage'];
          $round0 = round($pagenum, 0);
          $perpage = $round0*$PowerBB->_CONF['info_row']['perpage'];
		  $PowerBB->template->assign('count',$perpage);
          }


        // Subject top
        $PowerBB->template->assign('Subjectinfo',$PowerBB->_CONF['template']['SubjectInfo']);
        $PowerBB->template->assign('subject_title',$PowerBB->Powerparse->censor_words($PowerBB->_CONF['template']['SubjectInfo']['title']));
        $PowerBB->template->assign('subject_id',$PowerBB->_GET['id']);
        $PowerBB->template->assign('SectionGroup',$this->SectionGroup);
        $PowerBB->template->display('subject_top');

        // If the member isn't the writer , so register a new visit for the subject

		$PowerBB->_CONF['template']['SubjectInfo']['visitor'] +=1;
        $visitor = $PowerBB->_CONF['template']['SubjectInfo']['visitor'];

		$Subjectid = $PowerBB->_GET['id'];
			if  ($PowerBB->_CONF['member_row']['username'] != $PowerBB->_CONF['template']['SubjectInfo']['writer'])
		   {
		     $update_visitor = $PowerBB->DB->sql_query("UPDATE " . $PowerBB->table['subject'] . " SET visitor= '$visitor' WHERE id='$Subjectid'");
           }

         ////////

        ////////////////////////////////////////////////////////////////////////
        // there is poll in this subject
          if ($PowerBB->_CONF['template']['SubjectInfo']['poll_subject'])
		   {
			 $PollArr 			= 	array();
			 $PollArr['where'] 	= 	array('subject_id',$PowerBB->_GET['id']);

			  $Poll = $PowerBB->poll->GetPollInfo($PollArr);

			    // Aha, there is poll in this subject
	            $PowerBB->template->assign('Poll',$Poll);
	            $PowerBB->template->assign('subject_id',$PowerBB->_GET['id']);
		        $PowerBB->template->assign('poll_writer',$PowerBB->_CONF['template']['SubjectInfo']['writer']);
		        $PowerBB->template->assign('poll_section',$PowerBB->_CONF['template']['SubjectInfo']['section']);

				$PowerBB->template->display('show_poll_top');


			    $Poll['answers'] = unserialize($Poll['answers']);
				// Kill XSS
           if ($Poll['answers'])
		    {
	            foreach($Poll['answers'] as $answers_number => $answers)
	            {

                  $subject_id  = $PowerBB->_GET['id'];
                 $vote_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['vote'] . " WHERE answer_number = " . $answers_number . " AND subject_id = " . $subject_id . " "));

				$PowerBB->template->assign('answers',$answers);
				$PowerBB->template->assign('answers_number',$answers_number);
                $PowerBB->template->assign('Vote',$vote_nm);

                $CheckArr 						= 	array();

				$CheckArr['where'][0] 			= 	array();
				$CheckArr['where'][0]['name'] 	= 	'subject_id';
				$CheckArr['where'][0]['oper'] 	= 	'=';
				$CheckArr['where'][0]['value'] 	= 	$PowerBB->_GET['id'];


				$CheckArr['where'][1] 			= 	array();
				$CheckArr['where'][1]['con'] 	= 	'AND';
				$CheckArr['where'][1]['name'] 	= 	'member_id';
				$CheckArr['where'][1]['oper'] 	= 	'=';
				$CheckArr['where'][1]['value'] 	= 	$PowerBB->_CONF['member_row']['id'];
                 if (!$PowerBB->_CONF['member_permission'])
                  {
					$CheckArr['where'][2] 			= 	array();
					$CheckArr['where'][2]['con'] 	= 	'AND';
					$CheckArr['where'][2]['name'] 	= 	'user_ip';
					$CheckArr['where'][2]['oper'] 	= 	'=';
					$CheckArr['where'][2]['value'] 	= 	$PowerBB->_CONF['ip'];
                  }
				$ShowVote = $PowerBB->vote->GetVoteInfo($CheckArr);

		         $PowerBB->template->assign('ShowVote',$ShowVote);
				$PowerBB->template->display('show_poll');
				}

             }
			    $PowerBB->template->assign('Poll',$Poll);

				$CheckArr 						= 	array();

				$CheckArr['where'][0] 			= 	array();
				$CheckArr['where'][0]['name'] 	= 	'subject_id';
				$CheckArr['where'][0]['oper'] 	= 	'=';
				$CheckArr['where'][0]['value'] 	= 	$PowerBB->_GET['id'];

				$CheckArr['where'][1] 			= 	array();
				$CheckArr['where'][1]['con'] 	= 	'AND';
				$CheckArr['where'][1]['name'] 	= 	'member_id';
				$CheckArr['where'][1]['oper'] 	= 	'=';
				$CheckArr['where'][1]['value'] 	= 	$PowerBB->_CONF['member_row']['id'];

          if (!$PowerBB->_CONF['member_permission'])
              {

				$CheckArr['where'][1] 			= 	array();
				$CheckArr['where'][1]['con'] 	= 	'AND';
				$CheckArr['where'][1]['name'] 	= 	'user_ip';
				$CheckArr['where'][1]['oper'] 	= 	'=';
				$CheckArr['where'][1]['value'] 	= 	$PowerBB->_CONF['ip'];
             }
				$ShowVote = $PowerBB->vote->GetVoteInfo($CheckArr);

		         $PowerBB->template->assign('ShowVote',$ShowVote);

		         $subject_id  = $PowerBB->_GET['id'];
                 $Allvote_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['vote'] . " WHERE votes AND subject_id = " . $subject_id . " "));
                 $PowerBB->template->assign('AllVote',$Allvote_nm);
		         $PowerBB->template->display('show_poll_down');
            }

         ////////////////////////////////////////////////////////////////////////

         if (!isset($PowerBB->_GET['count']) OR $PowerBB->_GET['count'] <> 0)
         {

             $PowerBB->_GET['count'] <> 0;

         }
         $page  = intval($PowerBB->_GET['count']);

         $start = ($PowerBB->_CONF['info_row']['perpage']);
		$PowerBB->template->assign('url',$PowerBB->functions->GetForumAdress().'index.php?page=topic&amp;show=1&amp;id='.$PowerBB->_GET['id']);

         if ($PowerBB->_CONF['info_row']['show_subject_all']== 1 or $PowerBB->_CONF['info_row']['show_subject_all']== 0 and $page == 0)
         {
            // show Subject
             $PowerBB->template->display('show_subject');

           // show Guest Reply
           if ($this->SectionGroup['write_reply'])
           {
	       $subject_Info_id = $PowerBB->_GET['id'];
	       $ReplyGuestInfo = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['reply'] . " WHERE subject_id = '$subject_Info_id' AND delete_topic<>1 ORDER BY write_time ASC");
	       while ($ReplyGuestInforow = $PowerBB->DB->sql_fetch_array($ReplyGuestInfo))
		      {
		        if ($ReplyGuestInforow['writer'] == 'Guest')
				{

			       $Member_Info_writer = $ReplyGuestInforow['writer'];
			       $ReplyMemberInfo = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['member'] . " WHERE username = '$Member_Info_writer' ORDER BY id ASC");
			       while ($MemberInfo = $PowerBB->DB->sql_fetch_array($ReplyMemberInfo))
				      {
			            $PowerBB->template->assign('Info',$MemberInfo);
			          }

						// If the PowerCode is allow , so use it :)
						if ($this->SectionInfo['use_power_code_allow'])
						{
							$ReplyGuestInforow['text'] = $PowerBB->Powerparse->replace($ReplyGuestInforow['text']);
						}
						// The PowerCode isn't allow , don't use it :(
						else
						{
							$ReplyGuestInforow['text'] = nl2br($ReplyGuestInforow['text']);
						}

					 $PowerBB->Powerparse->replace_smiles($ReplyGuestInforow['text']);


			         // feltr guest Reply Text
                    $ReplyGuestInforow['text'] = $PowerBB->Powerparse->censor_words($ReplyGuestInforow['text']);
                   // Kill XSS
				   $PowerBB->functions->CleanVariable($ReplyGuestInforow['text'],'html');
					// Kill SQL Injection
					$PowerBB->functions->CleanVariable($ReplyGuestInforow['text'],'sql');
	                $Reply_time_date = $PowerBB->functions->date($ReplyGuestInforow['write_time']);
			        $Reply_time = $PowerBB->functions->time($ReplyGuestInforow['write_time']);
			        $PowerBB->template->assign('write_time',$Reply_time_date);
			        $PowerBB->template->assign('reply_guest',$ReplyGuestInforow);



                   $PowerBB->template->display('reply_guest');

				}

		     }
             //////////////////////
          }
         }
         elseif ($PowerBB->_CONF['info_row']['show_subject_all']== 1 and $start != 0)
         {
                // Do nothing :)
         }
         elseif ($PowerBB->_CONF['info_row']['show_subject_all']== 0)
         {
                 $PowerBB->template->display('show_subject_information');
         }


	}


	function __GetReply()
	{
		global $PowerBB;

		// Show the replies
		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		$SubjectInfid = $PowerBB->_GET['id'];
        $SubjectInfReplyNum = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['reply'] . " WHERE subject_id='$SubjectInfid' and delete_topic <>1"));

		$ReplyArr = array();
		// Pager setup
		$ReplyArr['pager'] 				= 	array();
		$ReplyArr['pager']['total']		= 	$SubjectInfReplyNum;
		$ReplyArr['pager']['perpage'] 	= 	$PowerBB->_CONF['info_row']['perpage'];
		$ReplyArr['pager']['count'] 	= 	$PowerBB->_GET['count'];
        if ($PowerBB->_CONF['info_row']['rewriterule'] == '1')
		{
		 $ReplyArr['pager']['location'] 	=   't' . $PowerBB->_GET['id'];
		 }
		else
		{
		$ReplyArr['pager']['location'] 	= 	'index.php?page=topic&amp;show=1&amp;id=' . $PowerBB->_GET['id'] . '&amp;password=' . $PowerBB->_GET['password'];
	    }
		$ReplyArr['pager']['var'] 		= 	'count';
		$ReplyArr['subject_id'] 		= 	$PowerBB->_GET['id'];

		$ReplyArr['order'] 					= 	array();
		$ReplyArr['order']['field'] 		= 	'write_time';
		$ReplyArr['order']['type'] 			= 	'ASC';

		$ReplyArr['where']				=	array();
		$ReplyArr['where'][0] 			= 	array();
		$ReplyArr['where'][0]['name']	=	'delete_topic';
		$ReplyArr['where'][0]['oper']	=	'<>';
		$ReplyArr['where'][0]['value']	=	'1';
      if ($this->SectionGroup['write_reply'])
       {
		$ReplyArr['where'][1] 			= 	array();
		$ReplyArr['where'][1]['con'] 		= 	'AND';
		$ReplyArr['where'][1]['name']	=	'writer';
		$ReplyArr['where'][1]['oper']	=	'<>';
		$ReplyArr['where'][1]['value']	=	'Guest';
       }
		$this->RInfo = $PowerBB->reply->GetReplyWriterInfo($ReplyArr);
		if (!$this->RInfo)
		{
         if ($this->SectionGroup['write_reply'])
         {
		  $this->RInfo = $PowerBB->reply->GetReplyGuestInfo($ReplyArr);
		 }
		}
        if ($SubjectInfReplyNum > $PowerBB->_CONF['info_row']['perpage'])
		{
		$PowerBB->template->assign('pager_reply',$PowerBB->pager->show());
		}

		$PowerBB->template->assign('count',$PowerBB->_GET['count']);

        		//////////

		// Kill XSS
		// TODO :: it's better to kill XSS inside the loop
		$PowerBB->functions->CleanVariable($this->RInfo,'html');
		$n = sizeof($this->RInfo);
		$this->x = 0;
		// Nice loop :D
		while ($n > $this->x)
		{
			// Get the replier info
			$this->___GetReplierInfo();
			// Make reply text as a nice format
			$this->___ReplyFormat();
			// The end of reply
			$this->___ReplyEnd();

		}


	}

	function ___GetReplierInfo()
	{
		global $PowerBB;

		// Make register date in nice format to show it
		if (is_numeric($this->RInfo[$this->x]['register_date']))
		{
			$this->RInfo[$this->x]['register_date'] = $PowerBB->functions->date($this->RInfo[$this->x]['register_date']);
		}

		$cache = unserialize(base64_decode($PowerBB->_CONF['member_row']['style_cache']));
        $image_path = $PowerBB->_CONF['rows']['style']['image_path'];


		$CheckOnline = ($this->RInfo[$this->x]['logged'] < $PowerBB->_CONF['timeout']) ? false : true;

		($CheckOnline) ? $PowerBB->template->assign('status',"<img title='online' src='$image_path/icon_user_online.gif'>") : $PowerBB->template->assign('status',"<img title='offline' src='$image_path/icon_user_offline.gif'>");

   		// Get username style
			$this->RInfo[$this->x]['display_username'] = $this->RInfo[$this->x]['username_style_cache'];

		////////

		$SubjectInfReplyNum = $SubjectInfReplyNum+$PowerBB->_GET['count']+1;


		if ($PowerBB->_GET['count'])
		{
		$SubjectInfReplyNum+$PowerBB->_GET['count'] += 1;
		}
		else
		{
		$SubjectInfReplyNum += 1;
		}

	}

	function ___ReplyFormat()
	{
		global $PowerBB;


		// The visitor come from search engine , I don't mean Google :/ I mean the local search engine
		// so highlight the key word
		if (!empty($PowerBB->_GET['highlight']))
		{
			$this->RInfo[$this->x]['text'] = $PowerBB->Powerparse->content_search_highlight( $this->RInfo[$this->x]['text'], $PowerBB->_GET['highlight'] );
		}
		// If the PowerCode is allow , use it
		if ($this->SectionInfo['use_power_code_allow'])
		{
			$this->RInfo[$this->x]['text'] = $PowerBB->Powerparse->replace($this->RInfo[$this->x]['text']);
		}
		// It's not allow , don't use it
		else
		{
			$this->RInfo[$this->x]['text'] = nl2br($this->RInfo[$this->x]['text']);
		}

		// Convert the smiles to image
		$PowerBB->Powerparse->replace_smiles($this->RInfo[$this->x]['text']);
		 $PowerBB->Powerparse->replace_wordwrap($this->RInfo[$this->x]['text']);

		// feltr Subject Text
         $this->RInfo[$this->x]['text'] = $PowerBB->Powerparse->censor_words($this->RInfo[$this->x]['text']);
        // Kill XSS
        $PowerBB->functions->CleanVariable($this->RInfo[$this->x]['text'],'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->RInfo[$this->x]['text'],'sql');

		if ($PowerBB->_CONF['info_row']['show_list_last_5_posts_member'] == 1)
		{
		//show list last 5 posts member
		$getid = $PowerBB->_GET['id'];
        $forum_id_not_in = "1";

		 $writer =$this->RInfo[$this->x]['writer'];
         $LastSubjectWriter_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['subject'] . " WHERE writer='$writer'"));
         $PowerBB->template->assign('LastSubjectWriter_nm',$LastSubjectWriter_nm);

		$LastSubjectWriterArr 							= 	array();
		$LastSubjectWriterArr['proc'] 					= 	array();
		$LastSubjectWriterArr['proc']['*'] 				= 	array('method'=>'clean','param'=>'html');

		$LastSubjectWriterArr['where']					=	array();
		$LastSubjectWriterArr['where'][0]				=	array();
		$LastSubjectWriterArr['where'][0]['name'] 	    = 	'review_subject<>1 AND sec_subject<>1 AND delete_topic<>1 and writer';
		$LastSubjectWriterArr['where'][0]['oper']		=	'=';
		$LastSubjectWriterArr['where'][0]['value']		=	$this->RInfo[$this->x]['writer'];

		$LastSubjectWriterArr['order']					=	array();
		$LastSubjectWriterArr['order']['field']			=	'id';
		$LastSubjectWriterArr['order']['type']			=	'DESC';
		$LastSubjectWriterArr['limit']			        =	$PowerBB->_CONF['info_row']['last_subject_writer_nm'];


       $PowerBB->_CONF['template']['while']['Writer_subjectList'] = $PowerBB->subject->GetSubjectList($LastSubjectWriterArr);
      }



		//////////
		//show Award member
       $ALL_Awards_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT id FROM " . $PowerBB->table['award'] . " "));
       if ($ALL_Awards_nm > 0)
		{
		 $username = $this->RInfo[$this->x]['writer'];
         $Award_nm = $PowerBB->DB->sql_num_rows($PowerBB->DB->sql_query("SELECT id FROM " . $PowerBB->table['award'] . " WHERE username='$username'"));
         $PowerBB->template->assign('Awards_nm',$Award_nm);

		$AwardArr 							= 	array();
		$AwardArr['proc'] 					= 	array();
		$AwardArr['proc']['*'] 				= 	array('method'=>'clean','param'=>'html');

		$AwardArr['where']					=	array();
		$AwardArr['where'][0]				=	array();
		$AwardArr['where'][0]['name']		=	'username';
		$AwardArr['where'][0]['oper']		=	'=';
		$AwardArr['where'][0]['value']		=	$username;

		$AwardArr['order']					=	array();
		$AwardArr['order']['field']			=	'id';
		$AwardArr['order']['type']			=	'DESC';


       $PowerBB->_CONF['template']['while']['AwardsList'] = $PowerBB->award->GetAwardList($AwardArr);

       }
        //////////

		//$this->RInfo[$this->x]['text'] = $PowerBB->functions->CleanVariable($this->RInfo[$this->x]['text'],'sql');
		// Member signture is not empty , show make it nice with PowerCode
       if (!empty($this->RInfo[$this->x]['user_sig']))
		{
		   $this->RInfo[$this->x]['user_sig'] = $PowerBB->Powerparse->replace($this->RInfo[$this->x]['user_sig']);
           $PowerBB->Powerparse->replace_smiles($this->RInfo[$this->x]['user_sig']);

		 // feltr sig Text
          $this->RInfo[$this->x]['user_sig'] = $PowerBB->Powerparse->censor_words($this->RInfo[$this->x]['user_sig']);
         // Kill XSS
		$PowerBB->functions->CleanVariable($this->RInfo[$this->x]['user_sig'],'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->RInfo[$this->x]['user_sig'],'sql');
        }

       if (!empty($this->RInfo[$this->x]['away_msg']))
		{
		   $this->RInfo[$this->x]['away_msg'] = $PowerBB->Powerparse->replace($this->RInfo[$this->x]['away_msg']);
           $PowerBB->Powerparse->replace_smiles($this->RInfo[$this->x]['away_msg']);

		// feltr away msg
           $this->RInfo[$this->x]['away_msg'] = $PowerBB->Powerparse->censor_words($this->RInfo[$this->x]['away_msg']);
         // Kill XSS
		$this->RInfo[$this->x]['away_msg'] = $PowerBB->functions->CleanVariable($this->RInfo[$this->x]['away_msg'],'html');
		// Kill SQL Injection
		$PowerBB->functions->CleanVariable($this->RInfo[$this->x]['away_msg'],'sql');

        }
     $this->RInfo[$this->x]['user_website'] = $PowerBB->functions->CleanVariable($this->RInfo[$this->x]['user_website'],'html');
     $this->RInfo[$this->x]['user_info'] = $PowerBB->functions->CleanVariable($this->RInfo[$this->x]['user_info'],'html');

		//get user rating
		$RatingArr 							= 	array();
		$RatingArr['proc'] 					= 	array();
		$RatingArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$RatingArr['where']					=	array();
		$RatingArr['where'][0]				=	array();
		$RatingArr['where'][0]['name']		=	'posts';
		$RatingArr['where'][0]['oper']		=	'>';
		$RatingArr['where'][0]['value']		=	$this->RInfo[$this->x]['posts'];

		$RatingInfo = $PowerBB->userrating->GetUserRatingInfo($RatingArr);
		$PowerBB->template->assign('RatingInfo',$RatingInfo);

		//get user title
		$UsertitleArr 							= 	array();
		$UsertitleArr['proc'] 					= 	array();
		$UsertitleArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$UsertitleArr['where']					=	array();
		$UsertitleArr['where'][0]				=	array();
		$UsertitleArr['where'][0]['name']		=	'posts';
		$UsertitleArr['where'][0]['oper']		=	'>';
		$UsertitleArr['where'][0]['value']		=	$this->RInfo[$this->x]['posts'];

		$UsertitleInfo = $PowerBB->usertitle->GetUsertitleInfo($UsertitleArr);
		$PowerBB->template->assign('Usertitle',$UsertitleInfo['usertitle']);
		$GrpArr 			= 	array();
		$GrpArr['where'] 	= 	array('id',$this->RInfo[$this->x]['usergroup']);

		$GroupInfo = $PowerBB->group->GetGroupInfo($GrpArr);
        $PowerBB->template->assign('GroupInfo',$GroupInfo);
	}

	function ___ReplyEnd()
	{
		global $PowerBB;

         // If time out For Editing Disable View Icon Edite

		$PowerBB->_CONF['template']['ReplyInfo'] = $this->RInfo[$this->x];

        $time_out = $PowerBB->_CONF['info_row']['time_out']*60;

        if ($PowerBB->_CONF['now'] > $PowerBB->_CONF['template']['ReplyInfo']['write_time']+$time_out != false)
        {
              $PowerBB->template->assign('timeout',false);
		}
		else
		{
			$PowerBB->template->assign('timeout',true);
		}

       if ($PowerBB->_CONF['group_info']['admincp_allow'] && $PowerBB->_CONF['group_info']['admincp_member'])
       {
          $PowerBB->template->assign('mod_edit_member',1);
       }
       else
       {
          $PowerBB->template->assign('mod_edit_member',0);
       }
        $Aht=$PowerBB->_CONF['template']['lang']['THours'];
		$reply_date = $PowerBB->functions->date($this->RInfo[$this->x]['write_time']);

		$action_date = $PowerBB->functions->date($this->RInfo[$this->x]['actiondate']);

		$this->RInfo[$this->x]['write_time'] = $reply_date;
        $this->RInfo[$this->x]['actiondate'] = $action_date;
		// We have attachment in this reply
		if ($this->RInfo[$this->x]['attach_reply'])
		{
			$AttachArr 							= 	array();
			$AttachArr['where']					= 	array();
			$AttachArr['where'][0] 				=	array();
			$AttachArr['where'][0]['name'] 		=	'subject_id';
			$AttachArr['where'][0]['oper'] 		=	'=';
			$AttachArr['where'][0]['value'] 	=	$this->RInfo[$this->x]['reply_id'];
			$AttachArr['where'][1] 				=	array();
			$AttachArr['where'][1]['con']		=	'AND';
			$AttachArr['where'][1]['name'] 		=	'reply';
			$AttachArr['where'][1]['oper'] 		=	'=';
			$AttachArr['where'][1]['value'] 	=	'1';

			// Get the attachment information
			$PowerBB->_CONF['template']['while']['AttachList'] = $PowerBB->attach->GetAttachList($AttachArr);

			if ($PowerBB->_CONF['template']['while']['AttachList'] != false)
			{
				$PowerBB->functions->CleanVariable($PowerBB->_CONF['template']['while']['AttachList'],'html');
			}

			$PowerBB->template->assign('AttachList',$PowerBB->_CONF['template']['while']['AttachList']);

		}

		// $RInfo to templates
		 $PowerBB->template->assign('reply_id',$this->RInfo[$this->x]['reply_id']);

     		if ($this->RInfo[$this->x]['review_reply_id'])
			{
             $display_review_reply_template='1';
			}

        $PowerBB->template->assign('resview_reply',$review_reply);

		$PowerBB->template->assign('ReviewInfo',$this->RInfo[$this->x]);
		$PowerBB->template->assign('Info',$this->RInfo[$this->x]);
		$PowerBB->template->assign('section',$this->Info['section']);

		// $x = $x + 1
               		$this->x += 1;

       		// reply number in Subject
        	if ($PowerBB->_GET['count'] == '0')
		   {
		    $PowerBB->_CONF['template']['Info']['reply_number'] = $this->x;
		   }
			elseif ($PowerBB->_GET['count'] == $PowerBB->_CONF['info_row']['reply_perpage'])
			{
			$PowerBB->_CONF['template']['Info']['reply_number'] = $this->x+$PowerBB->_CONF['info_row']['reply_perpage'];
			}
			else
			{
			$PowerBB->_CONF['template']['Info']['reply_number'] = $PowerBB->_GET['count']-$PowerBB->_CONF['info_row']['reply_perpage'];
			}

			if ($display_review_reply_template)
			{
				if ($PowerBB->functions->ModeratorCheck($this->SectionInfo['id']))
				{
					 $PowerBB->template->display('review_reply');
				}
			}
            else
            {
			// Show the reply :)
			$PowerBB->template->display('show_reply');
			}
	}

	function __SameTopics()
	{
		global $PowerBB;

		$SubjectArr = array();

		$SubjectArr['where'] 				= 	array();

		$SubjectArr['where'][0] 			= 	array();
		$SubjectArr['where'][0]['name'] 	= 	'title';
		$SubjectArr['where'][0]['oper'] 	= 	'LIKE';
		$SubjectArr['where'][0]['value'] 	= 	'%' . $this->Info['title'] . '%';

		$SubjectArr['where'][1] 			= 	array();
		$SubjectArr['where'][1]['con']		=	'AND';
		$SubjectArr['where'][1]['name'] 	= 	'delete_topic';
		$SubjectArr['where'][1]['oper'] 	= 	'<>';
		$SubjectArr['where'][1]['value'] 	= 	'1';

		$SubjectArr['where'][2] 			= 	array();
		$SubjectArr['where'][2]['con']		=	'AND';
		$SubjectArr['where'][2]['name'] 	= 	'id';
		$SubjectArr['where'][2]['oper'] 	= 	'<>';
		$SubjectArr['where'][2]['value'] 	= 	$PowerBB->_GET['id'];


		$SubjectArr['order'] = array();
		$SubjectArr['order']['field'] 	= 	'write_time';
		$SubjectArr['order']['type'] 	= 	'DESC';

		$SubjectArr['proc'] 						= 	array();
		$SubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$SubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$SubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

		$SubjectArr['limit'] = '5';

		$PowerBB->_CONF['template']['while']['SameSubject'] = $PowerBB->subject->GetSubjectList($SubjectArr);

		if (!$PowerBB->_CONF['template']['while']['SameSubject'])
		{
			$PowerBB->_CONF['template']['NO_SAME'] = true;
		}
	}

	function __PageEnd()
	{
		global $PowerBB;

		////////

		$Admin = false;

		if ($PowerBB->_CONF['member_permission'])
		{
			if ($PowerBB->_CONF['group_info']['admincp_allow']
				or $PowerBB->_CONF['group_info']['vice'])
			{
				$Admin = true;
			}
			else
			{
				if (isset($this->SectionInfo))
				{
					$AdminArr = array();
					$AdminArr['username'] = $PowerBB->_CONF['member_row']['username'];
					$AdminArr['section_id'] = $this->SectionInfo['id'];

					$Admin = $PowerBB->moderator->IsModerator($AdminArr);
				}
			}
		}


       // Show Next subject And previous subject:)
		 $idSubject = $PowerBB->_GET['id'];
		 $idSection = $this->Info['section'];
         $getnextsubject_query = $PowerBB->DB->sql_query("SELECT * FROM  " . $PowerBB->table['subject'] . " WHERE id > '$idSubject' and section='" . $idSection . "' AND review_subject<>1 AND delete_topic<>1 ORDER BY id ASC LIMIT 0,1");         $getnextsubject_row   = $PowerBB->DB->sql_fetch_array($getnextsubject_query);
         $getnextsubject_num   = $PowerBB->DB->sql_num_rows($getnextsubject_query);


         $getpersubject_query = $PowerBB->DB->sql_query("SELECT * FROM " . $PowerBB->table['subject'] . " WHERE id < '$idSubject' and section='" . $idSection . "' AND review_subject<>1 AND delete_topic<>1 ORDER BY id DESC LIMIT 0,1");         $getpersubject_row   = $PowerBB->DB->sql_fetch_array($getpersubject_query);
         $getpersubject_num   = $PowerBB->DB->sql_num_rows($getpersubject_query);

         $PowerBB->template->assign('getnextsubject_num',$getnextsubject_num);
         $PowerBB->template->assign('getpersubject_num',$getpersubject_num);
         $PowerBB->template->assign('getnextsubject_row',$getnextsubject_row['id']);
         $PowerBB->template->assign('getpersubject_row',$getpersubject_row['id']);
         $PowerBB->template->assign('getper_title_subject_row',$PowerBB->Powerparse->censor_words($getpersubject_row['title']));
         $PowerBB->template->assign('getnext_title_subject_row',$PowerBB->Powerparse->censor_words($getnextsubject_row['title']));

        ////////



		$PowerBB->functions->GetEditorTools();

     	$PowerBB->template->assign('reply_title',$this->Info['title']);
     	$PowerBB->template->assign('subject_id',$PowerBB->_GET['id']);
     	$PowerBB->template->assign('id',$PowerBB->_GET['id']);
     	$PowerBB->template->assign('Admin',$Admin);
     	$PowerBB->template->assign('stick',$this->Info['stick']);
     	$PowerBB->template->assign('close',$this->Info['close']);
     	$PowerBB->template->assign('Info_row',$this->Info);
     	$PowerBB->template->assign('special',$this->Info['special']);
     	$PowerBB->template->assign('review_subject',$this->Info['review_subject']);
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

       if($PowerBB->_CONF['group_info']['see_who_on_topic'])
       {
          $PowerBB->template->assign('see_who_on_topic',1);

	        /**
		 * Know who is in subject ?
		 */
		// Finally we get Who is in subject
		$SubjectWhoArr 						= 	array();
		$SubjectWhoArr['proc'] 				= 	array();
		$SubjectWhoArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');
		$SubjectWhoArr['where']				=	array();

		$SubjectWhoArr['where'][0]				=	array();
		$SubjectWhoArr['where'][0]['name'] 	= 	'subject_id';
		$SubjectWhoArr['where'][0]['oper'] 	= 	'=';
		$SubjectWhoArr['where'][0]['value'] 	= 	$PowerBB->_GET['id'];


		$SubjectWhoArr['order'] 				= 	array();
		$SubjectWhoArr['order']['field'] 		= 	'user_id';
		$SubjectWhoArr['order']['type'] 		= 	'DESC';

		$x = 1;

		if (!$PowerBB->_CONF['info_row']['show_onlineguest'])
		{
			$SubjectWhoArr['where'][$x]				=	array();
			$SubjectWhoArr['where'][$x]['con']			=	'AND';
			$SubjectWhoArr['where'][$x]['name']		=	'username_style';
			$SubjectWhoArr['where'][$x]['oper']		=	'<>';
			$SubjectWhoArr['where'][$x]['value']		=	'Guest';

			$x += 1;
		}

		// This member can't see hidden member
		if (!$PowerBB->_CONF['group_info']['show_hidden'])
		{
			$SubjectWhoArr['where'][$x] 			= 	array();
			$SubjectWhoArr['where'][$x]['con'] 	= 	'AND';
			$SubjectWhoArr['where'][$x]['name'] 	= 	'hide_browse';
			$SubjectWhoArr['where'][$x]['oper'] 	= 	'<>';
			$SubjectWhoArr['where'][$x]['value'] 	= 	'1';
		}

		$PowerBB->_CONF['template']['while']['SubjectVisitor'] = $PowerBB->online->GetOnlineList($SubjectWhoArr);

		$GuestNumberArr 						= 	array();
		$GuestNumberArr['where'] 				= 	array();

		$GuestNumberArr['where'][0] 			= 	array();
		$GuestNumberArr['where'][0]['name'] 	= 	'username_style';
		$GuestNumberArr['where'][0]['oper'] 	= 	'=';
		$GuestNumberArr['where'][0]['value'] 	= 	'Guest';

		$GuestNumberArr['where'][1] 			= 	array();
		$GuestNumberArr['where'][1]['con'] 		= 	'AND';
		$GuestNumberArr['where'][1]['name'] 	= 	'subject_id';
		$GuestNumberArr['where'][1]['oper'] 	= 	'=';
		$GuestNumberArr['where'][1]['value'] 	= 	$PowerBB->_GET['id'];


		$PowerBB->_CONF['template']['GuestNumber'] = $PowerBB->online->GetOnlineNumber($GuestNumberArr);

		$MemberNumberArr 						= 	array();
		$MemberNumberArr['where'] 				= 	array();

		$MemberNumberArr['where'][0] 			= 	array();
		$MemberNumberArr['where'][0]['name'] 	= 	'username_style';
		$MemberNumberArr['where'][0]['oper'] 	= 	'<>';
		$MemberNumberArr['where'][0]['value'] 	= 	'Guest';

		$MemberNumberArr['where'][1] 			= 	array();
		$MemberNumberArr['where'][1]['con'] 	= 	'AND';
		$MemberNumberArr['where'][1]['name'] 	= 	'subject_id';
		$MemberNumberArr['where'][1]['oper'] 	= 	'=';
		$MemberNumberArr['where'][1]['value'] 	= 	$PowerBB->_GET['id'];


		$PowerBB->_CONF['template']['MemberNumber'] = $PowerBB->online->GetOnlineNumber($MemberNumberArr);

       $online_number = $PowerBB->online->GetOnlineNumber($GuestNumberArr)+$PowerBB->online->GetOnlineNumber($MemberNumberArr);
       $PowerBB->template->assign('online_number',$online_number);
     }


		$PowerBB->template->assign('Subjectinfo',$Subjectinfo);
		$PowerBB->template->assign('id',$PowerBB->_GET['id']);

        ///////////////////////////////////////////////
        // pager Duwn Subject
		  //// get count perpage
			if ($SubjectInfReplyNum < $PowerBB->_CONF['info_row']['perpage'])
		   {

		   $PowerBB->template->assign('count',0);

		   }
          else
          {
          $ss_r = $PowerBB->_CONF['info_row']['perpage']/2;
		  $roun_ss_r = round($ss_r, 0);
          $reply_number = $SubjectInfReplyNum-$roun_ss_r;
          $pagenum = $reply_number/$PowerBB->_CONF['info_row']['perpage'];
          $round0 = round($pagenum, 0);
          $perpage = $round0*$PowerBB->_CONF['info_row']['perpage'];
		  $PowerBB->template->assign('count',$perpage);
          }

        // show TopicMod List
		$TopicModArr 					= 	array();
		$TopicModArr['order']			=	array();
		$TopicModArr['order']['field']	=	'id';
		$TopicModArr['order']['type']	=	'DESC';
		$TopicModArr['proc'] 			= 	array();
		$TopicModArr['proc']['*'] 		= 	array('method'=>'clean','param'=>'html');

		$PowerBB->_CONF['template']['while']['TopicModsList'] = $PowerBB->topicmod->GetTopicModList($TopicModArr);

      $TopicMods = $PowerBB->DB->sql_query("SELECT  *   FROM " . $PowerBB->table['topicmod'] . " WHERE id ");
	  while ($ModsList = $PowerBB->DB->sql_fetch_array($TopicMods))
      {
			if ( strstr( ",".$ModsList['forums'].",", ",".$this->Info['section']."," ) and $ModsList['forums'] != '*' )
			{
				$PowerBB->template->assign('Multi_Moderation',1);
			}
			elseif ($ModsList['forums'] == '*')
			{
				$PowerBB->template->assign('Multi_Moderation',1);
			}
			else
			{
				$PowerBB->template->assign('Multi_Moderation',0);
			}
       }

       /////

     	$PowerBB->template->display('topic_end');
	}

	    /**
	 * Get the Jump Sections List
	 */
	function _GetJumpSectionsList()
    {
		global $PowerBB;

		//////////

		$SecArr 						= 	array();
		$SecArr['get_from']				=	'db';

		$SecArr['proc'] 				= 	array();
		$SecArr['proc']['*'] 			= 	array('method'=>'clean','param'=>'html');

		$SecArr['order']				=	array();
		$SecArr['order']['field']		=	'sort';
		$SecArr['order']['type']		=	'ASC';

		$SecArr['where']				=	array();
		$SecArr['where'][0]['name']		= 	'parent';
		$SecArr['where'][0]['oper']		= 	'=';
		$SecArr['where'][0]['value']	= 	'0';

		// Get main sections
		$catsy = $PowerBB->section->GetSectionsList($SecArr);

		// Loop to read the information of main sections
		foreach ($catsy as $caty)
		{
			// Get the groups information to know view this section or not
			$groups = unserialize(base64_decode($caty['sectiongroup_cache']));

			if (is_array($groups[$PowerBB->_CONF['group_info']['id']]))
			{
				if ($groups[$PowerBB->_CONF['group_info']['id']]['view_section'])
				{
					$PowerBB->_CONF['template']['foreach']['forumsy_list'][$caty['id'] . '_m'] = $caty;

		if (!empty($caty['forums_cache']))
				{
					$forumsy = unserialize(base64_decode($caty['forums_cache']));

					foreach ($forumsy as $forumy)
					{
						if (is_array($forumy['groups'][$PowerBB->_CONF['group_info']['id']]))
						{
							if ($forumy['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
							{
								//////////

								// Get the first-level sub forums as a _link_ and store it in $forumy['sub']

								$forumy['is_sub'] 	= 	0;
								$forumy['sub']		=	'';

								if (!empty($forumy['forums_cache']))
								{
									$subsy = unserialize(base64_decode($forumy['forums_cache']));

									if (is_array($subsy))
									{
										foreach ($subsy as $suby)
										{
											if (is_array($suby['groups'][$PowerBB->_CONF['group_info']['id']]))
											{
												if ($suby['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
												{
													if (!$forumy['is_sub'])
													{
														$forumy['is_sub'] = 1;
													}

													$forumy['sub'] .= ('<option value="index.php?page=forum&amp;show=1&amp;id=' . $suby['id'] . '">---'  . $suby['title'] . '</option>');
												}
											}
										}
									}
								}


								$PowerBB->_CONF['template']['foreach']['forumsy_list'][$forumy['id'] . '_f'] = $forumy;
							}
						} // end if is_array
					} // end foreach ($forumsy)
				} // end !empty($forums_cache)
				}
			}

			unset($groups);


		} // end foreach ($catsy)

		//////////
   }
}

?>
