<?php

////////////

// PowerBB Engine
require_once(DIR . 'engine/Engine.class.php');

// General systems
require_once(DIR . 'includes/functions.class.php');
require_once(DIR . 'includes/template.class.php');
require_once(DIR . 'includes/pbboardCodeparse.class.php');
if (defined('IN_ADMIN'))
{
require_once(DIR . 'includes/FeedParser.php');
require_once(DIR . 'includes/HooksCache.php');
}

////////////

class PowerBB extends Engine
{
	////////////

	// General systems
	var $functions;
	var $template;
	var $Powerparse;
	var $FeedParser;
	////////////

	function PowerBB()
	{
		////////////

		$e = Engine::Engine();

		////////////

		if (!defined('INSTALL'))
		{
  			$this->template		  	= 	new PowerBBTemplate;
  			$this->Powerparse	  	= 	new PowerBBCodeParse;
			if (defined('IN_ADMIN'))
			{
			$this->FeedParser	  	= 	new FeedParser;

			}
		 }

  		////////////

  		if (defined('IN_ADMIN'))
  		{
  			$this->functions = new PowerBBAdminFunctions();
  		}
  		else
  		{
  			$this->functions = new PowerBBFunctions();
  		}

  		////////////

  		if (!is_bool($e)
  			and $e == 'ERROR::THE_TABLES_ARE_NOT_INSTALLED'
  			and !defined('INSTALL'))
  		{
  			$this->functions->redirect('./setup/install/',0);
  			$this->functions->stop(true);
  		}
  	}
 	////////////
}

////////////

?>
