<?

	class Manager
	{
		var	$user;
		var	$actionresult;
		
		function Manager()
		{
		}

		function getUser()
		{
			return $this->user;
		}
		
		function execute()
		{
			global $cat_need_install, $cat_session, $cat_log;	

			$cat_need_auth = false;	
			if(strlen($GLOBALS[cat_locale]) > 0) header("Content-Type: text/html; charset=$GLOBALS[cat_locale]");
			if($cat_session->isRegistered('cat_session_user')) {
				$this->user = $cat_session->get('cat_session_user');
			} else {
				if(strlen($GLOBALS['PHP_AUTH_USER']) > 0 && strlen($GLOBALS['PHP_AUTH_PW']) > 0) {

					if(ereg("([A-Za-z0-9]*)",$GLOBALS['PHP_AUTH_USER'],$regs)) $_l = $regs[0];
					else $_l = 'guest';

					if(ereg("([A-Za-z0-9]*)",$GLOBALS['PHP_AUTH_PW'],$regs)) $_p = $regs[0];
					else $_p = 'guest';
 
					$this->user = new User($_l,$_p);
					if($this->user->isValid()) {
						$cat_session->register('cat_session_user'); 
						$cat_session->set('cat_session_user',$this->user);
					} else {
						$cat_need_auth = true;
						$this->showAuthBox();
					};
				} else {
					$cat_need_auth = true;
					$this->showAuthBox();
				};
			};				
                        
			if(!$cat_need_auth) {
				if(is_object($this->user) && $this->user->isValid()) {
					$cat_log->setUser($this->user->getLogin());
					$this->action();
					$this->user = $cat_session->get('cat_session_user');
					$this->generate();
				};
			};
		}

		//
		//
		//

		function action()
		{
			global $cat_session, $cat_pos;
	
			$this->actionresult = '';
			switch($cat_pos) {
				case('system') : {
					if($this->user->isSystem()) {
						$obj = new System($this->user);
						$this->actionresult = $obj->execute(); 
					};              
					break;
				};
				case('info') : {
					if($this->user->isInfo()) {
						$obj = new Info($this->user);
						$this->actionresult = $obj->execute(); 
					};
					break;
				};
				case('control') : {
					if($this->user->isControl()) {
						$obj = new Control($this->user);
						$this->actionresult = $obj->execute(); 
					};
					break;
				};
				case('exit') : {
					$cat_session->unregister('cat_session_user');
					header("Location: ../");
					break;
				};
				default : {
					$this->actionresult = fileToString('misc/cms_help.html');
				};
			};
		}

		
		function generate()
		{
			global $cat_pattern, $cat_quiet;
	
			if($cat_quiet) return;			

			$p = new Pattern($cat_pattern);
			$p->reset();

			$p->addHash('TITLE', $this->getTitle());
			$p->addHash('PROJECTINFO', $this->getProjectInfo());
			$p->addHash('USERINFO', $this->user->getUserInfo());
			$p->addHash('MENU', $this->getMenu());
			$p->addHash('CONTENT', $this->getContain());
	
			$p->makeDataCode();
			$p->outDataCodeToStd();		 
		}
		
		//
		// Visualization
		//

		function showAuthBox()
		{
			global $cat_loginbox;

			$p = new Pattern($cat_loginbox);
			$p->reset();

			$p->addHash('PROJECTINFO', $this->getProjectInfo());
	
			$p->makeDataCode();
			$p->outDataCodeToStd();		 
		}

		function getTitle()
		{
			global $cat_m_title, $cat_pos;
			
			$str = "$cat_m_title :: ";
			switch($cat_pos) {
				case('system') : {
					$str .= $GLOBALS[cat_m_system];
					break;
				};
				case('info') : {
					$str .= $GLOBALS[cat_m_info];
					break;
				};
				case('control') : {
					$str .= $GLOBALS[cat_m_control];
					break;
				};
				default: {
					$str .= $GLOBALS[cat_m_enter];
				}
			};
			return $str;
		}

		function getProjectInfo()
		{
			global $cat_m_title, $cat_m_comment;
			
			$str = "<font class='title'><b>$cat_m_title</b></font><br>
				<font class='pt8' color='#666666'>$cat_m_comment</font>";
			return $str;
		}

		function getMenu()
		{
			$str = "<table border='0' cellpadding='2' cellspacing='0' width='100%' class='pt8'>";

			if($this->user->isSystem()) {
				$str .= "<tr><td valign='top' align='left' class='pt9'>&nbsp;&nbsp;<img src='images/minus.gif' width='11' height='11' alt='' border='0'>&nbsp;&nbsp;<a href='?cat_pos=system' class='qmenu'><b>$GLOBALS[cat_m_system]</b></a></td></tr>";
				$obj = new System($this->user);
				$str .= $obj->makeMenu();
			}; // else  $str .= "<tr><td valign='top' align='left' class='pt9'>&nbsp;&nbsp;<img src='images/plus.gif' width='11' height='11' alt='' border='0'>&nbsp;&nbsp;<a href='#' class='qmenu'><b>$GLOBALS[cat_m_system]</b></a></td></tr>";

			if($this->user->isInfo()) {
				$str .= "<tr><td valign='top' align='left' class='pt9'>&nbsp;&nbsp;<img src='images/minus.gif' width='11' height='11' alt='' border='0'>&nbsp;&nbsp;<a href='?cat_pos=info' class='qmenu'><b>$GLOBALS[cat_m_info]</b></a></td></tr>";
				$obj = new Info($this->user);
				$str .= $obj->makeMenu();
			}; // else  $str .= "<tr><td valign='top' align='left' class='pt9'>&nbsp;&nbsp;<img src='images/plus.gif' width='11' height='11' alt='' border='0'>&nbsp;&nbsp;<a href='#' class='qmenu'><b>$GLOBALS[cat_m_info]</b></a></td></tr>";

			if($this->user->isControl()) {
				$str .= "<tr><td valign='top' align='left' class='pt9'>&nbsp;&nbsp;<img src='images/minus.gif' width='11' height='11' alt='' border='0'>&nbsp;&nbsp;<a href='?cat_pos=control' class='qmenu'><b>$GLOBALS[cat_m_control]</b></a></td></tr>";
				$obj = new Control($this->user);
				$str .= $obj->makeMenu();
			}; // else  $str .= "<tr><td valign='top' align='left' class='pt9'>&nbsp;&nbsp;<img src='images/plus.gif' width='11' height='11' alt='' border='0'>&nbsp;&nbsp;<a href='#' class='qmenu'><b>$GLOBALS[cat_m_control]</b></a></td></tr>";

			// $str .= "<tr><td valign='top' align='left'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='#' class='wmenu'><b>wmenu</b></a></td></tr>";
			// $str .= "<tr><td valign='top' align='left'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='#' class='emenu'>emenu</a></td></tr>";
			
			$str .= "</table>";
			return $str;
		}

		function getContain()
		{
			$str = "<font class='title'><b>$GLOBALS[cat_m_error]</b></font><br>$GLOBALS[cat_m_error_comment]";
	
			if(strlen($this->actionresult) > 0) return $this->actionresult;
			else return $str;
		}

	}


?>