<?

	require_once "xslt/codegen/agents/_base.php";
	define('MAX_NEWS_PP',5);

	class NewsGenAgent extends BaseGenAgent
	{
		function NewsGenAgent()
		{}

		//
	 	// Process
		//
		
		function process($begin,$total)
		{
		        global $cat_db;
			
			$s = '<news>';
		
			$res = $cat_db->query("select * from news order by tmark desc limit $begin,".MAX_NEWS_PP);
			foreach($res as $r) {
				$s .= "<newsentry id='$r[id_news]'>";
				$s .= "<tmark>".DateToStrDO($r[tmark])."</tmark>";
				$s .= "<title>$r[title]</title>";
				if(strlen($r[photo]) > 2 && file_exists('../'.$r[photo])) $s .= "<photo>$r[photo]</photo>";
				$s .= "<info>".xmlParseToHTML($r[info])."</info>";
				if(strlen($r[link]) > 1) $s .= "<link>$r[link]</link>";
				$s .= "</newsentry>";	
			};		

			$s .= $this->tStatPager($total,$begin,MAX_NEWS_PP,10,'news_','.html','index.html');
			$s .= '</news>';
			return $s;
		}	

		function execute()
		{
			$res = array();
			$s = '';
			$filename = '';

			global $cat_db;
	
			$res = $cat_db->query("select count(id_news) from news");
			
			if(count($res) != 1) return;
			$c = $res[0]['count(id_news)'];

			if($c % MAX_NEWS_PP == 0) $cp = floor($c / MAX_NEWS_PP);
			else $cp = floor($c / MAX_NEWS_PP) + 1; 			

			for($i = 0; $i < $cp; $i++) {			
				if($i == 0) $filename = "news/index.html";
				else $filename = "news/news_".($i + 1).".html";

				$s = $this->preprocess($filename,'news');
				$s .= $this->process($i * MAX_NEWS_PP,$c);
				$s .= $this->postprocess();

				// print "$s";
				
		                $res[$i] = new GenPage($filename);
				$res[$i]->applyXML($s);
				
			};		
			return $res;
		}	
		

	};

?>