<?xml version="1.0" encoding="Windows-1251"?>
<!DOCTYPE xsl:stylesheet>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="format">
        <xsl:apply-templates select="bl|un|it|cd|small|text|txt|br|sp|link|image|lit"/>
</xsl:template>

<xsl:template match="bl">
	<b><xsl:value-of select="."/></b>
</xsl:template>

<xsl:template match="un">
	<u><xsl:value-of select="."/></u>
</xsl:template>

<xsl:template match="it">
	<i><xsl:value-of select="."/></i>
</xsl:template>

<xsl:template match="lit">
	<li><xsl:value-of select="."/></li>
</xsl:template>

<xsl:template match="cd">
	<code><xsl:value-of select="."/></code>
</xsl:template>

<xsl:template match="small">
	<small><xsl:value-of select="."/></small>
</xsl:template>


<xsl:template match="text">
	<font>
		<xsl:attribute name="color">
		<xsl:value-of select="@color"/>
    		</xsl:attribute>
	<xsl:value-of select="."/>
	</font>
</xsl:template>

<xsl:template match="txt">
	<xsl:value-of select="."/>
</xsl:template>

<xsl:template match="br">
	<br/>
</xsl:template>

<xsl:template match="sp">
	<img src="images/s_default/spacer.gif" alt="" width="25" height="1" border="0"/>
</xsl:template>

<xsl:template match="link">
	<a>
        	<xsl:attribute name="href">
		<xsl:value-of select="@href"/>
    		</xsl:attribute>
	<xsl:value-of select="."/>
	</a>
</xsl:template>

<xsl:template match="image">
	<xsl:element name="img">
			<xsl:attribute name="align">
				<xsl:value-of select="@align"/>
		    </xsl:attribute>        	
        	<xsl:attribute name="src">
                <xsl:value-of select="@src"/>
            </xsl:attribute>
        	<xsl:attribute name="border">0</xsl:attribute>
	</xsl:element> 
</xsl:template>

<xsl:template match="item">
        <xsl:value-of select="." disable-output-escaping="yes" />
</xsl:template>


</xsl:stylesheet>
