-- MySQL dump 10.11
--
-- Host: localhost    Database: freerealty
-- ------------------------------------------------------
-- Server version	5.0.51a-24+lenny4

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `agent_tbl_Files`
--

DROP TABLE IF EXISTS `agent_tbl_Files`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `agent_tbl_Files` (
  `id_files` int(11) NOT NULL auto_increment,
  `bin_data` longblob NOT NULL,
  `description` tinytext,
  `filename` varchar(50) default NULL,
  `filesize` varchar(50) default NULL,
  `filetype` varchar(50) default NULL,
  `agentnum` int(11) default NULL,
  `owner` int(11) default NULL,
  `thumb` longblob,
  `thumb_size` varchar(50) default NULL,
  `thumb_filetype` varchar(50) default NULL,
  PRIMARY KEY  (`id_files`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `agents`
--

DROP TABLE IF EXISTS `agents`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `agents` (
  `agent_id` int(11) NOT NULL auto_increment,
  `agent` varchar(30) default NULL,
  `agentpass` varchar(10) default NULL,
  `agenturl` varchar(70) default NULL,
  `agentemail` varchar(70) default NULL,
  `notes` text,
  `agentphone` varchar(30) default NULL,
  `agentcell` varchar(30) default NULL,
  `agentfax` varchar(30) default NULL,
  `agenttitle` varchar(30) default NULL,
  `priority` int(11) default NULL,
  `active` enum('no','yes') default NULL,
  `status` enum('no','yes') default NULL,
  `user_level` enum('agent','authorized user','admin') default NULL,
  PRIMARY KEY  (`agent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1178 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `configuration`
--

DROP TABLE IF EXISTS `configuration`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `configuration` (
  `config_key` varchar(30) NOT NULL,
  `config_value` varchar(51) default NULL,
  `config_label` varchar(50) default NULL,
  `allowed_values` varchar(30) default NULL,
  `description_text_field` varchar(130) default NULL,
  PRIMARY KEY  (`config_key`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `defaults`
--

DROP TABLE IF EXISTS `defaults`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `defaults` (
  `defaultid` varchar(25) NOT NULL,
  `defaultvalue` varchar(50) default NULL,
  PRIMARY KEY  (`defaultid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `features`
--

DROP TABLE IF EXISTS `features`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `features` (
  `features_key` int(11) NOT NULL auto_increment,
  `description` varchar(50) default NULL,
  `feature_type` int(11) default NULL,
  PRIMARY KEY  (`features_key`),
  KEY `idx_feature_type` (`feature_type`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `floorplan`
--

DROP TABLE IF EXISTS `floorplan`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `floorplan` (
  `floorplan_idx` int(1) default NULL,
  `home_id` int(11) default NULL,
  `floorplan_id` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `freerealty`
--

DROP TABLE IF EXISTS `freerealty`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `freerealty` (
  `version` char(20) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `heat_types`
--

DROP TABLE IF EXISTS `heat_types`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `heat_types` (
  `id` int(3) NOT NULL auto_increment,
  `heat` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `homes`
--

DROP TABLE IF EXISTS `homes`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `homes` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(250) default NULL,
  `address` varchar(250) default NULL,
  `city` varchar(50) default NULL,
  `state` char(4) default NULL,
  `zip` varchar(20) default NULL,
  `price` int(11) default NULL,
  `previewdesc` text,
  `fulldesc` text,
  `type` char(3) default NULL,
  `imageloc` varchar(50) default NULL,
  `beds` int(11) default NULL,
  `baths` float default NULL,
  `status` char(3) default NULL,
  `featured` char(1) default NULL,
  `mls` varchar(20) default NULL,
  `dateposted` date default NULL,
  `neighborhood` varchar(50) default NULL,
  `notes` text,
  `owner` int(11) default NULL,
  `numfloors` varchar(30) default NULL,
  `yearbuilt` int(11) default NULL,
  `sqfeet` varchar(30) default NULL,
  `lotsize` varchar(30) default NULL,
  `garagesize` varchar(30) default NULL,
  `proptax` int(11) default NULL,
  `country` varchar(30) default NULL,
  `virtualtour` varchar(60) default NULL,
  `dateavailable` varchar(30) default NULL,
  `heat` char(3) default NULL,
  `style` char(3) default NULL,
  `onmarket` varchar(10) default NULL,
  `price_low` int(11) default NULL,
  `price_hi` int(11) default NULL,
  `posteddate` date default NULL,
  `updated` date default NULL,
  `dateupdated` date default NULL,
  `reverse` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=181 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `homes_features`
--

DROP TABLE IF EXISTS `homes_features`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `homes_features` (
  `ref_homes` int(11) NOT NULL default '0',
  `ref_features` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ref_homes`,`ref_features`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `nearby`
--

DROP TABLE IF EXISTS `nearby`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `nearby` (
  `nearby_idx` int(1) default NULL,
  `home_id` int(11) default NULL,
  `nearby_id` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `property_styles`
--

DROP TABLE IF EXISTS `property_styles`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `property_styles` (
  `id` int(3) NOT NULL auto_increment,
  `property_style` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `property_types`
--

DROP TABLE IF EXISTS `property_types`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `property_types` (
  `id` int(3) NOT NULL auto_increment,
  `property_type` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `states` (
  `id` char(4) NOT NULL,
  `state` varchar(30) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `statuses`
--

DROP TABLE IF EXISTS `statuses`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `statuses` (
  `id` int(3) NOT NULL auto_increment,
  `status` varchar(35) default NULL,
  `shown` char(1) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `tbl_Files`
--

DROP TABLE IF EXISTS `tbl_Files`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `tbl_Files` (
  `id_files` int(11) NOT NULL auto_increment,
  `bin_data` longblob NOT NULL,
  `description` tinytext,
  `filename` varchar(50) default NULL,
  `filesize` varchar(50) default NULL,
  `filetype` varchar(50) default NULL,
  `prop_num` int(11) default NULL,
  `owner` int(11) default NULL,
  `thumb` longblob,
  `thumb_size` varchar(50) default NULL,
  `thumb_filetype` varchar(50) default NULL,
  `height` int(11) default NULL,
  `width` int(11) default NULL,
  `image_order` int(3) default NULL,
  PRIMARY KEY  (`id_files`)
) ENGINE=MyISAM AUTO_INCREMENT=345 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `update_log`
--

DROP TABLE IF EXISTS `update_log`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `update_log` (
  `id` int(11) NOT NULL auto_increment,
  `prop_id` int(11) default NULL,
  `changed_items` mediumtext,
  `user` varchar(25) default NULL,
  `changed_time` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `log_type` varchar(8) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `users` (
  `user_key` int(3) NOT NULL auto_increment,
  `user` varchar(30) default NULL,
  `password` varchar(30) default NULL,
  `user_level` enum('admin','authorized user') default NULL,
  PRIMARY KEY  (`user_key`),
  UNIQUE KEY `user` (`user`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2010-06-26 14:14:15
