/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.ChanList;
import irc.Channel;
import irc.ChannelInfo;
import irc.FirstLineFilter;
import irc.IRCConfiguration;
import irc.IRCObject;
import irc.IRCSource;
import irc.ListenerGroup;
import irc.MessageServerListener;
import irc.ModeHandler;
import irc.MultiModeHandler;
import irc.Query;
import irc.ReplyServerListener;
import irc.Server;
import irc.ServerListener;
import irc.ServerManager;
import irc.ServerProtocol;
import irc.ServerProtocolListener;
import irc.Source;
import irc.Status;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class IRCServer
extends IRCObject
implements Server,
ServerProtocolListener {
    private ServerProtocol _protocol;
    private Hashtable _channels;
    private Hashtable _queries;
    private Hashtable _chanlist;
    private Status _status;
    private Hashtable _ignoreList;
    private ListenerGroup _listeners;
    private ListenerGroup _replylisteners;
    private ListenerGroup _messagelisteners;
    private String[] _askedNick;
    private String _nick;
    private String _userName;
    private int _tryNickIndex;
    private ModeHandler _mode;
    private String[] _host;
    private int[] _port;
    private String[] _passWord;
    private int _tryServerIndex;
    private boolean _connected;
    private String _name;
    private Source _defaultSource;
    private boolean _serverLeaving;
    private boolean _registered;
    private FirstLineFilter _filter;
    private char[] _nickModes = new char[]{'o', 'h', 'v'};
    private char[] _nickPrefixes = new char[]{'@', '%', '+'};
    private char[] _channelPrefixes = new char[]{'#', '&', '!', '+'};
    private char[][] _globalModes = new char[][]{{'b'}, {'k'}, {'l'}, {'i', 'm', 'n', 'p', 's', 't', 'a', 'q', 'r'}};

    public IRCServer(IRCConfiguration iRCConfiguration, ServerManager serverManager, String string, String string2, String string3, String string4) {
        super(iRCConfiguration);
        this._filter = new FirstLineFilter(this, serverManager, iRCConfiguration);
        this._serverLeaving = false;
        this._name = string4;
        this._userName = string3;
        this._askedNick = new String[2];
        this._askedNick[0] = string;
        this._askedNick[1] = string2;
        this._nick = string;
        this._connected = false;
        this._ignoreList = new Hashtable();
        this._channels = new Hashtable();
        this._queries = new Hashtable();
        this._chanlist = new Hashtable();
        this._listeners = new ListenerGroup();
        this._replylisteners = new ListenerGroup();
        this._messagelisteners = new ListenerGroup();
        this._status = new Status(this._ircConfiguration, this);
        this._defaultSource = this._status;
        this._protocol = new ServerProtocol(this._ircConfiguration);
        this._protocol.addServerProtocolListener(this);
        this._host = null;
        this._mode = new ModeHandler(this._globalModes, this._nickModes);
    }

    public Object[] specialRequest(String string, Object[] objectArray) {
        return this._listeners.sendEvent("specialServerRequest", string, this, objectArray);
    }

    public void release() {
        this._protocol.removeServerProtocolListener(this);
        this._filter.release();
        super.release();
    }

    public Enumeration getSources() {
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this._channels.elements();
        while (enumeration.hasMoreElements()) {
            vector.insertElementAt(enumeration.nextElement(), vector.size());
        }
        enumeration = this._queries.elements();
        while (enumeration.hasMoreElements()) {
            vector.insertElementAt(enumeration.nextElement(), vector.size());
        }
        enumeration = this._chanlist.elements();
        while (enumeration.hasMoreElements()) {
            vector.insertElementAt(enumeration.nextElement(), vector.size());
        }
        if (this._status != null) {
            vector.insertElementAt(this._status, vector.size());
        }
        return vector.elements();
    }

    public void enumerateSourcesAsCreated(ServerListener serverListener) {
        Enumeration enumeration = this._channels.elements();
        while (enumeration.hasMoreElements()) {
            serverListener.sourceCreated((Source)enumeration.nextElement(), this, new Boolean(false));
        }
        enumeration = this._queries.elements();
        while (enumeration.hasMoreElements()) {
            serverListener.sourceCreated((Source)enumeration.nextElement(), this, new Boolean(false));
        }
        enumeration = this._chanlist.elements();
        while (enumeration.hasMoreElements()) {
            serverListener.sourceCreated((Source)enumeration.nextElement(), this, new Boolean(false));
        }
        if (this._status != null) {
            serverListener.sourceCreated(this._status, this, new Boolean(true));
        }
    }

    public void enumerateSourcesAsRemoved(ServerListener serverListener) {
        Enumeration enumeration = this._channels.elements();
        while (enumeration.hasMoreElements()) {
            serverListener.sourceRemoved((Source)enumeration.nextElement(), this);
        }
        enumeration = this._queries.elements();
        while (enumeration.hasMoreElements()) {
            serverListener.sourceRemoved((Source)enumeration.nextElement(), this);
        }
        enumeration = this._chanlist.elements();
        while (enumeration.hasMoreElements()) {
            serverListener.sourceRemoved((Source)enumeration.nextElement(), this);
        }
        if (this._status != null) {
            serverListener.sourceRemoved(this._status, this);
        }
    }

    public void setDefaultSource(Source source) {
        this._defaultSource = source;
    }

    public Source getDefaultSource() {
        return this._defaultSource;
    }

    public void setServers(String[] stringArray, int[] nArray, String[] stringArray2) {
        int n;
        this._tryServerIndex = 0;
        this._host = new String[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this._host[n] = stringArray[n];
        }
        this._port = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            this._port[n] = nArray[n];
        }
        this._passWord = new String[stringArray2.length];
        for (n = 0; n < stringArray2.length; ++n) {
            this._passWord[n] = stringArray2[n];
        }
    }

    public void connect() {
        this._tryServerIndex = 0;
        if (this._host != null) {
            this.connect(this._host, this._port, this._passWord);
        }
    }

    private void connect(String[] stringArray, int[] nArray, String[] stringArray2) {
        this._registered = false;
        if (this._tryServerIndex == this._host.length) {
            return;
        }
        this._tryNickIndex = 0;
        this._passWord = stringArray2;
        if (this._protocol.connecting()) {
            this.sendStatusMessage(this.getText(1282, stringArray[this._tryServerIndex], this._host[this._tryServerIndex]));
            return;
        }
        if (this._protocol.connected()) {
            this._protocol.disconnect();
        }
        this._connected = false;
        this.sendStatusMessage(this.getText(1284));
        this._protocol.connect(stringArray[this._tryServerIndex], nArray[this._tryServerIndex]);
    }

    public void disconnect() {
        if (this._protocol.connected()) {
            if (this._ircConfiguration.getS("quitmessage").length() == 0) {
                this.execute("QUIT");
            } else {
                this.execute("QUIT :" + this._ircConfiguration.get("quitmessage"));
            }
        } else {
            this.sendStatusMessage(this.getText(1285));
        }
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void connectionFailed(String string, String string2) {
        this.sendStatusMessage(this.getText(1281, string));
        ++this._tryServerIndex;
        if (this._tryServerIndex < this._host.length) {
            this.connect(this._host, this._port, this._passWord);
        }
    }

    private void nickUsed() {
        if (this._tryNickIndex >= this._askedNick.length) {
            Object[] objectArray = this._listeners.sendEvent("cannotUseRequestedNicknames", new Object[]{this});
            if (objectArray.length > 0) {
                this._askedNick = (String[])objectArray[0];
            }
            this._tryNickIndex = 0;
        } else if (this._askedNick[this._tryNickIndex].indexOf("?") == -1) {
            ++this._tryNickIndex;
        }
    }

    private void register() {
        String string = this._askedNick[this._tryNickIndex];
        if (string.length() == 0) {
            string = "Anon????";
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '?') {
                c = (char)(48.0 + Math.random() * 10.0);
            }
            string2 = string2 + c;
        }
        if (this._passWord[this._tryServerIndex].length() > 0) {
            this.execute("pass " + this._passWord[this._tryServerIndex]);
        }
        this.execute("nick " + string2);
        String string3 = this._ircConfiguration.getS("userid");
        if (string3.length() == 0) {
            string3 = string2;
        }
        if (!this._registered) {
            this._registered = true;
            this.execute("user " + string3 + " 0 0 :" + this._userName);
        }
    }

    public int getLocalPort() {
        return this._protocol.getLocalPort();
    }

    public void connected(String string) {
        this.sendStatusMessage(this.getText(1286));
        this.register();
    }

    private void clear(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            this._listeners.sendEvent("sourceRemoved", enumeration.nextElement(), this);
        }
        enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((Source)enumeration.nextElement()).release();
        }
        hashtable.clear();
    }

    public void disconnected(String string) {
        this.sendStatusMessage(this.getText(1287, string));
        this.clear(this._channels);
        this.clear(this._queries);
        this.clear(this._chanlist);
        this._mode.reset();
        if (this._status != null) {
            this._status.modeChanged(this.getMode());
        }
        this._connected = false;
        this._listeners.sendEvent("serverDisconnected", this);
        if (this._serverLeaving) {
            this._listeners.sendEvent("sourceRemoved", this._status, this);
            this.deleteStatus("");
            this._listeners.sendEvent("serverLeft", this);
        }
    }

    public void sendStatusMessage(String string) {
        if (this._status != null) {
            this._status.report(string);
        }
    }

    public Enumeration getChannels() {
        return this._channels.elements();
    }

    public Enumeration getQueries() {
        return this._queries.elements();
    }

    public Enumeration getChanLists() {
        return this._chanlist.elements();
    }

    public Channel getChannel(String string, boolean bl) {
        Channel channel = (Channel)this._channels.get(string.toLowerCase(Locale.ENGLISH));
        if (channel == null && bl) {
            channel = new Channel(this._ircConfiguration, string, this);
            this._channels.put(string.toLowerCase(Locale.ENGLISH), channel);
            this._listeners.sendEvent("sourceCreated", channel, this, new Boolean(true));
        }
        return channel;
    }

    public Query getQuery(String string, boolean bl) {
        if (!this._connected) {
            return null;
        }
        if (this._ircConfiguration.getB("disablequeries")) {
            return null;
        }
        Query query = (Query)this._queries.get(string.toLowerCase(Locale.ENGLISH));
        if (query == null) {
            query = new Query(this._ircConfiguration, string, this);
            this._queries.put(string.toLowerCase(Locale.ENGLISH), query);
            this._listeners.sendEvent("sourceCreated", query, this, new Boolean(bl));
        }
        return query;
    }

    private ChanList getChanList(String string) {
        ChanList chanList = (ChanList)this._chanlist.get(string.toLowerCase(Locale.ENGLISH));
        if (chanList == null) {
            chanList = new ChanList(this._ircConfiguration, this, string);
            this._chanlist.put(string.toLowerCase(Locale.ENGLISH), chanList);
            this._listeners.sendEvent("sourceCreated", chanList, this, new Boolean(true));
        }
        return chanList;
    }

    public void leaveChannel(String string) {
        this.execute("part " + string);
    }

    public void leaveQuery(String string) {
        Query query = this.getQuery(string, false);
        if (query == null) {
            return;
        }
        this._listeners.sendEvent("sourceRemoved", query, this);
        this.deleteQuery(string);
    }

    public void leave() {
        this.leaveStatus("");
    }

    public void leaveStatus(String string) {
        if (this._status == null) {
            return;
        }
        if (this.isConnected()) {
            this._serverLeaving = true;
            this.disconnect();
        } else {
            this._listeners.sendEvent("sourceRemoved", this._status, this);
            this.deleteStatus("");
            this._listeners.sendEvent("serverLeft", this);
        }
    }

    public void leaveChanList(String string) {
        this._listeners.sendEvent("sourceRemoved", this.getChanList(string), this);
        this.deleteChanList(string);
    }

    private void deleteSource(Source source) {
        if (source == this._defaultSource) {
            this._defaultSource = null;
        }
        source.release();
    }

    private void deleteChannel(String string) {
        this.deleteSource((Source)this._channels.remove(string.toLowerCase(Locale.ENGLISH)));
    }

    private void deleteQuery(String string) {
        this.deleteSource((Source)this._queries.remove(string.toLowerCase(Locale.ENGLISH)));
    }

    private void deleteChanList(String string) {
        this.deleteSource((Source)this._chanlist.remove(string.toLowerCase(Locale.ENGLISH)));
    }

    private void deleteStatus(String string) {
        this.deleteSource(this._status);
        this._status = null;
    }

    public String getServerName() {
        if (this._name.length() == 0) {
            if (this._tryServerIndex < this._host.length) {
                return this._host[this._tryServerIndex];
            }
            return this._host[0];
        }
        return this._name;
    }

    public Status getStatus() {
        return this._status;
    }

    public void addServerListener(ServerListener serverListener) {
        this._listeners.addListener(serverListener);
    }

    public void removeServerListener(ServerListener serverListener) {
        this._listeners.removeListener(serverListener);
    }

    public void addReplyServerListener(ReplyServerListener replyServerListener) {
        this._replylisteners.addListener(replyServerListener);
    }

    public void addMessageServerListener(MessageServerListener messageServerListener) {
        this._messagelisteners.addListener(messageServerListener);
    }

    public void removeReplyServerListener(ReplyServerListener replyServerListener) {
        this._replylisteners.removeListener(replyServerListener);
    }

    public void removeMessageServerListener(MessageServerListener messageServerListener) {
        this._messagelisteners.removeListener(messageServerListener);
    }

    public char[] getChannelPrefixes() {
        return this._channelPrefixes;
    }

    public char[] getNickPrefixes() {
        return this._nickPrefixes;
    }

    public char[] getNickModes() {
        return this._nickModes;
    }

    public char[][] getChannelModes() {
        return this._globalModes;
    }

    public String getNickPrefix(String string) {
        if (string.length() == 0) {
            return "";
        }
        char c = string.charAt(0);
        for (int i = 0; i < this._nickModes.length; ++i) {
            if (this._nickModes[i] != c) continue;
            return "" + this._nickPrefixes[i];
        }
        return "";
    }

    public String getNickMode(String string) {
        if (string.length() == 0) {
            return "";
        }
        char c = string.charAt(0);
        for (int i = 0; i < this._nickPrefixes.length; ++i) {
            if (this._nickPrefixes[i] != c) continue;
            return "" + this._nickModes[i];
        }
        return "";
    }

    private void setNicks(Channel channel, Vector vector) {
        String[] stringArray = new String[vector.size()];
        String[] stringArray2 = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
            stringArray2[i] = "";
            if (stringArray[i].length() <= 0) continue;
            stringArray2[i] = this.getNickMode("" + stringArray[i].charAt(0));
            if (stringArray2[i].length() == 0) continue;
            stringArray[i] = stringArray[i].substring(1);
        }
        channel.setNicks(stringArray, stringArray2);
    }

    private void decodeVariable(String string, String string2) {
        block14: {
            int n;
            block15: {
                block13: {
                    int n2;
                    if (!string.toLowerCase(Locale.ENGLISH).equals("prefix")) break block13;
                    if (!string2.startsWith("(")) {
                        return;
                    }
                    int n3 = string2.indexOf(")");
                    if (n3 < 0) {
                        return;
                    }
                    String string3 = string2.substring(1, n3);
                    String string4 = string2.substring(n3 + 1);
                    if (string4.length() != string3.length()) {
                        return;
                    }
                    this._nickModes = new char[string3.length()];
                    for (n2 = 0; n2 < string3.length(); ++n2) {
                        this._nickModes[n2] = string3.charAt(n2);
                    }
                    this._nickPrefixes = new char[string3.length()];
                    for (n2 = 0; n2 < string4.length(); ++n2) {
                        this._nickPrefixes[n2] = string4.charAt(n2);
                    }
                    break block14;
                }
                if (!string.toLowerCase(Locale.ENGLISH).equals("chantypes")) break block15;
                this._channelPrefixes = new char[string2.length()];
                for (int i = 0; i < this._channelPrefixes.length; ++i) {
                    this._channelPrefixes[i] = string2.charAt(i);
                }
                break block14;
            }
            if (!string.toLowerCase(Locale.ENGLISH).equals("chanmodes")) break block14;
            int n4 = string2.indexOf(44);
            if (n4 < 0) {
                return;
            }
            String string5 = string2.substring(0, n4);
            if ((n4 = (string2 = string2.substring(n4 + 1)).indexOf(44)) < 0) {
                return;
            }
            String string6 = string2.substring(0, n4);
            if ((n4 = (string2 = string2.substring(n4 + 1)).indexOf(44)) < 0) {
                return;
            }
            String string7 = string2.substring(0, n4);
            String string8 = string2.substring(n4 + 1);
            this._globalModes = new char[4][];
            this._globalModes[0] = new char[string5.length()];
            for (n = 0; n < string5.length(); ++n) {
                this._globalModes[0][n] = string5.charAt(n);
            }
            this._globalModes[1] = new char[string6.length()];
            for (n = 0; n < string6.length(); ++n) {
                this._globalModes[1][n] = string6.charAt(n);
            }
            this._globalModes[2] = new char[string7.length()];
            for (n = 0; n < string7.length(); ++n) {
                this._globalModes[2][n] = string7.charAt(n);
            }
            this._globalModes[3] = new char[string8.length()];
            for (n = 0; n < string8.length(); ++n) {
                this._globalModes[3][n] = string8.charAt(n);
            }
        }
    }

    private void learnServerVariables(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            int n = string3.indexOf(61);
            if (n < 0) {
                string2 = string3;
                string = "";
            } else {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            }
            this.decodeVariable(string2, string);
        }
        this._mode = new ModeHandler(this._globalModes, this._nickModes);
    }

    public void replyReceived(String string, String string2, String[] stringArray) {
        Channel channel;
        int n;
        Object[] objectArray = this._replylisteners.sendEvent("replyReceived", new Object[]{string, string2, stringArray, this});
        for (n = 0; n < objectArray.length; ++n) {
            if (!((Boolean)objectArray[n]).booleanValue()) continue;
            return;
        }
        if (string2.equals("324")) {
            Channel channel2 = this.getChannel(stringArray[1], false);
            if (channel2 != null) {
                String string3 = "";
                for (int i = 2; i < stringArray.length; ++i) {
                    string3 = string3 + " " + stringArray[i];
                }
                string3 = string3.substring(1);
                channel2.applyMode(string3, "");
            }
        } else if (string2.equals("332")) {
            Channel channel3 = this.getChannel(stringArray[1], false);
            if (channel3 != null) {
                channel3.setTopic(stringArray[2], "");
            }
        } else if (string2.equals("353")) {
            Channel channel4;
            n = 1;
            if (stringArray[1].length() == 1) {
                ++n;
            }
            if ((channel4 = this.getChannel(stringArray[n], false)) != null) {
                String string4 = "";
                Vector<String> vector = new Vector<String>();
                for (int i = 0; i < stringArray[n + 1].length(); ++i) {
                    char c = stringArray[n + 1].charAt(i);
                    if (c == ' ') {
                        if (string4.length() > 0) {
                            vector.insertElementAt(string4, vector.size());
                        }
                        string4 = "";
                        continue;
                    }
                    string4 = string4 + c;
                }
                if (string4.length() > 0) {
                    vector.insertElementAt(string4, vector.size());
                }
                this.setNicks(channel4, vector);
            }
        } else if (string2.equals("001")) {
            String string5 = stringArray[0];
            if (!string5.equals(this._nick)) {
                this._nick = string5;
                if (this._status != null) {
                    this._status.nickChanged(string5);
                }
            }
            this._connected = true;
            this._listeners.sendEvent("serverConnected", this);
        } else if (string2.equals("005")) {
            this.learnServerVariables(stringArray);
        } else if (string2.equals("321")) {
            this.getChanList(this._host[this._tryServerIndex]).begin();
        } else if (string2.equals("322")) {
            String string6 = stringArray[1];
            int n2 = new Integer(stringArray[2]);
            if (n2 < Short.MAX_VALUE && this.isChannel(string6)) {
                String string7 = stringArray[3];
                this.getChanList(this._host[this._tryServerIndex]).addChannel(new ChannelInfo(string6, string7, n2));
            }
        } else if (string2.equals("323")) {
            this.getChanList(this._host[this._tryServerIndex]).end();
        } else if (string2.equals("433")) {
            if (!this._connected) {
                this.nickUsed();
                this.register();
            }
        } else if (string2.equals("473") || string2.equals("471") || string2.equals("403") || string2.equals("474") || string2.equals("475") || string2.equals("476") || string2.equals("405")) {
            String string8 = stringArray[1];
            Channel channel5 = this.getChannel(string8, false);
            if (channel5 != null) {
                this.sendStatusMessage(this.getText(1290, string8));
                this._listeners.sendEvent("sourceRemoved", channel5, this);
                this.deleteChannel(string8);
            }
        } else if (string2.equals("442") && (channel = this.getChannel(stringArray[1], false)) != null) {
            this._listeners.sendEvent("sourceRemoved", channel, this);
            this.deleteChannel(channel.getName());
        }
    }

    private String extractNick(String string) {
        int n = string.indexOf(33);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private boolean isChannel(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < this._channelPrefixes.length; ++i) {
            if (string.charAt(0) != this._channelPrefixes[i]) continue;
            return true;
        }
        return false;
    }

    private void globalNickRemove(String string, String string2) {
        Enumeration enumeration = this._channels.elements();
        while (enumeration.hasMoreElements()) {
            Channel channel = (Channel)enumeration.nextElement();
            if (!channel.hasNick(string)) continue;
            channel.quitNick(string, string2);
        }
    }

    private void globalNickChange(String string, String string2) {
        IRCSource iRCSource;
        Enumeration enumeration = this._channels.elements();
        while (enumeration.hasMoreElements()) {
            iRCSource = (Channel)enumeration.nextElement();
            if (!((Channel)iRCSource).hasNick(string)) continue;
            ((Channel)iRCSource).changeNick(string, string2);
        }
        iRCSource = (Query)this._queries.get(string.toLowerCase(Locale.ENGLISH));
        if (iRCSource != null) {
            this._queries.remove(string.toLowerCase(Locale.ENGLISH));
            ((Query)iRCSource).changeNick(string2);
            Query query = (Query)this._queries.get(string2.toLowerCase(Locale.ENGLISH));
            if (query != null) {
                query.leave();
            }
            this._queries.put(string2.toLowerCase(Locale.ENGLISH), iRCSource);
        }
    }

    public synchronized boolean ignore(String string) {
        return this._ignoreList.get(string) != null;
    }

    public synchronized void addIgnore(String string) {
        this._ignoreList.put(string, string);
    }

    public synchronized void removeIgnore(String string) {
        this._ignoreList.remove(string);
    }

    public void messageReceived(String string, String string2, String[] stringArray) {
        Object[] objectArray = this._messagelisteners.sendEvent("messageReceived", new Object[]{string, string2, stringArray, this});
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((Boolean)objectArray[i]).booleanValue()) continue;
            return;
        }
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string3 = string3 + " " + stringArray[i];
        }
        string2 = string2.toLowerCase(Locale.ENGLISH);
        String string4 = this.extractNick(string);
        if (string2.equals("notice")) {
            if (!this.ignore(string4) && !this._filter.performFromNotice(string4, stringArray[1]) && this._defaultSource != null) {
                this._defaultSource.noticeReceived(string4, stringArray[1]);
            }
        } else if (string2.equals("privmsg")) {
            if (!this.ignore(string4)) {
                Query query;
                if (this.isChannel(stringArray[0])) {
                    Channel channel;
                    if (!this._filter.performFromChannelMessage(stringArray[0], string4, stringArray[1]) && (channel = this.getChannel(stringArray[0], false)) != null) {
                        channel.messageReceived(string4, stringArray[1]);
                    }
                } else if (!this._filter.performFromNickMessage(string4, stringArray[1]) && (query = this.getQuery(string4, false)) != null) {
                    query.messageReceived(string4, stringArray[1]);
                }
            }
        } else if (string2.equals("join")) {
            if (!string4.equals(this.getNick())) {
                Channel channel = this.getChannel(stringArray[0], false);
                if (channel != null) {
                    channel.joinNick(string4, "");
                }
            } else {
                Channel channel = this.getChannel(stringArray[0], true);
                if (channel != null) {
                    channel.resetNicks();
                    this.execute("mode " + stringArray[0]);
                }
            }
        } else if (string2.equals("part")) {
            Channel channel = this.getChannel(stringArray[0], false);
            if (channel != null) {
                if (stringArray.length > 1) {
                    channel.partNick(string4, stringArray[1]);
                } else {
                    channel.partNick(string4, "");
                }
                if (string4.equals(this.getNick())) {
                    this._listeners.sendEvent("sourceRemoved", channel, this);
                    this.deleteChannel(channel.getName());
                }
            }
        } else if (string2.equals("kick")) {
            Channel channel = this.getChannel(stringArray[0], false);
            if (channel != null) {
                String string5 = stringArray[1];
                String string6 = "";
                if (stringArray.length > 2) {
                    string6 = stringArray[2];
                }
                channel.kickNick(string5, string4, string6);
                if (string5.equals(this.getNick())) {
                    if (this._ircConfiguration.getB("autorejoin")) {
                        channel.report(this.getText(1289, channel.getName()));
                        this.execute("join " + stringArray[0]);
                    } else {
                        this._listeners.sendEvent("sourceRemoved", channel, this);
                        this.deleteChannel(channel.getName());
                    }
                }
            }
        } else if (string2.equals("topic")) {
            Channel channel = this.getChannel(stringArray[0], false);
            if (channel != null) {
                channel.setTopic(stringArray[1], string4);
            }
        } else if (string2.equals("mode")) {
            String string7 = "";
            for (int i = 1; i < stringArray.length; ++i) {
                string7 = string7 + stringArray[i] + " ";
            }
            if (this.isChannel(stringArray[0])) {
                Channel channel = this.getChannel(stringArray[0], false);
                if (channel != null) {
                    MultiModeHandler multiModeHandler = new MultiModeHandler(string7, this._globalModes, this._nickModes);
                    while (!multiModeHandler.terminated()) {
                        multiModeHandler.next();
                        if (multiModeHandler.isPrefix() || multiModeHandler.isModeA()) {
                            channel.applyUserMode(multiModeHandler.getParameter(), multiModeHandler.getMode(), string4);
                            continue;
                        }
                        if (multiModeHandler.hasParameter()) {
                            channel.applyMode(multiModeHandler.getMode() + " " + multiModeHandler.getParameter(), string4);
                            continue;
                        }
                        channel.applyMode(multiModeHandler.getMode(), string4);
                    }
                }
            } else if (string4.equals(this.getNick())) {
                this._mode.apply(string7);
                if (this._status != null) {
                    this._status.modeChanged(this.getMode());
                }
            }
        } else if (string2.equals("nick")) {
            if (string4.equals(this.getNick())) {
                this._nick = stringArray[0];
                if (this._status != null) {
                    this._status.nickChanged(this.getNick());
                }
            }
            this.globalNickChange(string4, stringArray[0]);
        } else if (string2.equals("quit")) {
            if (stringArray.length > 0) {
                this.globalNickRemove(string4, stringArray[0]);
            } else {
                this.globalNickRemove(string4, "");
            }
        } else if (string2.equals("ping")) {
            this.execute("pong :" + stringArray[0]);
        } else if (string2.equals("invite")) {
            String string8 = stringArray[0];
            String string9 = stringArray[1];
            if (string8.equals(this.getNick()) && this._status != null) {
                this._status.invited(string9, string4);
            }
        } else if (string2.equals("error")) {
            this.sendStatusMessage(this.getText(1288, stringArray[0]));
        }
    }

    public String getNick() {
        return this._nick;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getMode() {
        return this._mode.getMode();
    }

    public void say(String string, String string2) {
        this.execute("PRIVMSG " + string + " :" + string2);
    }

    public void execute(String string) {
        String string2;
        String string3;
        int n = string.indexOf(32);
        if (n >= 0) {
            string3 = string.substring(0, n).toLowerCase(Locale.ENGLISH);
            if (string3.equals("join")) {
                string2 = string.substring(n + 1);
                if ((n = string2.indexOf(32)) >= 0) {
                    string2 = string2.substring(0, n);
                }
                if (!this._ircConfiguration.mayJoin(string2)) {
                    return;
                }
            } else if (string3.equals("part")) {
                string2 = string.substring(n + 1);
                if ((n = string2.indexOf(32)) >= 0) {
                    string2 = string2.substring(0, n);
                }
                if (!this._ircConfiguration.mayLeave(string2)) {
                    return;
                }
            }
        }
        if ((n = string.indexOf(32)) > 0) {
            string3 = string.substring(0, n).toUpperCase(Locale.ENGLISH);
            string2 = string.substring(n + 1);
            string = string3 + " " + string2;
        } else {
            string = string.toUpperCase(Locale.ENGLISH);
        }
        this.sendString(string);
    }

    private void sendString(String string) {
        try {
            this._protocol.sendString(string);
        }
        catch (Exception exception) {
            this.sendStatusMessage(this.getText(1288, exception.getMessage()));
        }
    }
}

