/*
 * Decompiled with CFR 0.152.
 */
package irc.plugin.buttons;

import irc.plugin.buttons.SmileyGrayFilter;
import irc.plugin.buttons.SmileyLabel;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.net.URL;

public class SmileyButton
extends SmileyLabel {
    protected static final int defaultBorderWidth = 4;
    protected ActionListener actionListener = null;
    private String _smileyID;
    protected static final Color defaultBorderColor = new Color(160, 160, 160);
    private boolean mouseIsDown = false;
    private int darkness = -5263441;
    private Image graySmiley = null;

    public SmileyButton() {
        this.setBorders();
        this._smileyID = SmileyLabel.getDefaultSmileyString();
    }

    public SmileyButton(String string) {
        super(string);
        this.setBorders();
        this._smileyID = SmileyLabel.getDefaultSmileyString();
    }

    public SmileyButton(URL uRL) {
        super(uRL);
        this.setBorders();
        this._smileyID = SmileyLabel.getDefaultSmileyString();
    }

    public SmileyButton(URL uRL, String string) {
        super(uRL, string);
        this.setBorders();
        this._smileyID = SmileyLabel.getDefaultSmileyString();
    }

    public SmileyButton(Image image) {
        super(image);
        this.setBorders();
        this._smileyID = SmileyLabel.getDefaultSmileyString();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.graySmiley == null) {
            this.createGraySmiley(graphics);
        }
        this.drawBorder(true);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.mouseIsDown = true;
        Graphics graphics = this.getGraphics();
        int n3 = this.getBorder();
        if (this.hasExplicitSize()) {
            graphics.drawImage(this.graySmiley, n3, n3, this.getWidth() - 2 * n3, this.getHeight() - 2 * n3, this);
        } else {
            graphics.drawImage(this.graySmiley, n3, n3, this);
        }
        this.drawBorder(false);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.mouseIsDown = false;
        if (this.inside(n, n2)) {
            this.paint(this.getGraphics());
            event.id = 1001;
            event.arg = this.getSmiley();
            return this.action(event, event.arg);
        }
        return false;
    }

    public boolean action(Event event, Object object) {
        System.out.println("Clicked on button for " + SmileyLabel.getDefaultSmileyString() + ".");
        ActionEvent actionEvent = new ActionEvent(this, 0, this.getSmileyID());
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.mouseIsDown) {
            this.paint(this.getGraphics());
        }
        return true;
    }

    public String getSmileyID() {
        return this._smileyID;
    }

    public void setSmileyID(String string) {
        this._smileyID = string;
    }

    public int getDarkness() {
        return this.darkness;
    }

    public void setDarkness(int n) {
        this.darkness = n;
    }

    public Image getGraySmiley() {
        return this.graySmiley;
    }

    public void setGraySmiley(Image image) {
        this.graySmiley = image;
    }

    private void drawBorder(boolean bl) {
        Graphics graphics = this.getGraphics();
        graphics.setColor(this.getBorderColor());
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = this.getBorder();
        for (int i = 0; i < n5; ++i) {
            graphics.draw3DRect(n, n2, n3, n4, bl);
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
        }
    }

    private void setBorders() {
        this.setBorder(4);
        this.setBorderColor(defaultBorderColor);
    }

    private void createGraySmiley(Graphics graphics) {
        SmileyGrayFilter smileyGrayFilter = new SmileyGrayFilter(this.darkness);
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.getSmiley().getSource(), smileyGrayFilter);
        this.graySmiley = this.createImage(filteredImageSource);
        int n = this.getBorder();
        if (this.hasExplicitSize()) {
            this.prepareImage(this.graySmiley, this.getWidth() - 2 * n, this.getHeight() - 2 * n, this);
        } else {
            this.prepareImage(this.graySmiley, this);
        }
        super.paint(graphics);
    }
}

