/*
 * Decompiled with CFR 0.152.
 */
package irc.plugin.buttons;

import irc.EventDispatcher;
import irc.IRCApplication;
import irc.IRCConfiguration;
import irc.SmileyTable;
import irc.plugin.buttons.SmileyButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SmileyButtons
extends WindowAdapter
implements ActionListener,
Runnable {
    private Thread _thread = null;
    private Frame _frame;
    private Panel _panel;
    private IRCApplication _appl;
    private IRCConfiguration _config;
    private SmileyTable _smileyTable;
    private int _width = 18;
    private int _height = 18;

    public SmileyButtons(IRCConfiguration iRCConfiguration, IRCApplication iRCApplication) {
        this._appl = iRCApplication;
        this._config = iRCConfiguration;
        this._smileyTable = this._config.getSmileyTable();
        this._frame = new Frame();
        this._frame.hide();
        this._frame.setTitle("Smiley Picker");
        this._frame.setLayout(new BorderLayout());
        this._frame.setResizable(true);
        this._frame.addWindowListener(this);
        if (this._thread == null) {
            this._thread = new Thread((Runnable)this, "Smiley_Picker");
            this._thread.start();
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        this._panel = new Panel();
        this._panel.setLayout(new FlowLayout(1, 0, 0));
        int n = this._smileyTable.getSize();
        for (int i = 0; i < n; ++i) {
            String string = this._smileyTable.getMatch(i);
            Image image = this._smileyTable.getImage(i);
            SmileyButton smileyButton = new SmileyButton(image);
            smileyButton.waitForSmiley(true);
            while (!smileyButton.isLoaded()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            smileyButton.setBorder(smileyButton.getBorder() - 2);
            smileyButton.resize(this._width, this._height);
            smileyButton.setSmileyID(string);
            smileyButton.addActionListener(this);
            this._panel.add(smileyButton);
        }
        this.addPaneltoFrame(this._panel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EventDispatcher.dispatchEventAsync((Object)this, (String)"actionPerformedEff", (Object[])new Object[]{actionEvent});
    }

    public void actionPerformedEff(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        System.out.println("Action performed is " + string);
        this._appl.setFieldText(this._appl.getFieldText() + string);
    }

    public void addPaneltoFrame(Panel panel) {
        int n = this._smileyTable.getSize();
        int n2 = (int)Math.ceil(Math.sqrt(n) * 19.0);
        this._panel = panel;
        this._frame.add(this._panel);
        ((Component)this._frame).setSize(n2, n2 + 60);
    }

    public void show() {
        this._frame.show();
        this._frame.toFront();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        this._frame.hide();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this._frame.hide();
    }
}

