/*
 * Decompiled with CFR 0.152.
 */
package irc.plugin.buttons;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;

public class SmileyLabel
extends Canvas {
    private Image smiley;
    private static String defaultSmileyString = "http://java.sun.com/lib/smileys/logo.java.color-transp.55x60.gif";
    private String smileyString = "<Existing Smiley>";
    private boolean debug = false;
    private int border = 0;
    private Color borderColor = null;
    private int width;
    private int height;
    private boolean explicitSize = false;
    private int explicitWidth = 0;
    private int explicitHeight = 0;
    private MediaTracker tracker;
    private static int lastTrackerID = 0;
    private int currentTrackerID;
    private boolean doneLoading = false;
    private Container parentContainer;

    public SmileyLabel() {
        this(defaultSmileyString);
    }

    public SmileyLabel(String string) {
        this(SmileyLabel.makeURL(string));
    }

    public SmileyLabel(URL uRL) {
        this(SmileyLabel.loadSmiley(uRL));
        this.smileyString = uRL.toExternalForm();
    }

    public SmileyLabel(URL uRL, String string) {
        this(SmileyLabel.makeURL(uRL, string));
        this.smileyString = string;
    }

    public SmileyLabel(Image image) {
        this.smiley = image;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(image, this.currentTrackerID);
    }

    public void waitForSmiley(boolean bl) {
        if (!this.doneLoading) {
            this.debug("[waitForSmiley] - Resizing and waiting for " + this.smileyString);
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                System.out.println("Error loading " + this.smileyString + ": " + exception.getMessage());
                exception.printStackTrace();
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading smiley " + this.smileyString).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.smiley.getWidth(this) + 2 * this.border;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.smiley.getHeight(this) + 2 * this.border;
            this.resize(this.width, this.height);
            this.debug("[waitForSmiley] - " + this.smileyString + " is " + this.width + "x" + this.height + ".");
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && bl) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.layout();
            }
        }
    }

    public void centerAt(int n, int n2) {
        this.debug("Placing center of " + this.smileyString + " at (" + n + "," + n2 + ")");
        this.move(n - this.width / 2, n2 - this.height / 2);
    }

    public synchronized boolean inside(int n, int n2) {
        return n >= 0 && n <= this.width && n2 >= 0 && n2 <= this.height;
    }

    public void paint(Graphics graphics) {
        if (!this.doneLoading) {
            this.waitForSmiley(true);
        } else {
            if (this.explicitSize) {
                graphics.drawImage(this.smiley, this.border, this.border, this.width - 2 * this.border, this.height - 2 * this.border, this);
            } else {
                graphics.drawImage(this.smiley, this.border, this.border, this);
            }
            this.drawRect(graphics, 0, 0, this.width - 1, this.height - 1, this.border, this.borderColor);
        }
    }

    public Dimension preferredSize() {
        if (!this.doneLoading) {
            this.waitForSmiley(false);
        }
        return super.preferredSize();
    }

    public Dimension minimumSize() {
        if (!this.doneLoading) {
            this.waitForSmiley(false);
        }
        return super.minimumSize();
    }

    public void resize(int n, int n2) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (n > 0) {
                this.explicitWidth = n;
            }
            if (n2 > 0) {
                this.explicitHeight = n2;
            }
        }
        super.resize(n, n2);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (n3 > 0) {
                this.explicitWidth = n3;
            }
            if (n4 > 0) {
                this.explicitHeight = n4;
            }
        }
        super.reshape(n, n2, n3, n4);
    }

    protected void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        for (int i = 0; i < n5; ++i) {
            graphics.drawRect(n, n2, n3, n4);
            if (i >= n5 - 1) continue;
            ++n;
            ++n2;
            n3 -= 2;
            n4 -= 2;
        }
    }

    public boolean isLoaded() {
        return this.doneLoading;
    }

    protected void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private static URL makeURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Bad URL " + string + ": " + malformedURLException);
            malformedURLException.printStackTrace();
        }
        return uRL;
    }

    private static URL makeURL(URL uRL, String string) {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Bad URL " + uRL.toExternalForm() + ", " + string + ": " + malformedURLException);
            malformedURLException.printStackTrace();
        }
        return uRL2;
    }

    private static Image loadSmiley(URL uRL) {
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    public Image getSmiley() {
        return this.smiley;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    protected boolean hasExplicitSize() {
        return this.explicitSize;
    }

    public static String getDefaultSmileyString() {
        return defaultSmileyString;
    }

    public static void setDefaultSmileyString(String string) {
        defaultSmileyString = string;
    }

    protected String getSmileyString() {
        return this.smileyString;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setIsDebugging(boolean bl) {
        this.debug = bl;
    }
}

