/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.Channel;
import irc.ChannelListener2;
import irc.ModeHandler;
import irc.Source;
import irc.gui.pixx.BaseAWTSource;
import irc.gui.pixx.NickMenuHandler;
import irc.gui.pixx.NickNameComparator;
import irc.gui.pixx.PixxConfiguration;
import irc.gui.pixx.PixxNickListListener;
import irc.gui.pixx.PixxSeparator;
import irc.gui.pixx.ScrollablePixxNickList;
import irc.style.StyledList;
import irc.tree.SortedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;

public class AWTChannel
extends BaseAWTSource
implements ChannelListener2,
PixxNickListListener {
    private ScrollablePixxNickList _nicks;
    private Label _label;
    private SortedList _sortedList;
    private Hashtable _modeMapping;
    private NickMenuHandler _menu;

    public AWTChannel(PixxConfiguration pixxConfiguration, Channel channel) {
        super(pixxConfiguration, (Source)channel);
        this._menu = new NickMenuHandler(pixxConfiguration, this, (Source)channel);
        this._nicks = new ScrollablePixxNickList(this._pixxConfiguration, channel.getIRCServer().getNickPrefixes());
        channel.addChannelListener2((ChannelListener2)this);
        this._nicks.addPixxNickListListener(this);
        this._sortedList = new SortedList(new NickNameComparator(channel.getIRCServer().getNickPrefixes()));
        this._modeMapping = new Hashtable();
        this._label = new Label("");
        this._label.setBackground(this._pixxConfiguration.getColor(6));
        this._label.setForeground(this._pixxConfiguration.getColor(1));
        if (this._pixxConfiguration.getIRCConfiguration().getB("asl")) {
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this._nicks, "Center");
            Panel panel2 = new Panel();
            panel2.setLayout(new BorderLayout());
            panel2.add((Component)new PixxSeparator(2), "West");
            panel2.add((Component)new PixxSeparator(3), "East");
            panel2.add((Component)new PixxSeparator(0), "North");
            panel2.add((Component)new PixxSeparator(1), "South");
            panel2.add((Component)this._label, "Center");
            panel.add((Component)panel2, "South");
            this.add((Component)panel, "East");
        } else {
            this.add((Component)this._nicks, "East");
        }
        this.doLayout();
        this.title();
        if (this._pixxConfiguration.getB("showchannelyoujoin")) {
            this.print("*** " + this.getText(34324, channel.getName(), channel.getServer().getNick()), 3);
        }
    }

    public void release() {
        this._menu.release();
        ((Channel)this._source).removeChannelListener2((ChannelListener2)this);
        this._nicks.removePixxNickListListener(this);
        this._nicks.release();
        this._menu = null;
        super.release();
    }

    public void doLayout() {
        this._label.setText("");
        super.doLayout();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this._nicks.dispose();
        }
    }

    private String getFullModeNick(String string, String string2) {
        Channel channel = (Channel)this.getSource();
        char[] cArray = channel.getIRCServer().getNickPrefixes();
        char[] cArray2 = channel.getIRCServer().getNickModes();
        char[][] cArray3 = channel.getIRCServer().getChannelModes();
        ModeHandler modeHandler = new ModeHandler(string2, cArray3, cArray2);
        for (int i = 0; i < cArray2.length; ++i) {
            if (!modeHandler.hasMode(cArray2[i])) continue;
            return cArray[i] + string;
        }
        return string;
    }

    private String getUnprefixedNick(String string) {
        if (string.length() == 0) {
            return string;
        }
        Channel channel = (Channel)this.getSource();
        char[] cArray = channel.getIRCServer().getNickPrefixes();
        for (int i = 0; i < cArray.length; ++i) {
            if (string.charAt(0) != cArray[i]) continue;
            return string.substring(1);
        }
        return string;
    }

    private void setNicks(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addNick(stringArray[i]);
        }
    }

    private void addNick(String string) {
        String string2 = ((Channel)this._source).getNickMode(string);
        if (string2 != null) {
            String string3 = this.getFullModeNick(string, string2);
            this._sortedList.add(string3);
            this._modeMapping.put(string, string3);
        }
    }

    private void removeNick(String string) {
        String string2 = (String)this._modeMapping.get(string);
        if (string2 != null) {
            this._sortedList.remove(string2);
            this._modeMapping.remove(string);
        }
    }

    private void updateNick(String string) {
        this.removeNick(string);
        this.addNick(string);
    }

    private void update() {
        String string;
        String[] stringArray = new String[this._modeMapping.size()];
        Enumeration enumeration = this._modeMapping.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        this._textField.setCompleteList(stringArray);
        stringArray = new String[this._modeMapping.size()];
        enumeration = this._modeMapping.keys();
        n = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            stringArray[n++] = string + ":" + ((Channel)this._source).whois(this.getUnprefixedNick(string));
        }
        this._list.setNickList(stringArray);
        stringArray = new String[this._sortedList.getSize()];
        enumeration = this._sortedList.getItems();
        n = 0;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = ((Channel)this._source).whois(this.getUnprefixedNick(string));
            stringArray[n++] = string + ":" + string2;
        }
        this._nicks.set(stringArray);
        this.title();
    }

    public synchronized void nickSet(String[] stringArray, String[] stringArray2, Channel channel) {
        this.setNicks(stringArray);
        this.update();
    }

    public synchronized void nickReset(Channel channel) {
        this._sortedList.clear();
        this._modeMapping.clear();
        this._nicks.removeAll();
        this.update();
    }

    public synchronized void nickJoin(String string, String string2, Channel channel) {
        this.addNick(string);
        this.update();
        if (this._pixxConfiguration.getB("showchannelnickjoin")) {
            this.print("*** " + this.getText(34309, string, this._source.getName()), 3);
        }
    }

    public synchronized void nickPart(String string, String string2, Channel channel) {
        this.removeNick(string);
        this.update();
        if (this._pixxConfiguration.getB("showchannelnickpart")) {
            if (string2.length() > 0) {
                this.print("*** " + this.getText(34310, string, this._source.getName()) + " (" + string2 + ")", 3);
            } else {
                this.print("*** " + this.getText(34310, string, this._source.getName()), 3);
            }
        }
    }

    public synchronized void nickKick(String string, String string2, String string3, Channel channel) {
        this.removeNick(string);
        this.update();
        if (this._pixxConfiguration.getB("showchannelnickkick")) {
            if (string3.length() > 0) {
                this.print("*** " + this.getText(34311, string, string2) + " (" + string3 + ")", 3);
            } else {
                this.print("*** " + this.getText(34311, string, string2), 3);
            }
        }
        if (string.equals(this._source.getServer().getNick())) {
            this._source.getServer().sendStatusMessage(this.getText(34305, channel.getName(), string2) + " (" + string3 + ")");
        }
    }

    public synchronized void nickQuit(String string, String string2, Channel channel) {
        this.removeNick(string);
        this.update();
        if (this._pixxConfiguration.getB("showchannelnickquit")) {
            if (string2.length() > 0) {
                this.print("*** " + this.getText(34312, string) + " (" + string2 + ")", 2);
            } else {
                this.print("*** " + this.getText(34312, string), 2);
            }
        }
    }

    private void title() {
        int n = this._sortedList.getSize();
        String string = "";
        if (this._pixxConfiguration.getB("displaychannelname")) {
            string = string + this._source.getName();
        }
        if (this._pixxConfiguration.getB("displaychannelcount")) {
            string = string + " [" + n + "]";
        }
        if (this._pixxConfiguration.getB("displaychannelmode")) {
            string = string + " [" + ((Channel)this._source).getMode() + "]";
        }
        if (this._pixxConfiguration.getB("displaychanneltopic")) {
            string = string.length() != 0 ? string + ": " + ((Channel)this._source).getTopic() : ((Channel)this._source).getTopic();
        }
        this.setTitle(string.trim());
    }

    public synchronized void topicChanged(String string, String string2, Channel channel) {
        if (this._pixxConfiguration.getB("showchanneltopicchanged")) {
            if (string2.length() == 0) {
                this.print("*** " + this.getText(34313, string), 3);
            } else {
                this.print("*** " + this.getText(34314, string2, string), 3);
            }
        }
        this.title();
    }

    public synchronized void modeApply(String string, String string2, Channel channel) {
        if (this._pixxConfiguration.getB("showchannelmodeapply")) {
            if (string2.length() > 0) {
                this.print("*** " + this.getText(34315, string2, string), 3);
            } else {
                this.print("*** " + this.getText(34316, string), 3);
            }
        }
        this.title();
    }

    public synchronized void nickModeApply(String string, String string2, String string3, Channel channel) {
        if (this._pixxConfiguration.getB("showchannelnickmodeapply")) {
            this.print("*** " + this.getText(34317, string3, string2, string), 3);
        }
        this.updateNick(string);
        this.update();
    }

    public synchronized void nickChanged(String string, String string2, Channel channel) {
        if (this._pixxConfiguration.getB("showchannelnickchanged")) {
            this.print("*** " + this.getText(34318, string, string2), 3);
        }
        this.removeNick(string);
        this.addNick(string2);
        this.update();
    }

    public void nickWhoisUpdated(String string, String string2, Channel channel) {
        this.update();
    }

    public void eventOccured(String string, MouseEvent mouseEvent) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickpopup", mouseEvent)) {
            this._menu.popup(string, ((Channel)this._source).whois(string), this._nicks, mouseEvent.getX(), mouseEvent.getY());
        } else if (this._pixxConfiguration.matchMouseConfiguration("nickquery", mouseEvent) && this._pixxConfiguration.getB("automaticqueries") && !string.equals(this._source.getServer().getNick())) {
            this._source.sendString("/focus Query " + string);
            this._source.sendString("/query " + string);
        }
    }

    public void ASLEventOccured(String string, String string2) {
        this._label.setText(this._pixxConfiguration.getIRCConfiguration().formatASL(string2));
    }

    public void nickEvent(StyledList styledList, String string, MouseEvent mouseEvent) {
        if (this._pixxConfiguration.matchMouseConfiguration("nickpopup", mouseEvent)) {
            this._menu.popup(string, ((Channel)this._source).whois(string), (Component)this._list, mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.nickEvent(styledList, string, mouseEvent);
        }
    }
}

