<?php
// Checking page if is admin page
if (is_admin()) {

    // call function for admin menu
    add_action('admin_menu', 'paywithtweet_menu');

    /**
     * add Admin Menu
     * 
     */
    function paywithtweet_menu() {

        add_menu_page(
                'Pay With Tweet', 'Pay With Tweet', 'manage_options', 'paywithtweet', 'paywithtweet_list_panel'
        );

        add_submenu_page(
                'paywithtweet', 'All Link', 'See All Link', 'manage_options', 'paywithtweet', 'paywithtweet_list_panel'
        );
        
        add_submenu_page(
                'paywithtweet', 'Link Detail', 'Add New Link', 'manage_options', 'paywithtweet-form', 'paywithtweet_form_panel'
        );

        add_submenu_page(
                'paywithtweet', 'Settings', 'Settings', 'manage_options', 'paywithtweet-setup', 'paywithtweet_setup_panel'
        );
    }

}

/**
 * Print Pay With Tweet List Panel Page
 * Also used for deleting and edit (link to form_panel) action
 * 
 */
function paywithtweet_list_panel() {

    $url_edit = admin_url('admin.php?page=paywithtweet-form&action=edit');
    $url_delete = admin_url('admin.php?page=paywithtweet&action=delete');

    global $wpdb, $paywithtweet_table;

    // when Edit / Delete get clicked
    
    if (isset($_GET['action'])) {

        if ($_GET['action'] == 'delete') {

            $url_delete_confirmed = admin_url('admin.php?page=paywithtweet&action=delconfirm') . '&id=' . $_GET['id'];
            $url_delete_cancelled = admin_url('admin.php?page=paywithtweet');
            echo '<div id="message" class="error fade"><p>Are you sure you want to delete this? ' .
            '<a href="' . $url_delete_confirmed . '">Yes</a> | ' .
            '<a href="' . $url_delete_cancelled . '">No</a></p></div>';
            
        } elseif ($_GET['action'] == 'delconfirm') {

            $sql = "DELETE FROM " . $paywithtweet_table .
                    " WHERE id=" . $_GET['id'];
            $deleted = $wpdb->query($sql);

            if ($deleted) {
                echo '<div id="message" class="updated fade">';
                echo '<p>Link successfully deleted!</p>';
                echo '</div>';
            } else {
                echo '<div id="message" class="error fade">';
                echo '<p>Unable to delete selected Link.</p>';
                echo '</div>';
            }
            
        }
    }


    // get data list
    
    $sql = "SELECT id, title, download_link, tweet_text, tweet_link, post_date " .
            "FROM " . $paywithtweet_table .
            " ORDER BY post_date DESC";
    $results = $wpdb->get_results($sql);
        
    ?>

    <!--start: list panel -->
    <div class='wrap'> 
        <?php screen_icon('plugins'); ?>
        
        <h2><?php _e('Pay With Tweet', 'paywithtweet'); ?></h2> 

        <table class="widefat"> 
            <thead> 
                <tr>
                    <th><?php _e('ID', 'paywithtweet'); ?></th>
                    <th><?php _e('Title', 'paywithtweet'); ?></th>
                    <th><?php _e('Download Link', 'paywithtweet'); ?></th>
                    <th><?php _e('Text to Tweet', 'paywithtweet'); ?></th> 
                    <th><?php _e('Link to Tweet', 'paywithtweet'); ?></th> 
                    <th><?php _e('Post Date', 'paywithtweet'); ?></th>
                    <th><?php _e('Action', 'paywithtweet'); ?></th>
                </tr> 
            </thead> 
            <tfoot> 
                <tr> 
                    <th><?php _e('ID', 'paywithtweet'); ?></th>
                    <th><?php _e('Title', 'paywithtweet'); ?></th>
                    <th><?php _e('Download Link', 'paywithtweet'); ?></th>
                    <th><?php _e('Text to Tweet', 'paywithtweet'); ?></th> 
                    <th><?php _e('Link to Tweet', 'paywithtweet'); ?></th> 
                    <th><?php _e('Post Date', 'paywithtweet'); ?></th>
                    <th><?php _e('Action', 'paywithtweet'); ?></th>
                </tr> 
            </tfoot> 
            <tbody> 
                <?php foreach ($results as $result) : ?>
                    <tr> 
                        <td><?php echo $result->id; ?></td> 
                        <td><?php echo $result->title; ?></td> 
                        <td><?php echo $result->download_link; ?></td>
                        <td><?php echo $result->tweet_text; ?></td> 
                        <td><?php echo $result->tweet_link; ?></td> 
                        <td><?php echo $result->post_date; ?></td> 
                        <td><a href="<?php echo $url_edit . '&id=' . $result->id; ?>">Edit</a> | 
                            <a href="<?php echo $url_delete . '&id=' . $result->id; ?>">Delete</a></td>
                    </tr> 
                <?php endforeach; ?>
            </tbody> 
        </table>
    </div> <!--end: list panel-->
    
    <?php
} // end of paywithtweet_list_panel()

/**
 * Print Add New Link Form Panel Page
 * Used for adding New Link and edit existing one
 * 
 */
function paywithtweet_form_panel() {

    global $wpdb, $paywithtweet_table;
    ?>    
    
    <!--start: form panel-->
    <div class="wrap"> 
        <?php screen_icon('plugins'); ?>  

        <?php
        $form_title = __('Add New Link', 'paywithtweet');
        $title = isset($_REQUEST['title']) ? $_REQUEST['title'] : '';
        $download_link = isset($_REQUEST['downloadlink']) ? $_REQUEST['downloadlink'] : '';
        $tweet_text = isset($_REQUEST['tweettext']) ? $_REQUEST['tweettext'] : '';
        $tweet_link = isset($_REQUEST['tweetlink']) ? $_REQUEST['tweetlink'] : '';
        $submit_flag = 'add';

        if ((isset($_REQUEST['save'])) AND ($_REQUEST['save'])) {
            
            // call paytweet_update() function
            paywithtweet_update();
        }

        if (isset($_GET['action']) AND ($_GET['action'] == 'edit')) {
            $form_title = __('Edit Link', 'paywithtweet');

            $sql = "SELECT title, download_link, tweet_text, tweet_link " .
                    "FROM " . $paywithtweet_table .
                    " WHERE id='" . $_GET['id'] . "'";
            $row = $wpdb->get_row($sql);

            $title = $row->title;
            $download_link = $row->download_link;
            $tweet_text = $row->tweet_text;
            $tweet_link = $row->tweet_link;
            $submit_flag = 'edit';
        }
        ?>

        <h2><?php echo $form_title; ?></h2> 

        <form method="post" action="">
            <table class="form-table"> 
                <tr valign="top"> 
                    <th scope="row"><label for="title"><?php _e('Title', 'paywithtweet'); ?></label></th> 
                    <td>
                        <input name="title" type="text" id="title" value="<?php echo $title; ?>" class="regular-text" />
                        <br>
                        <!--<span class="description">This is the name that appears as the descriptive name of your file. So if it's a Song, take the name of the song or if it's a presentation, take the name of that presentation.</span>-->
                        <span class="description"><?php _e('Title Description', 'paywithtweet'); ?></span>
                    </td> 
                </tr>
                <tr valign="top"> 
                    <th scope="row"><label for="downloadlink"><?php _e('Download Link', 'paywithtweet'); ?></label></th> 
                    <td>
                        <input type="text" name="downloadlink" id="downloadlink" value="<?php echo $download_link; ?>" class="regular-text" />
                        <br />
                        <!--<span class="description">Please enter the direct URL to the file you want to sell. Like: http://awesome.com/even_more_awesome.zip</span>-->
                        <span class="description"><?php _e('Download Link Description', 'paywithtweet'); ?></span>
                    </td> 
                </tr>
                <tr valign="top"> 
                    <th scope="row"><label for="tweettext"><?php _e('Text to Tweet', 'paywithtweet'); ?></label></th> 
                    <td>
                        <input type="text" name="tweettext" id="tweettext" value="<?php echo $tweet_text; ?>" class="regular-text" />
                        <br />
                        <!--<span class="description">Enter the text of the Tweet you want the people to post. You got 110 characters and the text can be edited by the people downloading in order to add a personal note.</span>-->
                        <span class="description"><?php _e('Text to Tweet Description', 'paywithtweet'); ?></span>
                    </td> 
                </tr>
                <tr valign="top"> 
                    <th scope="row"><label for="tweetlink"><?php _e('Link to Tweet', 'paywithtweet'); ?></label></th> 
                    <td>
                        <input name="tweetlink" type="text" id="tweetlink" value="<?php echo $tweet_link; ?>" class="regular-text" />
                        <br />
                        <!--<span class="description">Here, enter the URL that will be attached to every Tweet the people post. It should be the URL pointing to the webpage where you will show your Pay with a Tweet download button. NOT the URL to the actual direct download. Also, this is the part of the Tweet that can't be edited by the people downloading. You got 29 characters, so better use a short URL like the ones from <a target="_blank" href="http://bit.ly">bit.ly</a>.</span>-->
                        <span class="description"><?php _e('Link to Tweet Description', 'paywithtweet'); ?></span>
                    </td> 
                </tr> 
                <tr valign="top"> 
                    <th scope="row"></th>
                    <td>
                        <input type="hidden" name="submit_flag" value="<?php echo $submit_flag; ?>" />
                        <input type="submit" name="save" value="Save Tweet" class="button-primary" />
                    </td> 
                </tr> 
            </table> 
        </form> 
    </div> <!--end: form panel-->
    <?php
} // end of paywithtweet_form_panel()

/**
 * Updating (add and edit) Link Record
 * 
 */
function paywithtweet_update() {
    $updated = false;

    global $wpdb, $current_user, $paywithtweet_table;
    get_currentuserinfo();

    $values = array(
        'title' => trim($_POST['title']),
        'download_link' => trim($_POST['downloadlink']),
        'tweet_text' => trim($_POST['tweettext']),
        'tweet_link' => trim($_POST['tweetlink']),
        'post_date' => current_time('mysql'),
        'user' => $current_user->display_name
    );
    
    if (!empty($values['title']) AND !empty($values['download_link']) AND
            !empty($values['tweet_text']) AND !empty($values['tweet_link'])) {

        if ($_POST['submit_flag'] == 'add') {

            // $formats_values = array( '%s', '%d' );
            $wpdb->insert($paywithtweet_table, $values);

            $updated = true;
            $msg = '<p>' . __('New Link successfully added!', 'paywithtweet') . '</p>';
        } elseif ($_POST['submit_flag'] == 'edit') {

            $where = array(
                'id' => $_GET['id']
            );
            // $formats_where = array ('5d');
            $wpdb->update($paywithtweet_table, $values, $where);

            $updated = true;
            $msg = '<p>' . __('Current Link is updated successfully.', 'paywithtweet') . '</p>';
        }
    }
    

    if ($updated) {
        echo '<div id="message" class="updated fade">';
        echo $msg;
        echo '</div>';
    } else {
        echo '<div id="message" class="error fade">';
        echo '<p>' . __('All field must be filled.') . '</p>';
        echo '</div>';
    }
    
}

/**
 * Print Settings Panel Page
 * 
 */
function paywithtweet_setup_panel() {
    global $wpdb, $paywithtweet_table;
    ?>    
    
    <!--start: setup panel-->
    <div class="wrap"> 
        <?php screen_icon('plugins'); ?>  

        <?php
        if ((isset($_REQUEST['save'])) AND ($_REQUEST['save'])) {
            
            // call update_paywithtweet_setting()
            update_paywithtweet_setting();
        }

        $wppwt_logo_path = get_option('wppwt_logo_path');
        $wppwt_logo_url = get_option('wppwt_logo_url');
        $wppwt_company_title = get_option('wppwt_company_title');
        $wppwt_description = get_option('wppwt_description');
        $wppwt_promotion = get_option('wppwt_promotion');
        $wppwt_footer = get_option('wppwt_footer');
        $wppwt_footer_url = get_option('wppwt_footer_url');
        $wppwt_after_tweet = get_option('wppwt_after_tweet');
        $wppwt_button_title = get_option('wppwt_button_title');
        ?>

        <h2>Settings</h2> 

        <form method="POST" action="" enctype="multipart/form-data" accept-charset="utf-8"> 
            <table class="form-table"> 
                <tr valign="top"> 
                    <th scope="row"><label for="tweettext"><?php _e('Company Logo', 'paywithtweet'); ?></label></th> 
                    <td><input type="file" name="uploadfiles[]" id="uploadfiles" size="35" class="uploadfiles" /></td> 
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="wppwt_logo_url"><?php _e('Logo URL', 'paywithtweet'); ?></label></th>
                    <td>
                        <input type="text" size="100" name="wppwt_logo_url" id="wppwt_logo_url" value="<?php echo $wppwt_logo_url; ?>" class="regular-text"/>
                        <br />
<!--                        <span class="description">Enter your Company URL here. When user click your Company Logo, they will be redirected here.</span>-->
                        <span class="description"><?php _e('Logo URL Description', 'paywithtweet'); ?></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="wppwt_company_title"><?php _e('Company Title', 'paywithtweet'); ?></label></th>
                    <td>
                        <input type="text" size="100" name="wppwt_company_title" id="wppwt_company_title" value="<?php echo $wppwt_company_title; ?>" class="regular-text"/>
                        <br />
<!--                        <span class="description">Enter your Company Title. This will be displayed along side with your Company Logo.</span>-->
                        <span class="description"><?php _e('Company Title Description', 'paywithtweet'); ?></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="wppwt_description"><?php _e('PayWithTweet Description', 'paywithtweet'); ?></label></th>
                    <td>
                        <textarea cols="100" name="wppwt_description" id="wppwt_description"><?php echo stripslashes($wppwt_description); ?></textarea>
                        <br />
<!--                        <span class="description">
                                Enter a description to your customer, explaining the workflow of this plugin.<br />
                                An example has been given to you, when you're activating this plugin.<br />
                                You may leave this field as is, or you may enter your own.
                        </span>-->
                        <span class="description"><?php _e('PayWithTweet Description Text', 'paywithtweet'); ?></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="wppwt_promotion"><?php _e('Promotion', 'paywithtweet'); ?></label></th>
                    <td>
                        <textarea cols="100" name="wppwt_promotion" id="wppwt_promotion"><?php echo stripslashes($wppwt_promotion); ?></textarea>
                        <br />
<!--                        <span class="description">Give some promotion text to your customer here.</span>-->
                        <span class="description"><?php _e('Promotion Description', 'paywithtweet'); ?></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="wppwt_footer"><?php _e('Footer Text', 'paywithtweet'); ?></label></th>
                    <td>
                        <input type="text" size="100" name="wppwt_footer" id="wppwt_footer" value="<?php echo $wppwt_footer; ?>" class="regular-text"/>
                        <br />
<!--                        <span class="description">This will be shown at the footer part of your pop-up screen.</span>-->
                        <span class="description"><?php _e('Footer Text Description', 'paywithtweet'); ?></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="wppwt_footer_url"><?php _e('Footer URL', 'paywithtweet'); ?></label></th>
                    <td>
                        <input type="text" size="100" name="wppwt_footer_url" id="wppwt_footer_url" value="<?php echo $wppwt_footer_url; ?>" class="regular-text"/>
                        <br />
<!--                        <span class="description">Enter the URL when user click your footer. You might want to make it similar with the Logo URL.</span>-->
                        <span class="description"><?php _e('Footer URL Description', 'paywithtweet'); ?></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="wppwt_after_tweet"><?php _e('Thanks Confirmation Page', 'paywithtweet'); ?></label></th>
                    <td>
                        <textarea cols="100" name="wppwt_after_tweet" id="wppwt_after_tweet"><?php echo $wppwt_after_tweet; ?></textarea>
                        <br />
<!--                        <span class="description">This text will be shown to your customer, once they had tweeted your link. This page also used to show the Download Button to your files.</span>-->
                        <span class="description"><?php _e('Thanks Confirmation Page Description', 'paywithtweet'); ?></span>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><label for="wppwt_button_title"><?php _e('Button Title', 'paywithtweet'); ?></label></th>
                    <td>
                        <input type="text" size="100" name="wppwt_button_title" id="wppwt_button_title" value="<?php echo $wppwt_button_title; ?>" class="regular-text"/>
                        <br />
<!--                        <span class="description">You may leave this field unchanged. Or you prefer your own title such as 'Download Now', 'Click Here', etc.</span>-->
                        <span class="description"><?php _e('Button Title Description', 'paywithtweet'); ?></span>
                    </td>
                </tr>
                <tr valign="top"> 
                    <th scope="row"></th>
                    <td>
                        <input type="submit" name="save" value="Save" class="button-primary" />
                        <input type="reset" name="reset" value="Reset" class="button-secondary" />
                    </td> 
                </tr> 
            </table> 
        </form> 
    </div> <!--end: setup panel -->
    
    <?php
} // end of paywithtweet_setup_panel()

/**
 * Updating PayTweet Setting
 * 
 */
function update_paywithtweet_setting() {
    $updated = false;

    if ($_POST['save']) {
        // call fileupload_process() for processing Company Logo
        fileupload_process();
        update_option('wppwt_logo_url', $_POST['wppwt_logo_url']);
        update_option('wppwt_company_title', $_POST['wppwt_company_title']);
        update_option('wppwt_description', $_POST['wppwt_description']);
        update_option('wppwt_promotion', $_POST['wppwt_promotion']);
        update_option('wppwt_footer', $_POST['wppwt_footer']);
        update_option('wppwt_footer_url', $_POST['wppwt_footer_url']);
        update_option('wppwt_after_tweet', $_POST['wppwt_after_tweet']);
        update_option('wppwt_button_title', $_POST['wppwt_button_title']);
        $updated = true;
    }

    if ($updated) {
        echo '<div id="message" class="updated fade">';
        echo '<p>Pay With Tweet settings successfully updated.</p>';
        echo '</div>';
    } else {
        echo '<div id="message" class="error fade">';
        echo '<p>Unable to update Pay With Tweet settings.</p>';
        echo '</div>';
    }
}

/**
 * Handle file uploads
 * http://www.nicolaskuttler.com/code/simple-upload-field-for-wordpress-pluginsthemes/
 *
 * @todo check nonces
 * @todo check file size
 *
 * @return none
 */
function fileupload_process() {
    $uploadfiles = $_FILES['uploadfiles'];

    if (is_array($uploadfiles)) {

        foreach ($uploadfiles['name'] as $key => $value) {

            // look only for uploded files
            if ($uploadfiles['error'][$key] == 0) {

                $filetmp = $uploadfiles['tmp_name'][$key];

                //clean filename and extract extension
                $filename = $uploadfiles['name'][$key];

                // get file info
                // @fixme: wp checks the file extension....
                $filetype = wp_check_filetype(basename($filename), null);
                $filetitle = preg_replace('/\.[^.]+$/', '', basename($filename));
                $filename = $filetitle . '.' . $filetype['ext'];
                $upload_dir = wp_upload_dir();

                // Check if the filename already exist in the directory and rename the
                // file if necessary
                $i = 0;
                while (file_exists($upload_dir['path'] . '/' . $filename)) {
                    $filename = $filetitle . '_' . $i . '.' . $filetype['ext'];
                    $i++;
                }
                $filedest = $upload_dir['path'] . '/' . $filename;

                // Check write permissions
                if (!is_writeable($upload_dir['path'])) {
                    $this->msg_e('Unable to write to directory %s. Is this directory writable by the server?');
                    return;
                }

                // Save temporary file to uploads dir
                if (!@move_uploaded_file($filetmp, $filedest)) {
                    $this->msg_e("Error, the file $filetmp could not moved to : $filedest ");
                    continue;
                }

                $attachment = array(
                    'post_mime_type' => $filetype['type'],
                    'post_title' => $filetitle,
                    'post_content' => '',
                    'post_status' => 'inherit'
                );

                $attach_id = wp_insert_attachment($attachment, $filedest);
                require_once( ABSPATH . "wp-admin" . '/includes/image.php' );
                $attach_data = wp_generate_attachment_metadata($attach_id, $filedest);
                wp_update_attachment_metadata($attach_id, $attach_data);


                // update _options table
                update_option('wppwt_logo_path', $attach_data['file']);
            }
        }
    }
}

/* End of File */