<?php

/*
  Plugin Name: Pay With Tweet
  Plugin URI: http://tokokoo.com
  Description: This plugin enables customers to pay for your product with a single tweet. An efficient way to promote your brand in a less tiring way.
  Author: Eric Gunawan, Onnay Okheng
  Version: 1.1
  Author URI: http://twitter.com/erricgunawan

  Copyright 2011
  Eric Gunawan (email : erricgunawan.at.gmail.dot.com)
  Onnay Okheng (site  : onnayokheng.com)

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */



/*
  |--------------------------------------------------------------------------
  | Language initialization
  |--------------------------------------------------------------------------
  |
  | Get language domain
  | load_plugin_textdomain( 'our-very-unique-domain', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
  }
 */

// get js to init
add_action('init', 'paywithtweet_language_init');

/**
 * load plugin text domain
 */
function paywithtweet_language_init() {
    load_plugin_textdomain('paywithtweet', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}

/*
  |--------------------------------------------------------------------------
  | Activating/Deactivating Plugin
  |--------------------------------------------------------------------------
  |
  | Activating:
  | - Define table name
  | - Create initial table
  | - Set initial options
  |
  | Deactivating:
  | - Drop table
  | - Unset options from _options
  |
 */

// do NOT forget this global
global $wpdb;
// define table name
$paywithtweet_table = $wpdb->prefix . "paywithtweet";

/**
 * Create initial table
 * 
 */
function paywithtweet_create_table() {
    global $wpdb, $paywithtweet_table;
    $table_name = $wpdb->prefix . "paywithtweet";

    $sql = "CREATE TABLE IF NOT EXISTS " . $table_name . " (" .
            "id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT, " .
            "title VARCHAR (255), " .
            "download_link VARCHAR (255), " .
            "tweet_text VARCHAR(110), " .
            "tweet_link VARCHAR(29) NOT NULL, " .
            "post_date DATETIME NOT NULL, " .
            "user VARCHAR(200), " .
            "PRIMARY KEY (id)" .
            ");";
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

/**
 * Set initial options
 * 
 */
function set_paywithtweet_options() {
    add_option("wppwt_logo_url", "http://tokokoo.com");
    add_option("wppwt_logo_path", "");
    add_option("wppwt_company_title", "Tokokoo");
    add_option("wppwt_description", "Pay With Tweet will only post this one tweet, not more. You can edit the text of the tweet, but not the URL. So whatever you will tweet, keep in mind that the URL to this download stays attached to it.");
    add_option("wppwt_promotion", "Post your Tweet.\n You're connected! Now Tweet like hell!");
    add_option("wppwt_footer", "Pay With Tweet is a project by Tokokoo");
    add_option("wppwt_footer_url", "http://tokokoo.com");
    add_option("wppwt_after_tweet", "Thanks a lot!\n You successfully posted your Tweet.");
    add_option("wppwt_button_title", "Get it Now");
}

// this hook will cause our creation function to run when the plugin is activated
register_activation_hook(__FILE__, 'paywithtweet_create_table');
register_activation_hook(__FILE__, "set_paywithtweet_options");


/**
 * Unset options from _options
 * 
 */
function unset_paywithtweet_options() {
    delete_option("wppwt_logo_url");
    delete_option("wppwt_logo_path");
    delete_option("wppwt_company_title");
    delete_option("wppwt_description");
    delete_option("wppwt_promotion");
    delete_option("wppwt_footer");
    delete_option("wppwt_footer_url");
    delete_option("wppwt_after_tweet");
    delete_option("wppwt_button_title");
}

// this hook will cause our drop function to run when the plugin is deactivated
register_deactivation_hook(__FILE__, "unset_paywithtweet_options");




/*
  |--------------------------------------------------------------------------
  | Admin Page
  |--------------------------------------------------------------------------
  |
  | Including admin_page.php where everything in Admin Panel lies
  |
 */
require_once ('admin_page.php');




/*
  |--------------------------------------------------------------------------
  | JavaScript initialization
  |--------------------------------------------------------------------------
  |
  | Get js running in WP Plugin
  |
 */

// get js to init
add_action('init', 'paywithtweet_update_js');

/**
 * Register js to WP Plugin
 * 
 */
function paywithtweet_update_js() {
    $src = plugins_url('js/paywithtweet.js', __FILE__);
    wp_register_script('paywithtweet', $src);
    wp_enqueue_script('paywithtweet');
}

/*
  |--------------------------------------------------------------------------
  | Shortcode initialization
  |--------------------------------------------------------------------------
  |
  | Create and Register Shortcode
  | Usage in Edit Post:
  |   [paytweet id=0 title='Text Displayed as Link']
  |
 */

// add TinyMCE buttons
require_once('shortcode.php');

// Register a new shortcode
add_shortcode('paywithtweet', 'paywithtweet_register_shortcode');

/**
 * Create and Register Shortcode
 * 
 * @param array
 * @return string
 */
function paywithtweet_register_shortcode($attr) {
    global $wpdb, $paywithtweet_table;

    $title = __('Pay With Tweet', 'paywithtweet'); // '';
    $download = 'http://tokokoo.com'; // '';
    $text = __('Try our Pay With Tweet WP Plugin', 'paywithtweet'); // '';
    $link = 'http://tokokoo.com'; // '';

    if (isset($attr['id'])) {
        $sql = "SELECT title, download_link, tweet_text, tweet_link " .
                "FROM " . $paywithtweet_table .
//            " WHERE tweet_link='" . $attr['url'] . "'";
                " WHERE id='" . $attr['id'] . "'";
        $row = $wpdb->get_row($sql);
        
        if ($row) {
            $title = $row->title;
            $download = $row->download_link;
            $text = $row->tweet_text;
            $link = $row->tweet_link;
        }
    }

    $pay_url = plugins_url('pay.php', __FILE__);
    $pay_url .= "?link=" . urlencode($link) . "&dl=" . urlencode($download) .
            "&text=" . urlencode($text) . "&title=" . urlencode($title);

    if (isset($attr['text'])) {
        $title = $attr['text'];
    } else {
        $title = __('Pay With Tweet', 'paywithtweet');
    }

    $shortcode = "<a href='#' onclick='OpenNewWindow(\"" .
            $pay_url . "\")'>" . $title . "</a>";

    return $shortcode;
}

/* End of File */