<?php

/**
 * Add paywithtweet tinyMCE button
 * 
 */
function paywithtweet_addbuttons() {
    // Don't bother doing this stuff if the current user lacks permissions
    if (!current_user_can('edit_posts') && !current_user_can('edit_pages'))
        return;

    // Add only in Rich Editor mode
    if (get_user_option('rich_editing') == 'true') {
        add_filter("mce_external_plugins", "add_paywithtweet_tinymce");
        add_filter('mce_buttons', 'register_paywithtweet_button');
    }
}

/**
 * add separator ont tinyMCE
 *
 * @param array $buttons
 * @return array 
 */
function register_paywithtweet_button($buttons) {
    array_push($buttons, "separator", "paywithtweet");
    return $buttons;
}

/**
 * register plugin google1 on tinyMCE
 *
 * @param array $plugin_array
 * @return array 
 */
function add_paywithtweet_tinymce($plugin_array) {
    $plugin_array['paywithtweet'] = plugins_url('tinymce/editor_plugin.js', __FILE__);
    return $plugin_array;
}

// init process for button control
add_action('init', 'paywithtweet_addbuttons');

/* End Of Files */