<?php
$wp_include = "../wp-load.php";
$i = 0;
while (!file_exists($wp_include) && $i++ < 10) {
    $wp_include = "../$wp_include";
}

// let's load WordPress
require($wp_include);
if (function_exists('admin_url')) {
	wp_admin_css_color('classic', __('Blue'), admin_url("css/colors-classic.css"), array('#073447', '#21759B', '#EAF3FA', '#BBD8E7'));
	wp_admin_css_color('fresh', __('Gray'), admin_url("css/colors-fresh.css"), array('#464646', '#6D6D6D', '#F1F1F1', '#DFDFDF'));
} else {
	wp_admin_css_color('classic', __('Blue'), get_bloginfo('wpurl').'/wp-admin/css/colors-classic.css', array('#073447', '#21759B', '#EAF3FA', '#BBD8E7'));
	wp_admin_css_color('fresh', __('Gray'), get_bloginfo('wpurl').'/wp-admin/css/colors-fresh.css', array('#464646', '#6D6D6D', '#F1F1F1', '#DFDFDF'));
}
?>

<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title>Paywithtweet Shortcode Panel</title>
        <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php echo get_option('blog_charset'); ?>" />
        <?php
        wp_enqueue_style('global');
        wp_enqueue_style('wp-admin');
        wp_enqueue_style('colors');
        wp_enqueue_style('media');
        wp_enqueue_script('jquery');
        ?>
        <?php
        do_action('admin_print_styles');
        do_action('admin_print_scripts');
        do_action('admin_head');
        if (isset($content_func) && is_string($content_func))
            do_action("admin_head_{$content_func}");
        ?>
        <script language="javascript" type="text/javascript" src="<?php echo get_option('siteurl') ?>/wp-includes/js/tinymce/tiny_mce_popup.js"></script>
        <script language="javascript" type="text/javascript" src="<?php echo get_option('siteurl') ?>/wp-includes/js/tinymce/utils/mctabs.js"></script>
        <script language="javascript" type="text/javascript" src="<?php echo get_option('siteurl') ?>/wp-includes/js/tinymce/utils/form_utils.js"></script>
        <script language="javascript" type="text/javascript" src="<?php echo plugins_url('tinymce.js', __FILE__); ?>"></script>
    </head>
    <body id="link" style="display: none">

        <?php
        
        global $wpdb, $paywithtweet_table;
        
        $sql = "SELECT id, title, download_link, tweet_text, tweet_link " .
                "FROM " . $paywithtweet_table .
                " ORDER BY post_date DESC";
        $results = $wpdb->get_results($sql);
        ?>

        <div class="mceActionPanel">
            <div style="float: left">
                <input type="button" id="cancel" name="cancel" value="Close" onClick="tinyMCEPopup.close();" />
            </div>
            <div style="float: right">
                <span><?php _e('Text in Link:', 'paywithtweet'); ?>:</span>
                <input type="text" name="linktext" id="linktext" class="text" placeholder="<?php _e('Pay With Tweet'); ?>"/>
            </div>
        </div>
        <table class="widefat">
            <thead> 
                <tr>
                    <th><?php _e('ID', 'paywithtweet'); ?></th>
                    <th><?php _e('Title', 'paywithtweet'); ?></th>
                    <th><?php _e('Download Link', 'paywithtweet'); ?></th>
                    <th><?php _e('Text to Tweet', 'paywithtweet'); ?></th> 
                    <th><?php _e('Link to Tweet', 'paywithtweet'); ?></th> 
                    <th><?php _e('Action', 'paywithtweet'); ?></th>
                </tr> 
            </thead>
            <tbody> 
                <?php foreach ($results as $result) : ?>
                <tr style="height: 30px; vertical-align:middle;"> 
                    
                        <td><?php echo $result->id; ?></td> 
                        <td><?php echo $result->title; ?></td> 
                        <td><?php echo substr($result->download_link, 0, 20) . '...'; ?></td>
                        <td><?php echo $result->tweet_text; ?></td> 
                        <td><?php echo $result->tweet_link; ?></td> 
                        <td><a href="#" class="button insertlink" id="download-<?php echo $result->id; ?>"><?php _e('Insert', 'paywithtweet');?></a></td>
                    </tr> 
                <?php endforeach; ?>
            </tbody> 
        </table>

    </body>
</html>