<?
/*
Il sistema di aggiornamenti deve
- leggere il file guida
- installare tutti i gli aggiornamenti per ogni modulo
  fino al raggiungimento della ultima versione disponibile

Il file guida ha formato
NomeModulo;2.2.3:234.234.3
*/


include "sas.php";
top_admin($sine);
echo "<center>";
grande("<b>Aggiornamenti</b>");
echo "</center><hr>";


//This function completely removes a dir and its subdirs
function removeDir($path) {
   // Add trailing slash to $path if one is not there
   if (substr($path, -1, 1) != "/") {
       $path .= "/";
   }

   $normal_files = glob($path . "*");
   $hidden_files = glob($path . "\.?*");
   $all_files = array_merge($normal_files, $hidden_files);

   foreach ($all_files as $file) {
       # Skip pseudo links to current and parent dirs (./ and ../).
       if (preg_match("/(\.|\.\.)$/", $file))
       {
               continue;
       }

       if (is_file($file) === TRUE) {
           // Remove each file in this Directory
           unlink($file);
           //echo "Removed File: " . $file . "<br>";
       }
       else if (is_dir($file) === TRUE) {
           // If this Directory contains a Subdirectory, run this Function on it
           removeDir($file);
       }
   }
   // Remove Directory once Files have been removed (If Exists)
   if (is_dir($path) === TRUE) {
       rmdir($path);
       //echo "<br>Removed Directory: " . $path . "<br><br>";
   }
}


// This function copies a directory and all subdirectories and files (recursive)
// void dircpy( str 'source directory', str 'destination directory' [, bool 'overwrite existing files'] )
function dircpy($basePath, $source, $dest, $overwrite = false){
   if(!is_dir($basePath . $dest)) //Lets just make sure our new folder is already created. Alright so its not efficient to check each time... bite me
   mkdir($basePath . $dest);
   if($handle = opendir($basePath . $source)){        // if the folder exploration is sucsessful, continue
       while(false !== ($file = readdir($handle))){ // as long as storing the next file to $file is successful, continue
           if($file != '.' && $file != '..'){
               $path = $source . '/' . $file;
               if(is_file($basePath . $path)){
                   if(!is_file($basePath . $dest . '/' . $file) || $overwrite)
                   if(!@copy($basePath . $path, $basePath . $dest . '/' . $file)){
                       echo '<font color="red">File ('.$path.') could not be copied, likely a permissions problem.</font>';
                   }
               } elseif(is_dir($basePath . $path)){
                   if(!is_dir($basePath . $dest . '/' . $file))
                   mkdir($basePath . $dest . '/' . $file); // make subdirectory before subdirectory is copied
                   dircpy($basePath, $path, $dest . '/' . $file, $overwrite); //recurse!
               }
           }
       }
       closedir($handle);
   }
}


/*
Lascio il commento, poco prima di uscire...
L'aggiornamento ora prevede che quando viene data come action "update"
si debba dividere ogni elemento POST in NomeDir e StringaVersioni
poi si installi uno per uno ogni elemento della stringa versioni
*/
//Module updating
if ($_POST[action] == "update"){
	include("archive.php");

	//Creating an array containing the current versions for all the modules
	$query = "SELECT * FROM ".$sine[db][prefisso_tab]."mods WHERE 1";
	if ($result = mysql_query($query, $sine[db][db]))
	{
		//Writing vars for the version compare
		while ($row = mysql_fetch_array($result))
		{
			$current_version_array[$row['name']] = $row['version'];
		}
	}

	foreach ( $_POST as $nome=>$aggiorna)
	{
		//Remote modules upgrading
		if ( $nome != "action" && $aggiorna == 1)
		{
			$nome = str_replace("_",".", $nome);

			//Divido il nome del modulo dalle versioni
			$string_to_cut = explode("-", $nome);
			
			//Assegno il nome del modulo
			$nome_dir = $string_to_cut[0];

			//Assegno le versioni
			$version_string = $string_to_cut[1];

			//Divido le versioni l'una dall'altra
			$array_versioni = explode(":", $version_string);
			
			//Inverto l'ordine dell'array per poterli prendere dal minore al maggiore
			$array_versioni = array_reverse($array_versioni);

			titoletti ("<b>Aggiornamento modulo $nome_dir in corso...</b><br><br>");

			foreach ($array_versioni as $version_to_download)
			{
				//Controllo se la versione da scricare è maggiore di quella nel db
				if (version_compare($current_version_array[$nome_dir],$version_to_download) == "-1")
				{
					//Il nome del pacchetto e' formato dal nome del modulo più la versione da trattare al momento
					$nome = $nome_dir."-".$version_to_download;
		
					echo "Scarico il modulo ...";
					$fh = fopen("../mods/" .$nome . ".tar.gz", "w");
		
					if ($content = @file_get_contents("http://www.sinecms.net/repository/mods/" . $nome_dir ."/" . $nome .".tar.gz"))
					{
						fwrite($fh, $content);
						fclose($fh);
						echo "fatto!<br>";
						echo "Lo scompatto ...<br>";
		
			
						//If the module to be updated is not the sine-kernel (Kenny)
						//we extract it in the mods dir...
						if ($nome_dir != "Kenny")
						{
							// Open archives/test.tar
							$test = new gzip_file("../mods/" . $nome . ".tar.gz");
		
							// Overwrite existing files
							$test->set_options(array('overwrite' => 1));
							$test->set_options(array('basedir' => "../mods/"));
		
							// Extract contents of archive to disk
							$test->extract_files("../mods/" . $nome . ".tar.gz"); 
		
							//Removing some useless files					
							echo "Rimuovo i file scaricati...";
							unlink("../mods/" . $nome . ".tar.gz");
		
							//Updating th DB
							echo "Aggiorno il database ...";
							include("../mods/$nome_dir/install.php");

							$version_for_function = str_replace(".","_", $version_to_download);

							$update_function = "update_".$nome_dir."_".$version_for_function;
							$update_function($sine);
						
						}
						//Else we extract it in the root directory
						else
						{
							// Open archives/test.tar
							$test = new gzip_file("../mods/" . $nome . ".tar.gz");
		
							// Overwrite existing files
							$test->set_options(array('overwrite' => 1));
							$test->set_options(array('basedir' => "../mods"));
		
							// Extract contents of archive to disk
							$test->extract_files("../mods/" . $nome . ".tar.gz"); 
							
							//Copying files from temp dir to root dir
							echo "Copying files from temp dir to root dir...<br>";
							dircpy($sine[config][base_url], "mods/Kenny", "", $verbose = true);
					
							//Removing temp dir
							echo "Removing temp dir...<br>";
							removeDir($sine[config][base_url]."mods/Kenny");
			
							echo "Rimuovo i file scaricati...<br>";
							unlink("../mods/" . $nome . ".tar.gz");
		
							//Updating the DB
							echo "Aggiorno il database ...<br>";
							include("../update.php");
							
							$version_for_function = str_replace(".","_", $version_to_download);

							$update_function = "update_".$nome_dir."_".$version_for_function;
							$update_function($sine);
						
						}
						echo "<br><b> Installazione completata!</b>";
		
					}
					else
					{
						echo "<br>Error: <b>Unable to download requested file: ".$nome.".tar.gz</b><br>";
					}
				}
			}
			
		}
		//Local modules upgrading
		elseif ($nome != "action" && $aggiorna == 2)
		{
			$nome = str_replace("_",".", $nome);
			list($nome_dir, ) = explode("-", $nome);
			titoletti ("<b>Aggiornamento modulo $nome in corso...</b><br><br>");

			if ($nome_dir != "Kenny"){ 
				include "../mods/$nome_dir/install.php";
			} else {
				include "../update.php";
			}
			$version_for_function = str_replace(".","_", $version);

			$update_function = "update_".$nome_dir."_".$version_for_function;
			$update_function($sine);
		}
	}

//Showing modules status
} else {
	to_update();

	titoletti ("<b>Moduli presenti</b><br><br>");
	echo '<form action="update.php" method="post">
		<input type="hidden" name="action" value="update">';
	echo "<table class=\"admin\" cellpadding=\"5\">
		<tr class=\"head\">
			<TD align=\"center\">";
	titoletti ("<b>Nome</b>");
	echo "		</TD>
			<TD align=\"center\">";
	titoletti ("<b>Versione database</b>");
	echo "		</TD>
			<TD align=\"center\">";
	titoletti ("<b>Versione installata</b>");
	echo "		</TD>
			<TD align=\"center\">";
	titoletti ("<b>Ultima versione</b>");
	echo "		</TD>
			<TD align=\"center\">";
	titoletti ("<b>Aggiorna</b>");
	echo "		</TD>";
	echo "</tr>";

	/***********************************************************
	bisogna fare in modo che vengano visualizzati tutti i moduli
	e che per ogni modulo venga visualizzata:
	- Versione corrente nel db
	- Versione corrente dei file
	- Ultima versione disponibile nel repository (deposito)
	
	N.B. solo se le tre versioni conicidono si può fare a meno
	     di visualizzare il modulo, ma per ora per KISS lascerei
	     perdere.

	Ora il problema e' mettere in un array i dati del file guida
	del deposito per poi tirarli fuori nel momento adatto.
	************************************************************/

	//Checking repository for updated modules
	if ($updates = @file("http://www.sinecms.net/repository/packages.txt")){
		foreach ($updates as $update) {

			//Divido il nome del modulo dalla stringa delle versioni
			$mod_up = explode(";", $update);
			
			//Assegno la prima parte della stringa al nome del modulo
			$nome_modulo = $mod_up[0];
			
			//Assegno la seconda parte alle variabili delle versioni
			$versioni_modulo = $mod_up[1];

			//Creo un array con tutte le versioni
			$array_versioni_modulo = explode(":", $versioni_modulo);

			//Current repository version
			$repository_data[$nome_modulo][current] = trim($array_versioni_modulo[0]);

			//Versions history
			$repository_data[$nome_modulo][all_version] = trim($versioni_modulo);

		}
	} else {
		echo "Unable to get repository files index.<br>
		      Let's continue without it.<br>";
	}

	//First we select all the modules
	$query = "SELECT * FROM ".$sine[db][prefisso_tab]."mods WHERE 1";
	if ($result = mysql_query($query, $sine[db][db])){
		
		//Writing out a row for each module
		while ($row = mysql_fetch_array($result)){
			
			//Including install file for this module
			//excluding Kenny and Integrated modules
 			if ($row[name] != "Kenny"){
				include "../mods/".$row[name]."/install.php";
 			} else {
				include "../update.php";
			}
			//Writing the row
			echo "<tr class=\"content\">\n";
			//Module name
			echo "	<td><b>".$row[name]."</b></td>\n";
			//Db version
			echo "	<td align=\"right\">".$row[version]."</td>\n";
			//Files version from module_name/install.php module file
			echo "	<td align=\"right\">".$version."</td>\n";
			//Repository version
			echo "  <td align=\"right\"><b>".$repository_data[$row[name]][current]."</b></td>\n";
			
			//Upgrading from files it is the first option showed
			if ($row[version] != $version AND isset($version))
			{
				echo "<td><INPUT type=\"checkbox\" name=\"".$row[name]."-".$version."\" value=\"2\"></td>\n";

			}
			//Else let's show remote upgrading
			elseif ( $row[version] != $repository_data[$row[name]][current] 
				 AND isset($repository_data[$row[name]][current]))
			{
				echo "<td>
					<INPUT type=\"checkbox\" name=\"".$row[name]."-".$repository_data[$row[name]][all_version]."\" value=\"1\">
				      </td>\n";

			}
			else
			{
				echo "<td></td>\n";
			}
			
			echo "</tr>\n";

			unset($version);
		}

	} else {
		mysql_error();
	}

	
	echo "</table>
		<br><br>
		<center>
			<input type=\"reset\" value=\"Reset\">&nbsp;<input type=\"submit\" value=\"Aggiorna!\">
		</center>
		</form>";
	
}
foot_admin($sine[db][db]);
?>
