<?
include("config.inc.php");

function xmlentities($string, $quote_style=ENT_QUOTES)
{
   static $trans;
   if (!isset($trans)) {
       $trans = get_html_translation_table(HTML_ENTITIES, $quote_style);
       foreach ($trans as $key => $value)
           $trans[$key] = '&#'.ord($key).';';
       // dont translate the '&' in case it is part of &xxx;
       $trans[chr(38)] = '&';
   }
   // after the initial translation, _do_ map standalone '&' into '&#38;'
   return preg_replace("/&(?![A-Za-z]{0,4}\w{2,3};|#[0-9]{2,3};)/","&#38;" , strtr($string, $trans));
}

function htmlwrap($str, $width = 60, $break = "\n", $nobreak = "") {

  // Split HTML content into an array delimited by < and >
  // The flags save the delimeters and remove empty variables
  $content = preg_split("/([<>])/", $str, -1, PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_NO_EMPTY);

  // Transform protected element lists into arrays
  $nobreak = explode(" ", strtolower($nobreak));

  // Variable setup
  $intag = false;
  $innbk = array();
  $drain = "";

  // List of characters it is "safe" to insert line-breaks at
  // It is not necessary to add < and > as they are automatically implied
  $lbrks = "/?!%)-}]\\\"':;&";

  // Is $str a UTF8 string?
  $utf8 = (preg_match("/^([\x09\x0A\x0D\x20-\x7E]|[\xC2-\xDF][\x80-\xBF]|\xE0[\xA0-\xBF][\x80-\xBF]|[\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}|\xED[\x80-\x9F][\x80-\xBF]|\xF0[\x90-\xBF][\x80-\xBF]{2}|[\xF1-\xF3][\x80-\xBF]{3}|\xF4[\x80-\x8F][\x80-\xBF]{2})*$/", $str)) ? true : false;

  while (list(, $value) = each($content)) {
    switch ($value) {

      // If a < is encountered, set the "in-tag" flag
      case "<": $intag = true; break;

      // If a > is encountered, remove the flag
      case ">": $intag = false; break;

      default:

        // If we are currently within a tag...
        if ($intag) {

          // Create a lowercase copy of this tag's contents
          $lvalue = strtolower($value);

          // If the first character is not a / then this is an opening tag
          if ($lvalue{0} != "/") {

            // Collect the tag name   
            preg_match("/^(\w*?)(\s|$)/", $lvalue, $t);

            // If this is a protected element, activate the associated protection flag
            if (in_array($t[1], $nobreak)) array_unshift($innbk, $t[1]);

          // Otherwise this is a closing tag
          } else {

            // If this is a closing tag for a protected element, unset the flag
            if (in_array(substr($lvalue, 1), $nobreak)) {
              reset($innbk);
              while (list($key, $tag) = each($innbk)) {
                if (substr($lvalue, 1) == $tag) {
                  unset($innbk[$key]);
                  break;
                }
              }
              $innbk = array_values($innbk);
            }
          }

        // Else if we're outside any tags...
        } else if ($value) {

          // If unprotected...
          if (!count($innbk)) {

            // Use the ACK (006) ASCII symbol to replace all HTML entities temporarily
            $value = str_replace("\x06", "", $value);
            preg_match_all("/&([a-z\d]{2,7}|#\d{2,5});/i", $value, $ents);
            $value = preg_replace("/&([a-z\d]{2,7}|#\d{2,5});/i", "\x06", $value);

            // Enter the line-break loop
            do {
              $store = $value;

              // Find the first stretch of characters over the $width limit
              if (preg_match("/^(.*?\s)?(\S{".$width."})(?!(".preg_quote($break, "/")."|\s))(.*)$/s".(($utf8) ? "u" : ""), $value, $match)) {

                if (strlen($match[2])) {
                  // Determine the last "safe line-break" character within this match
                  for ($x = 0, $ledge = 0; $x < strlen($lbrks); $x++) $ledge = max($ledge, strrpos($match[2], $lbrks{$x}));
                  if (!$ledge) $ledge = strlen($match[2]) - 1;

                  // Insert the modified string
                  $value = $match[1].substr($match[2], 0, $ledge + 1).$break.substr($match[2], $ledge + 1).$match[4];
                }
              }

            // Loop while overlimit strings are still being found
            } while ($store != $value);

            // Put captured HTML entities back into the string
            foreach ($ents[0] as $ent) $value = preg_replace("/\x06/", $ent, $value, 1);
          }
        }
    }

    // Send the modified segment down the drain
    $drain .= $value;
  }

  // Return contents of the drain
  return $drain;
}


function br2nl($text)
   {
       /* Remove XHTML linebreak tags. */
       $text = str_replace("<br />","",$text);
       /* Remove HTML 4.01 linebreak tags. */
       $text = str_replace("<br>","",$text);
       /* Return the result. */
       return $text;
   }

function insertbbcode($fusnewsm){
	$fusnewsm = eregi_replace("\\[color=([^\\[]*)\\]([^\\[]*)\\[/color\\]","<font color=\"\\1\">\\2</font>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[size=([^\\[]*)\\]([^\\[]*)\\[/size\\]","<font size=\"\\1\">\\2</font>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[font=([^\\[]*)\\]([^\\[]*)\\[/font\\]","<font face=\"\\1\">\\2</font>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[img height=([^\\[]*)\\ width=([^\\[]*)\\]([^\\[]*)\\[/img\\]","<img src=\"\\3\" alt=\"\\3\" height=\"\\1\" width=\"\\2\">",$fusnewsm);
	$fusnewsm = eregi_replace("\\[img width=([^\\[]*)\\ height=([^\\[]*)\\]([^\\[]*)\\[/img\\]","<img src=\"\\3\" alt=\"\\3\" width=\"\\1\" height=\"\\2\">",$fusnewsm);
	$fusnewsm = eregi_replace("\\[img]([^\\[]*)\\[/img\\]","<img src=\"\\1\" alt=\"\\1\">",$fusnewsm);
	$fusnewsm = eregi_replace("\\[flash=([^\\[]*)\\,([^\\[]*)\\]([^\\[]*)\\[/flash\\]","<object classid=\"clsid: D27CDB6E-AE6D-11cf-96B8-444553540000\" width=\\1 height=\\2><param name=movie value=\\3><param name=play value=true><param name=loop value=true><param name=quality value=high><embed src=\\3 width=\\1 height=\\2 play=true loop=true quality=high></embed></object>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[video]([^\\[]*)\\[/video\\]","<object classid=\"mediaPlayer\" width=\"320\" height=\"285\" codebase=\"http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701\" standby=\"Loading Microsoft Windows Media Player components...\" type=\"application/x-oleobject\"><param name=\"movie\" value=\"\\1\">
	<param name=\"fileName\" value=\"\\3\">
	<param name=\"animationatStart\" value=\"true\">
	<param name=\"transparentatStart\" value=\"true\">
	<param name=\"autoStart\" value=\"true\">
	<param name=\"showControls\" value=\"true\">
	<param name=\"loop\" value=\"true\">
	<EMBED type=\"application/x-mplayer2\"
		pluginspage=\"http://microsoft.com/windows/mediaplayer/en/download/\"
		id=\"mediaPlayer\" name=\"mediaPlayer\" displaysize=\"4\" autosize=\"-1\" 
		bgcolor=\"darkblue\" showcontrols=\"true\" showtracker=\"-1\" 
		showdisplay=\"0\" showstatusbar=\"-1\" videoborder3d=\"-1\" width=\"320\" height=\"285\"
		src=\"\\1\" autostart=\"true\" designtimesp=\"5311\" loop=\"true\">
	</EMBED>
	</object>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[align=([^\\[]*)\\]([^\\[]*)\\[/align\\]","<div style=\"text-align:\\1\">\\2</div>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[shadow=([^\\[]*)\\,([^\\[]*)\\,([^\\[]*)\\]([^\\[]*)\\[/shadow\\]","<font style=\"Filter: Shadow(color=\\1, Direction=\\2); Width=\\3px;\">\\4</font>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[glow=([^\\[]*)\\,([^\\[]*)\\,([^\\[]*)\\]([^\\[]*)\\[/glow\\]","<font style=\"Filter: Glow(color=\\1, Strength=\\2); Width=\\3px;\">\\4</font>",$fusnewsm);
	$fusnewsm = str_replace("[move]", "<marquee>", $fusnewsm);
	$fusnewsm = str_replace("[/move]", "</marquee>", $fusnewsm);
	$fusnewsm = str_replace("[hr]", "<hr>", $fusnewsm);
	$fusnewsm = str_replace("[sub]", "<sub>", $fusnewsm);
	$fusnewsm = str_replace("[/sub]", "</sub>", $fusnewsm);
	$fusnewsm = str_replace("[tt]", "<tt>", $fusnewsm);
	$fusnewsm = str_replace("[/tt]", "</tt>", $fusnewsm);
	$fusnewsm = str_replace("[sup]", "<sup>", $fusnewsm);
	$fusnewsm = str_replace("[/sup]", "</sup>", $fusnewsm);
	$fusnewsm = str_replace("[s]", "<s>", $fusnewsm);
	$fusnewsm = str_replace("[/s]", "</s>", $fusnewsm);
	$fusnewsm = str_replace("[b]", "<b>", $fusnewsm);
	$fusnewsm = str_replace("[/b]", "</b>", $fusnewsm);
	$fusnewsm = str_replace("[i]", "<i>", $fusnewsm);
	$fusnewsm = str_replace("[/i]", "</i>", $fusnewsm);
	$fusnewsm = str_replace("[u]", "<u>", $fusnewsm);
	$fusnewsm = str_replace("[/u]", "</u>", $fusnewsm);
	$fusnewsm = str_replace("[*]", "<li>", $fusnewsm);
	$fusnewsm = str_replace("[list]", "<ul>", $fusnewsm);
	$fusnewsm = str_replace("[/list]", "</ul>", $fusnewsm);
	$fusnewsm = eregi_replace("\\[email\\]([^\\[]*)\\[/email\\]", "<a href=\"mailto:\\1\">\\1</a>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[email=([^\\[]*)\\]([^\\[]*)\\[/email\\]", "<a href=\"mailto:\\1\">\\2</a>",$fusnewsm);
	$fusnewsm = str_replace("[quote]", "<blockquote><span class=\"12px\">quote:</span><hr>", $fusnewsm);
	$fusnewsm = str_replace("[/quote]", "<hr></blockquote>", $fusnewsm);
	$fusnewsm = str_replace("[code]","<blockquote><pre>",$fusnewsm);
	$fusnewsm = str_replace("[/code]","</pre></blockquote>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[url\\]www.([^\\[]*)\\[/url\\]", "<a  href=\"http://www.\\1\" target=\"_blank\">\\1</a>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[url\\]([^\\[]*)\\[/url\\]","<a href=\"\\1\" target=\"_blank\">\\1</a>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[url=([^\\[]*)\\]([^\\[]*)\\[/url\\]","<a href=\"\\1\" target=\"_blank\">\\2</a>",$fusnewsm);
	return $fusnewsm;
}

function grande($testo) {
    echo "<font class=\"grande\">$testo</font>";
}

function normale ($testo) {
    echo "<font class=\"normale\">$testo</font>";
}
function noecho_normale ($testo) {
    $stringa = "<font class=\"normale\">$testo</font>";
return($stringa);
}

function titoletti ($testo) {
    echo "<font class=\"titoletti\">$testo</font>";
}

function titoli ($testo) {
    echo "<font class=\"titoli\">$testo</font>";
}

function ln_normali ($dest, $testo, $target) {
	if ($target == '') {
           echo "<a href=\"$dest\" class=\"normal\">$testo</a>" ;
                }
	else {
	       echo "<a href=\"$dest\" target=\"$target\" class=\"normal\" >$testo</a>";
	}
}
function noecho_ln_normali ($dest, $testo, $target) {
	if ($target == '') {
           $stringa = "<a href=\"$dest\" class=\"normal\">$testo</a>" ;
                }
	else {
	   $stringa = "<a href=\"$dest\" target=\"$target\" class=\"normal\" >$testo</a>";
	}
return($stringa);
}
function ln_title ($dest, $testo, $target) {
	if ($target == '') {
           echo "<a href=\"$dest\" class=\"title\">$testo</a>" ;
                }
	else {
	       echo "<a href=\"$dest\" target=\"$target\" class=\"title\" >$testo</a>";
	}
}
function noecho_ln_title ($dest, $testo, $target) {
	if ($target == '') {
           $stringa = "<a href=\"$dest\" class=\"title\">$testo</a>" ;
                }
	else {
	   $stringa = "<a href=\"$dest\" target=\"$target\" class=\"title\" >$testo</a>";
	}
return($stringa);
}
function ln_piccoli ($dest, $testo, $target) {
	if ($target == '') {
           echo "<a href=\"$dest\" class=\"linkpiccoli\">$testo</a>";
           }
	else {
        echo "<a href=\"$dest\" target=\"$target\" class=\"linkpiccoli\" >$testo</a>";
	}
}
function noecho_ln_piccoli ($dest, $testo, $target) {
	if ($target == '') {
           $stringa = "<a href=\"$dest\" class=\"linkpiccoli\">$testo</a>";
           }
	else {
        $stringa = "<a href=\"$dest\" target=\"$target\" class=\"linkpiccoli\" >$testo</a>";
	}
return ($stringa);
}
function ln_menu ($dest, $testo, $target) {
	if ($target == '') {
           echo "<a href=\"$dest\" class=\"menu\">$testo</a>";
            }
	else {
	       echo "<a href=\"$dest\" target=\"$target\" class=\"menu\" >$testo</a>";
	}
}
function noecho_ln_menu ($dest, $testo, $target) {
	if ($target == '') {
           $stringa = "<a href=\"$dest\" class=\"menu\">$testo</a>";
            }
	else {
	   $stringa = "<a href=\"$dest\" target=\"$target\" class=\"menu\" >$testo</a>";
	}
return ($stringa);
}


function xhtml_substr($text, $lenght){
	/* function to cut xhtml document
	   by fain182 at gmail dot com
	   arguments:
	   $text - the text to cut
	   $lenght - minimum lenght of the text
	 */
	 if ( strlen($text) <= $lenght ) return $text;
		
	$i = 0;
	$tag_opened = 0;

	while ( strlen($text) > $i) {
		if ( ( $text{$i} == "<" ) && ( $text{$i+1} == "/" ) ) $tag_opened--;
		
		if ( ($text{$i} == "<" ) && ($text{$i+1} != "/") ){
			$b = $i;
			while ($text{$b} != ">") $b++;
			if ($text{$b-1} != "/") $tag_opened++;
			if ($text{$b-1} == "/") $i = $b;
			}

		if ( ($text{$i} == " ") && ($i > $lenght) && ($tag_opened == 0) ) {
			$text = substr($text, 0, $i);
			return $text . " ...";
			}
		$i++;
		}

	return $text;
}

function loggante($mod, $log){
	//prendo ip e data/ora
	$ip = $_SERVER['REMOTE_ADDR'];
	$data = mktime();
	// controlli sull'input per evitare problemi di sicurezza
	$mod = addslashes(stripslashes($mod));
	$log = addslashes(stripslashes($log));
	$mod = str_replace("<", "&lt;", $mod);
	$mod = str_replace(">", "&gt;", $mod);
	$log = str_replace("<", "&lt;", $log);
	$log = str_replace(">", "&gt;", $log);
	
	//inserisco il tutto nel db
	$query = "INSERT INTO ".sineconf('db:prefisso_tab')."log (data, modulo, ip, log) VALUES ('$data', '$mod', '$ip', '$log')";

	if (mysql_query($query, sineconf('db:db'))) return 0;
	echo mysql_error(sineconf('db:db'));

	return 1;
}

function connetti_db() {
//I don't know why we still have to do this...
    include "config.inc.php";
}

function setInput( $var = '' )
{
if (ereg("\.html", $_SERVER['REQUEST_URI'])){
      $input = explode( '_', $_GET['string'] );

      for( $i = 0; $i < count( $input ); $i++ )
      {
            if( $i != 0 )
            {
                  $input_array[ $input[ $i ] ] = $input[ $i + 1 ];
                  $i++;
            }
      }

      $input_array['mods'] = $input[0];

      unset( $_GET );
      $_GET = $input_array;
}
}
?>