<?
/**
* Export-subfile. Choses which XSL-Script to use.
* 
* In this file there are several forms which help choosing the proper XSL-Script 
* to transform the export-data into a specific file-format.
*
* @author		Arne Schroeder <schroeder@data.quest.de>
* @version		$Id: export_choose_xslt.inc.php,v 1.1 2006/03/16 16:33:29 anoack Exp $
* @access		public
* @modulegroup		export_modules
* @module		export_choose_xslt
* @package		Export
*/
// +---------------------------------------------------------------------------+
// This file is part of Stud.IP
// export_choose_xslt.inc.php
// pages for choosing an xslt-script
// 
// Copyright (c) 2002 Arne Schroeder <schroeder@data-quest.de> 
// Suchi & Berg GmbH <info@data-quest.de>
// +---------------------------------------------------------------------------+
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or any later version.
// +---------------------------------------------------------------------------+
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// +---------------------------------------------------------------------------+

$perm->check("tutor");

require_once ("$ABSOLUTE_PATH_STUDIP$PATH_EXPORT/export_xslt_vars.inc.php");   // Liste der XSLT-Skripts
require_once ("$ABSOLUTE_PATH_STUDIP/dates.inc.php");   // Datumsfunktionen

$cssSw = new cssClassSwitcher;									// Klasse fr Zebra-Design
$cssSw->enableHover();


/**
* Checks given parameters
*
* This function checks the given parameters. If some are missing or refer to a XSL-file that 
* doesn't exist it returns false and adds a warning to export_error.
*
* @access	public        
* @return		boolean
*/
function CheckParamXSLT()
{
global $ex_type, $xml_file_id, $page, $o_mode, $format, $choose, $xslt_files, $export_o_modes, $export_ex_types, $export_error, $export_error_num;
	if ($page==1)
	{
		reset($xslt_files);
		while (list($key, $val) = each($xslt_files))
			if ($val[$ex_type] AND $val[$format])
				$mod_counter++;
		if (($mod_counter == 0) AND ($format != "xml"))
		{	
			$export_error .= _("Fr dieses Format sind keine Ausgabemodule installiert.<br>Bitte whlen Sie ein anderes Ausgabeformat.") . "<br>";
			$page = 0;
		}

		if ($format == "")
			$page = 0;
		reset($xslt_files);
	}

	if ( ($page==2) AND ($choose == "") )
		$page = 1;
	if ( /*($xml_file_id != "") AND */( in_array($ex_type, $export_ex_types) ) AND ( in_array($o_mode, $export_o_modes) ) )
		return true;

	$export_error .= "<b>" . _("Unzulssiger Seitenaufruf!") . "</b><br>";
	$export_error_num++;
	return false;
}

$export_pagename = _("Konvertierung der Daten: ");

if (!CheckParamXSLT()) 
{
	$export_pagename .= _("Es ist ein Fehler aufgetreten ");
	$infobox = array(			
	array ("kategorie"  => _("Information:"),
		"eintrag" => array	(	
						array (	"icon" => "pictures/ausruf_small.gif",
								"text"  => _("Die Parameter, mit denen diese Seite aufgerufen wurde, sind fehlerhaft oder unvollstndig.")
							 )
						)
		)
	);
}

// Die Seiten 2 und 3 ueberspringen, wenn als Dateiformat XML gewaehlt wurde
if (($format == "xml") AND ($page == 1))
{
	$xml_file_id = "";
	$o_mode = "file";
	$page = 3;
}

elseif (!isset($page) or ($page == 0)) // Seite 1 : Auswahl des Dateiformats
{ 
	$export_pagename .= _("Auswahl des Dateiformats");
	
	unset($export_msg);
	unset($xml_printimage);
	unset($xml_printlink);
	unset($xml_printdesc);
	unset($xml_printcontent);
	
	$count = 0;
	if (!isset($ex_sem_class))
		foreach ($SEM_CLASS as $key=>$val) 
		{
			if (isset($GLOBALS["ex_class_" . $count])) 
				$ex_sem_class .= "1";
			else 
				$ex_sem_class .= "0";
			$count ++;
		}

	$export_info = _("Bitte whlen Sie, in welchem Format die Daten ausgegeben werden sollen!") . "<br>";

	$export_pagecontent .= "<form method=\"POST\" action=\"" . $PHP_SELF . "\">";
	
	$export_pagecontent .= "";
	$export_pagecontent .= "<b><font size=\"-1\">"._("Ausgabeformat:") .  "</font></b><br /><select name=\"format\">";

	while (list($key, $val) = each($output_formats))
	{
		$export_pagecontent .= "<option value=\"" . $key . "\"";
		if ($format==$key) $export_pagecontent .= " selected";
		$export_pagecontent .= ">" . $val;
	}
	$export_pagecontent .= "</select><br>	<br><br>";
	
	$export_pagecontent .= "<b><font size=\"-1\">"._("Name der Datei (z.B. &raquo;Test&laquo;):")."</font></b><br />";
	$export_pagecontent .= "<input type=\"text\" name=\"xslt_filename\" value=\"" . $xslt_filename . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"page\" value=\"1\"><br><br><br>";
	$export_pagecontent .= "<input type=\"hidden\" name=\"o_mode\" value=\"" . $o_mode . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"range_id\" value=\"" . $range_id . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_sem\" value=\"" . $ex_sem . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_sem_class\" value=\"" . $ex_sem_class . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_type\" value=\"" . $ex_type . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"choose\" value=\"" . $choose . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"xml_file_id\" value=\"" . $xml_file_id . "\">";

	$export_weiter_button = "<br /><center><input type=\"IMAGE\" " . makeButton("zurueck", "src") . " value=\"" . _("Zur&uuml;ck") . "\" name=\"back\">&nbsp;";
	$export_weiter_button .= "<input type=\"IMAGE\" " . makeButton("weiter", "src") . " name=\"next\">";

	$export_weiter_button .= "</center></form>";

	$infobox = array	(			
	array ("kategorie"  => _("Information:"),
		"eintrag" => array	(	
						array (	"icon" => "pictures/ausruf_small.gif",
								"text"  => sprintf(_("Diese Seite bereitet die Datenausgabe vor. %s Schritt 1/3 %s"), "<br><i>", "</i>")
							 )
						)
		)
	);
	$link = "<a href=\"./test.xml"."\">";
	$infobox[1]["kategorie"] = _("Aktionen:");
		$infobox[1]["eintrag"][] = array (	"icon" => "pictures/forumrot.gif" ,
									"text"  => _("Bitte w&auml;hlen Sie das Dateiformat, in dem Ihre Daten ausgegeben werden sollen. Klicken Sie anschlieend auf 'weiter'.")
								);
}


elseif ($page == 1) // Seite 2 : Auswahl des XSLT-Scripts
{
	if (strpos($choose, $format) === false)
		unset($choose);
	$export_pagename .= _("Auswahl des Ausgabemoduls");

	$export_info = _("W&auml;hlen Sie bitte eine der folgenden XSLT-Dateien und klicken Sie auf 'weiter'");

	$export_pagecontent .= "<form method=\"POST\" action=\"" . $PHP_SELF . "\">";
	$export_pagecontent .= "";
	$export_pagecontent .= "<table cellspacing=\"0\" cellpadding=\"1\" border=\"0\" width=\"100%\">";
	$export_pagecontent .= "<tr align=\"center\" valign=\"top\">";
	$export_pagecontent .= "<th width=\"5%\"><b>&nbsp;</b></th>";
	$export_pagecontent .= "<th width=\"15%\" align=\"left\">" . _("Ausgabemodul") . "</th>";
	$export_pagecontent .= "<th width=\"80%\"><b>" . _("Beschreibung") . "</b></th>";
	$export_pagecontent .= "</tr>";
	
	$opt_num = 0;
	while (list($key, $val) = each($xslt_files))
	{
		if ($val[$ex_type] AND $val[$format])
		{
			$cssSw->switchClass();
			$export_pagecontent .= "<tr " . $cssSw->getHover() . ">";
			$export_pagecontent .= "<td class=\"" . $cssSw->getClass() . "\">&nbsp;<input type=\"radio\" name=\"choose\" value=\"" . $key . "\"";
			if (($key == $choose) OR ( ($choose == "") AND ($opt_num == 0) ) ) $export_pagecontent .= " checked";
			$export_pagecontent .= ">&nbsp;</td>";
			$export_pagecontent .= "<td class=\"" . $cssSw->getClass() . "\">" . $val["name"] . "&nbsp;</td>";
			$export_pagecontent .= "<td class=\"" . $cssSw->getClass() . "\">" . $val["desc"] . "</td>";
			$export_pagecontent .= "</tr>";
			$opt_num++;
		}
	}
	
	$export_pagecontent .= "<br>";
	$export_pagecontent .= "</table>";
	$export_pagecontent .= "<input type=\"hidden\" name=\"page\" value=\"2\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"format\" value=\"" . $format . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"o_mode\" value=\"" . $o_mode . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_type\" value=\"" . $ex_type . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_sem\" value=\"" . $ex_sem . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_sem_class\" value=\"" . $ex_sem_class . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"range_id\" value=\"" . $range_id . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"xml_file_id\" value=\"" . $xml_file_id . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"xslt_filename\" value=\"" . $xslt_filename . "\">";
	
	$export_weiter_button = "<center><input type=\"IMAGE\" " . makeButton("zurueck", "src") . " value=\"" . _("Zur&uuml;ck") . "\" name=\"back\">&nbsp;";
	$export_weiter_button .= "<input type=\"IMAGE\" " . makeButton("weiter", "src") . " name=\"next\"";
	if ($skip_page_3 AND $XSLT_ENABLE)
		$export_weiter_button .=  " onClick=\"return export_start();\"";
	$export_weiter_button .=  "></center></form>";

	
	$infobox = array	(			
	array ("kategorie"  => _("Information:"),
		"eintrag" => array	(	
						array (	"icon" => "pictures/ausruf_small.gif",
								"text"  => sprintf(_("Diese Seite bereitet die Datenausgabe vor. %s Schritt 2/3 %s"), "<br><i>", "</i>")
							 )
						)
		)
	);
	$link = "<a href=\"./test.xml"."\">";
	$infobox[1]["kategorie"] = _("Aktionen:");
		$infobox[1]["eintrag"][] = array (	"icon" => "pictures/forumrot.gif" ,
									"text"  => _("W&auml;hlen Sie bitte eines der zur Verf&uuml;gung stehenden Ausgabemodule. Klicken Sie dann auf 'weiter'.")
								);
}


elseif ($page == 2)  // Seite 3 : Download der Dateien
{
	$export_pagename .= _("Download der Dateien");

	$export_info = _("Die ben&ouml;tigten Dateien liegen nun zum Download bereit.");
	$export_pagecontent .= "<form method=\"POST\" action=\"" . $PHP_SELF . "\">";

	$xml_printimage = '<a href="'. GetDownloadLink($xml_file_id, $xml_filename, 2) . '"><img src="pictures/' . $export_icon['xml'] . '" border=0></a>';
	$xml_printlink = '<a href="' . GetDownloadLink($xml_file_id, $xml_filename, 2) . '">' . $xml_filename . '</a>';
	$xml_printdesc = _("XML-Daten");
	$xml_printcontent = _("In dieser Datei sind die Daten als XML-Tags gespeichert. Diese Tags knnen mit einem XSLT-Script verarbeitet werden.") . "<br>";	

	$xslt_printimage = '<a href="' . GetDownloadLink( $xslt_files[$choose]['file'], $xslt_files[$choose]['name'] . '.xsl', 3). '"><img src="pictures/' . $export_icon['xslt'] . '" border=0></a>';
	$xslt_printlink = '<a href="'.GetDownloadLink( $xslt_files[$choose]['file'], $xslt_files[$choose]['name'] . '.xsl', 3).'">' . $xslt_files[$choose]['name'] . '.xsl</a>';
	$xslt_printdesc = _("XSLT-Datei");
	$xslt_printcontent = _("Dies ist das XSLT-Script zur Konvertierung der Daten. Klicken Sie auf den Dateinamen, um die Datei zu &ouml;ffnen.") . "<br>";	

	$export_pagecontent .= "";
	$export_pagecontent .= "<input type=\"hidden\" name=\"page\" value=\"3\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"choose\" value=\"" . $choose . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"format\" value=\"" . $format . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"o_mode\" value=\"" . $o_mode . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_type\" value=\"" . $ex_type . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_sem\" value=\"" . $ex_sem . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"ex_sem_class\" value=\"" . $ex_sem_class . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"range_id\" value=\"" . $range_id . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"xml_file_id\" value=\"" . $xml_file_id . "\">";
	$export_pagecontent .= "<input type=\"hidden\" name=\"xslt_filename\" value=\"" . $xslt_filename . "\">";

	$export_weiter_button = "<center><input type=\"IMAGE\" " . makeButton("zurueck", "src") . " value=\"" . _("Zur&uuml;ck") . "\" name=\"back\">&nbsp;";
	if ($XSLT_ENABLE) 
	{
		$export_pagecontent .= _("Um die Daten mit dem installierten XSLT-Prozessor in das gew&uuml;nschte Format zu bringen, klicken Sie bitte auf 'weiter'") . "<br><br>";
		$export_weiter_button .= "<input type=\"IMAGE\" " . makeButton("weiter", "src") . " onClick=\"return export_start();\" name=\"next\">";
	}
	else
		$export_pagecontent .= "<br><br><br>";
		
	$export_weiter_button .= "</center></form>";

	$infobox = array	(			
	array ("kategorie"  => _("Information:"),
		"eintrag" => array	(	
						array (	"icon" => "pictures/ausruf_small.gif",
								"text"  => sprintf(_("Diese Seite bereitet die Datenausgabe vor. %s Schritt 3/3 %s"), "<br><i>", "</i>")
							 )
						)
		)
	);
	$link = "<a href=\"./test.xml"."\">";
	$infobox[1]["kategorie"] = _("Aktionen:");
		$infobox[1]["eintrag"][] = array (	"icon" => "pictures/icon-disc.gif" ,
									"text"  => _("Sie knnen sich die XML-Daten und das XSLT-Skript herunterladen.")
								);
	if ($XSLT_ENABLE) 
	{
		$infobox[1]["eintrag"][] = array (	"icon" => "pictures/forumrot.gif" ,
									"text"  => _("Wenn Sie auf 'weiter' klicken, wird mit dem installierten XSLT-Prozessor die Ausgabedatei erzeugt.")
								);
	}
}
?>
