<?
/**
* ExternElementTableHeader.class.php
* 
* 
* 
*
* @author		Peter Thienel <pthienel@web.de>, Suchi & Berg GmbH <info@data-quest.de>
* @version	$Id: ExternElementTableHeader.class.php,v 1.1 2006/03/16 16:32:17 anoack Exp $
* @access		public
* @modulegroup	extern
* @module		ExternElementTableHeader
* @package	studip_extern
*/

// +---------------------------------------------------------------------------+
// This file is part of Stud.IP
// ExternElementTableHeader.class.php
// 
// Copyright (C) 2003 Peter Thienel <pthienel@web.de>,
// Suchi & Berg GmbH <info@data-quest.de>
// +---------------------------------------------------------------------------+
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or any later version.
// +---------------------------------------------------------------------------+
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// +---------------------------------------------------------------------------+


require_once($GLOBALS["ABSOLUTE_PATH_STUDIP"].$GLOBALS["RELATIVE_PATH_EXTERN"]."/lib/ExternElement.class.php");

class ExternElementTableHeader extends ExternElement {

	var $attributes = array("table_width", "table_align", "table_border", "table_bgcolor",
				"table_bordercolor", "table_cellpadding", "table_cellspacing", "table_class",
				"table_style");
	
	/**
	* Constructor
	*
	* @param array config
	*/
	function ExternElementTableHeader ($config = "") {
		if ($config)
			$this->config = $config;
		
		$this->name = "TableHeader";
		$this->real_name = _("Tabellenkopf");
		$this->description = _("Angaben zur Gestaltung der Tabelle.");
	}
	
	function toString ($args) {
		$out = "\n" . $this->config->getTag($this->name, "table") . "\n";
		$out .= $args["content"] . "</table>\n";
		
		return $out;
	}
	
}

?>
