<?
/**
* ExternElementMain.class.php
* 
*  
* 
*
* @author		Peter Thienel <pthienel@web.de>, Suchi & Berg GmbH <info@data-quest.de>
* @version	$Id: ExternElementMain.class.php,v 1.1 2006/03/16 16:32:17 anoack Exp $
* @access		public
* @modulegroup	extern
* @module		ExternElementMain
* @package	studip_extern
*/

// +---------------------------------------------------------------------------+
// This file is part of Stud.IP
// ExternElementMain.class.php
// 
// Copyright (C) 2003 Peter Thienel <pthienel@web.de>,
// Suchi & Berg GmbH <info@data-quest.de>
// +---------------------------------------------------------------------------+
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or any later version.
// +---------------------------------------------------------------------------+
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// +---------------------------------------------------------------------------+


require_once($GLOBALS["ABSOLUTE_PATH_STUDIP"].$GLOBALS["RELATIVE_PATH_EXTERN"]."/lib/ExternElement.class.php");
require_once($GLOBALS["ABSOLUTE_PATH_STUDIP"].$GLOBALS["RELATIVE_PATH_EXTERN"]."/lib/extern_functions.inc.php");

class ExternElementMain extends ExternElement {

	var $attributes = array();
	var $edit_function = "";
	var $data_fields;
	var $field_names;

	/**
	* Constructor
	*
	*/
	function ExternElementMain ($module_name, &$data_fields,
			&$field_names, &$config) {
			
		$this->real_name = _("Grundeinstellungen");
		$this->description = _("In den Grundeinstellungen k&ouml;nnen Sie allgemeine Daten des Elements ndern.");
		
		if ($module_name != "") {
			$main_class_name = "ExternElementMain" . $module_name;
			require_once($GLOBALS["ABSOLUTE_PATH_STUDIP"] . $GLOBALS["RELATIVE_PATH_EXTERN"]
					. "/elements/main/$main_class_name.class.php");
			$this = new $main_class_name();
		}
		$this->name = "Main";
		$this->config =& $config;
		$this->data_fields =& $data_fields;
		$this->field_names =& $field_names;
		if ($GLOBALS['EXTERN_SRI_ENABLE'] && (!$GLOBALS['EXTERN_SRI_ENABLE_BY_ROOT'] ||
				(sri_is_enabled($this->config->range_id) && $GLOBALS['EXTERN_SRI_ENABLE_BY_ROOT']))) {
			$this->attributes[] = 'sriurl';
		}
	}
	
	/**
	* 
	*/
	function getDefaultConfig () {}
	
	/**
	* 
	*/
	function toStringEdit ($post_vars = "", $faulty_values = "",
			$edit_form = "", $anker = "") {
		
		$out = '';
		$table = '';
		if ($edit_form == '')
			$edit_form =& new ExternEdit($this->config, $post_vars, $faulty_values, $anker);
		
		$edit_form->setElementName($this->getName());
		$element_headline = $edit_form->editElementHeadline($this->real_name,
				$this->config->getName(), $this->config->getId(), TRUE);
		
		if ($faulty_values == '')
			$faulty_values = array();
		
		$edit_function = $this->edit_function;
		$table = $edit_form->$edit_function($this->field_names);

		$content_table = $edit_form->editContentTable($tag_headline, $table);
		$submit = $edit_form->editSubmit($this->config->getName(),
				$this->config->getId(), $this->getName());
		$out = $edit_form->editContent($content_table, $submit);
		$out .= $edit_form->editBlank();
		
		return $element_headline . $out;
	}
	
	function getSRIFormContent (&$edit_form) {
		$content = '';
		if ($GLOBALS['EXTERN_SRI_ENABLE'] && (!$GLOBALS['EXTERN_SRI_ENABLE_BY_ROOT'] ||
				(sri_is_enabled($this->config->range_id) && $GLOBALS['EXTERN_SRI_ENABLE_BY_ROOT']))) {
			$headline = $edit_form->editHeadline(_("URL des SRI-Templates"));
			$info = _("Nur bei Benutzung der SRI-Schnittstelle fr dieses Modul: Geben Sie hier die vollstndige URL der Seite an, in die die Ausgabe des Moduls eingefgt werden soll.");
			$table = $edit_form->editTextfieldGeneric("sriurl", '', $info, 70, 350);
			$content = $edit_form->editContentTable($headline, $table);
			$content .= $edit_form->editBlankContent();
		}
		return $content;
	}
		
}

?>
