<?php
// +---------------------------------------------------------------------------+
// This file is part of Stud.IP
// StudipLitSearchPluginUlb.class.php
// 
// 
// Copyright (c) 2003 Andr Noack <noack@data-quest.de>
// Modified by Cornelius Hempel, 2004
// +---------------------------------------------------------------------------+
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or any later version.
// +---------------------------------------------------------------------------+
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// +---------------------------------------------------------------------------+

require_once ($GLOBALS['ABSOLUTE_PATH_STUDIP'] . "/lib/classes/lit_search_plugins/StudipLitSearchPluginZ3950Abstract.class.php");

/**
* Plugin for retrieval using Z39.50 
*
* 
*
* @access	public	
* @author	Andr Noack <noack@data-quest.de>
* @version	$Id: StudipLitSearchPluginLeopoldina.class.php,v 1.1 2006/03/16 16:30:10 anoack Exp $
* @package	
**/
class StudipLitSearchPluginLeopoldina extends StudipLitSearchPluginZ3950Abstract{
	
	
	function StudipLitSearchPluginLeopoldina(){
		parent::StudipLitSearchPluginZ3950Abstract();
		$this->description = "Deutsche Akademie der Naturforscher Leopoldina";
		$this->z_host = "z3950.gbv.de:20010/leop_opc";
		$this->z_options = array('user' => '999', 'password' => 'abc');
		$this->z_syntax = "UNIMARC";
		$this->convert_umlaute = true;



		$this->z_profile = array('1016' => _("Basisindex [ALL]"),
					 '2' => _("Krperschaftsname [KOS]"),
					 '3' => _("Kongress [KNS]"),
					 '4' => _("Titelstichwrter [TIT]"),
					 '5' => _("Serienstichwrter [SER]"), 
					 '7' => _("ISBN [ISB]"),
					 '8' => _("ISSN [ISS]"), 
					 '12' => _("PICA Prod.-Nr [PPN]"),
					 '21' => _("alle Klassifikationen [SYS]"), 
					 '1004' => _("Person, Author [PER]"),
					 '1005' => _("Krperschaften [KOR]"), 
					 '1006' => _("Kongresse [KON]"),
					 '1007' => _("alle Nummern [NUM]"),
					 '5040' => _("Schlagwoerter [SLW]"),
					 '8580' => _("Verlagsort, Verlag [PUB]"));
	}
}
?>
