<?php
/**
 * Ausgangspunkt fr Administrationsplugins, also Plugins, die speziell im
 * Adminstrator- / Root-Bereich angezeigt werden. 
 * @author Dennis Reil <dennis.reil@offis.de>
 */
// require_once('AbstractStudIPPlugin.class.php');

class AbstractStudIPAdministrationPlugin extends AbstractStudIPPlugin{

	var $topnavigation;
	
	function AbstractStudIPAdministrationPlugin(){
		// Konstruktor der Basisklasse aufrufen
    	AbstractStudIPPlugin::AbstractStudIPPlugin();
    	$this->topnavigation = null;
    	$this->pluginengine = PluginEngine::getPluginPersistence("Administration");
	}	
    
    /**
     * Verfgt dieses Plugin ber einen Eintrag auf der Startseite des
     * Administrators
     * @return  true 	- Hauptmen vorhanden 						
     * 			false	- kein Hauptmen vorhanden
     */
    function hasTopNavigation(){
    	if ($this->topnavigation != null){
    		return true;
    	}
    	else {
    		return false;
    	}
    }
    
    /**
     * Liefert den Meneintrag zurck
     * @return das Men, oder null, wenn kein Men vorhanden ist
     */
    function getTopNavigation(){
    	return $this->topnavigation;
    }
    
    /**
     * Setzt das Hauptmen des Plugins
     */
    function setTopnavigation($newnavigation){
    	if (is_a($newnavigation,'PluginNavigation') || is_subclass_of($newnavigation,'PluginNavigation')){
	    	// $newnavigation->setPluginpath($this->getPluginpath());
    		$this->topnavigation = $newnavigation;
    	}
    }
}
?>