<?PHP
/************************************************************************/
/* PicoFlat - Flat Text Based Content Management System                 */
/* ====================================================                 */
/*                                                                      */
/* Copyright (c) 2007 by Domenico Mancini                               */
/* Mailto: d.mancini@tiscali.it                                         */
/* http://www.beamitaly.tk                                              */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
// Installer
// Questo file di installazione creerà tutte le directory ed
// i file necessari al funzionamento iniziale di PicoflatCMS

if (eregi("install2.php",$_SERVER['PHP_SELF'])) {
	die('<h1>Accesso non consentito</h1>');
}

$pself = $_SERVER['PHP_SELF'];
$dir = strpos($pself, "/", 1);
$base = substr($pself, 0, ($dir)-0);		// home directory
$local_url = "http://".$_SERVER['HTTP_HOST'].$base ;	// URL
$rootdir = $_SERVER['DOCUMENT_ROOT'].$base;	// full homedir

chdir ($rootdir);

echo "<center>";

/************************************************************************/
// Directory CACHE
/************************************************************************/

if (!file_exists("cache")) {
  mkdir ("cache",0775); 
  copy ("_inst_files/motd.php", "cache/motd.php");
  copy ("_inst_files/temp_iconimg.php", "cache/temp_iconimg.php");
  copy ("_inst_files/temp_text.php", "cache/temp_text.php");
  copy ("_inst_files/tmotd.php", "cache/tmotd.php");
  copy ("_inst_files/index.html", "cache/index.html");
  print ("<br /><br />Directory 'cache' creata ...<br /><br />");
}else{
  // Aggionamenti software obbligati
  copy ("_inst_files/index.html", "cache/index.html");
  print "<br /><br />'cache' esiste: non è stata sovrascritta.<br /><br />";
}

/************************************************************************/
// Directory CONTENTS (contents/images|biografia)
/************************************************************************/

if (!file_exists("contents")) {
  mkdir ("contents");
  copy ("_inst_files/ext_link.txt", "contents/ext_link.txt"); // chmod0664
  copy ("_inst_files/motd.php", "contents/motd.php");
  mkdir ("contents/biografia",0775);
  copy ("_inst_files/biografia.php", "contents/biografia/biografia.php");
  mkdir ("contents/images",0775);
  copy ("_inst_files/index.html", "contents/index.html");
  copy ("_inst_files/index.html", "contents/images/index.html");
  copy ("_inst_files/site_map.ph_", "contents/site_map.php");
  copy ("_inst_files/remove_sitemap.ph_", "contents/remove_sitemap.php");
  print ("Directory 'contents' creata ...<br /><br />");
}else{
  // Aggionamenti software obbligati
  copy ("_inst_files/index.html", "contents/index.html");
  copy ("_inst_files/index.html", "contents/images/index.html");
  copy ("_inst_files/site_map.ph_", "contents/site_map.php");
  copy ("_inst_files/remove_sitemap.ph_", "contents/remove_sitemap.php");
  print "'contents' esiste: non è stata sovrascritta.<br /><br />";
}

if (!file_exists("contents/loghi")) {
  mkdir ("contents/loghi",0775);
}else{
  print "'contents/loghi' esiste: non è stata sovrascritta.<br /><br />";
}

  // Aggionamenti software obbligati
if (!file_exists("contents/loghi/bluesky")) {
  mkdir ("contents/loghi/bluesky",0775);
}else{
  print "'contents/loghi/bluesky' esiste: non è stata sovrascritta.<br /><br />";
}
if (!file_exists("contents/loghi/greenleaves")) {
  mkdir ("contents/loghi/greenleaves",0775);
  copy ("_inst_files/logo.png", "contents/loghi/greenleaves/logo.png");
}else{
  print "'contents/loghi/greenleaves' esiste: non è stata sovrascritta.<br /><br />";
}
if (!file_exists("contents/loghi/mistylook")) {
  mkdir ("contents/loghi/mistylook",0775);
}else{
  print "'contents/loghi/mistylook' esiste: non è stata sovrascritta.<br /><br />";
}
if (!file_exists("contents/loghi/spiderman10")) {
  mkdir ("contents/loghi/spiderman10",0775);
}else{
  print "'contents/loghi/spiderman10' esiste: non è stata sovrascritta.<br /><br />";
}
if (!file_exists("contents/loghi/wpscandycoated10")) {
  mkdir ("contents/loghi/wpscandycoated10",0775);
}else{
  print "'contents/loghi/wpscandycoated10' esiste: non è stata sovrascritta.<br /><br />";
}

/************************************************************************/
// Directory IMAGES
/************************************************************************/

if (!file_exists("images")) {
  mkdir ("images",0775);
  copy ("_inst_files/index.html", "images/index.html");
  copy ("_inst_files/terra.gif", "images/terra.gif");
  print ("Directory 'images' creata ...<br /><br />");
}else{
  // Aggionamenti software obbligati
  copy ("_inst_files/index.html", "images/index.html");
  copy ("_inst_files/terra.gif", "images/terra.gif");
  print "'images' esiste: non è stata sovrascritta.<br /><br />";
}

/************************************************************************/
// Directory NEWS
/************************************************************************/

if (!file_exists("news")) {
  mkdir ("news",0775);
  copy ("_inst_files/index.html", "news/index.html");
  print ("Directory 'news' creata ...<br /><br />");
  mkdir ("news/images",0775);
  copy ("_inst_files/index.html", "news/images/index.html");
  print ("Directory 'news/images' creata ...<br /><br />");
}else{
  // Aggionamenti software obbligati
  copy ("_inst_files/index.html", "news/index.html");
  print "'news' esiste: non è stata sovrascritta.<br /><br />";
  if (!file_exists("news/images")) {
    mkdir ("news/images",0775);
    copy ("_inst_files/index.html", "news/images/index.html");
    print ("Directory 'news/images' creata ...<br /><br />");
  }else{
    print "'news/images' esiste: non è stata sovrascritta.<br /><br />";
  }
}

/************************************************************************/
// Directory TEMPDIR
/************************************************************************/

if (!file_exists("tempdir")) {
  mkdir ("tempdir",0775);
  copy ("_inst_files/motd.php", "tempdir/motd.php"); // chmod0664
  copy ("_inst_files/index.html", "tempdir/index.html");
  print ("Direcotry 'tempdir' creata ...<br /><br />");
}else{
  // Aggionamenti software obbligati
  copy ("_inst_files/index.html", "tempdir/index.html");
  print "'tempdir' esiste: non è stata sovrascritta.<br /><br />";
}

/************************************************************************/
// Directory DOWNLOADS
/************************************************************************/

if (!file_exists("downloads")) {
  mkdir ("downloads",0775);
  copy ("_inst_files/download_lista.ph_", "downloads/lista.php");
  copy ("_inst_files/pico_faq.pdf", "downloads/pico_faq.pdf");
  copy ("_inst_files/tutorial_picoimpaginatore.pdf", "downloads/tutorial_picoimpaginatore.pdf");
  print ("Directory 'downloads' creata ...<br /><br />");
}else{
  // Aggionamenti software obbligati
  copy ("_inst_files/download_lista.ph_", "downloads/lista.php");
  print "'downloads' esiste: non è stata creata.<br /><br />";
}

/************************************************************************/
// Password temporanea
/************************************************************************/

if (!file_exists("misc/parole.php")) {
  copy ("_inst_files/parole.php", "misc/parole.php");
  copy ("_inst_files/index.html", "misc/index.html");
  print ("Password temporanea creata ...<br /><br />");
}else{
  // Aggionamenti software obbligati
  copy ("_inst_files/index.html", "misc/index.html");
  print "Il file delle password esiste: non è stata sovrascritta.<br />";
  print "Se non ricordi più la password, devi prima cancellare via FTP il file delle password.<br /><br />";
}

/************************************************************************/
// Directory STATS
/************************************************************************/

if (!file_exists("stats")) {
  mkdir ("stats",0775);
  
  $startdate = date("d-M-Y");
  touch ("stats/_startdate.dat");
  $filew = "stats/_startdate.dat";
  if (!$apriw = fopen ($filew,"w")) {
  	  echo "install2: non posso aprire il file $filew";
  	  die();
  }else{
	  fputs($apriw,"$startdate\n");
  }
  fclose($apriw);

  print ("Directory 'stats' creata ...<br /><br />");
}else{
  print "'stats' esiste: non è stata creata.<br /><br />";
}

if (!file_exists("stats/_startdate.dat")) {
   $startdate = date("d-M-Y");
   touch ("stats/_startdate.dat");
   $filew = "stats/_startdate.dat";
   if (!$apriw = fopen ($filew,"w")) {
        echo "install2: non posso aprire il file $filew";
        die();
   }else{
        fputs($apriw,"$startdate\n");
   }
   fclose($apriw);
   print ("File 'stats/_startdate.dat' creato ...<br /><br />");
}

/************************************************************************/
// Altre directory
/************************************************************************/

if (!file_exists("misc/stored_config.php")) {
  copy ("_inst_files/stored_config.php", "misc/stored_config.php");
}else{
  print "Il file 'stored_config' esiste: non è stato sovrascritto.<br /><br />";
}
if (!file_exists("BoxEvent.txt")) {
	touch ("BoxEvent.txt");
}else{
  print "Il file 'BoxEvent.txt' esiste: non è stato sovrascritto.<br /><br />";
}

/************************************************************************/
// Rimozioni
/************************************************************************/

if (file_exists("misc/phpinfo.php")) {
  unlink ("misc/phpinfo.php");
  print "Il file obsoleto 'phpinfo.php' è stato cancellato";
}
if (file_exists("misc/admin.php")) {
  unlink ("misc/admin.php");
  print "Il file obsoleto 'admin.php' è stato cancellato";
}


### Fine del file Installer

echo "<br /><br /><b>FINE DELLA INSTALLAZIONE.</b><br /><br />";
chdir ("$rootdir");
echo "<a href=\"$local_url\">Vai alla Home Page</a></center>";
?>
