<?php
/*
+--------------------------------------------------------------------------
|   CubeCart v3.0.11
|   ========================================
|   by Alistair Brookbanks
|	CubeCart is a Trade Mark of Devellion Limited
|   (c) 2005 Devellion Limited
|   Devellion Limited,
|   22 Thomas Heskin Court,
|   Station Road,
|   Bishops Stortford,
|   HERTFORDSHIRE.
|   CM23 3EE
|   UNITED KINGDOM
|   http://www.devellion.com
|	UK Private Limited Company No. 5323904
|   ========================================
|   Web: http://www.cubecart.com
|   Date: Thursday, 27th July 2006
|   Email: sales (at) cubecart (dot) com
|	License Type: CubeCart is NOT Open Source Software and Limitations Apply 
|   Licence Info: http://www.cubecart.com/site/faq/license.php
+--------------------------------------------------------------------------
|	testSubmit.php
|   ========================================
|	Submit tests for United States Postal Service account approval
| Created Sunday, 26th November 2005 by Sir William
+--------------------------------------------------------------------------
*/
include("../../../../includes/ini.inc.php");
include("../../../../includes/global.inc.php");
require_once("../../../../classes/db.inc.php");
$db = new db();
include_once("../../../../includes/functions.inc.php");
$config = fetchDbConfig("config");

include_once("../../../../language/".$config['defaultLang']."/lang.inc.php");
$enableSSl = 1;
include_once("../../../../includes/sslSwitch.inc.php");
include("../../../includes/auth.inc.php");
include("../../../includes/header.inc.php");

if(permission("settings","read")==FALSE){
	header("Location: ".$GLOBALS['rootRel']."admin/401.php");
	exit;
}

if(isset($_POST['module'])){
	include("../../status.php");
	include("../../../includes/functions.inc.php");
	$module = fetchDbConfig($_GET['folder']);
	$msg = writeDbConf($_POST['module'], $_GET['folder'], $module);
	
}
$module = fetchDbConfig($_GET['folder']);

require "../../../../modules/shipping/USPS/class.usps.php";

$module['test'] = 1;
$module['debug'] = 1;
$api = "RateV2";

$package1 = array(
	'service' => 'PRIORITY',
	'zip_origin' => '10022',
	'zip_dest' => '20008',
	'pounds' => '10',
	'ounces' => '5',
	'size' => 'REGULAR',
	'container' => 'Flat Rate Box'
);

$package2 = array(
	'service' => 'All',
	'zip_origin' => '10022',
	'zip_dest' => '20008',
	'pounds' => '10',
	'ounces' => '5',
	'size' => 'LARGE',
	'machinable' => 'TRUE'
);

$package3 = array(
	'pounds' => '2',
	'ounces' => '0',
	'mail_type' => 'Package',
	'country' => 'Albania'
);

$package4 = array(
	'pounds' => '0',
	'ounces' => '1',
	'mail_type' => 'Postcards or Aerogrammes',
	'country' => 'Algeria'
);

?>

<p><a href="http://www.usps.com/"><img src="logo.gif" alt="" border="0" title="" /></a></p>
<br />
<?php
// Initiate the USPS Class
$usps = new USPS($module['username'], $module['password'], $api);

if(!$usps->add_package($package1) && $module['debug']==0) die("Failed to add the package");
					
$usps->submit_request();
$rates = $usps->get_rates(0);
$usps->get_package_error(0);
?>
<table border="0" cellspacing="0" cellpadding="3" class="mainTable" width="450" align="center">
  <tr>
    <td colspan="2" class="tdTitle" align="center">USPS Server Domestic Test 1 - Actual Results</td>
  </tr>
<?php		
if(is_array($rates)){

	foreach($rates as $key => $value){

		echo "<tr>";
		echo "<td class=\"tdText\">".$key."</td>";
		echo "<td class=\"tdText\" align=\"right\"><strong>".sprintf("%.2f",$value)."</strong></td>";
		echo "</tr>\n";

	}
	$successful = 1;
}
?>
  <tr>
    <td colspan="2" class="tdTitle" align="center">USPS Server Domestic Test 2 - Actual Results</td>
  </tr>
<?php
// Reset the USPS Class Module to allow a 2nd request from within the same script.
$usps->reset();

// Initiate the USPS Class
$usps = new USPS($module['username'], $module['password'], $api);

if(!$usps->add_package($package2) && $module['debug']==0) die("Failed to add the package");
					
$usps->submit_request();
$rates = $usps->get_rates(0);
$usps->get_package_error(0);
				
if(is_array($rates)){

	foreach($rates as $key => $value){

		echo "<tr>";
		echo "<td class=\"tdText\">".$key."</td>";
		echo "<td class=\"tdText\" align=\"right\"><strong>".sprintf("%.2f",$value)."</strong></td>";
		echo "</tr>\n";

	}
	$successful = 2;
}
?>
	</tr>
</table>
<br />
<table border="0" cellspacing="0" cellpadding="3" class="mainTable" width="450" align="center">
  <tr>
    <td colspan="2" class="tdTitle" align="center">USPS Server International Test 1 - Actual Results</td>
  </tr>
<?php
// Reset the USPS Class Module to allow a 3rd request from within the same script.
$usps->reset();
$api = "IntlRate";

// Initiate the USPS Class
$usps = new USPS($module['username'], $module['password'], $api);

if(!$usps->add_package($package3) && $module['debug']==0) die("Failed to add the package");
					
$usps->submit_request();
$rates = $usps->get_rates(0);
$usps->get_package_error(0);
				
if(is_array($rates)){

	foreach($rates as $key => $value){

		echo "<tr>";
		echo "<td class=\"tdText\">".$key."</td>";
		echo "<td class=\"tdText\" align=\"right\"><strong>".sprintf("%.2f",$value)."</strong></td>";
		echo "</tr>\n";

	}
	$successful = 3;
}
?>
	</tr>
  <tr>
    <td colspan="2" class="tdTitle" align="center">USPS Server International Test 2 - Actual Results</td>
  </tr>
<?php
// Reset the USPS Class Module to allow a 4th request from within the same script.
$usps->reset();

// Initiate the USPS Class
$usps = new USPS($module['username'], $module['password'], $api);

if(!$usps->add_package($package4) && $module['debug']==0) die("Failed to add the package");
					
$usps->submit_request();
$rates = $usps->get_rates(0);
$usps->get_package_error(0);
				
if(is_array($rates)){

	foreach($rates as $key => $value){

		echo "<tr>";
		echo "<td class=\"tdText\">".$key."</td>";
		echo "<td class=\"tdText\" align=\"right\"><strong>".sprintf("%.2f",$value)."</strong></td>";
		echo "</tr>\n";

	}
	$successful = 4;
}
?>
	</tr>
</table>
<p>Now, email USPS at <a href="mailto:icustomercare@usps.com">icustomercare@usps.com</a> or
call them at <strong>1-800-344-7779</strong> (7:00 AM to 11:00 PM EST daily) and they will activate your account to use the live server.</p>
<div align="center">
<?php
if($successful == 4)
	{ ?>
<form action="<?php echo $GLOBALS['rootRel'];?>admin/modules/<?php echo $_GET['module']; ?>/<?php echo $_GET['folder']; ?>/index.php?module=<?php echo $_GET['module']; ?>&amp;folder=<?php echo $_GET['folder']; ?>" method="post" enctype="multipart/form-data">
<input type="hidden" name="module[testspassed]" value="1">
<input type="hidden" name="module[test]" value="0">
<input type="submit" class="submit" value="Register Successful USPS Tests" />
</form>
<?php
	} ?>
</div>
<?php include("../../../includes/footer.inc.php"); ?>