<?php
/*
+--------------------------------------------------------------------------
|   CubeCart v3.0.11
|   ========================================
|   by Alistair Brookbanks
|	CubeCart is a Trade Mark of Devellion Limited
|   Copyright Devellion Limited 2005 - 2006. All rights reserved.
|   Devellion Limited,
|   22 Thomas Heskin Court,
|   Station Road,
|   Bishops Stortford,
|   HERTFORDSHIRE.
|   CM23 3EE
|   UNITED KINGDOM
|   http://www.devellion.com
|	UK Private Limited Company No. 5323904
|   ========================================
|   Web: http://www.cubecart.com
|   Date: Thursday, 27th July 2006
|   Email: sales (at) cubecart (dot) com
|	License Type: CubeCart is NOT Open Source Software and Limitations Apply 
|   Licence Info: http://www.cubecart.com/site/faq/license.php
+--------------------------------------------------------------------------
|	gd.inc.php
|   ========================================
|	GD Class	
+--------------------------------------------------------------------------
*/
class thumbnail
{
	var $img;
	
	function thumbnail($imgfile)
	{
		global $config;
		
		//detect image format
		$this->img["format"]=ereg_replace(".*\.(.*)$","\\1",$imgfile);
		$this->img["format"]=strtoupper($this->img["format"]);
		
		if($config['gdversion']>0){
		
			if ($this->img["format"]=="JPG" || $this->img["format"]=="JPEG") {
				//JPEG
				$this->img["format"]="JPEG";
				$this->img["src"] = ImageCreateFromJPEG ($imgfile);
				
			} elseif ($this->img["format"]=="PNG") {
				//PNG
				$this->img["format"]="PNG";
				$this->img["src"] = ImageCreateFromPNG ($imgfile);
			} elseif ($this->img["format"]=="GIF") {
				//GIF
				$this->img["format"]="GIF";
				$this->img["src"] = ImageCreateFromGIF ($imgfile);
			} else {
				//DEFAULT
				echo "Not Supported File! Thumbnails can only be made from .jpg and .jpeg file types!";
				exit();
			}
			@$this->img["width"] = imagesx($this->img["src"]);
			@$this->img["height"] = imagesy($this->img["src"]);
			//default quality jpeg
			$this->img["quality"]=80;
		
		} else {
		
			return FALSE;
		
		}
		
	}

	function size_width($size=100)
	{
		//width
		$this->img["width_thumb"]=$size;
    	@$this->img["height_thumb"] = ($this->img["width_thumb"]/$this->img["width"])*$this->img["height"];
	}
	function size_auto($size=100)
	{
		//size
		if ($this->img["width"]>=$this->img["height"]) {
    		$this->img["width_thumb"]=$size;
    		@$this->img["height_thumb"] = ($this->img["width_thumb"]/$this->img["width"])*$this->img["height"];
		} else {
	    	$this->img["height_thumb"]=$size;
    		@$this->img["width_thumb"] = ($this->img["height_thumb"]/$this->img["height"])*$this->img["width"];
 		}
	}

	function jpeg_quality($quality=80)
	{
		//jpeg quality
		$this->img["quality"]=$quality;
	}

	function show()
	{
		global $config;
		
		@Header("Content-Type: image/".$this->img["format"]);
 		
		if ($config['gdversion']==2) {
			$this->img["des"] = imagecreatetruecolor($this->img["width_thumb"],$this->img["height_thumb"]);
			@imagecopyresampled ($this->img["des"], $this->img["src"], 0, 0, 0, 0, $this->img["width_thumb"],$this->img["height_thumb"], $this->img["width"], $this->img["height"]);
    		    
		} elseif ($config['gdversion']==1) {    
			$this->img["des"] = imagecreate($this->img["width_thumb"],$this->img["height_thumb"]);
			@imagecopyresized ($this->img["des"], $this->img["src"], 0, 0, 0, 0, $this->img["width_thumb"],$this->img["height_thumb"], $this->img["width"], $this->img["height"]);    
		}
		
		if ($config['gdversion']>0) {
		
			if ($this->img["format"]=="JPG" || $this->img["format"]=="JPEG") {
				//JPEG
				imageJPEG($this->img["des"],"",$this->img["quality"]);
				
			} elseif ($this->img["format"]=="PNG") {
				//PNG
				imagePNG($this->img["des"]);
				
			} elseif ($this->img["format"]=="GIF") {
				//GIF
				imageGIF($this->img["des"]);
			}
			
			imagedestroy($this->img["des"]);
			
		}
		
	}

	function save($save="")
	{
		global $config;
		
		if ($config['gdversion']==2) {
			$this->img["des"] = imagecreatetruecolor($this->img["width_thumb"],$this->img["height_thumb"]);
			@imagecopyresampled ($this->img["des"], $this->img["src"], 0, 0, 0, 0, $this->img["width_thumb"], $this->img["height_thumb"], $this->img["width"], $this->img["height"]);
		
		} elseif ($config['gdversion']==1) {
		
			$this->img["des"] = imagecreate($this->img["width_thumb"],$this->img["height_thumb"]);
			@imagecopyresized ($this->img["des"], $this->img["src"], 0, 0, 0, 0, $this->img["width_thumb"], $this->img["height_thumb"], $this->img["width"], $this->img["height"]);
		}
 		
		if ($config['gdversion']>0) {
		
			if ($this->img["format"]=="JPG" || $this->img["format"]=="JPEG") {
				//JPEG
				imageJPEG($this->img["des"],$save,$this->img["quality"]);
				
			} elseif ($this->img["format"]=="PNG") {
				//PNG
				imagePNG($this->img["des"],$save);
				
			} elseif ($this->img["format"]=="GIF") {
				//GIF
				imageGIF($this->img["des"],$save);
				
			}
			imagedestroy($this->img["des"]);
			@chmod($this->img["des"], 0644);
			
		}
	}
}
?>