<?php
/*
+--------------------------------------------------------------------------
|   CubeCart v3.0.2
|   ========================================
|   by Alistair Brookbanks
|	CubeCart is a Trade Mark of Devellion Limited
|   Copyright Devellion Limited 2005 - 2006. All rights reserved.
|   Devellion Limited,
|   22 Thomas Heskin Court,
|   Station Road,
|   Bishops Stortford,
|   HERTFORDSHIRE.
|   CM23 3EE
|   UNITED KINGDOM
|   http://www.devellion.com
|	UK Private Limited Company No. 5323904
|   ========================================
|   Web: http://www.cubecart.com
|   Date: Thursday, 27th July 2006
|   Email: sales (at) cubecart (dot) com
|	License Type: CubeCart is NOT Open Source Software and Limitations Apply 
|   Licence Info: http://www.cubecart.com/site/faq/license.php
+--------------------------------------------------------------------------
|	transfer.php
|   ========================================
|	Core functions for the PayPal Express Checkout Gateway
+--------------------------------------------------------------------------
*/
/*
//////////////////////////
// PAYPAL DIRECT PAYMENT GATEWAY
//////////////////////////
// L@@K AT ALL THE LOVELY 
// VARIABLES WE HAVE TO
// PLAY WITH!!
//////

//////////////////////////
// IN THE REPEATED REGION
//////
$orderInv['productId']						- product id as an integer
$orderInv['name']							- product name as a varchar
$orderInv['price']							- price of each product (inc options)
$orderInv['quantity']						- quantity of products as an integer
$orderInv['product_options']				- products attributes as test
$orderInv['productCode']					- product code as a varchar
$i											- This is the current incremented integer starting at 0

/////////////////////////
// FIXED VARS
///////
$cart_order_id							- cart order id as a varchar
$ccUserData[0]['email']						- Customers email address
$ccUserData[0]['title']						- Customers title (Mr Miss etc...)
$ccUserData[0]['firstName']					- Customers first name
$ccUserData[0]['lastName']					- Customers last name 
$ccUserData[0]['add_1']						- Invoice Address line 1
$ccUserData[0]['add_2']						- Invoice Address line 1
$ccUserData[0]['town']						- Invoice Town or city
$ccUserData[0]['county']					- Invoice County or state
$ccUserData[0]['postcode']					- Invoice Post/Zip Code
$ccUserData[0]['country']					- Invoice country Id we can look up the country name like this
										countryName($ccUserData[0]['country']);
$ccUserData[0]['phone']						- Contact phone no
$ccUserData[0]['mobile']					- Mobile/Cell phone number

$basket['delInf']['title']				- Delivery title (Mr Miss etc...)
$basket['delInf']['firstName']			- Delivery customers first name
$basket['delInf']['lastName']			- Delivery customers last name 
$basket['delInf']['add_1']				- Delivery Address line 1
$basket['delInf']['add_2']				- Delivery Address line 1
$basket['delInf']['town']				- Delivery Town or city
$basket['delInf']['county']				- Delivery County or state
$basket['delInf']['postcode']			- Delivery Post/Zip Code
$basket['delInf']['country']			- Delivery  country Id we can look up the country name like this	
									countryName($basket['delInf']['country']);


$basket['subTotal'] 					- Order Subtotal (exTax and Shipping)
$basket['grandTotal']					- Basket total which has to be paid (inc Tax and Shipping).
$basket['tax']							- Total tax to pay
$basket['shipCost']						- Shipping price
////////////////////////////////////////////////////////
*/


if(isset($_POST['gateway'])){
	
	// set include path for paypal sdk
	$includePath = ini_get('include_path');
	$pearPath = $glob['rootDir'] . "/pear";
	if(!stristr($includePath, $pearPath)) ini_set('include_path',$pearPath . PATH_SEPARATOR . $includePath);
	
	require_once ('Services/PayPal.php');
	require_once ('Services/PayPal/Profile/Handler/Array.php');
	require_once ('Services/PayPal/Profile/API.php');
	
	// set PayPal log level and directory
	require_once('Log.php');
	
	$module = fetchDbConfig("ExpressCheckout");
	
	if($module['debug'])
		define('PAYPAL_LOG_LEVEL', PEAR_LOG_DEBUG);
	define('PAYPAL_LOG_DIR', $glob['rootDir'] . "/pear/tmp");
	
	$certFile = $glob['rootDir']. "/pear/cert_key_pem.txt";
	$certPass = '';
	$apiUsername = $module['username'];
	$apiPassword = $module['password'];
	$subject = '';
	$environment = $module['gateway'] ? "Live" : "Sandbox";
	
	$handler =& ProfileHandler_Array::getInstance(array(
		'username' => $apiUsername,
		'certificateFile' => $certFile,
		'subject' => $subject,
		'environment' => $environment));
	
	$profile =& APIProfile::getInstance($apiUsername, $handler);
	$profile->setAPIPassword($apiPassword);
	
	$caller =& Services_PayPal::getCallerServices($profile);
	
	if(Services_PayPal::isError($caller))
	{
		//print $caller->getMessage();
		header("Location: confirmed.php?f=1");
		exit;
	}
	
	$currency = $db->select("SELECT currency FROM ".$glob['dbprefix']."CubeCart_sessions WHERE sessId = ".$db->mySQLSafe($_SESSION['ccUser']));
	
	if($currency == TRUE && $currency[0]['currency'] != ''){
		$currencyID = $db->mySQLSafe($currency[0]['currency']);
	} else {
		$currencyID = $config['defaultCurrency'];
	}
	
	$amount =& Services_PayPal::getType('BasicAmountType');
	$amount->setval(number_format($basket['grandTotal'], 2));
	$amount->setattr('currencyID', $currencyID); // only USD supported
	
	$ecd =& Services_PayPal::getType('SetExpressCheckoutRequestDetailsType');
	$ecd->setOrderTotal($amount);
	$ecd->setReturnURL($glob['storeURL']."/modules/gateway/ExpressCheckout/return.php");
	$ecd->setCancelURL($glob['storeURL']."/cart.php?act=step5");
	$ecd->setNoShipping(0); // do display shipping address at paypal site so user can't change it
	$ecd->setBuyerEmail($ccUserData[0]['email']);
	$ecd->setPaymentAction('Sale');
	
	$ec =& Services_PayPal::getType('SetExpressCheckoutRequestType');
	$ec->setSetExpressCheckoutRequestDetails($ecd);
	
	$response = $caller->SetExpressCheckout($ec);
	
	if(Services_PayPal::isError($response)  || ($response->getAck() != 'Success' && $response->getAck() != 'SuccessWithWarning')) 	{
		//if(Services_PayPal::isError($response)) {
		//	print $response->getMessage();
		//}
		header("Location: confirmed.php?f=1");
		exit;
	}
	
	$paypal_token = $response->getToken();

}

function repeatVars(){

		return FALSE;
	
}

function fixedVars(){
	global $paypal_token;

	$hiddenVars = "<input type='hidden' name='cmd' value='_express-checkout' />
				<input type='hidden' name='token' value='".$paypal_token."' />";

	return $hiddenVars;
}

function success(){
	global $basket;
	
	if($_GET['f']==1) {
	
		return FALSE;
	
	} else {
	
		return TRUE;
	
	}

}

///////////////////////////
// Other Vars
////////
if($module['gateway']==1){
	$formAction = "https://www.paypal.com/cgi-bin/webscr";
} else {
	$formAction = "https://www.sandbox.paypal.com/cgi-bin/webscr";
}

$formMethod = "get";
$formTarget = "_self";
$transfer = "auto";
$stateUpdate = TRUE;
?>
