<?php

/************************************************
* HSBC API Module by Adam Harris @ XOMY Limited *
* http://www.xomy.com | adam@xomy.com           *
*                                               *
* Before making any modifications, please       *
* contact me at the above email so that we can  *
* discuss the implications and advantages for   *
* the module.                                   *
*                                               *
* This module is released for the benefit of    *
* the community and should not be sold.         *
*                                               *
* This module is not released under GPL and     *
* cannot be redistributed without permission    *
* from myself.                                  *
************************************************/

$module = fetchDbConfig("HSBC");
include ("modules/gateway/HSBC/func_https_libcurl.php");

if($_GET['process']==1){

	switch($module['test']) {
		case "0": $pp_mode="P"; break;
		case "1": $pp_mode="Y"; break;
		default: $pp_mode="N"; break;
	}
	$domen = ($module["test"]=="2" ? $module["url"] : $module["url"]);
	$port = ($module["test"]=="2" ? 443 : 443);
	$pp_login = $module["userID"];
	$pp_pass = $module["passPhrase"];
	$pp_client = $module["acNo"];
	$curr = "826";

	$XPost = "";
	$XPost[] = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
	$XPost[] = "<EngineDocList>";
	$XPost[] = "<DocVersion>1.0</DocVersion>";
	$XPost[] = "<EngineDoc>";
	$XPost[] = "<ContentType>OrderFormDoc</ContentType>";

	$XPost[] = "<User>";
	$XPost[] = "<Name>$pp_login</Name>";
	$XPost[] = "<Password>$pp_pass</Password>";
	$XPost[] = "<ClientId DataType=\"S32\">$pp_client</ClientId>";
	$XPost[] = "</User>";

	$XPost[] = "<Instructions>";
	$XPost[] = "<Pipeline>Payment</Pipeline>";
	$XPost[] = "</Instructions>";

	$XPost[] = "<OrderFormDoc>";
	$XPost[] = "<Mode>$pp_mode</Mode>";
	$XPost[] = "<Consumer>";
	$XPost[] = "<Email>".$_POST["emailAddress"]."</Email>";
	$XPost[] = "<BillTo>";
	$XPost[] = "<Location>";
	$XPost[] = "<TelVoice>".$_POST["phone"]."</TelVoice>";
	$XPost[] = "<Address><Name>".$_POST["firstName"]." ".$_POST["lastName"]."</Name>";
	$XPost[] = "<City>".$_POST["city"]."</City>";
	$XPost[] = "<Street1>".$_POST["addr1"]."</Street1>";
	$XPost[] = "<Street2>".$_POST["addr2"]."</Street2>";
	$XPost[] = "<StateProv>".$_POST["state"]."</StateProv>";
	$XPost[] = "<PostalCode>".$_POST["postalCode"]."</PostalCode>";
	$XPost[] = "</Address>";
	$XPost[] = "</Location>";
	$XPost[] = "</BillTo>";

$XPost[] = "<PaymentMech>";
$XPost[] = "<CreditCard>";
$XPost[] = "<Cvv2Indicator>".(!empty($_POST["cvc2"])?1:2)."</Cvv2Indicator>";
$XPost[] = "<Cvv2Val>".$_POST["cvc2"]."</Cvv2Val>";
$XPost[] = "<Expires DataType=\"ExpirationDate\" Locale=\"840\">".$_POST["expirationMonth"]."/".$_POST["expirationYear"]."</Expires>";
if ((($_POST['cardType'] == 9)||($_POST['cardType'] == 10))&&($_POST['issueNumber'])){
	$XPost[] = "<IssueNum>".$_POST["issueNumber"]."</IssueNum>";
}
$XPost[] = "<Number>".$_POST["cardNumber"]."</Number>";
if ((($_POST['cardType'] == 9)||($_POST['cardType'] == 10))&&($_POST['startMonth'])){
	$XPost[] = "<StartDate DataType=\"StartDate\" Locale=\"840\">".substr($_POST["startMonth"],0,2)."/".substr($_POST["startYear"],2,2)."</StartDate>";
}
$XPost[] = "<Type>".$_POST['cardType']."</Type>";
$XPost[] = "</CreditCard>";
$XPost[] = "</PaymentMech>";
$XPost[] = "</Consumer>";
$XPost[] = "<Transaction>";
$XPost[] = "<Type>Auth</Type>";
$XPost[] = "<ChargeDesc1></ChargeDesc1>";
$XPost[] = "<CurrentTotals>";
$XPost[] = "<Totals>";
$XPost[] = "<Total DataType=\"Money\" Currency=\"".$curr."\">".(100*$_POST["amount"])."</Total>";
$XPost[] = "</Totals>";
$XPost[] = "</CurrentTotals>";
$XPost[] = "</Transaction>";
$XPost[] = "</OrderFormDoc>";
$XPost[] = "</EngineDoc>";
$XPost[] = "</EngineDocList>";

$pst = array("CLRCMRC_XML=".join("",$XPost));
list($a,$return)=func_https_request("POST","https://".$domen.":$port/",$pst);
$return=preg_replace("/\n/","",$return);

//debug
//print_r($return);
//exit;
	preg_match("/<AuthCode(.*)>(.*)<\/AuthCode>/",$return,$out);
	$authCode = $out[2];

	if($authCode) {
		header("Location: confirmed.php");
		exit;
	} else {
		header("Location: confirmed.php?f=1");
		exit;
	}
	
	
	
}


$formTemplate = new XTemplate ("modules/gateway/HSBC/form.tpl");

$formTemplate->assign("VAL_FIRST_NAME",$ccUserData[0]['firstName']);
$formTemplate->assign("VAL_LAST_NAME",$ccUserData[0]['lastName']);
$formTemplate->assign("VAL_EMAIL_ADDRESS",$ccUserData[0]['email']);
$formTemplate->assign("VAL_ADD_1",$ccUserData[0]['add_1']);
$formTemplate->assign("VAL_ADD_2",$ccUserData[0]['add_2']);
$formTemplate->assign("VAL_CITY",$ccUserData[0]['town']);
$formTemplate->assign("VAL_COUNTY",$ccUserData[0]['county']);
$formTemplate->assign("VAL_POST_CODE",$ccUserData[0]['postcode']);
$formTemplate->assign("VAL_CART_ORDER_ID",$basket['cart_order_id']);
$formTemplate->assign("VAL_GRAND_TOTAL",$basket['grandTotal']);
$formTemplate->assign("VAL_MERCH_ID",$module['acNo']);


$countries = $db->select("SELECT id, iso, printable_name FROM ".$glob['dbprefix']."CubeCart_iso_countries ORDER BY printable_name"); 
	
	for($i=0; $i<count($countries); $i++){
				
			
		if($countries[$i]['id'] == $ccUserData[0]['country']){
			$formTemplate->assign("COUNTRY_SELECTED","selected='selected'");
		} else {
			$formTemplate->assign("COUNTRY_SELECTED","");
		}
	
		$formTemplate->assign("VAL_COUNTRY_ISO",$countries[$i]['iso']);

		$countryName = "";
		$countryName = $countries[$i]['printable_name'];

		if(strlen($countryName)>20){

			$countryName = substr($countryName,0,20)."&hellip;";

		}

		$formTemplate->assign("VAL_COUNTRY_NAME",$countryName);
		$formTemplate->parse("form.repeat_countries");
	}

$formTemplate->parse("form");
$formTemplate = $formTemplate->text("form");
?>
