<?php
/**
 * TestLink Open Source Project - http://testlink.sourceforge.net/
 * This script is distributed under the GNU General Public License 2 or later.
 *
 * Constants and configuration parameters used throughout TestLink
 *
 * There are included extra files:
 * - your customized settings - custom_config.inc.php
 * - DB access - config_db.inc.php
 * - constants - const.inc.php
 * - basic checking - configCheck.php
 *
 * IMPORTANT:
 * To adapt values to your needs DO NOT EDIT THIS FILE but use custom_config.inc.php and
 * replace values of TestLink configuration variables.
 * It saves your changes for the next upgrade in one extra file.
 *
 * @filesource  config.inc.php
 * @package     TestLink
 * @copyright   2005-2014, TestLink community
 * @link        http://www.testlink.org
 *
 * @internal revisions
 * @since 1.9.11
 *
 *
 **/

// ----------------------------------------------------------------------------
/* [INITIALIZATION] - DO NOT CHANGE THE SECTION */

/** @global array Global configuration class */
$tlCfg = new stdClass();
$tlCfg->api = new stdClass();
$tlCfg->document_generator = new stdClass();

$tlCfg->spec_cfg = new stdClass();

$tlCfg->exec_cfg = new stdClass();
$tlCfg->exec_cfg->view_mode = new stdClass();
$tlCfg->exec_cfg->exec_mode = new stdClass();

// allow to define additional execution types other than 
// defined in testcase.class.php
// array(code => lblkey)
// code int value > latest standard execution code defined.
// lblkey => key to be used on lang_get() call.
// 
$tlCfg->custom_execution_types = null;

$tlCfg->gui = new stdClass();
$tlCfg->gui->custom_fields = new stdClass();
$tlCfg->testcase_cfg = new stdClass();
$tlCfg->req_cfg = new stdClass();
$tlCfg->validation_cfg = new stdClass();
$tlCfg->custom_fields = new stdClass();
$tlCfg->req_spec_cfg = new stdClass();
$tlCfg->diffEngine = new stdClass();
$tlCfg->tplanDesign = new stdClass();


/** @uses database access definition (generated automatically by TL installer) */ 
@include_once('config_db.inc.php');
if( !defined('DB_TABLE_PREFIX') )
{
    define('DB_TABLE_PREFIX','' );
}

/** The root dir for the testlink installation with trailing slash */
define('TL_ABS_PATH', dirname(__FILE__) . DIRECTORY_SEPARATOR);

/** Include constants and magic numbers (users should not change it)*/
require_once(TL_ABS_PATH . 'cfg' . DIRECTORY_SEPARATOR . 'const.inc.php');


// ----------------------------------------------------------------------------
/** @var string used to have (when needed) a possibility to identify different TL instances
    @since 1.9.4 used on mail subject when mail logger is used
 */
$tlCfg->instance_id = 'Main TestLink Instance';

/* [LOCALIZATION] */

/** @var string Default localization for users */
// The value must be available in $$tlCfg->locales (see cfg/const.inc.php).
// Note: An attempt will be done to establish the default locale
// automatically using $_SERVER['HTTP_ACCEPT_LANGUAGE']
$tlCfg->default_language = 'en_GB';

/**
 * @var string Charset 'UTF-8' is only officially supported charset (Require
 * MySQL version >= 4.1) 'ISO-8859-1' or another Charset could be set for
 * backward compatability by experienced users. However we have not resources
 * to support such patches.
 **/
$tlCfg->charset = 'UTF-8';

/**
 * @var string characters used to surround a description in the user interface
 * (for example role)
 **/
$tlCfg->gui_separator_open =  '[';
$tlCfg->gui_separator_close = ']';
$tlCfg->gui_room = '[ %s ]';

/** @var string Title separators are used when componing an title using several strings */
$tlCfg->gui_title_separator_1 = ' : '; // object : name (Test Specification : My best product)
$tlCfg->gui_title_separator_2 = ' - '; // parent - child

/**
 * @var string delimiter used to create DOC ID in this way:
 * <test_project_Prefix> . g_testcase_cfg->glue_character . <doc_id>
 * Could not be empty
 */
$tlCfg->testcase_cfg->glue_character = '-';

/**
 * fonts set used to draw charts
 **/
$tlCfg->charts_font_path = TL_ABS_PATH . "third_party/pchart/Fonts/tahoma.ttf";
/**
 * font size used to draw charts
 **/
$tlCfg->charts_font_size = 8;


// ----------------------------------------------------------------------------
/* [SERVER ENVIRONMENT] */

/**
 * TICKET 4969: Add Setting to Force HTTPS
 */
$tlCfg->force_https = false;


/**
 * @var integer Set the session timeout for inactivity [minutes].
 * Default high value disables this feature.
 */
$tlCfg->sessionInactivityTimeout = 9900;

/**
 * Set the session timeout value (in minutes).
 * This will prevent sessions timing out after very short periods of time
 * Warning: your server could block this settings
 **/
//ini_set('session.cache_expire',900);

/**
 * Set the session garbage collection timeout value (in seconds)
 * The default session garbage collection in php is set to 1440 seconds (24 minutes)
 * If you want sessions to last longer this must be set to a higher value.
 * You may need to set this in your global php.ini if the settings don't take effect.
 */
//ini_set('session.gc_maxlifetime', 54000);


// ----------------------------------------------------------------------------
/* [LOGGING] */

/** Error reporting - do we want php errors to show up for users */
error_reporting(E_ALL);

/** @var string Default level of logging (NONE, ERROR, INFO, DEBUG, EXTENDED) 
 *  is not used by tlLogger, we need to change this in future.
 */
$tlCfg->log_level = 'ERROR';

/** @var boolean show smarty debug window */
$tlCfg->smarty_debug = false;

/** 
 *  @var string Path to store logs - 
 *  for security reasons (see http://itsecuritysolutions.org/2012-08-13-TestLink-1.9.3-multiple-vulnerabilities/)
 *  put it out of reach via web or configure access denied.
 */
$tlCfg->log_path = '/var/testlink/logs/'; /* unix example */


/**
 * @var string How to warning user when security weak points exists.
 *
 * 'SCREEN': messages will displayed on login screen, and tl desktop (default)
 * 'FILE': a file with a list is created but users are not notified via GUI
 *         user will receive a message on screen.
 * 'SILENT': same that FILE, but user will not receive message on screen.
 */
$tlCfg->config_check_warning_mode = 'FILE';

/**
 * Configure if individual logging data stores are enabled of disabled
 * Possibile values to identify loggers: 'db','file'
 * $g_loggerCfg=null; all loggers enabled 
 * $g_loggerCfg['db']['enable']=true/false;
 * $g_loggerCfg['file']['enable']=true/false;
 * $g_loggerCfg['mail']['enable']=true/false;
 */
$g_loggerCfg = array('mail' => array('enable' => false));

/**  @var integer All events older this value [days] are removed from the db, during login */
$g_removeEventsOlderThan = 30;
                            

/**  @var map keys: 'all' + values present on proprety of logger class $loggerTypeDomain
 *                  values can be only these defined on logger.class.php 
 *   @since 1.9.4                                  
 *   example array('all' => array('INFO','AUDIT'),
 *                 'mail' =>  array('ERROR'))
 */                            
$tlCfg->loggerFilter = null; // default defined on logger.class.php ;                            

// ----------------------------------------------------------------------------
/* [SMTP] */

/**
 * @var string SMTP server name or IP address ("localhost" should work in the most cases)
 * Configure using custom_config.inc.php
 * @uses lib/functions/email_api.php
 */
$g_smtp_host        = '[smtp_host_not_configured]';  # SMTP server MUST BE configured

# Configure using custom_config.inc.php
$g_tl_admin_email     = '[testlink_sysadmin_email_not_configured]'; # for problem/error notification
$g_from_email         = '[from_email_not_configured]';  # email sender
$g_return_path_email  = '[return_path_email_not_configured]';

/**
 * Email notification priority (low by default)
 * Urgent = 1, Not Urgent = 5, Disable = 0
 **/
$g_mail_priority = 5;

/**
 * Taken from mantis for phpmailer config
 * select the method to mail by:
 * PHPMAILER_METHOD_MAIL - mail()
 * PHPMAILER_METHOD_SENDMAIL - sendmail
 * PHPMAILER_METHOD_SMTP - SMTP
 */
$g_phpMailer_method = PHPMAILER_METHOD_SMTP;

/** Configure only if SMTP server requires authentication */
$g_smtp_username    = '';  # user
$g_smtp_password    = '';  # password

/**
 * This control the connection mode to SMTP server. 
 * Can be '', 'ssl','tls'
 * @global string $g_smtp_connection_mode
 */
$g_smtp_connection_mode = '';

/**
 * The smtp port to use.  The typical SMTP ports are 25 and 587.  The port to use
 * will depend on the SMTP server configuration and hence others may be used.
 * @global int $g_smtp_port
 */
$g_smtp_port = 25;                        


// ----------------------------------------------------------------------------
/* [User Authentication] */

/**
 * Login authentication method:
 *  'MD5' => use password stored on db => will be deprecated and DB used.
 *  'DB'  => Same as MD5 use password stored on db
 *  'LDAP' => use password from LDAP Server
 */
$tlCfg->authentication['domain'] = array('DB' => array('description' => 'DB', 'allowPasswordManagement' => true) ,
										 'LDAP' => array('description' => 'LDAP', 'allowPasswordManagement' => false) );


// $tlCfg->authentication['domain'] = array('DB','LDAP')

/* Default Authentication method */
$tlCfg->authentication['method'] = 'DB';


/**
 * Single Sign On authentication
 * This will be used with $tlCfg->authentication['method'] <<= INCOMPLETE COMMENT
 *
 * This works with apache webserver
 */
$tlCfg->authentication['SSO_enabled'] = false; 
$tlCfg->authentication['SSO_method'] = 'CLIENT_CERTIFICATE';
$tlCfg->authentication['SSO_uid_field'] = 'SSL_CLIENT_S_DN_Email';



/** LDAP authentication credentials */
$tlCfg->authentication['ldap_server'] = 'localhost';
$tlCfg->authentication['ldap_port'] = '389';
$tlCfg->authentication['ldap_version'] = '3'; // could be '2' in some cases
$tlCfg->authentication['ldap_root_dn'] = 'dc=mycompany,dc=com';
$tlCfg->authentication['ldap_bind_dn'] = ''; // Left empty for anonymous LDAP binding
$tlCfg->authentication['ldap_bind_passwd'] = ''; // Left empty for anonymous LDAP binding
$tlCfg->authentication['ldap_tls'] = false; // true -> use tls

// Following configuration parameters are used to build 
// ldap filter and ldap attributes used by ldap_search()
//
// filter => "(&$t_ldap_organization($t_ldap_uid_field=$t_username))";
// attributess => array( $t_ldap_uid_field, 'dn' );
// 
// This can be used to manage situation like explained on post on forum:
// ActiveDirectory + users in AD group
// 
$tlCfg->authentication['ldap_organization'] = ''; // e.g. '(organizationname=*Traffic)'
$tlCfg->authentication['ldap_uid_field'] = 'uid'; // Use 'sAMAccountName' for Active Directory




// Follows Mantisbt idea.
// True if user does not exist on DB, but can be get from LDAP, 
// the user will be created AUTOMATICALLY with default user role.
// Create user with following data from LDAP
// mail
// name
// surname
$tlCfg->authentication['ldap_automatic_user_creation'] = false;

// Configure following fields in custom_config.inc.php according your configuration
$tlCfg->authentication['ldap_email_field'] = 'mail';
$tlCfg->authentication['ldap_firstname_field'] = 'givenname';
$tlCfg->authentication['ldap_surname_field'] = 'sn';




/** Enable/disable Users to create accounts on login page */
$tlCfg->user_self_signup = TRUE;

/** What happens when Administrator push the Reset Password Button 
  'send_password_by_mail'
  'display_on_screen'
*/
$tlCfg->password_reset_send_method = 'send_password_by_mail';

/** 
 * Validating new user login names
 * Taken mantisbt version 1.2.5 - www.mantisbt.org and adapted
 *
 * The regular expression to use when validating new user login names
 * The default regular expression allows a-z, A-Z, 0-9, +, -, dot, @ and underscore.   
 * For testing regular expressions, use http://rubular.com/.
 * For regular expression to englihs, use http://xenon.stanford.edu/~xusch/regexp/analyzer.html
 */
$tlCfg->validation_cfg->user_login_valid_regex='/^([a-z\d\-.+_@]+(@[a-z\d\-.]+\.[a-z]{2,4})?)$/i';

/**
 * Validating user email addresses
 * Example of other possibilities:
 * <code>
 * $regex = "/^[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*" .
 *     "@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i";
 * $regex = "/^([\w]+)(.[\w]+)*@([\w-]+\.){1,5}([A-Za-z]){2,4}$/";
 * </code>
 **/
// 
// This expression does not allow Top Level Domian (last part of domain name) longer than 4
// If you need to change this
// Configure this on custom_config.inc.php
$tlCfg->validation_cfg->user_email_valid_regex_js =  "/^(\w+)([-+.][\w]+)*@(\w[-\w]*\.){1,5}([A-Za-z]){2,4}$/";
$tlCfg->validation_cfg->user_email_valid_regex_php = "/^([\w]+)(.[\w]+)*@([\w-]+\.){1,5}([A-Za-z]){2,4}$/U";


// --------------------------------------------------------------------------------------
/* [API] */

/** XML-RPC API availability - do less than promised ;) 
    FALSE => user are not able to generate and set his/her API key.
    XML-RPC server do not check this config in order to answer or not a call.
 */

$tlCfg->api->enabled = TRUE;

// used to display API ID info in the *View pages
$tlCfg->api->id_format = "[ID: %s ]";


// --------------------------------------------------------------------------------------
/* [GUI LAYOUT] */

/** GUI themes (base for CSS and images)- modify if you create own one */
$tlCfg->theme_dir = 'gui/themes/default/';

/** Dir for compiled templates */
$tlCfg->temp_dir = TL_ABS_PATH . 'gui' . DIRECTORY_SEPARATOR . 'templates_c' . DIRECTORY_SEPARATOR;

/** Company logo (used by navigation bar and login page page) */
$tlCfg->logo_login = 'tl-logo-transparent-25.png';
$tlCfg->logo_navbar = 'tl-logo-transparent-12.5.png';


/** Login page could show an informational text */
$tlCfg->login_info = ''; // Empty by default


/** 
 * controls if operation area (buttons) starts open ('' or 'inline') or closed ('none') on:
 * - test suite management
 * - test case management
 * - req. spec management
 * - req. management
 */
$tlCfg->gui->op_area_display = new stdClass();

// test_spec_container => test project, test suite
$tlCfg->gui->op_area_display->test_spec_container = 'none'; // ''
$tlCfg->gui->op_area_display->test_case = 'none'; // 'inline'
$tlCfg->gui->op_area_display->req_spec_container = 'none'; // 'inline'
$tlCfg->gui->op_area_display->req = 'none'; // 'inline'



/**
 * @var string Availability of Test Project specific background colour
 * 'background'  -> standard behaviour for 1.6.x you can have a different
 *                  background colour for every test project.
 * 'none'        -> new behaviour no background color change
 */
$tlCfg->gui->testproject_coloring = 'none'; // I'm sorry default is not coloring using coloring is a pain
                                            // and useless
/** @TODO havlatm4francisco Ok, then merge these two attributes into one */
/** default background color */
$tlCfg->gui->background_color = '#9BD';

// ENABLED: on features that assign user role to test projects and test plan, colour user name
//          according GLOBAL role
// DISABLED: do not color [STANDARD BEHAVIOUR]
$tlCfg->gui->usersAssignGlobalRoleColoring = DISABLED;


// Enable/disable rounded corners via javascript
$tlCfg->gui->round_corners = new stdClass();
$tlCfg->gui->round_corners->exec_history = ENABLED;
$tlCfg->gui->round_corners->tc_title = ENABLED;
$tlCfg->gui->round_corners->tc_spec = ENABLED;

/**
 * Display name definition (used to build a human readable display name for users)
 * Example of values:
 *    '%first% %last%'          -> John Cook
 *    '%last%, %first%'          -> Cook John
 *    '%first% %last% %login%'    -> John Cook [ux555]
 **/
$tlCfg->username_format = '%login%';

/** Configure the frame frmWorkArea navigator width */
$tlCfg->frame_workarea_default_width = "30%";

/** true => icon edit will be added into <a href> as indication an edit features */
$tlCfg->gui->show_icon_edit = false;

/**
 * Order to use when building a testproject combobox (value must be SQL compliant)
 * For example:
 *    'ORDER BY name'
 *    'ORDER_BY nodes_hierarchy.id DESC' -> similar effect to order last created firts
 **/
$tlCfg->gui->tprojects_combo_order_by = 'ORDER BY nodes_hierarchy.id DESC';

/** Configure the input size of test case search by id on navigation bar.
 *  This value will be added to the length of the prefix to dynamically set input size.
 *  Example: prefix is "projectA-" -> length of prefix is 9
 *  Now the here defined value (default: 6) will be added to the prefix length
 *  -> Input field will have an input size of 15
 **/
$tlCfg->gui->dynamic_quick_tcase_search_input_size = 6;

// used to round percentages on metricsDashboard.php
$tlCfg->dashboard_precision = 2;

/**
 * Choose what kind of webeditor you want to use in every TL area. This configuration
 * will be used if no element with search key (area) is found on this structure.
 * Every element is a mp with this configuration keys:
 *
 * 'type':
 *        'fckeditor'  ==> will be deprecated in future versions
 *        'ckeditor'
 *        'tinymce'    ==> will be deprecated in future versions
 *        'none' -> use plain text area input field
 * 'toolbar': only applicable for type = 'fckeditor', 'ckeditor'
 *      name of ToolbarSet  (See: http://docs.fckeditor.net/ for more information about ToolbarSets)
 *      TestLink stores own definitions in <testlink_dir>/cfg/tl_fckeditor_config.js
 *      TestLink stores own definitions in <testlink_dir>/cfg/tl_ckeditor_config.js
 *
 * 'configFile': only applicable for type = 'fckeditor'
 *      See: http://docs.fckeditor.net/ for more information about CustomConfigurationsPath
 * 'height': the height in px for FCKEditor
 * 'width': the width in px for FCKEditor
 * 'cols': the number of cols for tinymce and none
 * 'rows': the number of rows for tinymce and none
 *
 * The next keys/areas are supported:
 *    'all' (default setting),
 *    'design', 'steps_design', 'testplan', 'build', 'testproject', 'role', 'requirement', 'requirement_spec'.
 *
 * Examples:
 * <code>
 * // Copy this to custom_config.inc.php if you want use 'tinymce' as default.
 * $tlCfg->gui->text_editor['all'] = array( 'type' => 'tinymce');
 * // Copy this to custom_config.inc.php if you want use 'nome' as default.
 * $tlCfg->gui->text_editor['all'] = array( 'type' => 'none');
 * //This configuration is useful only if default type is set to 'fckeditor'
 * $tlCfg->gui->text_editor['design'] = array('toolbar' => 'tl_mini');
 *
 * $tlCfg->gui->text_editor['testplan'] = array( 'type' => 'none');
 * $tlCfg->gui->text_editor['build'] = array( 'type' => 'fckeditor','toolbar' => 'tl_mini');
 * $tlCfg->gui->text_editor['testproject'] = array( 'type' => 'tinymce');
 * $tlCfg->gui->text_editor['role'] = array( 'type' => 'tinymce');
 * $tlCfg->gui->text_editor['requirement'] = array( 'type' => 'none');
 * $tlCfg->gui->text_editor['requirement_spec'] = array( 'type' => 'none');
 * </code>
 *
 * Hint: After doing configuration changes, clean you Browser's cookies and cache
 */
/*
$tlCfg->gui->text_editor = array();
$tlCfg->gui->text_editor['all'] = array('type' => 'fckeditor',
                                      'toolbar' => 'tl_default',
                                      'configFile' => 'cfg/tl_fckeditor_config.js',);
$tlCfg->gui->text_editor['execution'] = array( 'type' => 'none');
*/

$tlCfg->gui->text_editor = array();
$tlCfg->gui->text_editor['all'] = array('type' => 'ckeditor','toolbar' => 'Testlink',
                                        'configFile' => 'cfg/tl_ckeditor_config.js',
                                        'height' => 150);

// mini toolbar for test case steps edit
$tlCfg->gui->text_editor['steps_design'] = array('type' => 'ckeditor','toolbar' => 'TestlinkMini',
                                                 'configFile' => 'cfg/tl_ckeditor_config.js',
                                                 'height' => 100);

$tlCfg->gui->text_editor['execution'] = array( 'type' => 'none');


/** User can choose order of menu areas */
$tlCfg->gui->layoutMainPageLeft = array( 'testProject' => 1, 'userAdministration' => 2 ,
                                         'requirements' => 3, 'testSpecification' => 4,
                                         'general' => 5);
$tlCfg->gui->layoutMainPageRight = array( 'testPlan' => 1, 'testExecution' => 2 ,
                                          'testPlanContents' => 3);

/**
 * Enable warning on a changed content before an user leave a page.
 *
 * Tested in:
 * - IE8        OK
 * - Firefox 3  OK
 * - Chrome     FAIL
 *
 * Does not work in Webkit browsers (Chrome, Safari) when using frames.
 * Bug in webkit: https://bugs.webkit.org/show_bug.cgi?id=19418
 */

// seems that with config options that will be used on javascript via smarty template variables
// we are having problems using FALSE/TRUE => use 0/1 (or our CONSTANT DISABLED/ENABLED)
$tlCfg->gui->checkNotSaved = ENABLED;


// ----------------------------------------------------------------------------
/* [GUI: TREE] */

/** Default ordering value for new Test Suites and Test Cases to separate them */
$tlCfg->treemenu_default_testsuite_order = 1;
$tlCfg->treemenu_default_testcase_order = 100;

/** show/hide testcase id on tree menu */
$tlCfg->treemenu_show_testcase_id = TRUE;

/** Reorder test cases based on TC Name or External ID in tree on
 *  test suite level using reorder button 
 */
// 'EXTERNAL_ID' -> Sort on Test Case External ID field displayed on tree.(Default)
// 'NAME' -> Sort on Test Case Name field

$tlCfg->testcase_reorder_by = 'EXTERNAL_ID';
// $tlCfg->testcase_reorder_by = 'NAME';

// ----------------------------------------------------------------------------
/* [GUI: Javascript libraries] */

// May be in future another table sort engine will be better
// kryogenix.org -> Stuart Langridge sortTable
// '' (empty string) -> disable table sorting feature
$g_sort_table_engine='kryogenix.org';


// --------------------------------------------------------------------------------------
/* [Reports] */
$tlCfg->reportsCfg=new stdClass();

//Displayed execution statuses to use on reports (ordered). */
$tlCfg->reportsCfg->exec_status = $tlCfg->results['status_label_for_exec_ui'];

/**
 * Default Offset in seconds for reporting start date (reports with date range)
 * @uses lib/results/resultsMoreBuilds.php
 */
$tlCfg->reportsCfg->start_date_offset = (7*24*60*60); // one week

// minutes part is ignored but must be configured.
// Hint: set always to :00
$tlCfg->reportsCfg->start_time = '00:00';

// Result matrix (resultsTC.php)
// Shows an extra column which gives the status of the last executed build
$tlCfg->resultMatrixReport->buildColumns['showStatusLastExecuted'] = true;

// Show build columns in revers order. The latest build is to the left
$tlCfg->resultMatrixReport->buildColumns['latestBuildOnLeft'] = false;

// After having got performance and usability issue, a limit on max qty of builds
// allowed on data extration has been set.
// Is absolutely arbitrary
// 
$tlCfg->resultMatrixReport->buildQtyLimit = 6;

// ORDER BY sql clause, refers to builds table columns
$tlCfg->resultMatrixReport->buildOrderByClause = " ORDER BY name ASC";


// Show all available status details for test plans on metrics dashboard 
$tlCfg->metrics_dashboard = new stdClass();
$tlCfg->metrics_dashboard->show_test_plan_status = false;




// ----------------------------------------------------------------------------
/* [GENERATED DOCUMENTATION] */

/**
 * Texts and settings for printed documents
 * Image is expected in directory <testlink_root>/gui/themes/<your_theme>/images/
 * Leave text values empty if you would like to hide parameters.
 */
$tlCfg->document_generator->company_name = 'TestLink Community [configure $tlCfg->document_generator->company_name]';
$tlCfg->document_generator->company_copyright = '2012 &copy; TestLink Community';
$tlCfg->document_generator->confidential_msg = '';

// Logo for generated documents
$tlCfg->document_generator->company_logo = $tlCfg->logo_login;
$tlCfg->document_generator->company_logo_height = '53';

/** CSS used in printed html documents */
$tlCfg->document_generator->css_template = 'css/tl_documents.css';

// CSS file for Requirement Specification Document, Requirement and Requirement Spec Print View
$tlCfg->document_generator->requirement_css_template = 'css/tl_documents.css';

/** Misc settings */
// Display test case version when creating test spec document
$tlCfg->document_generator->tc_version_enabled = FALSE;



// ----------------------------------------------------------------------------
/* [Test Executions] */

// ENABLED -> enable XML-RPC calls to external test automation server
//            new buttons will be displayed on execution pages
// DISABLED -> disable
$tlCfg->exec_cfg->enable_test_automation = DISABLED;


// ASCending   -> last execution at bottom
// DESCending  -> last execution on top      [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->history_order = 'DESC';

// TRUE  -> the whole execution history for the choosen build will be showed
// FALSE -> just last execution for the choosen build will be showed [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->history_on = FALSE;

// TRUE  ->  test case VERY LAST (i.e. in any build) execution status will be displayed [STANDARD BEHAVIOUR]
// FALSE -> only last result on current build.
$tlCfg->exec_cfg->show_last_exec_any_build = TRUE;

// TRUE  ->  History for all builds will be shown
// FALSE ->  Only history of the current build will be shown  [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->show_history_all_builds = FALSE;

// TRUE  ->  History for all platforms (if any exists for test plan) will be shown
// FALSE ->  Only history of the current platform will be shown  [STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->show_history_all_platforms = FALSE;

// different models for the attachments management on execution page
// $att_model_m1 ->  shows upload button and title
// $att_model_m2 ->  hides upload button and title
$tlCfg->exec_cfg->att_model = $att_model_m2;   //defined in const.inc.php


// ENABLED -> test cases will be coloured according to test case status
$tlCfg->exec_cfg->enable_tree_testcases_colouring = ENABLED;

// ENABLED -> test cases will be coloured according to execution status on build selected for execution
// DISABLED -> test cases will be coloured according status on latest execution regardless of selected build
// see http://mantis.testlink.org/view.php?id=3450 for more details 
$tlCfg->exec_cfg->testcases_colouring_by_selected_build = ENABLED;

// ENABLED -> test case counters will be coloured according to test case status
$tlCfg->exec_cfg->enable_tree_counters_colouring = ENABLED;


// This can help to avoid performance problems.
// Controls what happens on right frame when user clicks on a testsuite on tree.
// ENABLED -> show all test cases presents on test suite and children test suite.
// DISABLED -> nothing happens, to execute a test case you need to click on test case
$tlCfg->exec_cfg->show_testsuite_contents = DISABLED;

// ENABLED -> enable testcase counters by status on tree
$tlCfg->exec_cfg->enable_tree_testcase_counters = ENABLED;


// Define list of roles that are affected by:
// $tlCfg->exec_cfg->view_mode and $tlCfg->exec_cfg->exec_mode
// User must reconfigure if define other simple tester roles
//
// In addition (till code changes) also roles that verify this condition:
// $effective_role->hasRight('testplan_execute') and !$effective_role->hasRight('testplan_planning')
// Will be affected by:
// $tlCfg->exec_cfg->view_mode and $tlCfg->exec_cfg->exec_mode
//
$tlCfg->exec_cfg->simple_tester_roles=array(TL_ROLES_TESTER);

// Filter Test cases a user with tester role can VIEW depending on
// test execution assignment.
// all: all test cases.
// assigned_to_me: test cases assigned to logged user.
// assigned_to_me_or_free: test cases assigned to logged user or not assigned
$tlCfg->exec_cfg->view_mode->tester='assigned_to_me';

// Filter Test cases a user with tester role can EXECUTE depending on
// test execution assignment.
// all: all test cases.
// assigned_to_me: test cases assigned to logged user.
// assigned_to_me_or_free: test cases assigned to logged user or not assigned
$tlCfg->exec_cfg->exec_mode->tester='assigned_to_me';

/** User filter in Test Execution navigator - default value */
// logged_user -> combo will be set to logged user
// none        -> no filter applied by default
$tlCfg->exec_cfg->user_filter_default='none';


// 'horizontal' ->  step and results on the same row
// 'vertical'   ->  steps on one row, results in the row bellow
$tlCfg->exec_cfg->steps_results_layout = 'horizontal';

// true => on single test case execution feature, notes and result
//         can be provided for each step
// false => pre 1.9.10 behaviour
// 
$tlCfg->exec_cfg->steps_exec = true;

// When textarea is displayed to allow user to write execution notes
// at step level, choose what to display:
// 'empty'
// 'latest' => latest execution notes.
$tlCfg->exec_cfg->steps_exec_notes_default = 'empty';

// Parameters to show notes/details when entering test execution feature
// EXPAND: show expanded/open
// COLLAPSE: show collapsed/closede
// LAST_USER_CHOICE: get status from cookie that holds last user choice.[STANDARD BEHAVIOUR]
$tlCfg->exec_cfg->expand_collapse = new stdClass();
$tlCfg->exec_cfg->expand_collapse->testplan_notes = LAST_USER_CHOICE;
$tlCfg->exec_cfg->expand_collapse->platform_description = LAST_USER_CHOICE;
$tlCfg->exec_cfg->expand_collapse->build_description = LAST_USER_CHOICE;
$tlCfg->exec_cfg->expand_collapse->testsuite_details = LAST_USER_CHOICE;


// ----------------------------------------------------------------------------
/* [Test Specification] */

// 'horizontal' ->  step and results on the same row
// 'vertical'   ->  steps on one row, results in the row bellow
$tlCfg->spec_cfg->steps_results_layout = 'horizontal';


// ENABLED -> User will see a test suite filter while creating test specification
// DISABLED -> no filter available
// $g_spec_cfg->show_tsuite_filter = ENABLED;
$tlCfg->spec_cfg->show_tsuite_filter = ENABLED;

// ENABLED -> every time user do some operation on test specification
//            tree is updated on screen.
// DISABLED -> tree will not be updated, user can update it manually.
// Anyway on user interface user will be able to change this choice
// $g_spec_cfg->automatic_tree_refresh = ENABLED;
$tlCfg->spec_cfg->automatic_tree_refresh = ENABLED;


// To avoid perfomance problems on search test case feature,
// we can decide when to inform user that results can not be displayed
// due to too many results.
$tlCfg->testcase_cfg->search=new stdClass();
$tlCfg->testcase_cfg->search->max_qty_for_display=200;


$tlCfg->testcase_cfg->duplicated_name_algorithm = new stdClass();
// 'stringPrefix' => use duplicated_name_algorithm->text
// 'counterSuffix' => creare name as :
//                    test case title  + (number of existent test cases +1)
//                    example: My Test Title 2
//                    duplicated_name_algorithm->text is used as sprintf format mask
$tlCfg->testcase_cfg->duplicated_name_algorithm->type = 'stringPrefix';
$tlCfg->testcase_cfg->duplicated_name_algorithm->text = strftime("%Y%m%d-%H:%M:%S", time());
// $tlCfg->testcase_cfg->duplicated_name_algorithm->type = 'counterSuffix';
// $tlCfg->testcase_cfg->duplicated_name_algorithm->text = " (%s)";


// TICKET 6422: Estimation in Test specification as mandatory field
// Implemented using HTML5
$tlCfg->testcase_cfg->estimated_execution_duration = new stdClass();
// $tlCfg->testcase_cfg->estimated_execution_duration->required = 'required';
$tlCfg->testcase_cfg->estimated_execution_duration->required = '';


/** text template for a new items:
    Test Case: summary, steps, expected_results, preconditions

*/
// object members has SAME NAME that FCK editor objects.
// the logic present on tcEdit.php is dependent of this rule.
// every text object contains an object with following members: type and value
//
// Possible values for type member:
// none: template will not be used, default will be a clean editor screen.
//
// string: value of value member is assigned to FCK object
// string_id: value member is used in a lang_get() call, and return value
//       is assigned to FCK object. Configure string_id on custom_strings.txt
// file: value member is used as file name.
//       file is readed and it's contains assigned to FCK object
//
// any other value for type, results on '' assigned to FCK object

$tlCfg->testcase_template = new stdClass();

$tlCfg->testcase_template->summary = new stdClass();
$tlCfg->testcase_template->summary->type = 'none';
$tlCfg->testcase_template->summary->value = '';

$tlCfg->testcase_template->steps = new stdClass();
$tlCfg->testcase_template->steps->type = 'none';
$tlCfg->testcase_template->steps->value = '';

$tlCfg->testcase_template->expected_results = new stdClass();
$tlCfg->testcase_template->expected_results->type = 'none';
$tlCfg->testcase_template->expected_results->value = '';

$tlCfg->testcase_template->preconditions = new stdClass();
$tlCfg->testcase_template->preconditions->type = 'none';
$tlCfg->testcase_template->preconditions->value = '';


/** text template for a new Test Suite description */
$tlCfg->testsuite_template = new stdClass();
$tlCfg->testsuite_template->details = new stdClass();
$tlCfg->testsuite_template->details->type = 'none';
$tlCfg->testsuite_template->details->value = '';

$tlCfg->project_template = new stdClass();
$tlCfg->project_template->notes  = new stdClass();
$tlCfg->project_template->notes->type = 'none';
$tlCfg->project_template->notes->value = '';

$tlCfg->testplan_template = new stdClass();
$tlCfg->testplan_template->notes = new stdClass();
$tlCfg->testplan_template->notes->type = 'none';
$tlCfg->testplan_template->notes->value = '';

$tlCfg->execution_template = new stdClass();
$tlCfg->execution_template->bulk_exec_notes = new stdClass();
$tlCfg->execution_template->bulk_exec_notes->type = 'none';
$tlCfg->execution_template->bulk_exec_notes->value = '';

$tlCfg->execution_template->notes = new stdClass();
$tlCfg->execution_template->notes->type = 'none';
$tlCfg->execution_template->notes->value = '';

$tlCfg->build_template = new stdClass();
$tlCfg->build_template->notes = new stdClass();
$tlCfg->build_template->notes->type = 'none';
$tlCfg->build_template->notes->value = '';

$tlCfg->requirement_template = new stdClass();
$tlCfg->requirement_template->scope = new stdClass();
$tlCfg->requirement_template->scope->type = 'none';
$tlCfg->requirement_template->scope->value = '';

$tlCfg->req_spec_template = new stdClass();
$tlCfg->req_spec_template->scope = new stdClass();
$tlCfg->req_spec_template->scope->type = 'none';
$tlCfg->req_spec_template->scope->value = '';

$tlCfg->role_template = new stdClass();
$tlCfg->role_template->notes = new stdClass();
$tlCfg->role_template->notes->type = 'none';
$tlCfg->role_template->notes->value = '';


$tlCfg->platform_template = new stdClass();
$tlCfg->platform_template->notes = new stdClass();
$tlCfg->platform_template->notes->type = 'none';
$tlCfg->platform_template->notes->value = '';

// ----------------------------------------------------------------------------
/* [ATTACHMENTS] */

/** Attachment feature availability */
$g_attachments = new stdClass();
$g_attachments->enabled = TRUE;

/** the type of the repository can be database or filesystem
 * TL_REPOSITORY_TYPE_DB => database
 * TL_REPOSITORY_TYPE_FS => filesystem
 **/
$g_repositoryType = TL_REPOSITORY_TYPE_FS;

/**
 * TL_REPOSITORY_TYPE_FS: the where the filesystem repository should be located
 * We recommend to change the directory for security reason.
 * (see http://itsecuritysolutions.org/2012-08-13-TestLink-1.9.3-multiple-vulnerabilities/)
 * Put it out of reach via web or configure access denied.
 *
 **/
$g_repositoryPath = '/var/testlink/upload_area/';  /* unix example */

/**
 * compression used within the repository
 * TL_REPOSITORY_COMPRESSIONTYPE_NONE => no compression
 * TL_REPOSITORY_COMPRESSIONTYPE_GZIP => gzip compression
 */
$g_repositoryCompressionType = TL_REPOSITORY_COMPRESSIONTYPE_NONE;

// the maximum allowed file size for each repository entry, default 1MB.
// Also check your PHP settings (default is usually 2MBs)
$tlCfg->repository_max_filesize = 1; //MB

// TRUE -> when you upload a file you can give no title
$g_attachments->allow_empty_title = TRUE;

// $g_attachments->allow_empty_title == TRUE, you can ask the system
// to do something
//
// 'none'         -> just write on db an empty title
// 'use_filename' -> use filename as title
//$g_attachments->action_on_save_empty_title='use_filename';
//
$g_attachments->action_on_save_empty_title = 'none';

// Remember that title is used as link description for download
// then if title is empty, what the system has to do when displaying ?
// 'show_icon'  -> the $g_attachments->access_icon will be used.
// 'show_label' -> the value of $g_attachments->access_string will be used .
$g_attachments->action_on_display_empty_title = 'show_icon';

// need to be moved AFTER include of custom_config
//
// $g_attachments->access_icon = '<img src="' . $tlCfg->theme_dir . 'images/new_f2_16.png" style="border:none" />';
$g_attachments->access_string = "[*]";

// Set display order of uploaded files 
$g_attachments->order_by = " ORDER BY date_added DESC ";



// ----------------------------------------------------------------------------
/* [Requirements] */

// HAS TO BE REMOVED - > req_doc_id UNIQUE INSIDE test project
// true : you want req_doc_id UNIQUE IN THE WHOLE DB (system_wide)
// false: you want req_doc_id UNIQUE INSIDE a SRS
// $tlCfg->req_cfg->reqdoc_id->is_system_wide = FALSE;

// 20101212 - truncate log message to this amount of chars for reqCompareVersions
$tlCfg->req_cfg->log_message_len = 200;

/**
 * Test Case generation from Requirements - use_req_spec_as_testsuite_name
 *  FALSE => test cases are created and assigned to a test suite
 *           with name $tlCfg->req_cfg->default_testsuite_name
 *  TRUE  => REQuirement Specification Title is used as testsuite name
 */
$tlCfg->req_cfg->use_req_spec_as_testsuite_name = TRUE;
$tlCfg->req_cfg->default_testsuite_name = "Auto-created Test cases";
$tlCfg->req_cfg->testsuite_details = "Test Cases in the Test Suite are generated from Requirements. " .
                                "A refinement of test scenario is highly recommended.";
$tlCfg->req_cfg->testcase_summary_prefix = "<b>The Test Case was generated from the assigned requirement.</b><br />";


// If the following value is enabled, then the summary prefix string will include the
// title and version number of the assigned requirement.
$tlCfg->req_cfg->use_testcase_summary_prefix_with_title_and_version = ENABLED;

// If above option is enabled, the following string will be used as a template for the tc summary prefix.
// It has to include four variables in the form of "%s". The first and second one will be used internally by the system.
// The third one will then be replaced by the title of the originating Requirement,
// the fourth one by its version number.
// Attention: If there aren't exactly three variables in it, the operation will fail.
$tlCfg->req_cfg->testcase_summary_prefix_with_title_and_version = "<b>The Test Case was generated from the assigned" .
    " requirement <a href=\"javascript:openLinkedReqVersionWindow(%s,%s)\">\"%s\" (version %s)</a>.</b><br />";

/**
 * ENABLED: When generating Test Cases from Requirements, copy the scope of the Requirement
 * to the summary of the newly created Test Case.
 */
$tlCfg->req_cfg->copy_req_scope_to_tc_summary = DISABLED;


// To avoid perfomance problems on search Requirements feature,
// we can decide when to inform user that results can not be displayed
// due to too many results.
$tlCfg->req_cfg->search=new stdClass();
$tlCfg->req_cfg->search->max_qty_for_display=200;


// ENABLED: allow N level depth tree
// DISABLED: just one level
$tlCfg->req_cfg->child_requirements_mgmt = ENABLED;


// ENABLED: ask for this value on user interface and use on several features
// DISABLED: do not ask, do not use
$tlCfg->req_cfg->expected_coverage_management = ENABLED;

// Show Child Requirements on Requirement Specification Print View
// ENABLED: Requirement Specification including Child Requirements are shown
// DIABLED: ONLY Requirement Specification is shown
$tlCfg->req_cfg->show_child_reqs_on_reqspec_print_view = DISABLED;

// 20090111 - franciscom
// Order of test cases status in this array, is used to undestand
// to what status set requirement in the requirements report.
// Standard algorithm, present in getReqCoverage(), is:
//
//
// if at least one of Test Cases linked to Requirement has status FAILED
//    Requirement Coverage Status = FAILED
// else if at least one of Test Cases linked to Requirement has status BLOCKED
//    Requirement Coverage Status = BLOCKED
// else if ALL Test Cases linked to Requirement has status NOT RUN
//    Requirement Coverage Status = NOT RUN
// else if ALL Test Cases linked to Requirement has status PASSED
//    Requirement Coverage Status = PASSED
// else
//    Requirement Coverage Status = Partially Passed
//
// This logic is implemented using following config parameter
$tlCfg->req_cfg->coverageStatusAlgorithm['checkOrder']=array('atLeastOne','all');
$tlCfg->req_cfg->coverageStatusAlgorithm['checkType']['atLeastOne']=array('failed','blocked');
$tlCfg->req_cfg->coverageStatusAlgorithm['checkType']['all']=array('passed');

// Configure here what status has to get requirement when check of type 'all' fails like
// in following situation (BUGID 2171)
// If particular requirement has assigned more than one test cases, and:
// - at least one of assigned test cases was not yet executed
// - the rest of assigned test cases was executed and passed
// then on the "Requirements based report" this particular requirement is not shown at all (in any section).
//
// $tlCfg->req_cfg->coverageStatusAlgorithm['checkFail']['all']='partially_passed';
// $tlCfg->req_cfg->coverageStatusAlgorithm['displayOrder']=array('passed','failed',
//                                                                'blocked','not_run','partially_passed');
// 20100819 - asimon - fix not needed anymore after rewrite of req based report
//$tlCfg->req_cfg->coverageStatusAlgorithm['checkFail']['all']='failed';
//$tlCfg->req_cfg->coverageStatusAlgorithm['displayOrder']=array('passed','failed','blocked','not_run');




// TICKET 4661 - truncate log message to this amount of chars for reqSpecCompareRevisions
$tlCfg->req_spec_cfg->log_message_len = 200;


// Linking between requirements/requirement specifications
//
$tlCfg->internal_links =  new stdClass();

//
// TRUE: links to other requirements/requirement specifications are
//       automatically generated from the corresponding Document ID, enclosed by tags (like BBCode).
//
// Usage:
// link to requirements: [req]req_doc_id[/req]
// link to requirement specifications: [req_spec]req_spec_doc_id[/req_spec]
//
// The test project of the requirement / requirement specification and an anchor
// to jump to can also be specified:
// [req tproj=<tproj_prefix> anchor=<anchor_name>]req_doc_id[/req]
// This syntax also works for requirement specifications.
//
// FALSE: no links are automatically created. 
//
$tlCfg->internal_links->enable =  TRUE;

// how a linked document (requirement/requirement specification) should be displayed.
// posible values:
//                'window': new window/tab will be used (depending on browser configuration)
//                'frame' : same frame as the clicked link
//                'popup' (default): popup window  (ATTENTION to browser pop-up block).
//
$tlCfg->internal_links->target = 'popup';

// title for automatically created link
// possible values:
//                 'string': lang_get() will be used to localize
//                 'none': no title will be generated, only link with ID
//                 'item' (default): localized type of item (e.g. "Requirement: ",  "Req Spec")
//                                   will be used as title for the generated link
//
$tlCfg->internal_links->req_link_title = new stdClass();
$tlCfg->internal_links->req_link_title->type = 'item';
$tlCfg->internal_links->req_link_title->value = '';

$tlCfg->internal_links->req_spec_link_title = new stdClass();
$tlCfg->internal_links->req_spec_link_title->type = 'item';
$tlCfg->internal_links->req_spec_link_title->value = '';


// Relations between requirement documents:
//
// The relation types have to be configured in cfg/const.inc.php
// and their respective localization values in locale strings.txt.

// There are some preconfigured standard types which you can use,
// additionally you can configure your own types.
$tlCfg->req_cfg->relations = new stdClass();
$tlCfg->req_cfg->relations->enable = TRUE;
$tlCfg->req_cfg->relations->interproject_linking = FALSE;

// Requirement/testcase diff
// default value of lines to show before and after each difference
$tlCfg->diffEngine->context = 5;


// Configuration for Requirement Import using DOCBOOK format
$tlCfg->req_cfg->importDocBook = new stdClass();
$tlCfg->req_cfg->importDocBook->requirement= "sect3";
$tlCfg->req_cfg->importDocBook->title= "title";
$tlCfg->req_cfg->importDocBook->paragraph= "para";
$tlCfg->req_cfg->importDocBook->ordered_list="orderedlist";
$tlCfg->req_cfg->importDocBook->list_item="listitem";
$tlCfg->req_cfg->importDocBook->table="informaltable";
$tlCfg->req_cfg->importDocBook->table_group="tgroup";
$tlCfg->req_cfg->importDocBook->table_head="thead";
$tlCfg->req_cfg->importDocBook->table_body="tbody";
$tlCfg->req_cfg->importDocBook->table_row="row";
$tlCfg->req_cfg->importDocBook->table_entry="entry";
$tlCfg->req_cfg->importDocBook->list_item_children = array('para','title');
$tlCfg->req_cfg->importDocBook->table_entry_children = array('para');


// If an external tool is used for requirement management, enable this setting.
// You will get an additional field on requirement specifications where you
// can enter the total count of requirements so that external requirements
// are also counted for metrics/statistics. 
$tlCfg->req_cfg->external_req_management = DISABLED;


//If enabled an icon next to Document ID field will show up that allows
//to insert the last defined Requirement Document ID within the same Project
//into Document ID field
$tlCfg->req_cfg->allow_insertion_of_last_doc_id = DISABLED;


// used ONLY to configure the mask (text) .
// algorithm type is fixed HARDCODED
//
$tlCfg->req_cfg->duplicated_name_algorithm = new stdClass();
$tlCfg->req_cfg->duplicated_name_algorithm->text = " (%s)";

$tlCfg->req_cfg->duplicated_docid_algorithm = new stdClass();
$tlCfg->req_cfg->duplicated_docid_algorithm->text = " (%s)";


// ----------------------------------------------------------------------------
/* [TREE FILTER CONFIGURATION] */

/* In the following section, you can configure which filters shall be used
 * in combination with the tree view for testcases and requirements.
 * There are five available filter modes (four for the testcase tree,
 * one for requirement documents), which are used for the different features
 * as listed here:
 *
 * For Test Cases:
 * --> execution_mode
 *    execution of testcases
 * --> edit_mode
 *    create and edit testcases
 *    assign keywords to testcases
 *    assign requirements to testcases
 * --> plan_mode
 *    assign testcase execution to users
 *    update linked versions for testplan
 *    set urgent testcases
 * --> plan_add_mode
 *    add/remove testcases to/from testplan
 *
 * For Requirements:
 * There are no modes defined, there is only one filter configuration.
 * The filters configured here will be used for requirement editing.
 */
$tlCfg->tree_filter_cfg = new stdClass();
$tlCfg->tree_filter_cfg->testcases = new stdClass();
$tlCfg->tree_filter_cfg->requirements = new stdClass();

// These are the available filter modes for testcases:
$tlCfg->tree_filter_cfg->testcases->execution_mode = new stdClass();
$tlCfg->tree_filter_cfg->testcases->edit_mode = new stdClass();
$tlCfg->tree_filter_cfg->testcases->plan_mode = new stdClass();
$tlCfg->tree_filter_cfg->testcases->plan_add_mode = new stdClass();

// If you disable one of these items here, you switch
// the complete filter panel off for a specific mode/feature.
// You should rather do this here instead of individually disabling all the filters,
// if you don't want to have any filters at all for a given feature.
$tlCfg->tree_filter_cfg->testcases->execution_mode->show_filters = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->show_filters = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->show_filters = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->show_filters = ENABLED;
$tlCfg->tree_filter_cfg->requirements->show_filters = ENABLED;

// Detailed settings for each mode.
// Here, the single filter fields can be disabled if not wanted.
// Also, the choice of advanced filter mode can be disabled.
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_testcase_name = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_toplevel_testsuite = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_keywords = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_priority = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_execution_type = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_assigned_user = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_result = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->filter_bugs = ENABLED;
$tlCfg->tree_filter_cfg->testcases->execution_mode->advanced_filter_mode_choice = ENABLED;

$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_testcase_name = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_toplevel_testsuite = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_keywords = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_active_inactive = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_importance = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_execution_type = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->testcases->edit_mode->filter_workflow_status = ENABLED;

// filter mode choice disabled for this mode because there are no filters benefiting from it
$tlCfg->tree_filter_cfg->testcases->edit_mode->advanced_filter_mode_choice = DISABLED;


$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_testcase_name = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_toplevel_testsuite = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_keywords = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_priority = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_execution_type = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_assigned_user = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->filter_result = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_mode->advanced_filter_mode_choice = ENABLED;

$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_testcase_name = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_toplevel_testsuite = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_keywords = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_active_inactive = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_importance = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_execution_type = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_workflow_status = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->testcases->plan_add_mode->advanced_filter_mode_choice = ENABLED;

$tlCfg->tree_filter_cfg->requirements->filter_doc_id = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_title = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_status = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_type = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_spec_type = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_coverage = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_relation = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_tc_id = ENABLED;
$tlCfg->tree_filter_cfg->requirements->filter_custom_fields = ENABLED;
$tlCfg->tree_filter_cfg->requirements->advanced_filter_mode_choice = ENABLED;

// ENABLED -> Every time the user does some operation on requirement spec,
//            the tree will be updated on screen. [DEFAULT]
// DISABLED -> The tree will not be updated automatically, but  the user can update it manually.
//             On graphical user interface any user will is able to change this setting.
$tlCfg->tree_filter_cfg->requirements->automatic_tree_refresh = ENABLED;



/* [Assign test cases to test plan] */
$tlCfg->tplanDesign->hideTestCaseWithStatusIn = array($tlCfg->testCaseStatus['obsolete'] => 'obsolete',
                            $tlCfg->testCaseStatus['future'] => 'future' );

// ----------------------------------------------------------------------------
/* [MISC FUNCTIONALITY] */

/** Maximum uploadfile size to importing stuff in TL */
// Also check your PHP settings (default is usually 2MBs)
// unit BYTES is required by MAX_FILE_SIZE HTML option
$tlCfg->import_file_max_size_bytes = '409600';

/** Maximum line size of the imported file */
$tlCfg->import_max_row = '10000'; // in chars

/** Set the default role used for new users */
// - created from the login page.
// - created using user management features
$tlCfg->default_roleid = TL_ROLES_GUEST;

// only show custom fields if their value isn't empty
$tlCfg->custom_fields->show_custom_fields_without_value = true;

/** used to check size in char for TEXT AREA type custom fields */
// can not be greater that column definition on DB
// 0 => do not check.
$tlCfg->custom_fields->max_length = 255;

// sizes for HTML INPUTS
// for list, multiselection list => number of items
// for checkbox,radio is useless
// Hint: more than 120 produce weird effects on user interface
//
$tlCfg->custom_fields->sizes = array('string' => 100,
                                     'numeric' => 10,
                                     'float' => 10,
                                     'email' => 100,
                                     'list' => 5,
                                     'multiselection list' => 5,
                         'text area' => array('rows' => 6, 'cols' => 80),
                       'script' => 100,
                       'server' => 100);

// Use this variable (on custom_config.inc.php) to define new Custom Field types.
// IMPORTANT:
//           check $custom_field_types property on cfield_mgr.class.php
//           to avoid overwrite of standard types.
//
$tlCfg->gui->custom_fields->types = null;

// Use this variable (on custom_config.inc.php)
// to define possible values behaviour for new Custom Field types.
//
// IMPORTANT:
//           check $possible_values_cfg property on cfield_mgr.class.php
//           to avoid overwrite of standard values.
//
$tlCfg->gui->custom_fields->possible_values_cfg = null;


/**
 * Check unique titles of Test Project, Test Suite and Test Case
 *  ENABLED  => Check              [STANDARD BEHAVIOUR]
 *  DISABLED => don't check
 **/
$tlCfg->check_names_for_duplicates = ENABLED;

/**
 * Action for duplication check (only if check_names_for_duplicates=ENABLED)
 * 'allow_repeat' => allow the name to be repeated (backward compatibility)
 * 'generate_new' => generate a new name using $g_prefix_name_for_copy
 * 'block'        => return with an error
 **/
$tlCfg->action_on_duplicate_name = 'generate_new';

/**
 * String checking and conversions
 * Allow automatically convert www URLs and email adresses into clickable links
 * used by function string_display_links() for example by custom fields.
 * Valid values = ENABLED/DISABLED.
 **/
$tlCfg->html_make_links = ENABLED;

/**
 * Define the valid html tags for "content driven" single-line and multi-line fields.
 * Do NOT include tags with parameters (eg. <font face="arial">), img and href.
 * It's used by function string_display_links() for example by custom fields.
 */
$tlCfg->html_valid_tags = 'p, li, ul, ol, br, pre, i, b, u, em';
$tlCfg->html_valid_tags_single_line = 'i, b, u, em';

/**
 * Defines the threshold values for filtering TC by a priority according to the formula
 * LOW  => all Tc's with (urgency*importance) < LOW_Threshold
 * HIGH   => all Tc's with (urgency*importance) >= HIGH_Threshold
 * MEDIUM  => all Tc's with (urgency*importance) >= LOW_Threshold AND (urgency*importance) < HIGH_Threshold
 */
$tlCfg->urgencyImportance = new stdClass();
$tlCfg->urgencyImportance->threshold['low'] = 3;
$tlCfg->urgencyImportance->threshold['high'] = 6;

/**
 * @var boolean Demo mode disables some functionality
 * user edit disable
 * role create ENABLED
 * user create ENABLED
 * special users manage DISABLE
 */
$tlCfg->demoMode = OFF;
$tlCfg->demoSpecialUsers = array('admin');

/**
 * If enabled, every Ext JS table in TestLink will offer an export button,
 * which generates a file with the contents of the table.
 * ATTENTION: This feature is fully experimental. Enable at your own risk!
 *            Enabling it can cause broken tables.
 */
$tlCfg->enableTableExportButton = DISABLED;


/**
 * Taken from Mantis to implement better login security, and solve
 * TICKET 4342
 */
$tlCfg->auth_cookie = "TESTLINK_USER_AUTH_COOKIE";

/** 
Used when creating a Test Suite using copy
and you have choose  $g_action_on_duplicate_name = 'generate_new'
if the name exist.
*/
$g_prefix_name_for_copy = strftime("%Y%m%d-%H:%M:%S", time());

// name of your custom.css, place it in same folder that standard TL css
// null or '' => do not use
$tlCfg->custom_css = null;


// ----- End of Config ------------------------------------------------------------------
// --------------------------------------------------------------------------------------
// DO NOT CHANGE NOTHING BELOW
// --------------------------------------------------------------------------------------

/** Functions for check request status */
require_once('configCheck.php');

clearstatcache();
if ( file_exists( TL_ABS_PATH . 'custom_config.inc.php' ) )
{
  require_once( TL_ABS_PATH . 'custom_config.inc.php' );
}

/** root of testlink directory location seen through the web server */
/*  20070106 - franciscom - this statement it's not 100% right
    better use $_SESSION['basehref'] in the scripts. */
define('TL_BASE_HREF', get_home_url(array('force_https' => $tlCfg->force_https)));


if( !isset($g_attachments->access_icon) )
{
  $g_attachments->access_icon = '<img src="' . $tlCfg->theme_dir . 'images/new_f2_16.png" style="border:none" />';
}


// Important to do this only after custom_* to use (if exists) redefinition of
// $tlCfg->results['status_label_for_exec_ui']
$tlCfg->reportsCfg->exec_status = $tlCfg->results['status_label_for_exec_ui'];


/** Support for localization */
//  @TODO schlundus, move the code out of config and do it only once and not always in any include!
//  @TODO schlundus, a better parsing function should be include
$serverLanguage = false;
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
{
  @list($code) = explode(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
  @list($a,$b) = explode("-",$code);
  if ($a && $b)
  {
    $a = strtolower($a);
    $b = strtoupper($a);
    $serverLanguage = $a."_".$b;
  }
}

if(false !== $serverLanguage)
{
  if (array_key_exists($serverLanguage,$tlCfg->locales))
  { 
    $tlCfg->default_language = $serverLanguage;
  } 
}
define ('TL_DEFAULT_LOCALE', $tlCfg->default_language);

// Reverted execution status is used for two applications.
// 1. To map code to CSS, Please if you add an status you need to add a corresponding CSS Class
//    in the CSS files (see the gui directory)
// 2. to decode from code to some more human oriented to use in code
//
/** Revered list of Test Case execution results */
$tlCfg->results['code_status'] = array_flip($tlCfg->results['status_code']);

// Enable CSRF global protection
$tlCfg->csrf_filter_enabled = TRUE;

// --------------------------------------------------------------------------------------
/** Converted and derived variables (Users should not modify this section) */
define('REFRESH_SPEC_TREE',$tlCfg->spec_cfg->automatic_tree_refresh ? 1 : 0);
define('TL_SORT_TABLE_ENGINE',$g_sort_table_engine);
define("TL_REPOSITORY_MAXFILESIZE", 1024*1024*$tlCfg->repository_max_filesize);

define('TL_XMLEXPORT_HEADER', "<?xml version=\"1.0\" encoding=\"" . $tlCfg->charset . "\"?>\n");

define('TL_THEME_BASE_DIR', $tlCfg->theme_dir);
define('TL_THEME_IMG_DIR', $tlCfg->theme_dir . 'images/');
define('TL_THEME_CSS_DIR', $tlCfg->theme_dir . 'css/');
define('TL_TESTLINK_CSS', TL_THEME_CSS_DIR . TL_CSS_MAIN);
define('TL_PRINT_CSS', TL_THEME_CSS_DIR . TL_CSS_PRINT);
define('TL_TREEMENU_CSS', TL_THEME_CSS_DIR . TL_CSS_TREEMENU);

// if you do not want to use this, redefine $tlCfg->custom_css as '' or null
define('TL_TESTLINK_CUSTOM_CSS', TL_THEME_CSS_DIR . $tlCfg->custom_css);


// --------------------------------------------------------------------------------------
// when a role is deleted, a new role must be assigned to all users
// having role to be deleted
// A right choice seems to be using $g_default_roleid.
// You can change this adding a config line in custom_config.inc.php
// @TODO martin: remove - use directly $tlCfg->default_roleid;
$g_role_replace_for_deleted_roles = $tlCfg->default_roleid;


/**
 * Using "|" in the testsuite name causes malformed URLs
 * regexp used to check for chars not allowed in:
 * test project, test suite and testcase names.
 * @TODO martin: encode harm characters @see http://cz.php.net/urlencode (and remove the parameter)
 *
 * now is preg pattern
 */
$g_ereg_forbidden = "/[|]/i";



/**
 * @TODO remove from TL - unfinished refactorization;
 * use $tlCfg instead of old variables and constants
 */
define('TL_IMPORT_ROW_MAX', $tlCfg->import_max_row);
define('TL_TPL_CHARSET', $tlCfg->charset);
define('TITLE_SEP',$tlCfg->gui_title_separator_1);
define('TITLE_SEP_TYPE2',$tlCfg->gui_title_separator_2);
define('TITLE_SEP_TYPE3',$tlCfg->gui_title_separator_2); // obsolete: use type 1,2
define('TL_FRMWORKAREA_LEFT_FRAME_WIDTH', $tlCfg->frame_workarea_default_width);
define('TL_TEMP_PATH', $tlCfg->temp_dir);

$tlCfg->gui->title_separator_1 =  $tlCfg->gui_title_separator_1;
$tlCfg->gui->title_separator_2 =  $tlCfg->gui_title_separator_2;
$tlCfg->gui->role_separator_open =  $tlCfg->gui_separator_open;
$tlCfg->gui->role_separator_close = $tlCfg->gui_separator_close;
// ----- END OF FILE --------------------------------------------------------------------