<?php
/**
 * ♔ TestLink Open Source Project - http://testlink.sourceforge.net/
 * This script is distributed under the GNU General Public License 2 or later.
 *
 * Filename $RCSfile: texts.php,v $
 * @version $Revision: 1.5 $
 * @modified $Date: 2010/06/24 17:25:53 $ by $Author: asimon83 $
 * @author Martin Havlat and reviewers from TestLink Community
 *
 * --------------------------------------------------------------------------------------
 *
 * Scope:
 * English (en_GB) texts for help/instruction pages. Strings for dynamic pages
 * are stored in strings.txt pages.
 *
 * Here we are defining GLOBAL variables. To avoid override of other globals
 * we are using reserved prefixes:
 * $TLS_help[<key>] and $TLS_help_title[<key>]
 * or
 * $TLS_instruct[<key>] and $TLS_instruct_title[<key>]
 *
 *
 * Revisions history is not stored for the file
 *
 *-------------------------------------------------------------------
 * Japanese translation
 *-------------------------------------------------------------------
 * Testing Engineer's Forum (TEF) in Japan
 * Working Group of TestLink Japanese Translation Project
 *
 * http://blues.se.uec.ac.jp/swtest/
 * http://testlinkjp.org/
 * http://sourceforge.jp/projects/testlinkjp/
 *
 * Adviser:
 * Yasuharu NISHI
 *
 * Core member:
 * Atsushi Nagata,       AZMA Daisuke,         Hiromi Nishiyama,
 * Kaname Mochizuki,     Kaoru Nakamura,       Kunio Murakami,
 * Lumina Nishihara,     Marino Suda,          Masahide Katsumata,
 * Masami Ichikawa,      Masataka Yoneta,      Sadahiko Hantani,
 * Shinichi Sugiyama,    Shinsuke Matsuki,     Shizuka Ban,
 * Takahiro Wada,        Toshinori Sawaguchi,  Toshiyuki Kawanishi,
 * Yasuhiko Okada,       Yoichi Kunihiro,      Yoshihiro Yoshimura,
 * Yukiko Kajino
 *
 * ------------------------------------------------------------------------------------ */


$TLS_htmltext_title['assignReqs']	= "テストケースに要件をアサインする";
$TLS_htmltext['assignReqs'] 		= "<h2>目的:</h2>
<p>この機能により、要件とテストケースを関連付けることができます。
テスト設計者は0..n対0..nの関連付けを定義することができます。
すなわち、要件に関連付けられないテストケースがあったり、複数の
要件にテストケースを関連付けることができますし、逆も可能です。
このトレーサビリティマトリクスにより、
要件カバレッジの調査や要件ごとのテストの結果の追跡することができます。
この解析結果は、次の計画に役立つでしょう。</p>

<h2>やってみましょう！:</h2>
<ol>
	<li>左ブロックのツリー構造からテストケースを選択してください。
    要件仕様書リストのコンボボックスがワークエリアの上部に表示されます。 </li>
	<li>要件仕様を選択してください。
    TestLink は自動でページの再読み込みを行います。</li>
	<li>ワークエリアの中央のブロックに選択した仕様書より、
    テストケースと関係付けられたすべての要件がリストされます。
    下のブロックには現在のテストケースと関連付けられていないすべての要件の中から
    「使用可能な要件」がリストされます。
    このテストケースを選択し、「アサイン」ボタンをクリックすることにより、
    テスト設計者は要件に印をつけることができます。
    新規にアサインされたテストケースは中央のブロックの「アサインされた要件」に表示されます。</li>
</ol>";


// --------------------------------------------------------------------------------------
$TLS_htmltext_title['editTc']	= "テスト仕様";
$TLS_htmltext['editTc'] 		= "<h2>目的:</h2>
<p><i>テスト仕様</i> は、存在する<i>テストスイート</i>そして<i>テストケース</i> の".
        "情報を閲覧したり変更したりする場所です。" .
        "異なるバージョンのテストケースを見ることもできます。</p>

<h2>やってみましょう！:</h2>
<ol>
	<li>テストプロジェクトをナビゲーションのツリーから選択します。<i>メモ: " .
	"テストプロジェクトの変更は右上の" .
    "プルダウンリストを選択することでおこなうことができます。</i></li>
	<li><b>子テストスイート作成</b>ボタンをクリックし、テストスイートを作成します。" .
	"このテストスイートに従ってテストドキュメントが構成されます" .
	"(例えば、機能/非機能などの種別、コンポーネントやフィーチャーによる分別など)。" .
	"テストスイートには、テストケース、環境設定、関連ドキュメントへの参照、" .
	"制限事項や、それ以外に必要な情報を記載します。" .
	"一般に、配下のテストケースに関する様々な共通する説明を記述することになります。" .
	"<li>テストスイートは「フォルダー」のような概念ともいえます。 従って、テストプロジェクト内で" .
	"テストスイートのコピーや移動ができます。また、インポートとエクスポートも可能です (テストケースを含めることもできます)。</li>
	<li>作成したテストスイートをナビゲーションから選択し、" .
	"<b>テストケースを作成</b>ボタンをクリックすることでテストケースを作成します。" .
	"テストケースには、テストシナリオ、期待結果やテストプロジェクトで定義されたカスタムフィールド" .
	"などを記載します (詳しくは、ユーザマニュアルを参照してください。" .
	"また、トレーサビリティのために<b>キーワード</b>をアサインすることもできます。</li>
	<li>左横にあるツリーでデータ編集を指示します。</li>
	<li>作成したテスト仕様書をテストケースが準備完了したときに <i>テスト計画</i>に割り当てます。</li>
</ol>

<p>TestLinkではテストスイートによってテストケースを整理することができるでしょう。" .
"テストスイートは入れ子状にすることができるので、テストスイートの階層を作ることができます。
この情報はテストケースとともに印刷されます。</p>";


// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['searchTc']	= "テストケース検索ページ";
$TLS_htmltext['searchTc'] 		= "<h2>目的：</h2>

<p>ナビゲーションないの検索文字列に従って検索をおこないます。
検索は大文字と小文字を区別しません。 
検索結果は現在ののテストプロジェクトからのテストケースのみを含みます。</p>


<h2>検索してみましょう！：</h2>

<ol>
    <li>適当な欄に検索したい文字列を入力してください。左にあるフォームの空欄部分です。</li>
    <li>必要なキーワードを選ぶか、左側にある値の '適用しない' を選んで下さい。</li>
    <li>検索ボタンをクリックして下さい。</li>
    <li>全ての条件に一致したテストケースが表示されます。'タイトル'をクリックすることでテストケースを編集できます。</li>
</ol>";


// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['printTestSpec']	= "テスト仕様の印刷"; //printTC.html
$TLS_htmltext['printTestSpec'] 			= "<h2>目的:</h2>
<p>この機能は各々のテストケース、またはテストプロジェクト/テスト計画全体のテストケースを印刷できます。</p>
<h2>やってみましょう！:</h2>
<ol>
<li>
<p>参照するテストケース、テストスイート、またはテストプロジェクトをクリックします。<br />
</p>
</li>
<li><p>ナビゲーションシートの「印刷オプション」テーブルにて印刷データの範囲とフォーマットを
設定します。HTMLもしくはMS Word形式を選択することができます。詳しくは<span class=\"help\" 
onclick=\"javascript:open_help_windows('printFilter','{$locale}');\">ヘルプ</span>を参照してください。</p>
</li>
<li><p>ブラウザの印刷機能にてテストケースを印刷します。<br />
 <i>注意: 印刷できるのはブラウザの右側のみです。</i></p></li>
</ol>";


// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['reqSpecMgmt']	= "要件仕様の設計";
$TLS_htmltext['reqSpecMgmt'] 			= "<p>要件仕様ドキュメントを管理することができます。</p>

<h2>要件仕様</h2>

<p>各要件は、テストプロジェクトごとに作成する<b>要件仕様ドキュメント</b>によって
まとめられています。<br />ただし、TestLink 自体には、要件仕様、および要件の
バージョン管理機能はサポートされていません。もし、バージョンを考慮する必要がある場合は、
バージョン番号を含めた題号を<b>タイトル</b>欄に記載してください。
また、仕様の簡単な説明や備考を <b>スコープ</b> 欄に記載することができます。</p>

<p><b><a name='total_count'>ドキュメント内の全要件数</a></b> は、
TestLinkに全要件を登録しなかった場合に、要件カバレッジを計算するために使用します。
値<b>0</b>を設定した場合は、TestLinkに登録されている要件数をメトリクス計算で使用します。</p>
<p><i>例えば、SRSが 200 の要件を含んでいるが、50のみをTestLinkに登録したとします。
するとテストの要件カバレッジは25%となります (追加した要件を全てテストした場合)。</i></p>

<h2><a name='req'>要件</a></h2>

<p>要件を作成する要件仕様のタイトルをクリックしてください。要件仕様が内場合は、テストプロジェクト名をクリックすることで作成することができます。
要件をドキュメントに作成、編集、削除、または要件をインポートすることができます。
ステータスは「通常」または「テスト不能」から選択する必要があります。
テスト不能要件はメトリクス計算で使用されません。
このパラメータは実装されていない機能、間違った設計の要件のために使用されます。</p> 

<p>要件仕様のページから、数回ボタンをクリックすることで、
要件をチェックするための新規テストケースを作成することができます。
これらのテストケースは、TestLinkの設定で定義された名前のテストスイートに格納されます
<i>(デフォルトでは \$tlCfg->req_cfg->default_testsuite_name =
'Test suite created by Requirement - Auto';)</i>。
タイトルとスコープは作成されたテストケースにコピーされます。</p>";


// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['keywordsAssign']	= "キーワードのアサイン";
$TLS_htmltext['keywordsAssign'] 			= "<h2>目的:</h2>
<p>キーワードのアサインでは、ユーザが一括してテストスイートまたはテストケースに
一括してキーワードを割り当てることができます。</p>

<h2>キーワードを割り当てましょう！:</h2>
<ol>
	<li>左側のツリービューのテストスイート、
        テストケースを選択しましょう。</li>
	<li>右側のボックスはキーワードをアサインした
        各テストケースを参照できます。</li>
	<li>これらの選択は後でもっと大まかなレベルに
        ケースをアサインすることもできます。 </li>
</ol>

<h2>テスト計画の重要な情報に関してのキーワードのアサイン:</h2>
<p>キーワードのアサインの詳細はテスト計画のテストケース、
テスト計画に最新バージョンのテストケースが含まれていればそれが有効になり作成されます。
もし、そうでなく古いバージョンのテストケースがテスト計画に含まれている場合には、
アサインされたキーワードは、現時点では表示されません。
</p>
<p>
TestLinkはテスト計画の古いバージョンのテストケースは、最新バージョンのテストケースに対しておこなったキーワードのアサインによって影響を受けません。
もしテスト計画が更新されたテストケースを必要とするならば、はじめに「修正されたテストケースの更新」
機能をキーワードのアサインを行う前に使用し、対象のテストケースが最新であることを確かめてください。
</p>";


// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['executeTest']	= "テストケース実行";
$TLS_htmltext['executeTest'] 		= "<h2>目的:</h2>

<p>各テスト担当者がテストケース実行をおこなうことができます。
ユーザはテスト結果をビルドごとのテストケースに登録することができます。" .
         "フィルタ、設定(セッティング)についてのいろいろな情報についてはヘルプを参照してください。（「?」のアイコンをクリックしてください。）</p>

<h2>やってみましょう！</h2>

<ol>
    <li>テスト計画を実行するビルドを決定しなければなりません。</li>
    <li>プルダウンからビルドと、ナビゲーションシートの「更新」ボタンを選択してください。</li>
    <li>ツリーにあるテストケース名をクリックします。</li>
	<li>テスト結果および、備考、バグなどを登録します。</li>
	<li>結果を保存します。</li>
</ol>
<p><i>備考: GUI上から障害レポートを作成するためには、
バグ管理システムと連携するようにTestLinkを設定する必要があります。</i></p>";

// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['showMetrics']	= "テストレポートとメトリクスの概要";
$TLS_htmltext['showMetrics'] 		= "<p>レポートはテスト計画に関連しています。 " .
		"(上段のナビゲータにより選択します)。現在実行中のテスト計画以外のテスト計画を選択して
レポートを表示することもできます。以下のレポートフォーマットを選択することができます:</p>
<ul>
<li><b>Normal</b> - Webページにレポートを表示</li>
<li><b>MS Excel</b> - Microsoft Excel用にレポートをエクスポート</li>
<li><b>HTML email</b> - ユーザのアドレスにEメールでレポートを送信</li>
<li><b>グラフ</b> - グラフによるレポートを表示 (Flash技術を使用)</li>
</ul>

<p>「印刷」ボタンは1種類のレポートのみを印刷します。</p>
<p>数種類のレポートを選択することができます。いかに各レポートの機能を説明します。</p>

<h3>一般的なテスト計画のメトリクス</h3>
<p>このページでは、テストスイート、オーナー、キーワードごとのテスト計画の最新の
ステータスを表示します。「最新のテスト結果」とは、最後に実行したビルドに関するテストケースの結果を示しています。
例えば、複数のビルドにわたってあるテストケースを実行した場合は、最新の結果のみが反映されます。</p> 
	
<p>「最新のテスト結果」は多くのレポートで使用される概念で、以下のように決められます: </p>
<ul>
<li>テスト計画に追加された順番によって、ビルドの新旧が決まります。
ビルドの最新のビルドの結果は古いビルドの結果よりも優先されます。
例えば、ビルド1で「失敗」したテストケースでも、ビルド2で「成功」していれば、最新の結果は「成功」となります。</li>
<li>あるテストケースが同じビルド内で複数回実行された場合は、
最新の実行結果が優先されます。例えば、ビルド3のリリース後、テスター1よって午後2時に「成功」したテストケースでも、
テスター2によって午後3時に「失敗」と記録されれれば、最新の結果は「失敗」となります。</li>
<li>未実行のビルドがある場合は、そのテストケースの結果にはそのビルドは影響しません。
例えば、ビルド1で「成功」したテストケースが、テスト2で「未実行」だった場合は、
最新の結果は「成功」となります。</li>
</ul>
<p>以下の表が表示されます:</p>
<ul>
    <li><b>最上位のテストスイートごとの結果</b>
    各最上位スイートの結果が一覧表示されます。成功、失敗、ブロック、未実行のテストケースの合計、そして完了率を表示します。
    「完了した」テストケースとは、成功、失敗、ブロックの結果となったテストケースのことです。
    トップレベルスイートの結果には全ての子スイートの結果を含みます。</li>
    <li><b>キーワードごとの結果</b>
    現在のテスト計画のテストケースに割り当てられているキーワードを全て表示します。
    またそのキーワードに関連するテストケースを表示します。</li>
    <li><b>オーナーごとの結果</b>
    現在のテスト計画の中で、各オーナーに割り当てたれたテストの結果を一覧表示します。
    未アサインのテストケースは、「未アサイン」という見出しのもとに集計されます。</li> 
</ul>

<h3>総合的なビルドのステータス</h3>
<p>全ビルドの実行結果を一覧表示します。各ビルドのテストケースの合計数、成功数、成功率、失敗数、失敗率、ブロック数、ブロック率、未実行数、未実行率を表示します。
もし、同一ビルドでテストケースが複数回実行されている場合は、最新のテスト結果が考慮されます。</p>

<h3>クエリーのメトリクス</h3>
<p>このレポートはクエリー入力ページと、クエリーデータを含むクエリー出力ページから構成されます。
4種類のコントロールでクエリーを形成することができます。
デフォルトでは、最も多くのテストケースとビルドを選択するように各コントロールが設定されています。
コントロールを変更することにより、指定したオーナー、キーワード、テストスイート、
ビルドの組み合わせによって、レポートに表示される結果をフィルタリングすることができます。</p>

<ul>
<li><b>キーワード:</b> 0個または1個のキーワードを選択することができます。デフォルトでは、キーワードは選択されていません。キーワードが選択されていない場合は、キーワード割り当てに関係なく、全てのテストケースに関する結果を表示します。キーワードはテスト仕様のページもしくは、キーワード管理のページで割り当てることができます。キーワードは、全テスト計画の全バージョンのテストケースにわたって割り当てることができます。特定のキーワードが割り当てられているテストケースの結果に興味がある場合は、このコントロールにキーワードを設定してください。</li>
<li><b>オーナー:</b> 0人または1人のオーナーを選択することができます。デフォルトではオーナーは選択されていません。 オーナーが選択されていない場合は、オーナーの割り当てに関係なく、全てのテストケースに関する結果を表示します。「未割り当て」のテストケースは検索できません。オーナーシップは、「テスト実行の割り当て」のページで割り当てることができ、テスト計画ごとに割り当てられます。特定のテスターが実行したテストケースの結果に興味がある場合は、このコントロールにオーナーを設定してください。</li>
<li><b>トップレベルテストスイート:</b> 0個からn個のトップレベルテストスイートを選択することができます。デフォルトでは全てのテストスイートが選択されています。選択したテストスイートの結果のみが、クエリーのメトリクスに反映されます。特定のテストスイートの結果に興味がある場合は、このコントロールを操作してください。</li>
<li><b>ビルド:</b> 1個からn個のビルドを選択することができます。デフォルトでは全てのビルドが選択されています。選択したビルドでの実行結果のみを使用してメトリクスが計算されます。例えば、最後の3回のビルドで、いくつのテストケースを実行したかを調べたい場合は、このコントロールを操作してください。
キーワード、オーナー、トップレベルテストスイートを選択することで、テスト計画ごと、テストスイートごとのメトリクスの計算に使用するテストケースの数を変化させることができます。例えば、オーナー=「Greg」、キーワード=「優先度1」と全テストスイートを選択した場合は、Gregに割り当てられた優先度1のテストケースのみが計算に使用されます。レポートの「テストケース数」の合計は、これら3種類のコントロールによって決められます。
ビルドの選択は、「成功」、「失敗」、「ブロック」、「未実行」の数に影響します。先に説明した、「最新のテスト結果」のルールを参照してください。</li>
</ul>
<p>「クエリーを送信」ボタンをクリックすると、クエリー出力ページが表示されます。</p>

<p>クエリ出力ページ:</p>
<ol>
<li>レポートを作成するために使用したクエリーパラメータ</li>
<li>テスト計画内の合計</li>
<li>スイートごとの全実行結果の合計 (総テストケース数 / 成功 / 失敗 / ブロック / 未実行)。もし、あるテストケースを複数のビルドで複数回実行した場合、選択したビルドに関連する全ての実行結果を表示します。しかし、テストスイートの実行結果の概要には、選択したビルドに対する「最新のテスト結果」のみが反映されます。</li>
</ol>

<h3>ブロック、失敗、未実行のテストケースのレポート</h3>
<p>これらのレポートは、ブロック、失敗、未実行の全テストケースを表示します。「最新のテスト結果」のルール（一般的なテスト計画のメトリクスの項で説明しました）によって、テストケースがブロック、失敗、未実行に該当するかどうかを判定します。TestLinkとバグトラッキングシステムを統合して使用している場合は、ブロックと失敗のレポートに関連するバグが表示されます。</p>

<h3>テストレポート</h3>
<p>全ビルドの全テストケースのステータスを表示します。同一ビルド内でテストケースが複数回実行された場合は、最新の結果が表示されます。このレポートでは、「?」 マークを未実行のテストケースを表わすために使用します。大量のデータを使用している場合は、ブラウジングが簡単なExcel形式で出力することをお勧めします。</p>

<h3>グラフ</h3>
<p>4種類のチャートに表示される結果は、「最新のテスト結果」のルールに従って計算されます。グラフのアニメーションは、ユーザが現在のテスト計画のメトリクスを把握するための手助けとなるでしょう。
以下の4種類のチャートが表示されます:</p>
<ul>
<li>成功 / 失敗 / ブロック / 未実行のテストケースを表わす円グラフ</li>
<li>キーワードごとの結果を表わす棒グラフ</li>
<li>オーナーごとの結果を表わす棒グラフ</li>
<li>トップレベルスイートごとの結果を表わす棒グラフ</li>
</ul>
<p>棒グラフは、成功、失敗、ブロック、未実行のテストケース数を近似的に示しています。</p>
<p>このレポートページを表示するためにはFlashプラグインが必要です。グラフィカルに結果を表示するために http://www.maani.us が提供している Flash 技術を使用しています。</p>

<h3>各テストケースのバグの合計</h3>
<p>このレポートは、テストプロジェクト内のバグが発見されたテストケースを表示します。このレポートはバグトラキングシステムが接続されている場合のみ表示されます。</p>";


// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['planAddTC']	= "テスト計画へテストケースを追加/削除"; // testSetAdd
$TLS_htmltext['planAddTC'] 			= "<h2>目的:</h2>
<p>リーダー権限を持つユーザは、テストケースをテスト計画へ追加できます。</p>

<h2>テストケースの追加/削除:</h2>
<ol>
	<li>テストスイートをクリックし、全て、または1つのテストケースを表示します。</li>
	<li>あなたが追加を完了したい時、「テストケース追加/削除」ボタンをクリックし、テストケースをインポートして下さい。 
        注意：同じテストケースを複数回追加することは出来ません。</li>
</ol>";

// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['tc_exec_assignment']	= "テストケース実行ユーザのアサイン";
$TLS_htmltext['tc_exec_assignment'] 		= "<h2>目的:</h2>
<p>この機能により、各テストケースについて実行する責任を持つユーザを設定することができます。</p>

<h2>やってみましょう！</h2>
<ol>
	<li>テストケースもしくはテストスイートを選択します。</li>
	<li>対象のテスト担当者を選択します。</li>
	<li>アサインを確定するためにボタンをクリックします。</li>
	<li>実行ページでアサインの完了を確認します。フィルターをアサインした担当者にせっていしてみてください。</li>
</ol>";


// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['planUpdateTC']	= "テスト計画にアサインされたテストケースを更新する";
$TLS_htmltext['planUpdateTC'] 		= "<h2>目的</h2>
<p>このページでは、テスト仕様上で変更されたテストケースを最新バージョンに更新することができます。
テストの実行期間中に、テストケースのバージョンを明確にしたい場合は多くあるでしょう。" .
"例えば、あるテスト設計者がテスト仕様を変更したけれどもテスト計画には一通りのテスト完了後に反映させたい場合、" .
"もしくは、テスト実行はオリジナルバージョンで行ったけれども、結果は修正されたテストケースと共に参照したい場合などが考えられます。</p>

<h2>やってみましょう！</h2>
<ol>
	<li>テストケースもしくはテストスイートを選択します。</li>
	<li>対象のテストケースに対してプルダウンメニューから新たなバージョンを選択します。</li>
	<li>変更を確定するために「テスト計画を更新」ボタンをクリックします。</li>
	<li>実行ページのテストケースの文章を確認します。</li>
</ol>";


// ------------------------------------------------------------------------------------------
$TLS_htmltext_title['test_urgency']	= "テストに緊急度を設定する";
$TLS_htmltext['test_urgency'] 		= "<h2>目的</h2>
<p>TestLinkでは、テストケースの優先度に影響を与える「緊急度」をテストスイートに設定することができます。
		テストの優先度は各テストケースの作成時に設定する重要度とテスト計画で定義する重要度
		の両方から計算されます。テストリーダーは始めに実行すべきテストを指定すべきでしょう。
		これにより、時間に限りがある場合でも最重要なテストを網羅することができます。</p>

<h2>やってみましょう！</h2>
<ol>
	<li>ウィンドウ左のナビゲータから緊急性のあるプロダクト/コンポーネントに関する
	テストスイートを選択します。</li>
	<li>緊急度のレベルを選択します (高、中、低)。中がデフォルトです。
	例えば、あまり使用しない部分の優先度を下げたり、大きな変更が行われたコンポーネント
	の優先度を上げたりといったことが可能です。</li>
	<li>変更を確定するために「保存」ボタンをクリックしてください。</li>
</ol>
<p><i>一例として、テストケースに重要度「高」、テストスイートに緊急度「低」を設定すると " .
		"優先度は「中」になります。</i>";


// ------------------------------------------------------------------------------------------

?>