# Copyright (c) since 2005, GECAD Technologies
# For any feedback, please contact:
#   "AXIGEN Team" <team@axigen.com>

DESCRIPTION="Fast, reliable and secure internet messaging solution"
SRC_URI="${P}.i386.tar.gz"
HOMEPAGE="http://www.axigen.com/"
RESTRICT="nostrip nomirror nofetch"
LICENSE="as-is"
KEYWORDS="x86"
SLOT="0"
PROVIDE="
	virtual/mta
	virtual/mda
"
IUSE="mailwrapper"
RDEPEND="
	!mailwrapper? ( !virtual/mta )
	mailwrapper? ( >=net-mail/mailwrapper-0.2 )
"
	
inherit eutils

axigen_group_user() {
	enewgroup axigen 220 && \
	enewuser axigen 220 -1 -1 axigen -c "AXIGEN Mail Server system account"
}

pkg_setup() {
	axigen_group_user || die "Could not create axigen user/group"
	if has_version '<=mail-mta/axigen-1.1.1-r1' && [[ -f /var/lib/init.d/started/axigen ]]; then
		ewarn "It is recommended that, before the upgrade, to stop"
		ewarn "the AXIGEN server with:"
		ewarn "  /etc/init.d/axigen stop"
		ewarn "and after emerging this new version, to start it again:"
		ewarn "  /etc/init.d/axigen start"
		ewarn "Waiting 5 seconds before continuing (Press CTRL-C to stop)"
		epause 5
	fi
}

src_install() {
	cp --recursive ${WORKDIR}/* ${D}
	chown -R axigen:axigen ${D}/var/opt/axigen
	fowners axigen:axigen /opt/axigen/bin/sendmail
	diropts -m 755
	dodir /usr /usr/{sbin,lib}
	if useq mailwrapper; then
		dosym /opt/axigen/bin/sendmail /usr/sbin/sendmail.axigen
		dosym /usr/sbin/sendmail /usr/lib/sendmail.axigen
		MAILERCONF=/etc/mail/mailer.conf
		dodir /etc/mail
		echo "sendmail	/usr/sbin/sendmail.axigen" > ${D}${MAILERCONF}
		echo "send-mail	/usr/sbin/sendmail.axigen" >> ${D}${MAILERCONF}
	else
		dosym /opt/axigen/bin/sendmail /usr/sbin/sendmail
		dosym /usr/sbin/sendmail /usr/lib/sendmail
	fi
	echo "CONFIG_PROTECT=\"/var/opt/axigen/run\"" > ${T}/99axigen
	doenvd ${T}/99axigen
}

pkg_postinst() {
	chown -R axigen:axigen /var/opt/axigen/
	if ! has_version "<${PF}"; then # fresh install
		einfo "Thank you for installing AXIGEN Mail Server"
		if [ -x /opt/axigen/bin/axigen-cfg-wizard ]; then
			einfo
			einfo "In order to configure AXIGEN for the first time, please run:"
			einfo "  /opt/axigen/bin/axigen-cfg-wizard"
			einfo
		else
			einfo
			einfo "In order to configure AXIGEN for the first time, please read"
			einfo "the  \"Initial Setup\" section from the file:"
			einfo "  /opt/axigen/share/doc/README"
		fi
		einfo "In order to make AXIGEN start at boot time, issue:"
		einfo "  rc-update add axigen default"
		einfo
	fi
	ewarn "Note that the /opt/axigen/bin/sendmail binary does not"
	ewarn "have the SUID and GUID bits set, due to security reasons."
	ewarn "In order to be able to send e-mails using the sendmail"
	ewarn "command line utility, issue:"
	ewarn "  chmod 6750 /opt/axigen/bin/sendmail"
	ewarn "and then add the desired users in the \`axigen' group"
}

