#!/bin/sh
# This script prepares the installation environment in Gentoo,
#   so that you can install AXIGEN, using the emerge command

# Copyright (c) 2005, Gecad Technologies
# For any feedback, please contact:
# "AXIGEN Team" <team@axigen.com>

AXIVER="2.0.0_beta1"
AXIREV=""
AXIOVERLAY="/opt/axigen/portage-axigen"

. /sbin/functions.sh

die() {
  eerror "$1"
  exit 1
}

# verify if we are root; otherwise, exit
[ "$(id -u)" != "0" ] && \
die "Please run this script while logged in as root"

# verify if the ebuild is located in the same directory
[ ! -r "${PWD}/axigen-${AXIVER}${AXIREV}.ebuild" -o ! -r "${PWD}/axigen-${AXIVER}.i386.tar.gz" ] && \
die "Please run this script from the same directory where the ebuild and distfile file is located"

einfon "Grabbing your PORTDIR_OVERLAY setting..."
pdo="$(portageq portdir_overlay)"

pprefix="\n# Next line has been added automatically by AXIGEN\n"
if [ -z "${pdo}" ]; then
  echo " not set"
  echo -e "${pprefix}PORTDIR_OVERLAY=\"${AXIOVERLAY}\"" >> /etc/make.conf
  einfo "Added the following line in /etc/make.conf:"
  einfo "  PORTDIR_OVERLAY=\"${AXIOVERLAY}\""
else
  echo " \"${pdo}\""
  if [ -z "`grep \"${AXIOVERLAY}\" <<< \"${pdo}\"`" ]; then
    echo -e "${pprefix}PORTDIR_OVERLAY=\"\${PORTDIR_OVERLAY} ${AXIOVERLAY}\"" >> /etc/make.conf
    einfo "Added the following line in /etc/make.conf:"
    einfo "  PORTDIR_OVERLAY=\"\${PORTDIR_OVERLAY} ${AXIOVERLAY}\""
  else
    einfo "You already have the PORTDIR_OVERLAY variable from /etc/make.conf"
    einfo "  containing the \"${AXIOVERLAY}\" directory"
  fi
fi

[ -d "${AXIOVERLAY}/mail-mta/axigen" ] || mkdir -p ${AXIOVERLAY}/mail-mta/axigen

distdir="$(portageq distdir)"

# copy the ebuild in the mail-mta/axigen directory from the first Portage overlay
cp --force axigen-${AXIVER}${AXIREV}.ebuild ${AXIOVERLAY}/mail-mta/axigen
# copy the .tar.gz package
cp --force axigen-${AXIVER}.i386.tar.gz ${distdir}

echo
einfo "The following files/directories have been created (if non-existent):"
einfo "  ${AXIOVERLAY}/"
einfo "  ${AXIOVERLAY}/mail-mta/"
einfo "  ${AXIOVERLAY}/mail-mta/axigen/"
einfo "  ${AXIOVERLAY}/mail-mta/axigen/axigen-${AXIVER}${AXIREV}.ebuild"
einfo "  ${distdir}/axigen-${AXIVER}.i386.tar.gz"

# generate the digests/metadata
echo
einfo "Creating digests and metadata information"
ebuild ${AXIOVERLAY}/mail-mta/axigen/axigen-${AXIVER}${AXIREV}.ebuild digest || {
  ewarn
  ewarn "The digest command failed at some point."
  ewarn "This could happen because the file cannot be downloaded."
  ewarn "Please solve the problems (i.e. download the file manually)"
  ewarn "and then try again, by running the following command:"
  ewarn "ebuild ${AXIOVERLAY}/mail-mta/axigen/axigen-${AXIVER}.ebuild digest"
  ewarn
}
env-update
einfo "In order for the previously installed AXIGEN env.d file to be"
einfo "loaded, you should source again your /etc/profile file, with:"
einfo "  source /etc/profile"
einfo "Eventually, you can install axigen with"
einfo "  emerge axigen"

