/**
 * \file lib_info.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 01-08-2005
 *
 * Copyright &copy; 2006 AXIGEN GECAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - form validation / info / details
 */

/*******************************************************************************
 * Reset to defaults functions
 */

function resetField(formName, fieldName, fieldDefaults, fieldConfirm)
{
    eval ("var form = document.forms."+formName+";");
    eval ("var field = form."+fieldName+";");
    
    if (field && (!fieldConfirm || confirm("Reset field \""+fieldName+"\" to defaults?"))) {field.value = fieldDefaults;}
}

function resetAllFields(formName, options_array_name)
{
    eval ("var field_names = "+options_array_name);
    
    for (i in field_names) {
        var field_name = field_names[i];
        eval ("var field_default = "+field_name+"[4]");
        
        // Test for non-resetable field
        eval ("var not_resetable = " + field_name + "_not_resetable;");
        if (!not_resetable) {resetField(formName, field_name, field_default, false);}
    }
}

/*******************************************************************************
 * Toggle details view functions
 */

function showDetails(field_name)
{
    var fields = Array("desc", "minmax", "defaults", "note");
    var infos = Array("Description", "Min-Max", "Default", "Note");

    eval ("var field_array = "+field_name);
    var field_desc = field_array[0];
    var field_minmax = field_array[1];
    var field_defaults = field_array[2];
    var field_note = field_array[3];
    
    for (i in fields) {
        field = fields[i];
        info = infos[i];
        eval("text = field_"+field);
        
        var field_info = document.getElementById(field_name+"_"+field+"_info");
        var field_text = document.getElementById(field_name+"_"+field+"_text");
        
        if (field_info && field_text) {
            field_info.innerHTML = "<b>"+info+":</b>";
            field_text.innerHTML = text;
        }
    }
}

function hideDetails(field_name)
{
    var fields = Array("desc", "minmax", "defaults", "note");
    
    for (i in fields) {
        field = fields[i];
        
        var field_info = document.getElementById(field_name+"_"+field+"_info");
        var field_text = document.getElementById(field_name+"_"+field+"_text");
        
        if (field_info && field_text) {
            field_info.innerHTML = "";
            field_text.innerHTML = "";
        }
    }
}

function showDetailsForAll(options_array_name)
{
    eval ("var field_names = "+options_array_name);
    
    for (i in field_names) {
        showDetails(field_names[i]);
    }
}

function hideDetailsForAll(options_array_name)
{
    eval ("var field_names = "+options_array_name);
    
    for (i in field_names) {
        hideDetails(field_names[i]);
    }
}

function toggleDetailsForAll(options_array_name)
{
    eval ("var field_names = "+options_array_name);
    
    // Check if all expanded
    var allExpanded = true;
    for (i in field_names) {
        var field_name = document.getElementById(field_names[i] + "_desc_info");
        
        if (field_name && field_name.innerHTML == "") {
            allExpanded = false;
            break;
        }
    }
    
    // Collapse/Expand as necessary
    if (allExpanded) {
        hideDetailsForAll(options_array_name);
    } else {
        showDetailsForAll(options_array_name);
    }
}

function toggleDetails(field_name)
{
    var field_probe = document.getElementById(field_name + "_desc_info");
    if (field_probe && field_probe.innerHTML == "") {
        showDetails(field_name);
    } else {
        hideDetails(field_name);
    }
}

/*******************************************************************************
 * Function registration and call-back
 */

function registerFunction(function_name)
{
    if (!top.registeredFunctions) {
        top.registeredFunctions = new Array();
    }
    
    top.registeredFunctions[top.registeredFunctions.length] = function_name;
}

function callRegisteredFunctions()
{
    for (i in top.registeredFunctions) {
        eval(top.registeredFunctions[i] + "();");
    }
    
    // Clear array
    top.registeredFunctions = new Array();
}
