/**
 * \file lib_common.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 13-06-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - common definitions & classes
 *
 */

/*******************************************************************************
 * Global definitions - Tree
 */

var TREE_SPECIAL_FOLDERS = new Array("inbox", "sent", "drafts", "trash");

/*******************************************************************************
 * Global definitions - Manager
 */

var MANAGER_COUNT       = 0;

var MANAGER_MAIN        = MANAGER_COUNT++;
var MANAGER_TREE        = MANAGER_COUNT++;
var MANAGER_HEADER      = MANAGER_COUNT++;
var MANAGER_FOOTER      = MANAGER_COUNT++;
var MANAGER_MENUBAR     = MANAGER_COUNT++;

var ManagerNames = new Array();

ManagerNames[MANAGER_MAIN]      = "Manager - Main";
ManagerNames[MANAGER_TREE]      = "Manager - Tree";
ManagerNames[MANAGER_HEADER]    = "Manager - Header";
ManagerNames[MANAGER_FOOTER]    = "Manager - Footer";
ManagerNames[MANAGER_MENUBAR]   = "Manager - Menubar";

/*******************************************************************************
 * Global definitions - EventManager
 */

var EVENT_COUNT                 = 0;

var EVENT_NEW_DROPDOWN          = EVENT_COUNT++;
var EVENT_NEW_MESSAGE           = EVENT_COUNT++;
var EVENT_NEW_CONTACT           = EVENT_COUNT++;

var EVENT_REPLY_DROPDOWN        = EVENT_COUNT++;
var EVENT_REPLY                 = EVENT_COUNT++;
var EVENT_REPLY_ALL             = EVENT_COUNT++;

var EVENT_FORWARD_DROPDOWN      = EVENT_COUNT++;
var EVENT_FORWARD               = EVENT_COUNT++;
var EVENT_FORWARD_ATT           = EVENT_COUNT++;

var EVENT_SELECT_DROPDOWN       = EVENT_COUNT++;
var EVENT_SELECT                = EVENT_COUNT++;
var EVENT_SELECT_ALL            = EVENT_COUNT++;
var EVENT_SELECT_NONE           = EVENT_COUNT++;
var EVENT_SELECT_INVERT         = EVENT_COUNT++;

var EVENT_COPY_DROPDOWN         = EVENT_COUNT++;
var EVENT_COPY                  = EVENT_COUNT++;
var EVENT_MOVE                  = EVENT_COUNT++;

var EVENT_DELETE                = EVENT_COUNT++;

var EVENT_RESET                 = EVENT_COUNT++;

var EVENT_TREE                  = EVENT_COUNT++;
var EVENT_TREE_NAV              = EVENT_COUNT++;

var EVENT_MAIL_OPEN             = EVENT_COUNT++;
var EVENT_MAIL_SEND             = EVENT_COUNT++;
var EVENT_MAIL_CONTACTS         = EVENT_COUNT++;
var EVENT_MAIL_ATTACH           = EVENT_COUNT++;
var EVENT_MAIL_SAVE             = EVENT_COUNT++;

var EventNames = new Array();

EventNames[EVENT_NEW_DROPDOWN]     = "New dropdown";
EventNames[EVENT_NEW_MESSAGE]      = "Compose";
EventNames[EVENT_NEW_CONTACT]      = "Add contact";

EventNames[EVENT_REPLY]            = "Reply";
EventNames[EVENT_REPLY_ALL]        = "Reply to all";

EventNames[EVENT_FORWARD]          = "Forward as inline";
EventNames[EVENT_FORWARD_ATT]      = "Forward as attachment";

EventNames[EVENT_SELECT]           = "Select";
EventNames[EVENT_SELECT_ALL]       = "Select all";
EventNames[EVENT_SELECT_NONE]      = "Select none";
EventNames[EVENT_SELECT_INVERT]    = "Select invert";

EventNames[EVENT_COPY]             = "Copy";
EventNames[EVENT_MOVE]             = "Move";

EventNames[EVENT_DELETE]           = "Delete";

EventNames[EVENT_RESET]            = "Reset";

EventNames[EVENT_TREE]             = "Folder open";
EventNames[EVENT_TREE_NAV]         = "Folder operation";

EventNames[EVENT_MAIL_OPEN]        = "Mail open";
EventNames[EVENT_MAIL_SEND]        = "Mail send";
EventNames[EVENT_MAIL_CONTACTS]    = "Mail contacts";
EventNames[EVENT_MAIL_ATTACH]      = "Mail attach";
EventNames[EVENT_MAIL_SAVE]        = "Mail save";

/*******************************************************************************
 * ManagerLink class
 */

function getFrame(name) { return getManager()?getManager().getFrame(name):false; }

function getManager() { return getObject("manager"); }

function getDisplayManager() { return getObject("displayManager"); }

function getEventManager() { return getObject("eventManager"); }

/*******************************************************************************
 * Object manipulation functions
 */

function registerObject(obj, id)
{
    // Sanity
    if (!top.registeredObjects) { top.registeredObjects = new Array(); }

    obj.objectId = id;

    // Search for duplicates
    var objIdx = 0;
    for (objIdx = 0; objIdx < top.registeredObjects.length; ++objIdx) {
        if (top.registeredObjects[objIdx] &&
            top.registeredObjects[objIdx].objectId == id) { break; }
    }

    // Register
    top.registeredObjects[objIdx] = obj;
}

function unregisterObject(id)
{
    // Sanity
    if (!top.registeredObjects) { return false; }

    // Search for duplicates
    for (var objIdx = 0; objIdx < top.registeredObjects.length; ++objIdx) {
        if (top.registeredObjects[objIdx] &&
            top.registeredObjects[objIdx].objectId == id)
        {
            top.registeredObjects[objIdx] = null;
            break;
        }
    }
}

function getObject(id)
{
    var ret = _getObject(id, top);

    if (!ret && top.isPopup && top.parentWindow) {
        ret = _getObject(id, top.parentWindow);
    }

    return ret;
}

function _getObject(id, scope)
{
    if (!scope.registeredObjects) { return false; }

    var idx;
    for (idx = 0; idx < scope.registeredObjects.length && scope.registeredObjects[idx].objectId != id;
        ++idx);

    return idx < scope.registeredObjects.length?scope.registeredObjects[idx]:false;
}

function in_array(needle, haystack)
{
    for (var i = 0; i < haystack.length; ++i) {
        if (haystack[i] == needle) { return true; }
    }
    
    return false;
}

/*******************************************************************************
 * Global display functions
 */

function validateForm(name)
{
    var form = eval("document.forms." + name);
    
    if (!form) { return false; }
    
    if (!constraints.length) { return true; }

    var errors = new Array();
    var error_msg = getObject("dictionary").getAlert("settings_errors") + ":\n";

    // Constraint testing
    for (var i = 0; i < constraints.length; ++i) {
        var constraint = constraints[i];
        
        switch(constraint.type) {
            case "eq": {
                    var field1 = eval("form." + constraint.name);
                    var field2 = eval("form." + constraint.eq_name);

                    if (field1.value != field2.value) {
                        errors[errors.length] = field1;
                        errors[errors.length] = field2;

                        error_msg += "  * " + field1.name + ", " + field2.name +
                            " " + getObject("dictionary").getAlert("settings_mismatch")
                            + "!";
                    }
                } break;

            case "!empty": {
                    var field = eval("form." + constraint.name);

                    if (field.value == "") {
                        errors[errors.length] = field;

                        error_msg += "  * " + field.name +
                            " field is empty!";
                    }
                } break;
        }
    }

    if (!errors.length) { return true; }

    // Error display
    for (var i = 0; i < errors.length; ++i) {
        if (-1 == errors[i].className.indexOf("_error")) {
            errors[i].className += "_error";
        }

        var text = errors[i].parentNode.previousSibling;
        while(text.nodeName != "TD") { text = text.previousSibling; }
        
        if (-1 == text.className.indexOf("_error")) {
            text.className += "_error";
        }
    }

    alert(error_msg);

    return false;
}

function formAddField(name)
{
    // Container setup
    var container = document.getElementById(name + "_container");
    
    if (!container || arguments.length < 2) { return false; }

    var tbody = document.createElement("tbody");

    var tr = document.createElement("tr");

    // Fields
    for (var i = 1; i < arguments.length; ++i) {
        var fieldName = arguments[i];

        var td = document.createElement("td");
        td.className = "option_value_input";
        td.style.textAlign = "center";
      
        var input = document.createElement("input");
        input.type = "text";
        input.className = "option_value";
        input.name = name + "_" + fieldName + "[]";
        
        eval("var field_i18n = getObject('dictionary').get('attribute_" +
            fieldName + "')");
        if (field_i18n) { td.innerHTML = field_i18n + ":"; }
		else { td.innerHTML = fieldName + ":"; }

        td.appendChild(input);

        tr.appendChild(td);
    }

    // Delete
    var td = document.createElement("td");
    td.className = "option_value_input";
    td.style.textAlign = "center";
  
    var a = document.createElement("a");
    a.href = "#";
    a.innerHTML = getObject("dictionary").get("contact_delete");
    
    a.onclick = function()
    {
        formRemoveField(this);
    }
    
    td.appendChild(document.createTextNode("["));
    td.appendChild(a);
    td.appendChild(document.createTextNode("]"));

    tr.appendChild(td);

    tbody.appendChild(tr);

    container.appendChild(tbody);
}

function formRemoveField(obj)
{
    var tr = obj.parentNode.parentNode;
    tr.parentNode.removeChild(tr);
}

function mailAttOpen(att)
{
    var fid = getObject("mailList").fid;
    var mid = getObject("mailHeader").mail.mid;

    if (att.type == "image") {
        getFrame("frame_mail_body").document.location.href = "?_h=" +
            getManager().sessionId + "&page=mail_view_att" +
            "&fid=" + fid + "&mid=" + mid + "&attid=" + att.attid +
            "&download=no";
    } else {
        window.open("?_h=" +
            getManager().sessionId + "&page=mail_att" +
            "&fid=" + fid + "&mid=" + mid + "&attid=" + att.attid +
            "&download=yes");
    }
}

function attPreview(id, size)
{
    var image = document.getElementById(id);
    
    if (!image) { return false; }

    var imageWidth = image.width;
    var imageHeight = image.height;

    if (imageHeight > size) {
        image.height = size;
    }
    
    image.origWidth = imageWidth;
    image.origHeight = imageHeight;
    image.onclick = function()
    {
        if (this.height < this.origHeight) {
            this.height = this.origHeight;
        } else {
            this.height = size;
        }
    }
    
    if (image.style.setAttribute) {
        image.style.setAttribute("visibility", "visible");
    } else {
        image.style.visibility = "visible";
    }
}

function mailSearch(form_name)
{
    eval("var form = document.forms." + form_name);
    
    if (!form || !getObject("mailList")) { return false; }

    var fid = getObject("mailList").fid;
    var action = "?_h=" + getManager().sessionId + "&page=mail_list_content&action=search";
    var search = form.search.value;

    // Test for empty search string
    if (search.replace(/ /g, "") == "" ||
        search == getObject("dictionary").getAlert("search_default"))
    { return false; }
    
    action += "&fid=" + fid + "&match=any" +
        "&subject=" + search + "&from=" + search;
        
    form.setAttribute("action", action);
    
    return true;
}

function mouseover(obj, id)
{
    obj.className = "dropdown_hover";
}

function mouseout(obj, id)
{
    obj.className = "dropdown";
}

/*******************************************************************************
 * Syncronization functions
 */

function ENTER_CS()
{
    if (!top.CS || top.CS != "locked") {
        top.CS = "locked";
        
        return true;
    }

    return false;
}

function LEAVE_CS() { top.CS = false; }
