/**
 * \file lib_composer.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 07-09-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - composer library
 *
 */

/*******************************************************************************
 * MailComposer class
 */

function MailComposer(webmailData)
{
    registerObject(this, "mailComposer");

    this.started = false;
    
    this.data = webmailData;
    this.attCount = 0;
}

/*******************************************************************************
 * Setup current mail composer
 */

MailComposer.prototype.start = function()
{
    if (this.started) { return; }

    this.started = true;
}

/*******************************************************************************
 * Draw composer
 */

MailComposer.prototype.draw = function(headers_container)
{
    // Initialize containers
//    var headers_container = document.createElement("div");
//    headers_container.className = "headers_container";

    var to_i18n = "To";
    var cc_i18n = "Cc";
    var bcc_i18n = "Bcc";
    var subject_i18n = "Subject";

    if (getObject("dictionary")) {
        to_i18n = getObject("dictionary").get("mail_view_to");
        cc_i18n = getObject("dictionary").get("mail_view_cc");
        bcc_i18n = getObject("dictionary").get("mail_view_bcc");
        subject_i18n = getObject("dictionary").get("mail_view_subject");
    }

    // To header
    this.drawHeader("To", to_i18n, headers_container);
    this.drawHeader("Cc", cc_i18n, headers_container);
    this.drawHeader("Bcc", bcc_i18n, headers_container);

    this.drawHeader("Subject", subject_i18n, headers_container);

//    this.drawHeader("fileName", "Attachment", att_container, "file expand form");

//    container.appendChild(headers_container);
}

MailComposer.prototype.drawAtt = function(att_container)
{
    // IE test
    if (document.all) {
        att_container.innerHTML = 
            "<form name='form_composer_att_1' " +
            "method='POST' enctype='multipart/form-data' " +
            "target='frame_mail_att' " + "action='?_h=" + getManager().sessionId +
            "&page=mail_view_att&action=attach&ref=" + this.attCount +"' class='header_container'>" +

                "<div class='header_title'>Attachment</div>" +
                "<div class='header_field'>" +
                    "<input type='file' name='fileName' class='header_field'>" +
                "</div>" +

                "<a href='#' onclick='form_composer_att_1.submit()' class='header_upload'>Upload</a>" +

            "</form>";
 
        return;
    }

    this.drawHeader("fileName", "Attachment", att_container, "file form");
}

/*******************************************************************************
 * Update composer - for replies / forwards
 */

MailComposer.prototype.update = function(data)
{
    var form = document.forms.form_composer_headers;

    var To = form.To;
    var Cc = form.Cc;
    var Bcc = form.Bcc;
    var Subject = form.Subject;

    // IE test
    if (document.all) {
        for (var i = 0; i < form.elements.length; ++i) {
            var elem = form.elements[i];
            
            eval(elem.name + " = elem");
        }
    }

    var to = data.to.replace("&lt;", "<").replace("&gt;", ">");
    var cc = data.cc.replace("&lt;", "<").replace("&gt;", ">");
    var bcc = data.bcc.replace("&lt;", "<").replace("&gt;", ">");

    var replyto = data.replyto.replace("&lt;", "<").replace("&gt;", ">");
    var replytoall = data.replytoall.replace("&lt;", "<").replace("&gt;", ">");

    var subject = data.subject.replace("&lt;", "<").replace("&gt;", ">");

    switch(data.action) {
        case "edit": {
            To.value = to;
            Cc.value = cc;

            Subject.value = subject;
            } break;

        case "reply": {
            To.value = replyto;

            Subject.value = "Re: " + subject;
            } break;

        case "reply_all": {
            To.value = replyto;
            Cc.value = replytoall;

            Subject.value = "Re: " + subject;
            } break;

        case "forward": {
            Subject.value = "[Fwd: " + subject + "]";
            } break;

        default:
            Subject.value = subject;
    }

    Bcc.value = bcc;
}

MailComposer.prototype.updateAtt = function(form_id)
{
    eval("var form = document.forms.form_composer_att_" + form_id);
    eval("var status = document.forms.status_container_" + form_id);

    // IE
    if (document.all) {
        var obj = document.getElementById("composer_att");
        obj.innerHTML = "";
        
        return;

        for (var j = 0; j < document.forms.length; ++j) {
            form = document.forms[j];
            if (form.name == "form_composer_att_" + form_id) {
                break;
            }
        }

        for (var j = 0; j < document.forms.length; ++j) {
            status = document.forms[j];
            if (status.name == "form_status_container_" + form_id) {
                break;
            }
        }       
    }
    
    form.parentNode.removeChild(form);

    --getObject("mailComposer").attCount;
}

/*******************************************************************************
 * Draw field
 */

MailComposer.prototype.drawHeader = function(name, title, container, smodifiers, refNode)
{
    // Setting modifiers
    var field_form = false;
    var field_type = "text";
    var field_child = false;
    var field_expand = false;
    var modifiers = smodifiers?smodifiers.split(" "):new Array();
    for (var i = 0; i < modifiers.length; ++i) {
        var modifier = modifiers[i];

        switch (modifier) {
            case "file": {
                field_type = "file";
                } break;

            case "form": {
                field_form = true;
                } break;

            case "child": {
                field_child = true;
                } break;

            case "expand": {
                field_expand = true;
                } break;
        }
    }

    // Initialize containers
    var header_container;
    if (field_form) {
        ++this.attCount;

        header_container = document.createElement("form");
        header_container.className = "header_container";

        header_container.setAttribute("name", "form_composer_att_" + this.attCount);
        header_container.setAttribute("action", "?_h=" + getManager().sessionId +
            "&page=mail_view_att&action=attach&ref=" + this.attCount);
        header_container.setAttribute("target", "frame_mail_att");
        header_container.setAttribute("method", "POST");
        header_container.setAttribute("enctype", "multipart/form-data");
        
    } else {
        header_container = document.createElement("div");
        header_container.className = "header_container";
    }

    var title_container = document.createElement("div");
    title_container.className = "header_title";
    title_container.innerHTML = title;    

    // Field section
    var field_container = document.createElement("div");
    field_container.className = "header_field";

    var field = document.createElement("input");
    field.className = "header_field";
    field.type = field_type;
    field.name = name;

    field_container.appendChild(field);
    
    header_container.appendChild(title_container);
    header_container.appendChild(field_container);

    // Status section
    if (field_type == "file") {
        var status_container = document.createElement("div");
        status_container.id = "status_container_" + this.attCount;
        status_container.className = "header_status_container";

        var upload_container = document.createElement("a");
        upload_container.className = "header_upload";
        upload_container.href = "#";
        upload_container.innerHTML = "Upload";
        upload_container.onclick = function()
        {
            getManager().registerEvent(EVENT_MAIL_ATTACH, this);
        }

        header_container.appendChild(upload_container);
    }

    // Expand section
    if (field_expand) {
        var expand_container = document.createElement("div");
        expand_container.className = "header_expand_container";
    
        expand_container.name = name;
        expand_container.title = title;
        expand_container.container = container;
        expand_container.smodifiers = smodifiers?smodifiers.replace("expand", ""):"";
        expand_container.refNode = header_container;
        expand_container.linkElement = this;
    
        expand_container.onmouseover = function()
        {
            this.className += "_hover";
        }
    
        expand_container.onmouseout = function()
        {
            this.className = this.className.replace("_hover", "");
        }
    
        expand_container.onclick = function()
        {
            this.linkElement.drawHeader(this.name, this.title, this.container,
                this.smodifiers);
        }
    
        var expand = document.createElement("button");
        expand.className = "header_expand";
    
        expand_container.appendChild(expand);
    
        header_container.appendChild(expand_container);
    
    }

    // Populate container
    if (field_child) {
        container.insertBefore(header_container, refNode.nextSibling);
    } else {
        container.appendChild(header_container);
    }
    
    return header_container;
}

/*******************************************************************************
 * Send mail event
 */

MailComposer.prototype.sendMail = function()
{
    var eventInfo = getEventManager().getEventInfo();

    var eventId = eventInfo[0];
    var callerId = eventInfo[1];

    var form_body = document.forms.form_composer;
    var form_headers = document.forms.form_composer_headers;

    if (!form_body || !form_headers) { return false; }

    var To = form_headers.To;
    var Cc = form_headers.Cc;
    var Bcc = form_headers.Bcc;
    var Subject = form_headers.Subject;

    // IE test
    if (document.all) {
        for (var i = 0; i < form_headers.elements.length; ++i) {
            var elem = form_headers.elements[i];

            if (elem.name == "To" || elem.name == "Cc" ||
                elem.name == "Bcc" || elem.name == "Subject")
            {
                eval(elem.name + " = elem");
            }
        }
    }

    // Field validations
    if (To.value == "" && Cc.value == "" && Bcc.value == "") {
        alert(getObject("dictionary").getAlert("mail_empty_rcpts"));
        
        return false;
    }

    if (Subject.value == "") {
        if (!confirm(getObject("dictionary").getAlert("mail_empty_subject"))) {
            return false;
        }
    }

    var form_att = document.forms.form_composer_att_1;
    var fileName = form_att?form_att.fileName:null;

    if (fileName && fileName.value != "") {
        if (!confirm(getObject("dictionary").getAlert("mail_unsent_atts")))
        {
            return false;
        }
    }

    if (!ENTER_CS()) { return false; }

    // Test for settings page
    if (!getManager().getFrame("frame_mail_list")) {
        form_body.target = "frame_main";
        form_body.setAttribute("action", getManager().getFrame("frame_main").
            document.location.href + "&action=compose");
    }

    // Event handling
    switch (eventId) {
        case EVENT_MAIL_SEND: {
            var action = form_body.getAttribute("action");

            form_body.setAttribute("action",  action + "&op=send" +
                "&fid=" + getObject("mailList").fid);

            // To field
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "To";
            input.value = To.value;
            
            form_body.appendChild(input);

            // Cc field
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "Cc";
            input.value = Cc.value;
            
            form_body.appendChild(input);

            // Bcc field
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "Bcc";
            input.value = Bcc.value;
            
            form_body.appendChild(input);

            // Subject field
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "Subject";
            input.value = Subject.value;
            
            form_body.appendChild(input);
           
            form_body.submit();
            } break;

        case EVENT_MAIL_SAVE: {
            var action = form_body.getAttribute("action");

            form_body.setAttribute("action",  action + "&op=save" +
                "&fid=" + getObject("mailList").fid);

            // To field
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "To";
            input.value = To.value;
            
            form_body.appendChild(input);

            // Cc field
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "Cc";
            input.value = Cc.value;
            
            form_body.appendChild(input);

            // Bcc field
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "Bcc";
            input.value = Bcc.value;
            
            form_body.appendChild(input);

            // Subject field
            var input = document.createElement("input");
            input.type = "hidden";
            input.name = "Subject";
            input.value = Subject.value;
            
            form_body.appendChild(input);
           
            form_body.submit();
            } break;
    }
}

MailComposer.prototype.attachFiles = function()
{
    var eventInfo = getEventManager().getEventInfo();

    var eventId = eventInfo[0];
    var callerId = eventInfo[1];

    var mailComposer = getObject("mailComposer");

    switch (eventId) {
        case EVENT_MAIL_ATTACH: {
            if (!mailComposer.attCount) {
                mailComposer.drawAtt(document.getElementById("composer_att"));
                break;
            }
            for (var i = 1; i <= mailComposer.attCount; ++i) {
                eval("var form = document.forms.form_composer_att_" + i);

                // IE test
                if (document.all) {
                    for (var j = 0; j < document.forms.length; ++j) {
                        form = document.forms[j];
                        if (form.name == "form_composer_att_" + i) {
                            break;
                        }
                    }
                }
    
                var fileName = form.fileName;

                // IE test
                if (document.all) {
                    for (var i = 0; i < form.elements.length; ++i) {
                        var elem = form.elements[i];
                        
                        eval(elem.name + " = elem");
                    }
                }
                
                if (fileName.value != "") { form.submit(); }
            }
            } break;
    }
}
