/**
 * \file lib_contacts.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 11-09-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - contacts library
 *
 */

/*******************************************************************************
 * ContactList class
 */

function ContactList(contacts)
{
    registerObject(this, "contactList");

    this.started = false;
    
    this.contacts = contacts;
    this.search = "";
    this.displayed = false;
}

/*******************************************************************************
 * Setup current mail composer
 */

ContactList.prototype.start = function()
{
    if (this.started) { return; }

    this.started = true;
}

/*******************************************************************************
 * Attach contacts
 */

ContactList.prototype.attach = function(obj)
{
    obj.isActive = false;
    obj.ContactList = this;
  
    obj.onfocus = function()
    {
        this.isBlured = false;
    }

    obj.onblur = function()
    {
        this.isBlured = true;

        if (this.isActive && this.nextSibling.isBlured) {
            this.parentNode.removeChild(this.nextSibling);

            this.isActive = false;
        }
    }
  
    obj.onkeyup = function(e)
    {
        var MAX_RESULT_COUNT = 3;

        if (!e) var e = window.event;

        // Test for navigation keys
        if (e.keyCode == 38 && this.isActive) {
            if (this.nextSibling.selectedIndex > 0) {
                --this.nextSibling.selectedIndex;
            }
            return;
        }

        if (e.keyCode == 40 && this.isActive) {
            if (this.nextSibling.selectedIndex < (this.nextSibling.options.length - 1)) {
                ++this.nextSibling.selectedIndex;
            }
            return;
        }

        if (e.keyCode == 13 && this.isActive) {
            this.value = this.nextSibling.value;

            this.parentNode.removeChild(this.nextSibling);

            this.isActive = false;

            return;
        }

        // Dialog setup / cleanup
        if (this.isActive) {
            obj.parentNode.removeChild(obj.nextSibling);

            this.isActive = false;                 
        }

        if (this.value == "") { return false; }
        
        // Dropdown setup
        var container = document.createElement("select");
        container.id = "autocomplete";

        container.style.width = "50%";

        container.style.border = "1px solid #999999";
        container.style.background = "#EEEEEE";

        container.linkElement = this;
        container.onfocus = function()
        {
            this.isBlured = false;
        }
        
        container.onblur = function()
        {
            this.isBlured = true;

            if (this.linkElement.isActive && this.linkElement.isBlured) {
                this.parentNode.removeChild(this);
    
                this.linkElement.isActive = false;
            }
        }
        
        container.onkeyup = function(e)
        {
            if (!e) var e = window.event;
            
            if (e.keyCode == 8 || e.keyCode == 27) {
                this.linkElement.focus();

                this.linkElement.isActive = false;
    
                this.parentNode.removeChild(this);
            }

            if (e.keyCode == 13) {
                this.linkElement.value = this.value;

                this.linkElement.isActive = false;
    
                this.parentNode.removeChild(this);
                
                return;
            }           
        }

        container.ondblclick = function()
        {
            this.linkElement.value = this.value;

            this.linkElement.isActive = false;

            this.parentNode.removeChild(this);

            return;
        }

//        container.style.position = "relative";
//        container.style.top = "16px";
              
        // Populate control with search results
        var results = getObject("contactList").get(this.value);
        
        for (var i = 0; i < results.length; ++i) {
            var option = document.createElement("option");
            option.value = results[i].email;
            option.innerHTML = results[i].email;
            
            container.appendChild(option);
        }

        // Check results
        if (!results.length) { return false; }

        container.multiple = MAX_RESULT_COUNT;

        if (results.length < MAX_RESULT_COUNT) {
            container.style.height = results.length + 1 +  "em";
        }

        obj.parentNode.insertBefore(container, obj.nextSibling);
        
        this.isActive = true;
    }
}

/*******************************************************************************
 * Draw contacts
 */

ContactList.prototype.toggleContacts = function()
{
    var form = document.forms.form_composer_headers;
    var contactList = getObject("contactList");
    
    if (!form || !contactList) { return false; }

    if (contactList.displayed) {
        contactList.displayed = false;

        form.removeChild(form.firstChild);
        
        return true;
    }
    
    contactList.displayed = true;
    
    // Containers
    var header_container = document.createElement("div");
    header_container.className = "header_container";

    var title_container = document.createElement("div");
    title_container.className = "header_title";
    title_container.innerHTML = "Contacts";    

    // Field section
    var field_container = document.createElement("div");
    field_container.className = "header_field";

    var select = document.createElement("select");
    select.className = "header_field";
    select.name = "contacts";

    for (var i = 0; i < contactList.contacts.length; ++i) {
        var option = document.createElement("option");
        option.value = contactList.contacts[i].email;
        option.innerHTML = contactList.contacts[i].email;
        
        select.appendChild(option);
    }

    field_container.appendChild(select);

    // Action section
    var expand_container = document.createElement("div");
    expand_container.className = "header_expand_container";

    expand_container.linkForm = form;
    expand_container.linkSelect = select;
    expand_container.onmouseover = function()
    {
        this.className += "_hover";
    }

    expand_container.onmouseout = function()
    {
        this.className = this.className.replace("_hover", "");
    }

    expand_container.onclick = function()
    {
        var form = this.linkForm;
        var select = this.linkSelect;
        
        var To = form.To;
        var Cc = form.Cc;
        
        // IE test
        if (document.all) {
            for (var i = 0; i < form.elements.length; ++i) {
                var elem = form.elements[i];

                if (elem.name == "To" || elem.name == "Cc") {
                    eval(elem.name + " = elem;");
                }
            }
        }
       
        if (To.value == "") {
            To.value = select.value;
    
            return false;
        } 

        if (Cc.value == "") {
            Cc.value = select.value;
        } else {
            Cc.value += "; " + select.value;
        }

        return false;
    }

    var expand = document.createElement("button");
    expand.className = "header_expand";

    expand_container.appendChild(expand);
    
    header_container.appendChild(title_container);
    header_container.appendChild(field_container);
    header_container.appendChild(expand_container);
    
    form.insertBefore(header_container, form.firstChild);
    
    return true;
}

/*******************************************************************************
 * Retrieve pattern
 */

ContactList.prototype.match = function(needle, subject)
{
    if (subject.substring(0, needle.length).toLowerCase() == needle.toLowerCase())
    {
        return true;
    }
}

/*******************************************************************************
 * Retrieve pattern
 */

ContactList.prototype.get = function(name)
{
    var results = new Array();
    for (var i = 0; i < this.contacts.length; ++i) {
        var contact = this.contacts[i];

        if (this.match(name, contact.name) ||
            this.match(name, contact.email))
        {
            results[results.length] = contact;
        }
    }

    return results;
}
