/**
 * \file lib_displaymgr.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 28-07-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - Display manager library
 *
 */

/*******************************************************************************
 * DisplayManager setup
 */

function DisplayManager()
{
    registerObject(this, "displayManager");
}

DisplayManager.prototype.start = function() {}

DisplayManager.prototype.popup = function(obj)
{
    // Popup cleaner
    if (top.popup) { top.popup.close(); top.popup = null; }

    var specs = "directories=no" +
        ",location=no" +
        ",menubar=no" +
        ",resizable=no" +
        ",status=no" +
        ",toolbar=no";

    if (obj.width) { specs += ",width=" + obj.width; }
    if (obj.height) { specs += ",height=" + obj.height; }

    if (obj.top) { specs += ",top=" + obj.top; }
    if (obj.left) { specs += ",left=" + obj.left; }

    var handler = window.open(obj.url, obj.name, specs);

    handler.top.isPopup = true;
    handler.top.parentWindow = top;

    return handler;
}

DisplayManager.prototype.notify = function()
{
    var eventInfo = getEventManager().getEventInfo();

    var eventId = eventInfo[0];
    var callerId = eventInfo[1];

    alert("Event info:\n" +
        "* Current frame context: " + callerId + "\n" +
        "* Event processed: " + EventNames[eventId]);
}

DisplayManager.prototype.addRollOver = function(obj)
{
    obj.onmouseover = function()
    {
        this.className += "_hover";
    }
    
    obj.onmouseout = function()
    {
        var idx = this.className.indexOf("_hover");
        if (idx >= 0) { this.className = this.className.substring(0, idx); }
    }

    if (arguments.length < 2) { return false; }

    if (typeof(arguments[1]) == 'string') {
        obj.objUrl = arguments[1];
        obj.onclick = function()
        {
            getManager().openPage(this.objUrl);
        }
    } else {
        obj.objEvent = arguments[1];
        obj.onclick = function()
        {
            getManager().registerEvent(this.objEvent, this);
        }
    }

    if (arguments.length < 3 || arguments[2] != "cancel_bubble") { return false; }

    if (typeof(arguments[1]) == 'string') {
        obj.objUrl = arguments[1];
        obj.onclick = function(e)
        {
            if (!e) var e = window.event;
            e.cancelBubble = true;
            if (e.stopPropagation) e.stopPropagation();

            getManager().openPage(this.objUrl);
        }
    } else {
        obj.objEvent = arguments[1];
        obj.onclick = function(e)
        {
            if (!e) var e = window.event;
            e.cancelBubble = true;
            if (e.stopPropagation) e.stopPropagation();

            getManager().registerEvent(this.objEvent, this);
        }
    }
}

/*******************************************************************************
 * Tab setup
 */

function TabBar()
{
    registerObject(this, "tabbar");

    this.tabs = null;
    this.currentTab = null;

    if (arguments.length % 2) { return false; }

    this.tabs = new Array();

    for (var i = 0; i < arguments.length; i += 2) {
        var tab = new Object();
        tab.name = arguments[i];
        tab.url = "settings" + "&tab=" + arguments[i + 1];
        tab.link = arguments[i + 1];
        
        this.tabs[this.tabs.length] = tab;
    }
}

TabBar.prototype.start = function() {}

TabBar.prototype.setCurrent = function(tab) { this.currentTab = tab; }

TabBar.prototype.draw = function()
{
    var body;
    if (arguments.length > 0 && typeof(arguments[0]) == 'string') {
        body = document.getElementById(arguments[0]);
    } else {
        body = document.getElementsByTagName("body").item(0);
    }

    if (!body) { return false; }

    var container = document.createElement("div");
    container.className = "tab_container";

    for (var i = 0; i < this.tabs.length; ++i) {
        this.drawTab(i, container);
    }
    
    body.appendChild(container);
}

TabBar.prototype.drawTab = function(tabIdx, container)
{
    var tab = this.tabs[tabIdx];

    var tabElement = document.createElement("div");
    tabElement.className = "tab_element" + (this.currentTab == tab.link?"_active":"");

    tabElement.onmouseover = function()
    {
        this.className += "_hover";
    }
    
    tabElement.onmouseout = function()
    {
        var idx = this.className.indexOf("_hover");
        if (idx >= 0) { this.className = this.className.substring(0, idx); }
    }

    tabElement.onclick = function()
    {
        getManager().openPage(this.tabURL);
    }

    var tabData = document.createElement("button");
    tabData.className = "tab_data" + (this.currentTab == tab.link?"_active":"");
    tabData.innerHTML = tab.name;    

    tabData.onmouseover = function()
    {
        this.className += "_hover";
    }
    
    tabData.onmouseout = function()
    {
        var idx = this.className.indexOf("_hover");
        if (idx >= 0) { this.className = this.className.substring(0, idx); }
    }

    tabData.tabURL = tab.url;
    tabElement.tabURL = tab.url;

    tabElement.appendChild(tabData);

    container.appendChild(tabElement);
}
