/**
 * \file lib_eventmgr.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 14-06-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - Event manager
 *
 */

/*******************************************************************************
 * Event manager class
 */

function EventManager()
{
    registerObject(this, "eventManager");

    this.started = false;

    this.handlers = new Array();

    this.eventStack = new Array();
    this.callerStack = new Array();
}

EventManager.prototype.start = function()
{
    if (this.started) { return; }

    this.started = true;
}

EventManager.prototype.notify = function(eventId, callerId)
{
//    var mgr = getManager().managers[callerId];

//    alert("Event info:\n" +
//        "* Current manager context: " + ManagerNames[mgr.managerId] + "\n" +
//        "* Current frame context: " + callerId + "\n" +
//        "* Event processed: " + EventNames[eventId]);

    this.setEventInfo(eventId, callerId);

    if (this.handlers[eventId]) {
        if (typeof(this.handlers[eventId]) == 'function') {
            this.handlers[eventId]();
        }

        if (typeof(this.handlers[eventId]) == 'object') {
            if (this.handlers[eventId].notify) {
                this.handlers[eventId].notify();
            } else {
                // IE
                this.handlers[eventId]();
            }
        }
    }
}

EventManager.prototype.setEventInfo = function(eventId, callerId)
{
    this.eventStack[this.eventStack.length] = eventId;
    this.callerStack[this.callerStack.length] = callerId;
}

EventManager.prototype.getEventInfo = function()
{
    var eventId = this.eventStack[this.eventStack.length - 1];
    var callerId = this.callerStack[this.callerStack.length - 1];
    
    --this.eventStack.length;
    --this.callerStack.length;

    return new Array(eventId, callerId);
}

EventManager.prototype.registerCallback = function(eventId, callback)
{
    this.handlers[eventId] = callback;
}

EventManager.prototype.unregisterCallback = function(eventId)
{
    this.handlers[eventId] = function() {};
}
