/**
 * \file lib_mail.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 25-08-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - Mail library
 *
 */

/*******************************************************************************
 * MailList setup
 */

function MailList(mails)
{
    registerObject(this, "mailList");

    this.started = false;

    this.fid = null;
    this.sortType = null;
    this.sortOrder = null;

    this.mails = mails;
    this.selectedMails = new Array();
    this.selectedLast = -1;
    
    this.headers = new Array("idx", "flagged", "att", "subject", "from", "date");
    this.sizes = new Array("4%", "3%", "3%", "40%", "30%", "20%");
    
    this.activeHeader = this.headers[3];
}

MailList.prototype.start = function()
{
    if (this.started) { return false; }

    this.started = true;
}

MailList.prototype.draw = function(parentContainer, discardSection)
{
    var body = document.getElementsByTagName("body").item(0);
    
    if (parentContainer) { body = parentContainer; }

    if (!body) { return false; }

    var container = document.createElement("div");
    container.className =  "mailList_container";

    // Header
    if (discardSection != "header") { 
        var header = document.createElement("div");
        header.className = "mailList_header";
        
        this.drawHeader(header);
        container.appendChild(header);
    }

    // List
    for (var i = 0; i < this.mails.length && discardSection != "list"; ++i) {
        var record = document.createElement("div");
        record.className = "mailList_record";
        
        if (mails[i].deleted) { record.className += "_deleted"; }

        // Set record's events
        getDisplayManager().addRollOver(record);

        record.linkIdx = i;
        record.linkElement = this;
        record.onclick = function(e)
        {
            if (!e) var e = window.event;

            // Shift select
            if (e.shiftKey) {
                var idxS, idxF;
                var selectedLast = this.linkElement.selectedLast;
                if (selectedLast == -1) { selectedLast = 0; }

                if (this.linkIdx > selectedLast) {
                    idxS = selectedLast;
                    idxF = this.linkIdx;
                } else {
                    idxS = this.linkIdx + 1;
                    idxF = this.linkElement.selectedLast;
                }
                
                for (var i = idxS; i < idxF; ++i) {
                    this.linkElement.selectIdx(i);
                }
            } else if (!e.ctrlKey) {
                if (this.linkElement.selectedLast != -1) {
                    this.linkElement.selectNone();
                }
            }

            this.linkElement.selectedLast = this.linkIdx;

            // Select / deselect
            var idx;
            if ((idx = this.className.indexOf("_active")) >= 0) {
                this.className = this.className.substring(0, idx);
                this.className += "_hover";
            } else if ((idx = this.className.indexOf("_hover")) >= 0) {
                this.className = this.className.substring(0, idx);
                this.className += "_active_hover";
            }
            
            // Add to selectedMails array
            if (this.linkElement.selectedMails[this.linkIdx]) {
                this.linkElement.selectedMails[this.linkIdx] = false;
            } else {
                this.linkElement.selectedMails[this.linkIdx] = true;
            }
        }

        // Draw fields
        this.drawField(this.mails[i], record);
        
        container.appendChild(record);
    }

    body.appendChild(container);

    this.container = container;

    // Clear body events
    body.onmousedown = function() { return false; }
    body.onselectstart = function() { return false; }
}

MailList.prototype.drawHeader = function(container)
{
    var sortType = this.sortType == "incoming"?"idx":this.sortType;
    var newSortOrder = this.sortOrder == "ascending"?"descending":"ascending";

    for (var i = 0; i < this.headers.length; ++i) {
        // Setup container
        var field = document.createElement("div");
        field.className = "mailList_header_field";

        field.style.width = this.sizes[i];

        // Skip flags / att column
        if (this.headers[i] == "flagged" || this.headers[i] == "att") {
            field.innerHTML = "&nbsp;";

            container.appendChild(field);

            continue;
        }

        var a = document.createElement("a");
        a.target = "frame_mail_list";
        a.className = "mailList_header_field";

        if (sortType == this.headers[i]) {
            a.className += "_" + this.sortOrder;

            a.href = "?_h=" + getManager().sessionId +
                "&page=" + pageContext +
                "&action=sort" +
                "&sortType=" + this.headers[i] +
                "&sortOrder=" + newSortOrder +
                "&fid=" + this.fid;
        } else {
            a.href = "?_h=" + getManager().sessionId +
                "&page=" + pageContext +
                "&action=sort" +
                "&sortType=" + this.headers[i] +
                "&fid=" + this.fid;
        }

        // header to i18n
        var header_i18n = this.headers[i];
        if (getObject("dictionary")) {
            var i18n = getObject("dictionary").get("mail_list_" + this.headers[i]);
            
            if (i18n) { header_i18n = i18n; }
        }

        a.innerHTML = header_i18n;    

        field.appendChild(a);
        
        container.appendChild(field);
    }
}

MailList.prototype.drawField = function(data, container)
{
    for (var i = 0; i < this.headers.length; ++i) {
        // Draw flags column
        if (this.headers[i] == "flagged" || this.headers[i] == "att") {
            var field = document.createElement("div");
            field.className = "mailList_field";
            field.style.width = this.sizes[i];

            field.innerHTML = "&nbsp;";

            eval("var flag = data." + this.headers[i]);
            if (flag) { field.className += "_" + this.headers[i]; }
            
            container.appendChild(field);

            continue;
        }

        // Setup container + active field
        var field = document.createElement("div");
        field.className = "mailList_field";
        if (!data.seen) { field.className += "_new"; }

        if (this.headers[i] == this.activeHeader) {
            field.data = data;
            field.data.fid = this.fid;

            getDisplayManager().addRollOver(field, EVENT_MAIL_OPEN);
        }

        field.style.width = this.sizes[i];

        var text = eval("data." + this.headers[i]);
        if (text == "") {
            text = "<empty " + this.headers[i] + ">";
            field.style.fontStyle = "oblique";
        }

        field.innerHTML = text;
        
        container.appendChild(field);
    }
}

MailList.prototype.selectIdx = function(idx)
{
    var record = this.container.childNodes[idx + 1];

    if (record.className.indexOf("_active") < 0) {
        this.selectedMails[idx] = true;

        record.className += "_active";
    }
}

MailList.prototype.selectAll = function()
{
    for (var i = 1; i < this.container.childNodes.length; ++i) {
        var record = this.container.childNodes[i];

        if (record.className.indexOf("_active") < 0) {
            this.selectedMails[i - 1] = true;

            record.className += "_active";
        }
    }
}

MailList.prototype.selectNone = function()
{
    for (var i = 1; i < this.container.childNodes.length; ++i) {
        var record = this.container.childNodes[i];

        if (record.className.indexOf("_active") >= 0) {
            this.selectedMails[i - 1] = false;

            record.className = record.className.replace("_active", "");
        }
    }
}

MailList.prototype.selectInvert = function()
{
    for (var i = 1; i < this.container.childNodes.length; ++i) {
        var record = this.container.childNodes[i];

        if (record.className.indexOf("_active") >= 0) {
            this.selectedMails[i - 1] = false;

            record.className = record.className.replace("_active", "");
        } else {
            this.selectedMails[i - 1] = true;

            record.className += "_active";
        }
    }
}

MailList.prototype.select = function()
{
    var selectedCount = 0
    for (var i = 0; i < this.selectedMails.length; ++i) {
        if (this.selectedMails[i]) { ++selectedCount; }
    }
    
    if (selectedCount <= (this.selectedMails.length - selectedCount)) {
        this.selectAll();
    } else {
        this.selectNone();
    }
}

MailList.prototype.notify = function()
{
    var eventInfo = getEventManager().getEventInfo();

    var eventId = eventInfo[0];
    var callerId = eventInfo[1];

    if (eventId == EVENT_MAIL_OPEN) {
        // Check for drafts
        var mailList = getObject("mailList");
        if (mailList && mailList.folderPath == "Drafts") {
            return getManager().openDraft(mailList.fid, callerId.data.mid);
        }

        // Update tree
        if (callerId.className.indexOf("_new") >= 0) {
            var activeFolder = getObject("tree").activeFolder;
            --activeFolder.data.news;

            // Correction
            if (activeFolder.data.news < 0) { activeFolder.data.news = 0; }

            getObject("tree").activeFolder.update();
        }

        // Clear new flag
        var children = callerId.parentNode.childNodes;
        for (var i = 0; i < children.length; ++i) {
            var child = children[i];
            child.className = child.className.replace("_new", "");
        }

        getManager().openMail(callerId);
    }
}

/*******************************************************************************
 * MailHeaders setup
 */

function MailHeader(mail)
{
    registerObject(this, "mailHeader");

    this.mail = mail;

    this.container = null;
    this.isExpanded = true;
}

MailHeader.prototype.start = function() {}

MailHeader.prototype.draw = function(parentContainer)
{
    // Headers to i18n
    this.subject_i18n = "Subject";
    this.from_i18n = "From";
    this.to_i18n = "To";
    this.cc_i18n = "Cc";
    this.date_i18n = "Date";
    if (getObject("dictionary")) {
        var i18n = getObject("dictionary").get("mail_view_subject");
        if (i18n) { this.subject_i18n = i18n; }

        var i18n = getObject("dictionary").get("mail_view_from");
        if (i18n) { this.from_i18n = i18n; }

        var i18n = getObject("dictionary").get("mail_view_to");
        if (i18n) { this.to_i18n = i18n; }

        var i18n = getObject("dictionary").get("mail_view_cc");
        if (i18n) { this.cc_i18n = i18n; }

        var i18n = getObject("dictionary").get("mail_view_date");
        if (i18n) { this.date_i18n = i18n; }
    }

    // Container setup
    if (!this.container) {
        var body = document.getElementsByTagName("body").item(0);
        
        if (!body) { return false; }

        if (parentContainer) { body = parentContainer; }
        
        this.container = document.createElement("div");
        this.container.className = "mailHeader_container";

        body.appendChild(this.container);
    } else {
        this.container.removeChild(this.container.firstChild);
    }

    if (this.isExpanded) {
        this.drawCompact(this.container);
    } else {
        this.drawExpanded(this.container);
    }

    this.isExpanded = this.isExpanded?false:true;
}

MailHeader.prototype.drawCompact = function(container)
{
    var compactHeader = document.createElement("div");
    compactHeader.className = "mailHeader_compact";

    // Expand / Collapse
    var field = document.createElement("div");
    field.className = "mailHeader_field_expand";

    field.onclick = function()
    {
        getObject("mailHeader").draw();
    }

    compactHeader.appendChild(field);

    // Subject
    var field = document.createElement("div");
    field.className = "mailHeader_field";
    field.style.width = "50%";
   
    var field_text = document.createElement("b");
    field_text.innerHTML = this.subject_i18n + ": ";

    field.appendChild(field_text);
    field.innerHTML += this.mail.subject;    

    compactHeader.appendChild(field);

    // From
    var field = document.createElement("div");
    field.className = "mailHeader_field";
    field.style.width = "30%";
   
    var field_text = document.createElement("b");
    field_text.innerHTML = this.from_i18n + ": ";    

    field.appendChild(field_text);
    field.innerHTML += this.mail.from;    

    compactHeader.appendChild(field);

    // Date
    var field = document.createElement("div");
    field.className = "mailHeader_field";
   
    var field_text = document.createElement("b");
    field_text.innerHTML = this.date_i18n + ": ";    

    field.appendChild(field_text);
    field.innerHTML += this.mail.dateFriendly;    

    compactHeader.appendChild(field);
    
    container.appendChild(compactHeader);
}

MailHeader.prototype.drawExpanded = function(container)
{
    var compactHeader = document.createElement("div");
    compactHeader.className = "mailHeader_compact";

    // Expand / Collapse
    var field = document.createElement("div");
    field.className = "mailHeader_field_collapse";

    field.onclick = function()
    {
        getObject("mailHeader").draw();
    }

    compactHeader.appendChild(field);

    // Subject
    var field = document.createElement("div");
    field.className = "mailHeader_field";
   
    var field_text = document.createElement("b");
    field_text.innerHTML = this.subject_i18n + ": ";    

    field.appendChild(field_text);
    field.innerHTML += this.mail.subject;    

    compactHeader.appendChild(field);
    
    compactHeader.appendChild(document.createElement("br"));

    // From
    var field = document.createElement("div");
    field.className = "mailHeader_field";
//    field.style.paddingLeft = "1em";
   
    var field_text = document.createElement("b");
    field_text.innerHTML = this.from_i18n + ": ";    

    field.appendChild(field_text);
    field.innerHTML += this.mail.from;    

    compactHeader.appendChild(field);

    compactHeader.appendChild(document.createElement("br"));

    // To
    var field = document.createElement("div");
    field.className = "mailHeader_field";
    field.style.paddingLeft = "1em";
   
    var field_text = document.createElement("b");
    field_text.innerHTML = this.to_i18n + ": ";    

    field.appendChild(field_text);
    field.innerHTML += this.mail.to;    

    compactHeader.appendChild(field);
    
    compactHeader.appendChild(document.createElement("br"));

    // Cc
    var field = document.createElement("div");
    field.className = "mailHeader_field";
    field.style.paddingLeft = "1em";
   
    var field_text = document.createElement("b");
    field_text.innerHTML = this.cc_i18n + ": ";    

    field.appendChild(field_text);
    field.innerHTML += this.mail.cc;    

    compactHeader.appendChild(field);
    
    compactHeader.appendChild(document.createElement("br"));

    // Date
    var field = document.createElement("div");
    field.className = "mailHeader_field";
    field.style.paddingLeft = "1em";
   
    var field_text = document.createElement("b");
    field_text.innerHTML = this.date_i18n + ": ";    

    field.appendChild(field_text);
    field.innerHTML += this.mail.date;    

    compactHeader.appendChild(field);
    
    container.appendChild(compactHeader);
}
