/**
 * \file lib_manager.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 13-06-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - content manager
 *
 */

/*******************************************************************************
 * Manager class
 */

function Manager(sessId)
{
    registerObject(this, "manager");

    this.started = false;
    this.managerId = parseInt(frameContext);

    this.managers = new Array();
    
    this.sessionId = sessId;
}

/*******************************************************************************
 * Get frame by name
 */

Manager.prototype.getFrame = function(name)
{
    var frames = top.frames;

    if (arguments.length > 1 && typeof(arguments[1]) == 'object') {
        frames = arguments[1].frames;
    }

    var frameIdx;
    for (frameIdx = 0; frameIdx < frames.length &&
        !frames[frameIdx].name.match(name); ++frameIdx);
    
    var ret = frameIdx < frames.length?frames[frameIdx]:false;
    
    if (ret) { return ret; }
    
    for (frameIdx = 0; frameIdx < frames.length; ++frameIdx)
    {
        var parentFrame = frames[frameIdx];
        var frame = this.getFrame(name, parentFrame);
        
        if (frame) { return frame; }
    }  
}

/*******************************************************************************
 * Scan & identify all frames
 */

Manager.prototype.scanFrames = function(callback)
{
    var frames = top.frames;
    var iframes = top.document.getElementsByTagName("iframe");
    
    for (var i = 0; i < frames.length; ++i) {
        var frame = frames[i];

        if (frame.manager) {
            callback(frame);
        }
    }
}

/*******************************************************************************
 * Scan & identify all managers
 */

//Manager.prototype.scanManagers = function(callback)
//{
//    this.scanFrames(function(frame) { callback(frame.manager); } );
//}

Manager.prototype.scanObjects = function(callback)
{
    for (var i = 0; i < top.registeredObjects.length; ++i) {
        callback(top.registeredObjects[i]);
    }
}

/*******************************************************************************
 * Setup current manager
 */

Manager.prototype.start = function()
{
    if (this.started) { return; }

    this.started = true;

//    this.scanManagers(function(mgr) {
//        this.manager.managers[mgr.managerId] = mgr;
//    } );
}

/*******************************************************************************
 * Setup all identified managers
 */

Manager.prototype.startAll = function()
{
//    this.scanManagers(function(mgr) { mgr.start(); } );

    this.scanObjects(function(obj) { if (obj && obj.start) { obj.start(); } } );

//    this.start();
}

/*******************************************************************************
 * Manager event generation
 */

Manager.prototype.registerEvent = function(eventId, callerId)
{
    getObject("eventManager").notify(eventId, callerId);
}

Manager.prototype.openPage = function(page)
{
    var query = "";
    var target = "frame_main";

    if (arguments.length > 1) { query = "&" + arguments[1]; }

    if (arguments.length > 2) { target = arguments[2]; }

    var frame = getFrame(target);
    if (frame) {
        getFrame(target).location.href = "?_h=" + this.sessionId +
            "&page=" + page + query;
    } else {
        window.open("?_h=" + this.sessionId + "&page=" + page + query, target);
    }
}

Manager.prototype.openPopup = function(page, query)
{
    var specs = new Object();

    specs.url = "?_h=" + this.sessionId + "&page=" + page + query;
    specs.name = "popup_" + page;

    specs.width = 420;
    specs.height = 320;

    specs.top = 100;
    specs.left = 100;

    top.popup = getObject("displayManager").popup(specs);
    
    return top.popup;
}

Manager.prototype.openTree = function()
{
    // Test for empty list selection
    if (!getObject("mailList") || getObject("mailList").selectedLast == -1) {
        return false;
    }

    var eventInfo = getEventManager().getEventInfo();

    var popup;
    switch (eventInfo[0]) {
        case EVENT_COPY: {
            popup = getManager().openPopup("mail_tree", "&section=copy");
            } break;

        case EVENT_MOVE: {
            popup = getManager().openPopup("mail_tree", "&section=move");
            } break;
    }
}

Manager.prototype.openFolder = function(folder)
{
    getFrame("frame_main").location.href = "?_h=" + this.sessionId +
        "&page=folder&fid=" + folder.data.fid;
}

Manager.prototype.openMail = function(mail)
{
    getFrame("frame_mail_view").location.href = "?_h=" + this.sessionId +
        "&page=mail_view&fid=" + mail.data.fid + "&mid=" + mail.data.mid;
}

Manager.prototype.openNewContact = function()
{
    getFrame("frame_main").location.href = "?_h=" + getManager().sessionId +
        "&page=settings&tab=contacts&id=add";
}

Manager.prototype.select = function()
{
    getObject("mailList").select();
}

Manager.prototype.selectAll = function()
{
    getObject("mailList").selectAll();
}

Manager.prototype.selectNone = function()
{
    getObject("mailList").selectNone();
}

Manager.prototype.selectInvert = function()
{
    getObject("mailList").selectInvert();
}

Manager.prototype.deleteMails = function()
{
    // Initalize objects
    var mailList = getObject("mailList");
    var selectedCount = 0;

    var frame = getFrame("frame_mail_list");
    var body = frame.document.getElementsByTagName("body").item(0);

    // Initialize form
    var form = frame.document.createElement("form");
    form.action = "?_h=" + getManager().sessionId + "&page=mail_list" + "&action=delete";
    form.method = "POST";
    form.target = "frame_mail_list";
    form.style.display = "none";
        
    var input = frame.document.createElement("input");
    input.type = "hidden";
    input.name = "fid";
    input.value = mailList.fid;

    form.appendChild(input);

    // Populate form
    for ( var i = 0; i < mailList.selectedMails.length; ++i) {
        if (mailList.selectedMails[i]) {
            var mail = mailList.mails[i];
            
            var input = frame.document.createElement("input");
            input.type = "hidden";
            input.name = "mails[]";
            input.value = mail.mid;

            form.appendChild(input);
            
            ++selectedCount;
        }
    }
    
    // Perform action
    var webmailData = getObject("mailList").webmailData;
    var msg = getObject("dictionary").getAlert("confirm_delete").replace("%%1%%", selectedCount);
    if (selectedCount && (webmailData.confirmMailDelete == "no" || confirm(msg))) {
        body.appendChild(form);

        form.submit();
    }
}

Manager.prototype.markMails = function(obj)
{
    // Initalize objects
    var mailList = getObject("mailList");
    var selectedCount = 0;

    var frame = getFrame("frame_mail_list");
    var body = frame.document.getElementsByTagName("body").item(0);

    // Initialize form
    var form = frame.document.createElement("form");
    form.action = "?_h=" + getManager().sessionId + "&page=mail_list" +
        "&action=mark" + "&markType=" + obj.value;
    form.method = "POST";
    form.target = "frame_mail_list";
    form.style.display = "none";
        
    var input = frame.document.createElement("input");
    input.type = "hidden";
    input.name = "fid";
    input.value = mailList.fid;

    form.appendChild(input);

    // Populate form
    for ( var i = 0; i < mailList.selectedMails.length; ++i) {
        if (mailList.selectedMails[i]) {
            var mail = mailList.mails[i];
            
            var input = frame.document.createElement("input");
            input.type = "hidden";
            input.name = "mails[]";
            input.value = mail.mid;

            form.appendChild(input);
            
            ++selectedCount;
        }
    }
      
    // Perform action
    var msg = getObject("dictionary").getAlert("confirm_mark").replace("%%1%%", selectedCount) +
        " " + getObject("dictionary").getAlert("mark_as_" + obj.value) +
        ".\n" + getObject("dictionary").getAlert("confirm_sure");
    if (selectedCount && confirm(msg)) {
        body.appendChild(form);

        form.submit();
    }

    obj.selectedIndex = 0;
}

Manager.prototype.mailListJump = function(type)
{
    // Initalize objects
    var mailList = getObject("mailList");

    if (!mailList) { return false; }
    
    var fid = mailList.fid;
    var startIdx = mailList.startIdx;
    var pageSize = mailList.pageSize;
    var actualSize = mailList.actualSize;
    var totalSize = mailList.totalSize;
    
    var query = "fid=" + fid;
    
    // Test for jump type
    switch(type) {
        case "first": {
            startIdx = 0;
            } break;

        case "last": {
            startIdx = totalSize - pageSize;
            } break;

        case "prev": {
            startIdx -= pageSize;
            } break;

        case "next": {
            startIdx = parseInt(startIdx) + parseInt(pageSize);
            } break;
    }
    
    // Test for out-of-boundaries jump
    if (startIdx > totalSize) { startIdx = totalSize - pageSize; }
    if (startIdx < 0) { startIdx = 0; }

    // Query
    query += "&startIdx=" + startIdx;

    this.openPage("mail_list", query, "frame_mail_list");
}

Manager.prototype.openComposer = function()
{
    // Action setup
    var action = "";
    var eventInfo = getEventManager().getEventInfo();
  
    switch (eventInfo[0]) {
        case EVENT_REPLY: {
            action += "&action=reply";
            } break;

        case EVENT_REPLY_ALL: {
            action += "&action=reply_all";
            } break;

        case EVENT_FORWARD: {
            action += "&action=forward";
            } break;

        case EVENT_FORWARD_ATT: {
            action += "&action=forward_att";
            } break;
    }

    var currentMail = getObject("mailHeader")?getObject("mailHeader").mail:null;
    var currentFid = getObject("mailList")?getObject("mailList").fid:null;

    if (action != "" && (!currentMail || !currentFid)) { return false; }
    else if (action != "") { action += "&fid=" + currentFid + "&mid=" + currentMail.mid; }
    
    // Popup opening
    var specs = new Object();

    specs.url = "?_h=" + getManager().sessionId + "&page=mail_compose" + action;
    specs.name = "popup_mail_compose";

    specs.width = 700;
    specs.height = 500;

    specs.top = 100;
    specs.left = 100;

    top.popup = getObject("displayManager").popup(specs);
    
    return top.popup;
}

Manager.prototype.openDraft = function(fid, mid)
{
    // Action setup
    var action = "&action=edit&fid=" + fid + "&mid=" + mid;

    // Popup opening
    var specs = new Object();

    specs.url = "?_h=" + getManager().sessionId + "&page=mail_compose" + action;
    specs.name = "popup_mail_compose";

    specs.width = 700;
    specs.height = 500;

    specs.top = 100;
    specs.left = 100;

    top.popup = getObject("displayManager").popup(specs);
    
    return top.popup;
}

Manager.prototype.viewSource = function()
{
    var fid = getObject("mailList").fid;
    var mid = getObject("mailHeader").mail.mid;

    getManager().openPage("mail_view_source", "fid=" + fid + "&mid=" + mid,
        "_blank");
}

Manager.prototype.showResources = function()
{
    var fid = getObject("mailList").fid;
    var mid = getObject("mailHeader").mail.mid;

    getManager().openPage("mail_view_body", "fid=" + fid + "&mid=" + mid + "&showGraphics=true",
        "frame_mail_body");
}

Manager.prototype.hideResources = function()
{
    var fid = getObject("mailList").fid;
    var mid = getObject("mailHeader").mail.mid;

    getManager().openPage("mail_view_body", "fid=" + fid + "&mid=" + mid,
        "frame_mail_body");
}

Manager.prototype.showDeleted = function()
{
    var fid = getObject("mailList").fid;

    getManager().openPage("mail_list", "fid=" + fid + "&action=show_deleted",
        "frame_mail_list");
}

Manager.prototype.hideDeleted = function()
{
    var fid = getObject("mailList").fid;

    getManager().openPage("mail_list", "fid=" + fid + "&action=hide_deleted",
        "frame_mail_list");
}

/*******************************************************************************
 * Test managers layout
 */


Manager.prototype.test = function()
{
    for (var i = 0; i < this.managers.length; ++i) {
        var mgr = this.managers[i];
        
        if (!mgr) { continue; }

        var text = "";
        
        text += "Manager:\n";
        text += "* managerId = " + mgr.managerId + "\n";
        text += "* managername = " + ManagerNames[mgr.managerId] + "\n";
        text += "* managerCount = " + mgr.managers.length + "\n";
        
        alert(text);
    }
}
