/**
 * \file lib_menubar.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 17-06-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - Menubar
 *
 */

/*******************************************************************************
 * MenuBar class
 */

function MenuBar(frameName, sections)
{
	var objName = "menubar";

	if (arguments.length > 2) {
		objName = arguments[2];
	}

    registerObject(this, objName);

    this.frame = top;
    if (frameName != "") {
        this.frame = getManager().getFrame(frameName);
    }

    this.container_main = document.createElement("div");
    this.container_main.id = objName;

    this.containers = new Array();
    for (var i = 0; i < sections.length; ++i) {
        this.containers[i] = document.createElement("div");
        this.containers[i].id = sections[i];
    
        this.container_main.appendChild(this.containers[i]);
    }
    
    this.currentOffset = "0px";
}

MenuBar.prototype.getSection = function(id)
{
    var idx;
    for (idx = 0; idx < this.containers.length && this.containers[idx].id != id; ++idx);

    return idx < this.containers.length?this.containers[idx]:false;
}

MenuBar.prototype.add = function(sectionId, obj)
{
    obj.offset = this.updateOffset(obj.width);

    this.getSection(sectionId).appendChild(obj.getElement(this.frame));
}

MenuBar.prototype.remove = function(sectionId, obj)
{
    this.getSection(sectionId).removeChild(obj.getElement(this.frame));
}

MenuBar.prototype.start = function()
{
	return false;
    document.body.appendChild(this.container_main);
}

MenuBar.prototype.draw = function(container)
{
    container.appendChild(this.container_main);
}

MenuBar.prototype.updateOffset = function(width)
{
    if (!width || width == "") { return this.currentOffset; }

    var idxO = 0, idxW = 0;
    var oldOffset = this.currentOffset;

    if ( (idxW = width.indexOf("em") >= 0) &&
        (idxO = this.currentOffset.indexOf("em") >= 0) )
    {
        this.currentOffset = parseInt(this.currentOffset.substring(0, idxO));
        this.currentOffset += parseInt(width.substring(0, idxW + 1));

        this.currentOffset += "em";
    } else if ( ((idxW = width.indexOf("px")) >= 0) &&
        ((idxO = this.currentOffset.indexOf("px")) >= 0) )
    {
        this.currentOffset = parseInt(this.currentOffset.substring(0, idxO + 1));
        this.currentOffset += parseInt(width.substring(0, idxW + 1)) + 56;

        this.currentOffset += "px";
    }
    
    return oldOffset;
}

/*******************************************************************************
 * Menu link
 */

function MenuLink(text, href, id, width, target)
{
    var jsPrefix = "javascript:";

    this.element = document.createElement("a");

    // Test for plain-link / or js-link
    this.element.href = href;
    if (href.substring(0, jsPrefix.length) == jsPrefix) {
        this.element.href = "#";
        eval("this.element.onclick = function() { " + href + " }");
    }

    this.element.innerHTML = text;    

    if (id) { this.element.id = id; }
    if (width) { this.element.style.width = width; }
    if (target) { this.element.target = target; }
    
    this.width = this.element.style.width;
}

MenuLink.prototype.getElement = function(targetFrame) { return this.element; }

/*******************************************************************************
 * MenuButton
 */

function MenuButton(link)
{
    // Objects setup
    this.element = document.createElement("div");

    this.link = link.getElement();
    this.link.className = "a_" + this.link.id;
    
    this.dropdown = document.createElement("div");
    this.dropdown.className = "trail";

    this.element.appendChild(this.link);
    this.element.appendChild(this.dropdown);
}

MenuButton.prototype.getElement = function(targetFrame) { return this.element; }

/*******************************************************************************
 * MenuButton
 */

function MenuSelect()
{
    // Objects setup
    this.element = document.createElement("div");

    var select = document.createElement("select");
    select.name = "more_actions";
    select.className = "more_actions";
    
    if (arguments.length == 0 || arguments.length % 2) { return false; }
    
    // Populate select
    for (var i = 0; i < (arguments.length - 1); i += 2) {
        // TODO: optgroup code
        if (arguments[i] == "---" && arguments[i + 1] != "") {
            var optgroup = document.createElement("optgroup");
            optgroup.label = arguments[i + 1];
    
            select.appendChild(optgroup);

            continue;
        }

        var option = document.createElement("option");
        option.value = arguments[i];
        option.innerHTML = arguments[i];

        option.linkAction = arguments[i + 1];
        option.customOnClick = function(obj)
        {
            if (obj.linkAction != "") { eval(obj.linkAction); }
        }

        select.appendChild(option);
    }

    select.onchange = function()
    {
        this.options[this.selectedIndex].customOnClick(
            this.options[this.selectedIndex]);

        this.selectedIndex = 0;
    }

    this.element.appendChild(select);
}

MenuSelect.prototype.getElement = function(targetFrame) { return this.element; }

/*******************************************************************************
 * Menu text
 */

function MenuText(text)
{
    this.element = document.createElement("font");

    this.element.innerHTML = text;    
    this.element.className = "text";
}

MenuText.prototype.getElement = function(targetFrame) { return this.element; }

/*******************************************************************************
 * MenuDropdown
 */

function MenuDropdown(link, panel)
{
    // Objects setup
    this.element = document.createElement("div");

    this.link = link.getElement();
    this.link.className = "a_" + this.link.id;
    
    this.dropdown = document.createElement("div");
    this.dropdown.className = "dropdown";

    var eventName = "EVENT_" + this.link.id.toUpperCase() + "_DROPDOWN";

    // Event handling
    this.link.linkElement = this.dropdown;
    this.link.onmouseover = function()
    {
        // No roll-over / clear panel if clicked
        if (this.linkElement.isClicked) { return; }

        // Roll-over
        this.className = "a_hover_" + this.id;
        this.linkElement.className = "dropdown_hover";

        // Clear panel
        if (top.currentPanel) { top.currentPanel.hide(); }
    }
    this.link.onmouseout = function()
    {
        if (this.linkElement.isClicked) { return; }

        this.className = "a_" + this.id;
        this.linkElement.className = "dropdown";
    }

    this.dropdown.panel = panel;
    this.dropdown.linkElement = this.link;
    this.dropdown.eventName = eventName;
    this.dropdown.onmouseover = function()
    {
        if (this.isClicked) { return; }

        this.className = "dropdown_hover";
        this.linkElement.className = "a_hover_" + this.linkElement.id;
    }
    this.dropdown.onmouseout = function()
    {
        if (this.isClicked) { return; }

        this.className = "dropdown";
        this.linkElement.className = "a_" + this.linkElement.id;
    }
    this.dropdown.onclick = function()
    {
        this.isClicked = true;

        this.className = "dropdown_click";
        this.linkElement.className = "a_click_" + this.linkElement.id;

        getManager().registerEvent(eval(this.eventName), this.panel);
    }

    this.element.appendChild(this.link);
    this.element.appendChild(this.dropdown);

    panel.linkElement = this;
    panel.width = parseInt(link.width.replace("px", "")) + 75 + "px";

    getEventManager().registerCallback(eval(eventName), panel.show );
//    getEventManager().registerCallback(EVENT_RESET, panel.hide );

//    alert("EVENT_" + this.element.id.toUpperCase() + "_DROPDOWN");

    this.width = this.link.style.width;
}

MenuDropdown.prototype.getElement = function(targetFrame) { return this.element; }

MenuDropdown.prototype.reset = function()
{
    this.link.className = "a_" + this.link.id;
    this.dropdown.className = "dropdown";
    this.dropdown.isClicked = false;
}

/*******************************************************************************
 * MenuPanel class
 */

function MenuPanel(frameName, name)
{
    registerObject(this, name);
    
    this.name = name;

    this.frame = getManager().getFrame(frameName);
    
    this.options = new Array();
    this.links = new Array();

    if (arguments.length > 2) {
        for (var i = 2; i < (arguments.length - 1); i += 2) {
            this.options[this.options.length] = arguments[i];
            this.links[this.links.length] = arguments[i + 1];
        }
    }
}

MenuPanel.prototype.start = function()
{
    var d = this.frame.document;
    var body = d.getElementsByTagName("body").item(0);

    if (!body) { return false; }

//    body.onclick = function() { getManager().registerEvent(EVENT_RESET); }
}

MenuPanel.prototype.show = function()
{
    // Initialize panel / container
    top.currentPanel = getEventManager().getEventInfo()[1];

    var panel = top.currentPanel;

    var d = panel.frame.document;
    var body = d.getElementsByTagName("body").item(0);

    var div = d.createElement("div");
    div.id = panel.name;
    div.className = "panel";
    div.style.width = panel.width;

    // Populate panel
    for (var i = 0; i < panel.options.length; ++i ) {
        var opt = d.createElement("a");
        opt.href = panel.links[i];
        opt.className = "panel_option";
        opt.innerHTML = panel.options[i];          

        // Option events
        opt.onmouseout = function()
        {
            top.currentPanelTID = window.setTimeout("top.currentPanel.hide()", 1000);
        }

        opt.onmouseover = function()
        {
            window.clearTimeout(top.currentPanelTID);
        }

        div.appendChild(opt);
    }
    
    // Positioning
    div.style.left = panel.linkElement.offset;

    // Draw panel
    if (body.firstChild) { body.insertBefore(div, body.firstChild); }
    else { body.appendChild(div); }
}

MenuPanel.prototype.hide = function()
{
    var panel = this;

    panel.linkElement.reset();

    var d = panel.frame.document;
    var body = d.getElementsByTagName("body").item(0);

    var element = d.getElementById(panel.name);
    
    if (!element) { return false; }

    body.removeChild(element);
}
