/**
 * \file lib_menupanel.js
 * \author Mihai OPREA <mihai.oprea@axigen.com>
 * \date 17-06-2006
 *
 * Copyright &copy; 2006 GeCAD Technologies SRL. All Rights Reserved.
 * \brief SCRIPT - Menu panel
 *
 */

/*******************************************************************************
 * MenuPanel class
 */

function MenuPanel(frameName)
{
    registerObject(this, "menuPanel");

    this.frame = getManager().getFrame(frameName);
}

MenuPanel.prototype.start = function()
{
    var d = this.frame.document;
    var body = d.getElementsByTagName("body").item(0);
    body.onclick = function() { getManager().registerEvent(EVENT_RESET); }
}

/*******************************************************************************
 * Drop-down event callback
 */

MenuPanel.prototype.show = function()
{
    var d = this.frame.document;
    var body = d.getElementsByTagName("body").item(0);

    var div = d.createElement("div");
    div.id = "newPanel";
    div.className = "panel";

    var opt = d.createElement("a");
    opt.href = "#";
    opt.className = "panel_option";
    opt.innerHTML = "New message";    
    div.appendChild(opt);

    var opt = d.createElement("a");
    opt.href = "#";
    opt.className = "panel_option";
    opt.innerHTML = "New contact";    
    div.appendChild(opt);

    if (body.firstChild) { body.insertBefore(div, body.firstChild); }
    else { body.appendChild(div); }
}

MenuPanel.prototype.hide = function()
{
    var d = this.frame.document;
    var body = d.getElementsByTagName("body").item(0);

    body.removeChild(d.getElementById("newPanel"));
}
